/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a configuration of participant HLS recordings for individual participant recording.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParticipantRecordingHlsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ParticipantRecordingHlsConfiguration.Builder, ParticipantRecordingHlsConfiguration> {
    private static final SdkField<Integer> TARGET_SEGMENT_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("targetSegmentDurationSeconds")
            .getter(getter(ParticipantRecordingHlsConfiguration::targetSegmentDurationSeconds))
            .setter(setter(Builder::targetSegmentDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSegmentDurationSeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TARGET_SEGMENT_DURATION_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer targetSegmentDurationSeconds;

    private ParticipantRecordingHlsConfiguration(BuilderImpl builder) {
        this.targetSegmentDurationSeconds = builder.targetSegmentDurationSeconds;
    }

    /**
     * <p>
     * Defines the target duration for recorded segments generated when recording a stage participant. Segments may have
     * durations longer than the specified value when needed to ensure each segment begins with a keyframe. Default: 6.
     * </p>
     * 
     * @return Defines the target duration for recorded segments generated when recording a stage participant. Segments
     *         may have durations longer than the specified value when needed to ensure each segment begins with a
     *         keyframe. Default: 6.
     */
    public final Integer targetSegmentDurationSeconds() {
        return targetSegmentDurationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetSegmentDurationSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantRecordingHlsConfiguration)) {
            return false;
        }
        ParticipantRecordingHlsConfiguration other = (ParticipantRecordingHlsConfiguration) obj;
        return Objects.equals(targetSegmentDurationSeconds(), other.targetSegmentDurationSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParticipantRecordingHlsConfiguration")
                .add("TargetSegmentDurationSeconds", targetSegmentDurationSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetSegmentDurationSeconds":
            return Optional.ofNullable(clazz.cast(targetSegmentDurationSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("targetSegmentDurationSeconds", TARGET_SEGMENT_DURATION_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParticipantRecordingHlsConfiguration, T> g) {
        return obj -> g.apply((ParticipantRecordingHlsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParticipantRecordingHlsConfiguration> {
        /**
         * <p>
         * Defines the target duration for recorded segments generated when recording a stage participant. Segments may
         * have durations longer than the specified value when needed to ensure each segment begins with a keyframe.
         * Default: 6.
         * </p>
         * 
         * @param targetSegmentDurationSeconds
         *        Defines the target duration for recorded segments generated when recording a stage participant.
         *        Segments may have durations longer than the specified value when needed to ensure each segment begins
         *        with a keyframe. Default: 6.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSegmentDurationSeconds(Integer targetSegmentDurationSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer targetSegmentDurationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantRecordingHlsConfiguration model) {
            targetSegmentDurationSeconds(model.targetSegmentDurationSeconds);
        }

        public final Integer getTargetSegmentDurationSeconds() {
            return targetSegmentDurationSeconds;
        }

        public final void setTargetSegmentDurationSeconds(Integer targetSegmentDurationSeconds) {
            this.targetSegmentDurationSeconds = targetSegmentDurationSeconds;
        }

        @Override
        public final Builder targetSegmentDurationSeconds(Integer targetSegmentDurationSeconds) {
            this.targetSegmentDurationSeconds = targetSegmentDurationSeconds;
            return this;
        }

        @Override
        public ParticipantRecordingHlsConfiguration build() {
            return new ParticipantRecordingHlsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
