/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary object describing a participant that has joined a stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParticipantSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ParticipantSummary.Builder, ParticipantSummary> {
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("participantId").getter(getter(ParticipantSummary::participantId)).setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(ParticipantSummary::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(ParticipantSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Instant> FIRST_JOIN_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("firstJoinTime")
            .getter(getter(ParticipantSummary::firstJoinTime))
            .setter(setter(Builder::firstJoinTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstJoinTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Boolean> PUBLISHED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("published").getter(getter(ParticipantSummary::published)).setter(setter(Builder::published))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("published").build()).build();

    private static final SdkField<String> RECORDING_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recordingState").getter(getter(ParticipantSummary::recordingStateAsString))
            .setter(setter(Builder::recordingState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingState").build()).build();

    private static final SdkField<String> REPLICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicationType").getter(getter(ParticipantSummary::replicationTypeAsString))
            .setter(setter(Builder::replicationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationType").build()).build();

    private static final SdkField<String> REPLICATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicationState").getter(getter(ParticipantSummary::replicationStateAsString))
            .setter(setter(Builder::replicationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationState").build()).build();

    private static final SdkField<String> SOURCE_STAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceStageArn").getter(getter(ParticipantSummary::sourceStageArn))
            .setter(setter(Builder::sourceStageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceStageArn").build()).build();

    private static final SdkField<String> SOURCE_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceSessionId").getter(getter(ParticipantSummary::sourceSessionId))
            .setter(setter(Builder::sourceSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSessionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTICIPANT_ID_FIELD,
            USER_ID_FIELD, STATE_FIELD, FIRST_JOIN_TIME_FIELD, PUBLISHED_FIELD, RECORDING_STATE_FIELD, REPLICATION_TYPE_FIELD,
            REPLICATION_STATE_FIELD, SOURCE_STAGE_ARN_FIELD, SOURCE_SESSION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String participantId;

    private final String userId;

    private final String state;

    private final Instant firstJoinTime;

    private final Boolean published;

    private final String recordingState;

    private final String replicationType;

    private final String replicationState;

    private final String sourceStageArn;

    private final String sourceSessionId;

    private ParticipantSummary(BuilderImpl builder) {
        this.participantId = builder.participantId;
        this.userId = builder.userId;
        this.state = builder.state;
        this.firstJoinTime = builder.firstJoinTime;
        this.published = builder.published;
        this.recordingState = builder.recordingState;
        this.replicationType = builder.replicationType;
        this.replicationState = builder.replicationState;
        this.sourceStageArn = builder.sourceStageArn;
        this.sourceSessionId = builder.sourceSessionId;
    }

    /**
     * <p>
     * Unique identifier for this participant, assigned by IVS.
     * </p>
     * 
     * @return Unique identifier for this participant, assigned by IVS.
     */
    public final String participantId() {
        return participantId;
    }

    /**
     * <p>
     * Customer-assigned name to help identify the token; this can be used to link a participant to a user in the
     * customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage participants
     * and should not be used for personally identifying, confidential, or sensitive information</i>.
     * </p>
     * 
     * @return Customer-assigned name to help identify the token; this can be used to link a participant to a user in
     *         the customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage
     *         participants and should not be used for personally identifying, confidential, or sensitive
     *         information</i>.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * Whether the participant is connected to or disconnected from the stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ParticipantState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Whether the participant is connected to or disconnected from the stage.
     * @see ParticipantState
     */
    public final ParticipantState state() {
        return ParticipantState.fromValue(state);
    }

    /**
     * <p>
     * Whether the participant is connected to or disconnected from the stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ParticipantState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Whether the participant is connected to or disconnected from the stage.
     * @see ParticipantState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * ISO 8601 timestamp (returned as a string) when the participant first joined the stage session.
     * </p>
     * 
     * @return ISO 8601 timestamp (returned as a string) when the participant first joined the stage session.
     */
    public final Instant firstJoinTime() {
        return firstJoinTime;
    }

    /**
     * <p>
     * Whether the participant ever published to the stage session.
     * </p>
     * 
     * @return Whether the participant ever published to the stage session.
     */
    public final Boolean published() {
        return published;
    }

    /**
     * <p>
     * The participant’s recording state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordingState}
     * will return {@link ParticipantRecordingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #recordingStateAsString}.
     * </p>
     * 
     * @return The participant’s recording state.
     * @see ParticipantRecordingState
     */
    public final ParticipantRecordingState recordingState() {
        return ParticipantRecordingState.fromValue(recordingState);
    }

    /**
     * <p>
     * The participant’s recording state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordingState}
     * will return {@link ParticipantRecordingState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #recordingStateAsString}.
     * </p>
     * 
     * @return The participant’s recording state.
     * @see ParticipantRecordingState
     */
    public final String recordingStateAsString() {
        return recordingState;
    }

    /**
     * <p>
     * Indicates if the participant has been replicated to another stage or is a replica from another stage. Default:
     * <code>NONE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationType}
     * will return {@link ReplicationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicationTypeAsString}.
     * </p>
     * 
     * @return Indicates if the participant has been replicated to another stage or is a replica from another stage.
     *         Default: <code>NONE</code>.
     * @see ReplicationType
     */
    public final ReplicationType replicationType() {
        return ReplicationType.fromValue(replicationType);
    }

    /**
     * <p>
     * Indicates if the participant has been replicated to another stage or is a replica from another stage. Default:
     * <code>NONE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationType}
     * will return {@link ReplicationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicationTypeAsString}.
     * </p>
     * 
     * @return Indicates if the participant has been replicated to another stage or is a replica from another stage.
     *         Default: <code>NONE</code>.
     * @see ReplicationType
     */
    public final String replicationTypeAsString() {
        return replicationType;
    }

    /**
     * <p>
     * The participant's replication state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationState}
     * will return {@link ReplicationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicationStateAsString}.
     * </p>
     * 
     * @return The participant's replication state.
     * @see ReplicationState
     */
    public final ReplicationState replicationState() {
        return ReplicationState.fromValue(replicationState);
    }

    /**
     * <p>
     * The participant's replication state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationState}
     * will return {@link ReplicationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicationStateAsString}.
     * </p>
     * 
     * @return The participant's replication state.
     * @see ReplicationState
     */
    public final String replicationStateAsString() {
        return replicationState;
    }

    /**
     * <p>
     * ARN of the stage from which this participant is replicated.
     * </p>
     * 
     * @return ARN of the stage from which this participant is replicated.
     */
    public final String sourceStageArn() {
        return sourceStageArn;
    }

    /**
     * <p>
     * ID of the session within the source stage, if <code>replicationType</code> is <code>REPLICA</code>.
     * </p>
     * 
     * @return ID of the session within the source stage, if <code>replicationType</code> is <code>REPLICA</code>.
     */
    public final String sourceSessionId() {
        return sourceSessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(firstJoinTime());
        hashCode = 31 * hashCode + Objects.hashCode(published());
        hashCode = 31 * hashCode + Objects.hashCode(recordingStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(replicationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceStageArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSessionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantSummary)) {
            return false;
        }
        ParticipantSummary other = (ParticipantSummary) obj;
        return Objects.equals(participantId(), other.participantId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(firstJoinTime(), other.firstJoinTime()) && Objects.equals(published(), other.published())
                && Objects.equals(recordingStateAsString(), other.recordingStateAsString())
                && Objects.equals(replicationTypeAsString(), other.replicationTypeAsString())
                && Objects.equals(replicationStateAsString(), other.replicationStateAsString())
                && Objects.equals(sourceStageArn(), other.sourceStageArn())
                && Objects.equals(sourceSessionId(), other.sourceSessionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParticipantSummary").add("ParticipantId", participantId()).add("UserId", userId())
                .add("State", stateAsString()).add("FirstJoinTime", firstJoinTime()).add("Published", published())
                .add("RecordingState", recordingStateAsString()).add("ReplicationType", replicationTypeAsString())
                .add("ReplicationState", replicationStateAsString()).add("SourceStageArn", sourceStageArn())
                .add("SourceSessionId", sourceSessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "participantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "firstJoinTime":
            return Optional.ofNullable(clazz.cast(firstJoinTime()));
        case "published":
            return Optional.ofNullable(clazz.cast(published()));
        case "recordingState":
            return Optional.ofNullable(clazz.cast(recordingStateAsString()));
        case "replicationType":
            return Optional.ofNullable(clazz.cast(replicationTypeAsString()));
        case "replicationState":
            return Optional.ofNullable(clazz.cast(replicationStateAsString()));
        case "sourceStageArn":
            return Optional.ofNullable(clazz.cast(sourceStageArn()));
        case "sourceSessionId":
            return Optional.ofNullable(clazz.cast(sourceSessionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("participantId", PARTICIPANT_ID_FIELD);
        map.put("userId", USER_ID_FIELD);
        map.put("state", STATE_FIELD);
        map.put("firstJoinTime", FIRST_JOIN_TIME_FIELD);
        map.put("published", PUBLISHED_FIELD);
        map.put("recordingState", RECORDING_STATE_FIELD);
        map.put("replicationType", REPLICATION_TYPE_FIELD);
        map.put("replicationState", REPLICATION_STATE_FIELD);
        map.put("sourceStageArn", SOURCE_STAGE_ARN_FIELD);
        map.put("sourceSessionId", SOURCE_SESSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParticipantSummary, T> g) {
        return obj -> g.apply((ParticipantSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParticipantSummary> {
        /**
         * <p>
         * Unique identifier for this participant, assigned by IVS.
         * </p>
         * 
         * @param participantId
         *        Unique identifier for this participant, assigned by IVS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);

        /**
         * <p>
         * Customer-assigned name to help identify the token; this can be used to link a participant to a user in the
         * customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage
         * participants and should not be used for personally identifying, confidential, or sensitive information</i>.
         * </p>
         * 
         * @param userId
         *        Customer-assigned name to help identify the token; this can be used to link a participant to a user in
         *        the customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed to all stage
         *        participants and should not be used for personally identifying, confidential, or sensitive
         *        information</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * Whether the participant is connected to or disconnected from the stage.
         * </p>
         * 
         * @param state
         *        Whether the participant is connected to or disconnected from the stage.
         * @see ParticipantState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantState
         */
        Builder state(String state);

        /**
         * <p>
         * Whether the participant is connected to or disconnected from the stage.
         * </p>
         * 
         * @param state
         *        Whether the participant is connected to or disconnected from the stage.
         * @see ParticipantState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantState
         */
        Builder state(ParticipantState state);

        /**
         * <p>
         * ISO 8601 timestamp (returned as a string) when the participant first joined the stage session.
         * </p>
         * 
         * @param firstJoinTime
         *        ISO 8601 timestamp (returned as a string) when the participant first joined the stage session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstJoinTime(Instant firstJoinTime);

        /**
         * <p>
         * Whether the participant ever published to the stage session.
         * </p>
         * 
         * @param published
         *        Whether the participant ever published to the stage session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder published(Boolean published);

        /**
         * <p>
         * The participant’s recording state.
         * </p>
         * 
         * @param recordingState
         *        The participant’s recording state.
         * @see ParticipantRecordingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRecordingState
         */
        Builder recordingState(String recordingState);

        /**
         * <p>
         * The participant’s recording state.
         * </p>
         * 
         * @param recordingState
         *        The participant’s recording state.
         * @see ParticipantRecordingState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRecordingState
         */
        Builder recordingState(ParticipantRecordingState recordingState);

        /**
         * <p>
         * Indicates if the participant has been replicated to another stage or is a replica from another stage.
         * Default: <code>NONE</code>.
         * </p>
         * 
         * @param replicationType
         *        Indicates if the participant has been replicated to another stage or is a replica from another stage.
         *        Default: <code>NONE</code>.
         * @see ReplicationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationType
         */
        Builder replicationType(String replicationType);

        /**
         * <p>
         * Indicates if the participant has been replicated to another stage or is a replica from another stage.
         * Default: <code>NONE</code>.
         * </p>
         * 
         * @param replicationType
         *        Indicates if the participant has been replicated to another stage or is a replica from another stage.
         *        Default: <code>NONE</code>.
         * @see ReplicationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationType
         */
        Builder replicationType(ReplicationType replicationType);

        /**
         * <p>
         * The participant's replication state.
         * </p>
         * 
         * @param replicationState
         *        The participant's replication state.
         * @see ReplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationState
         */
        Builder replicationState(String replicationState);

        /**
         * <p>
         * The participant's replication state.
         * </p>
         * 
         * @param replicationState
         *        The participant's replication state.
         * @see ReplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationState
         */
        Builder replicationState(ReplicationState replicationState);

        /**
         * <p>
         * ARN of the stage from which this participant is replicated.
         * </p>
         * 
         * @param sourceStageArn
         *        ARN of the stage from which this participant is replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceStageArn(String sourceStageArn);

        /**
         * <p>
         * ID of the session within the source stage, if <code>replicationType</code> is <code>REPLICA</code>.
         * </p>
         * 
         * @param sourceSessionId
         *        ID of the session within the source stage, if <code>replicationType</code> is <code>REPLICA</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSessionId(String sourceSessionId);
    }

    static final class BuilderImpl implements Builder {
        private String participantId;

        private String userId;

        private String state;

        private Instant firstJoinTime;

        private Boolean published;

        private String recordingState;

        private String replicationType;

        private String replicationState;

        private String sourceStageArn;

        private String sourceSessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantSummary model) {
            participantId(model.participantId);
            userId(model.userId);
            state(model.state);
            firstJoinTime(model.firstJoinTime);
            published(model.published);
            recordingState(model.recordingState);
            replicationType(model.replicationType);
            replicationState(model.replicationState);
            sourceStageArn(model.sourceStageArn);
            sourceSessionId(model.sourceSessionId);
        }

        public final String getParticipantId() {
            return participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ParticipantState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getFirstJoinTime() {
            return firstJoinTime;
        }

        public final void setFirstJoinTime(Instant firstJoinTime) {
            this.firstJoinTime = firstJoinTime;
        }

        @Override
        public final Builder firstJoinTime(Instant firstJoinTime) {
            this.firstJoinTime = firstJoinTime;
            return this;
        }

        public final Boolean getPublished() {
            return published;
        }

        public final void setPublished(Boolean published) {
            this.published = published;
        }

        @Override
        public final Builder published(Boolean published) {
            this.published = published;
            return this;
        }

        public final String getRecordingState() {
            return recordingState;
        }

        public final void setRecordingState(String recordingState) {
            this.recordingState = recordingState;
        }

        @Override
        public final Builder recordingState(String recordingState) {
            this.recordingState = recordingState;
            return this;
        }

        @Override
        public final Builder recordingState(ParticipantRecordingState recordingState) {
            this.recordingState(recordingState == null ? null : recordingState.toString());
            return this;
        }

        public final String getReplicationType() {
            return replicationType;
        }

        public final void setReplicationType(String replicationType) {
            this.replicationType = replicationType;
        }

        @Override
        public final Builder replicationType(String replicationType) {
            this.replicationType = replicationType;
            return this;
        }

        @Override
        public final Builder replicationType(ReplicationType replicationType) {
            this.replicationType(replicationType == null ? null : replicationType.toString());
            return this;
        }

        public final String getReplicationState() {
            return replicationState;
        }

        public final void setReplicationState(String replicationState) {
            this.replicationState = replicationState;
        }

        @Override
        public final Builder replicationState(String replicationState) {
            this.replicationState = replicationState;
            return this;
        }

        @Override
        public final Builder replicationState(ReplicationState replicationState) {
            this.replicationState(replicationState == null ? null : replicationState.toString());
            return this;
        }

        public final String getSourceStageArn() {
            return sourceStageArn;
        }

        public final void setSourceStageArn(String sourceStageArn) {
            this.sourceStageArn = sourceStageArn;
        }

        @Override
        public final Builder sourceStageArn(String sourceStageArn) {
            this.sourceStageArn = sourceStageArn;
            return this;
        }

        public final String getSourceSessionId() {
            return sourceSessionId;
        }

        public final void setSourceSessionId(String sourceSessionId) {
            this.sourceSessionId = sourceSessionId;
        }

        @Override
        public final Builder sourceSessionId(String sourceSessionId) {
            this.sourceSessionId = sourceSessionId;
            return this;
        }

        @Override
        public ParticipantSummary build() {
            return new ParticipantSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
