/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a configuration to record a stage stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecordingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RecordingConfiguration.Builder, RecordingConfiguration> {
    private static final SdkField<CompositionRecordingHlsConfiguration> HLS_CONFIGURATION_FIELD = SdkField
            .<CompositionRecordingHlsConfiguration> builder(MarshallingType.SDK_POJO).memberName("hlsConfiguration")
            .getter(getter(RecordingConfiguration::hlsConfiguration)).setter(setter(Builder::hlsConfiguration))
            .constructor(CompositionRecordingHlsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsConfiguration").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(RecordingConfiguration::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HLS_CONFIGURATION_FIELD,
            FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CompositionRecordingHlsConfiguration hlsConfiguration;

    private final String format;

    private RecordingConfiguration(BuilderImpl builder) {
        this.hlsConfiguration = builder.hlsConfiguration;
        this.format = builder.format;
    }

    /**
     * <p>
     * An HLS configuration object to return information about how the recording will be configured.
     * </p>
     * 
     * @return An HLS configuration object to return information about how the recording will be configured.
     */
    public final CompositionRecordingHlsConfiguration hlsConfiguration() {
        return hlsConfiguration;
    }

    /**
     * <p>
     * The recording format for storing a recording in Amazon S3.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link RecordingConfigurationFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #formatAsString}.
     * </p>
     * 
     * @return The recording format for storing a recording in Amazon S3.
     * @see RecordingConfigurationFormat
     */
    public final RecordingConfigurationFormat format() {
        return RecordingConfigurationFormat.fromValue(format);
    }

    /**
     * <p>
     * The recording format for storing a recording in Amazon S3.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link RecordingConfigurationFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #formatAsString}.
     * </p>
     * 
     * @return The recording format for storing a recording in Amazon S3.
     * @see RecordingConfigurationFormat
     */
    public final String formatAsString() {
        return format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hlsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordingConfiguration)) {
            return false;
        }
        RecordingConfiguration other = (RecordingConfiguration) obj;
        return Objects.equals(hlsConfiguration(), other.hlsConfiguration())
                && Objects.equals(formatAsString(), other.formatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecordingConfiguration").add("HlsConfiguration", hlsConfiguration())
                .add("Format", formatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hlsConfiguration":
            return Optional.ofNullable(clazz.cast(hlsConfiguration()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("hlsConfiguration", HLS_CONFIGURATION_FIELD);
        map.put("format", FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecordingConfiguration, T> g) {
        return obj -> g.apply((RecordingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecordingConfiguration> {
        /**
         * <p>
         * An HLS configuration object to return information about how the recording will be configured.
         * </p>
         * 
         * @param hlsConfiguration
         *        An HLS configuration object to return information about how the recording will be configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsConfiguration(CompositionRecordingHlsConfiguration hlsConfiguration);

        /**
         * <p>
         * An HLS configuration object to return information about how the recording will be configured.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CompositionRecordingHlsConfiguration.Builder} avoiding the need to create one manually via
         * {@link CompositionRecordingHlsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CompositionRecordingHlsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #hlsConfiguration(CompositionRecordingHlsConfiguration)}.
         * 
         * @param hlsConfiguration
         *        a consumer that will call methods on {@link CompositionRecordingHlsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsConfiguration(CompositionRecordingHlsConfiguration)
         */
        default Builder hlsConfiguration(Consumer<CompositionRecordingHlsConfiguration.Builder> hlsConfiguration) {
            return hlsConfiguration(CompositionRecordingHlsConfiguration.builder().applyMutation(hlsConfiguration).build());
        }

        /**
         * <p>
         * The recording format for storing a recording in Amazon S3.
         * </p>
         * 
         * @param format
         *        The recording format for storing a recording in Amazon S3.
         * @see RecordingConfigurationFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordingConfigurationFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The recording format for storing a recording in Amazon S3.
         * </p>
         * 
         * @param format
         *        The recording format for storing a recording in Amazon S3.
         * @see RecordingConfigurationFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordingConfigurationFormat
         */
        Builder format(RecordingConfigurationFormat format);
    }

    static final class BuilderImpl implements Builder {
        private CompositionRecordingHlsConfiguration hlsConfiguration;

        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordingConfiguration model) {
            hlsConfiguration(model.hlsConfiguration);
            format(model.format);
        }

        public final CompositionRecordingHlsConfiguration.Builder getHlsConfiguration() {
            return hlsConfiguration != null ? hlsConfiguration.toBuilder() : null;
        }

        public final void setHlsConfiguration(CompositionRecordingHlsConfiguration.BuilderImpl hlsConfiguration) {
            this.hlsConfiguration = hlsConfiguration != null ? hlsConfiguration.build() : null;
        }

        @Override
        public final Builder hlsConfiguration(CompositionRecordingHlsConfiguration hlsConfiguration) {
            this.hlsConfiguration = hlsConfiguration;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(RecordingConfigurationFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        @Override
        public RecordingConfiguration build() {
            return new RecordingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
