/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that describes an S3 location where recorded videos will be stored.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3DestinationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<S3DestinationConfiguration.Builder, S3DestinationConfiguration> {
    private static final SdkField<String> STORAGE_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageConfigurationArn").getter(getter(S3DestinationConfiguration::storageConfigurationArn))
            .setter(setter(Builder::storageConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfigurationArn").build())
            .build();

    private static final SdkField<List<String>> ENCODER_CONFIGURATION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("encoderConfigurationArns")
            .getter(getter(S3DestinationConfiguration::encoderConfigurationArns))
            .setter(setter(Builder::encoderConfigurationArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoderConfigurationArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RecordingConfiguration> RECORDING_CONFIGURATION_FIELD = SdkField
            .<RecordingConfiguration> builder(MarshallingType.SDK_POJO).memberName("recordingConfiguration")
            .getter(getter(S3DestinationConfiguration::recordingConfiguration)).setter(setter(Builder::recordingConfiguration))
            .constructor(RecordingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingConfiguration").build())
            .build();

    private static final SdkField<List<CompositionThumbnailConfiguration>> THUMBNAIL_CONFIGURATIONS_FIELD = SdkField
            .<List<CompositionThumbnailConfiguration>> builder(MarshallingType.LIST)
            .memberName("thumbnailConfigurations")
            .getter(getter(S3DestinationConfiguration::thumbnailConfigurations))
            .setter(setter(Builder::thumbnailConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CompositionThumbnailConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(CompositionThumbnailConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STORAGE_CONFIGURATION_ARN_FIELD, ENCODER_CONFIGURATION_ARNS_FIELD, RECORDING_CONFIGURATION_FIELD,
            THUMBNAIL_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String storageConfigurationArn;

    private final List<String> encoderConfigurationArns;

    private final RecordingConfiguration recordingConfiguration;

    private final List<CompositionThumbnailConfiguration> thumbnailConfigurations;

    private S3DestinationConfiguration(BuilderImpl builder) {
        this.storageConfigurationArn = builder.storageConfigurationArn;
        this.encoderConfigurationArns = builder.encoderConfigurationArns;
        this.recordingConfiguration = builder.recordingConfiguration;
        this.thumbnailConfigurations = builder.thumbnailConfigurations;
    }

    /**
     * <p>
     * ARN of the <a>StorageConfiguration</a> where recorded videos will be stored.
     * </p>
     * 
     * @return ARN of the <a>StorageConfiguration</a> where recorded videos will be stored.
     */
    public final String storageConfigurationArn() {
        return storageConfigurationArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the EncoderConfigurationArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEncoderConfigurationArns() {
        return encoderConfigurationArns != null && !(encoderConfigurationArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * ARNs of the <a>EncoderConfiguration</a> resource. The encoder configuration and stage resources must be in the
     * same AWS account and region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEncoderConfigurationArns} method.
     * </p>
     * 
     * @return ARNs of the <a>EncoderConfiguration</a> resource. The encoder configuration and stage resources must be
     *         in the same AWS account and region.
     */
    public final List<String> encoderConfigurationArns() {
        return encoderConfigurationArns;
    }

    /**
     * <p>
     * Array of maps, each of the form <code>string:string (key:value)</code>. This is an optional customer
     * specification, currently used only to specify the recording format for storing a recording in Amazon S3.
     * </p>
     * 
     * @return Array of maps, each of the form <code>string:string (key:value)</code>. This is an optional customer
     *         specification, currently used only to specify the recording format for storing a recording in Amazon S3.
     */
    public final RecordingConfiguration recordingConfiguration() {
        return recordingConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThumbnailConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasThumbnailConfigurations() {
        return thumbnailConfigurations != null && !(thumbnailConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that allows you to enable/disable the recording of thumbnails for a <a>Composition</a> and modify
     * the interval at which thumbnails are generated for the live session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThumbnailConfigurations} method.
     * </p>
     * 
     * @return A complex type that allows you to enable/disable the recording of thumbnails for a <a>Composition</a> and
     *         modify the interval at which thumbnails are generated for the live session.
     */
    public final List<CompositionThumbnailConfiguration> thumbnailConfigurations() {
        return thumbnailConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasEncoderConfigurationArns() ? encoderConfigurationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recordingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasThumbnailConfigurations() ? thumbnailConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DestinationConfiguration)) {
            return false;
        }
        S3DestinationConfiguration other = (S3DestinationConfiguration) obj;
        return Objects.equals(storageConfigurationArn(), other.storageConfigurationArn())
                && hasEncoderConfigurationArns() == other.hasEncoderConfigurationArns()
                && Objects.equals(encoderConfigurationArns(), other.encoderConfigurationArns())
                && Objects.equals(recordingConfiguration(), other.recordingConfiguration())
                && hasThumbnailConfigurations() == other.hasThumbnailConfigurations()
                && Objects.equals(thumbnailConfigurations(), other.thumbnailConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3DestinationConfiguration").add("StorageConfigurationArn", storageConfigurationArn())
                .add("EncoderConfigurationArns", hasEncoderConfigurationArns() ? encoderConfigurationArns() : null)
                .add("RecordingConfiguration", recordingConfiguration())
                .add("ThumbnailConfigurations", hasThumbnailConfigurations() ? thumbnailConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "storageConfigurationArn":
            return Optional.ofNullable(clazz.cast(storageConfigurationArn()));
        case "encoderConfigurationArns":
            return Optional.ofNullable(clazz.cast(encoderConfigurationArns()));
        case "recordingConfiguration":
            return Optional.ofNullable(clazz.cast(recordingConfiguration()));
        case "thumbnailConfigurations":
            return Optional.ofNullable(clazz.cast(thumbnailConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("storageConfigurationArn", STORAGE_CONFIGURATION_ARN_FIELD);
        map.put("encoderConfigurationArns", ENCODER_CONFIGURATION_ARNS_FIELD);
        map.put("recordingConfiguration", RECORDING_CONFIGURATION_FIELD);
        map.put("thumbnailConfigurations", THUMBNAIL_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3DestinationConfiguration, T> g) {
        return obj -> g.apply((S3DestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3DestinationConfiguration> {
        /**
         * <p>
         * ARN of the <a>StorageConfiguration</a> where recorded videos will be stored.
         * </p>
         * 
         * @param storageConfigurationArn
         *        ARN of the <a>StorageConfiguration</a> where recorded videos will be stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfigurationArn(String storageConfigurationArn);

        /**
         * <p>
         * ARNs of the <a>EncoderConfiguration</a> resource. The encoder configuration and stage resources must be in
         * the same AWS account and region.
         * </p>
         * 
         * @param encoderConfigurationArns
         *        ARNs of the <a>EncoderConfiguration</a> resource. The encoder configuration and stage resources must
         *        be in the same AWS account and region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encoderConfigurationArns(Collection<String> encoderConfigurationArns);

        /**
         * <p>
         * ARNs of the <a>EncoderConfiguration</a> resource. The encoder configuration and stage resources must be in
         * the same AWS account and region.
         * </p>
         * 
         * @param encoderConfigurationArns
         *        ARNs of the <a>EncoderConfiguration</a> resource. The encoder configuration and stage resources must
         *        be in the same AWS account and region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encoderConfigurationArns(String... encoderConfigurationArns);

        /**
         * <p>
         * Array of maps, each of the form <code>string:string (key:value)</code>. This is an optional customer
         * specification, currently used only to specify the recording format for storing a recording in Amazon S3.
         * </p>
         * 
         * @param recordingConfiguration
         *        Array of maps, each of the form <code>string:string (key:value)</code>. This is an optional customer
         *        specification, currently used only to specify the recording format for storing a recording in Amazon
         *        S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordingConfiguration(RecordingConfiguration recordingConfiguration);

        /**
         * <p>
         * Array of maps, each of the form <code>string:string (key:value)</code>. This is an optional customer
         * specification, currently used only to specify the recording format for storing a recording in Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecordingConfiguration.Builder} avoiding
         * the need to create one manually via {@link RecordingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecordingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #recordingConfiguration(RecordingConfiguration)}.
         * 
         * @param recordingConfiguration
         *        a consumer that will call methods on {@link RecordingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordingConfiguration(RecordingConfiguration)
         */
        default Builder recordingConfiguration(Consumer<RecordingConfiguration.Builder> recordingConfiguration) {
            return recordingConfiguration(RecordingConfiguration.builder().applyMutation(recordingConfiguration).build());
        }

        /**
         * <p>
         * A complex type that allows you to enable/disable the recording of thumbnails for a <a>Composition</a> and
         * modify the interval at which thumbnails are generated for the live session.
         * </p>
         * 
         * @param thumbnailConfigurations
         *        A complex type that allows you to enable/disable the recording of thumbnails for a <a>Composition</a>
         *        and modify the interval at which thumbnails are generated for the live session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailConfigurations(Collection<CompositionThumbnailConfiguration> thumbnailConfigurations);

        /**
         * <p>
         * A complex type that allows you to enable/disable the recording of thumbnails for a <a>Composition</a> and
         * modify the interval at which thumbnails are generated for the live session.
         * </p>
         * 
         * @param thumbnailConfigurations
         *        A complex type that allows you to enable/disable the recording of thumbnails for a <a>Composition</a>
         *        and modify the interval at which thumbnails are generated for the live session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailConfigurations(CompositionThumbnailConfiguration... thumbnailConfigurations);

        /**
         * <p>
         * A complex type that allows you to enable/disable the recording of thumbnails for a <a>Composition</a> and
         * modify the interval at which thumbnails are generated for the live session.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ivsrealtime.model.CompositionThumbnailConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.ivsrealtime.model.CompositionThumbnailConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ivsrealtime.model.CompositionThumbnailConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #thumbnailConfigurations(List<CompositionThumbnailConfiguration>)}.
         * 
         * @param thumbnailConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ivsrealtime.model.CompositionThumbnailConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thumbnailConfigurations(java.util.Collection<CompositionThumbnailConfiguration>)
         */
        Builder thumbnailConfigurations(Consumer<CompositionThumbnailConfiguration.Builder>... thumbnailConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String storageConfigurationArn;

        private List<String> encoderConfigurationArns = DefaultSdkAutoConstructList.getInstance();

        private RecordingConfiguration recordingConfiguration;

        private List<CompositionThumbnailConfiguration> thumbnailConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3DestinationConfiguration model) {
            storageConfigurationArn(model.storageConfigurationArn);
            encoderConfigurationArns(model.encoderConfigurationArns);
            recordingConfiguration(model.recordingConfiguration);
            thumbnailConfigurations(model.thumbnailConfigurations);
        }

        public final String getStorageConfigurationArn() {
            return storageConfigurationArn;
        }

        public final void setStorageConfigurationArn(String storageConfigurationArn) {
            this.storageConfigurationArn = storageConfigurationArn;
        }

        @Override
        public final Builder storageConfigurationArn(String storageConfigurationArn) {
            this.storageConfigurationArn = storageConfigurationArn;
            return this;
        }

        public final Collection<String> getEncoderConfigurationArns() {
            if (encoderConfigurationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return encoderConfigurationArns;
        }

        public final void setEncoderConfigurationArns(Collection<String> encoderConfigurationArns) {
            this.encoderConfigurationArns = EncoderConfigurationArnListCopier.copy(encoderConfigurationArns);
        }

        @Override
        public final Builder encoderConfigurationArns(Collection<String> encoderConfigurationArns) {
            this.encoderConfigurationArns = EncoderConfigurationArnListCopier.copy(encoderConfigurationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encoderConfigurationArns(String... encoderConfigurationArns) {
            encoderConfigurationArns(Arrays.asList(encoderConfigurationArns));
            return this;
        }

        public final RecordingConfiguration.Builder getRecordingConfiguration() {
            return recordingConfiguration != null ? recordingConfiguration.toBuilder() : null;
        }

        public final void setRecordingConfiguration(RecordingConfiguration.BuilderImpl recordingConfiguration) {
            this.recordingConfiguration = recordingConfiguration != null ? recordingConfiguration.build() : null;
        }

        @Override
        public final Builder recordingConfiguration(RecordingConfiguration recordingConfiguration) {
            this.recordingConfiguration = recordingConfiguration;
            return this;
        }

        public final List<CompositionThumbnailConfiguration.Builder> getThumbnailConfigurations() {
            List<CompositionThumbnailConfiguration.Builder> result = CompositionThumbnailConfigurationListCopier
                    .copyToBuilder(this.thumbnailConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThumbnailConfigurations(
                Collection<CompositionThumbnailConfiguration.BuilderImpl> thumbnailConfigurations) {
            this.thumbnailConfigurations = CompositionThumbnailConfigurationListCopier.copyFromBuilder(thumbnailConfigurations);
        }

        @Override
        public final Builder thumbnailConfigurations(Collection<CompositionThumbnailConfiguration> thumbnailConfigurations) {
            this.thumbnailConfigurations = CompositionThumbnailConfigurationListCopier.copy(thumbnailConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbnailConfigurations(CompositionThumbnailConfiguration... thumbnailConfigurations) {
            thumbnailConfigurations(Arrays.asList(thumbnailConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbnailConfigurations(
                Consumer<CompositionThumbnailConfiguration.Builder>... thumbnailConfigurations) {
            thumbnailConfigurations(Stream.of(thumbnailConfigurations)
                    .map(c -> CompositionThumbnailConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public S3DestinationConfiguration build() {
            return new S3DestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
