/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCompositionResponse extends IvsRealTimeResponse implements
        ToCopyableBuilder<StartCompositionResponse.Builder, StartCompositionResponse> {
    private static final SdkField<Composition> COMPOSITION_FIELD = SdkField.<Composition> builder(MarshallingType.SDK_POJO)
            .memberName("composition").getter(getter(StartCompositionResponse::composition)).setter(setter(Builder::composition))
            .constructor(Composition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("composition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPOSITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Composition composition;

    private StartCompositionResponse(BuilderImpl builder) {
        super(builder);
        this.composition = builder.composition;
    }

    /**
     * <p>
     * The Composition that was created.
     * </p>
     * 
     * @return The Composition that was created.
     */
    public final Composition composition() {
        return composition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(composition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCompositionResponse)) {
            return false;
        }
        StartCompositionResponse other = (StartCompositionResponse) obj;
        return Objects.equals(composition(), other.composition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCompositionResponse").add("Composition", composition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "composition":
            return Optional.ofNullable(clazz.cast(composition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("composition", COMPOSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCompositionResponse, T> g) {
        return obj -> g.apply((StartCompositionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IvsRealTimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartCompositionResponse> {
        /**
         * <p>
         * The Composition that was created.
         * </p>
         * 
         * @param composition
         *        The Composition that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder composition(Composition composition);

        /**
         * <p>
         * The Composition that was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link Composition.Builder} avoiding the need to
         * create one manually via {@link Composition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Composition.Builder#build()} is called immediately and its result
         * is passed to {@link #composition(Composition)}.
         * 
         * @param composition
         *        a consumer that will call methods on {@link Composition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #composition(Composition)
         */
        default Builder composition(Consumer<Composition.Builder> composition) {
            return composition(Composition.builder().applyMutation(composition).build());
        }
    }

    static final class BuilderImpl extends IvsRealTimeResponse.BuilderImpl implements Builder {
        private Composition composition;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCompositionResponse model) {
            super(model);
            composition(model.composition);
        }

        public final Composition.Builder getComposition() {
            return composition != null ? composition.toBuilder() : null;
        }

        public final void setComposition(Composition.BuilderImpl composition) {
            this.composition = composition != null ? composition.build() : null;
        }

        @Override
        public final Builder composition(Composition composition) {
            this.composition = composition;
            return this;
        }

        @Override
        public StartCompositionResponse build() {
            return new StartCompositionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
