/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopParticipantReplicationResponse extends IvsRealTimeResponse implements
        ToCopyableBuilder<StopParticipantReplicationResponse.Builder, StopParticipantReplicationResponse> {
    private static final SdkField<String> ACCESS_CONTROL_ALLOW_ORIGIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("accessControlAllowOrigin")
            .getter(getter(StopParticipantReplicationResponse::accessControlAllowOrigin))
            .setter(setter(Builder::accessControlAllowOrigin))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Access-Control-Allow-Origin").build())
            .build();

    private static final SdkField<String> ACCESS_CONTROL_EXPOSE_HEADERS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("accessControlExposeHeaders")
            .getter(getter(StopParticipantReplicationResponse::accessControlExposeHeaders))
            .setter(setter(Builder::accessControlExposeHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Access-Control-Expose-Headers")
                    .build()).build();

    private static final SdkField<String> CACHE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cacheControl").getter(getter(StopParticipantReplicationResponse::cacheControl))
            .setter(setter(Builder::cacheControl))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Cache-Control").build()).build();

    private static final SdkField<String> CONTENT_SECURITY_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentSecurityPolicy").getter(getter(StopParticipantReplicationResponse::contentSecurityPolicy))
            .setter(setter(Builder::contentSecurityPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Security-Policy").build())
            .build();

    private static final SdkField<String> STRICT_TRANSPORT_SECURITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("strictTransportSecurity").getter(getter(StopParticipantReplicationResponse::strictTransportSecurity))
            .setter(setter(Builder::strictTransportSecurity))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Strict-Transport-Security").build())
            .build();

    private static final SdkField<String> X_CONTENT_TYPE_OPTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("xContentTypeOptions").getter(getter(StopParticipantReplicationResponse::xContentTypeOptions))
            .setter(setter(Builder::xContentTypeOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Content-Type-Options").build())
            .build();

    private static final SdkField<String> X_FRAME_OPTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("xFrameOptions").getter(getter(StopParticipantReplicationResponse::xFrameOptions))
            .setter(setter(Builder::xFrameOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Frame-Options").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACCESS_CONTROL_ALLOW_ORIGIN_FIELD, ACCESS_CONTROL_EXPOSE_HEADERS_FIELD, CACHE_CONTROL_FIELD,
            CONTENT_SECURITY_POLICY_FIELD, STRICT_TRANSPORT_SECURITY_FIELD, X_CONTENT_TYPE_OPTIONS_FIELD, X_FRAME_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accessControlAllowOrigin;

    private final String accessControlExposeHeaders;

    private final String cacheControl;

    private final String contentSecurityPolicy;

    private final String strictTransportSecurity;

    private final String xContentTypeOptions;

    private final String xFrameOptions;

    private StopParticipantReplicationResponse(BuilderImpl builder) {
        super(builder);
        this.accessControlAllowOrigin = builder.accessControlAllowOrigin;
        this.accessControlExposeHeaders = builder.accessControlExposeHeaders;
        this.cacheControl = builder.cacheControl;
        this.contentSecurityPolicy = builder.contentSecurityPolicy;
        this.strictTransportSecurity = builder.strictTransportSecurity;
        this.xContentTypeOptions = builder.xContentTypeOptions;
        this.xFrameOptions = builder.xFrameOptions;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String accessControlAllowOrigin() {
        return accessControlAllowOrigin;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String accessControlExposeHeaders() {
        return accessControlExposeHeaders;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String cacheControl() {
        return cacheControl;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String contentSecurityPolicy() {
        return contentSecurityPolicy;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String strictTransportSecurity() {
        return strictTransportSecurity;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String xContentTypeOptions() {
        return xContentTypeOptions;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String xFrameOptions() {
        return xFrameOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessControlAllowOrigin());
        hashCode = 31 * hashCode + Objects.hashCode(accessControlExposeHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(cacheControl());
        hashCode = 31 * hashCode + Objects.hashCode(contentSecurityPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(strictTransportSecurity());
        hashCode = 31 * hashCode + Objects.hashCode(xContentTypeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(xFrameOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopParticipantReplicationResponse)) {
            return false;
        }
        StopParticipantReplicationResponse other = (StopParticipantReplicationResponse) obj;
        return Objects.equals(accessControlAllowOrigin(), other.accessControlAllowOrigin())
                && Objects.equals(accessControlExposeHeaders(), other.accessControlExposeHeaders())
                && Objects.equals(cacheControl(), other.cacheControl())
                && Objects.equals(contentSecurityPolicy(), other.contentSecurityPolicy())
                && Objects.equals(strictTransportSecurity(), other.strictTransportSecurity())
                && Objects.equals(xContentTypeOptions(), other.xContentTypeOptions())
                && Objects.equals(xFrameOptions(), other.xFrameOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopParticipantReplicationResponse").add("AccessControlAllowOrigin", accessControlAllowOrigin())
                .add("AccessControlExposeHeaders", accessControlExposeHeaders()).add("CacheControl", cacheControl())
                .add("ContentSecurityPolicy", contentSecurityPolicy()).add("StrictTransportSecurity", strictTransportSecurity())
                .add("XContentTypeOptions", xContentTypeOptions()).add("XFrameOptions", xFrameOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessControlAllowOrigin":
            return Optional.ofNullable(clazz.cast(accessControlAllowOrigin()));
        case "accessControlExposeHeaders":
            return Optional.ofNullable(clazz.cast(accessControlExposeHeaders()));
        case "cacheControl":
            return Optional.ofNullable(clazz.cast(cacheControl()));
        case "contentSecurityPolicy":
            return Optional.ofNullable(clazz.cast(contentSecurityPolicy()));
        case "strictTransportSecurity":
            return Optional.ofNullable(clazz.cast(strictTransportSecurity()));
        case "xContentTypeOptions":
            return Optional.ofNullable(clazz.cast(xContentTypeOptions()));
        case "xFrameOptions":
            return Optional.ofNullable(clazz.cast(xFrameOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Access-Control-Allow-Origin", ACCESS_CONTROL_ALLOW_ORIGIN_FIELD);
        map.put("Access-Control-Expose-Headers", ACCESS_CONTROL_EXPOSE_HEADERS_FIELD);
        map.put("Cache-Control", CACHE_CONTROL_FIELD);
        map.put("Content-Security-Policy", CONTENT_SECURITY_POLICY_FIELD);
        map.put("Strict-Transport-Security", STRICT_TRANSPORT_SECURITY_FIELD);
        map.put("X-Content-Type-Options", X_CONTENT_TYPE_OPTIONS_FIELD);
        map.put("X-Frame-Options", X_FRAME_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopParticipantReplicationResponse, T> g) {
        return obj -> g.apply((StopParticipantReplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IvsRealTimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StopParticipantReplicationResponse> {
        /**
         * <p/>
         * 
         * @param accessControlAllowOrigin
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlAllowOrigin(String accessControlAllowOrigin);

        /**
         * <p/>
         * 
         * @param accessControlExposeHeaders
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlExposeHeaders(String accessControlExposeHeaders);

        /**
         * <p/>
         * 
         * @param cacheControl
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheControl(String cacheControl);

        /**
         * <p/>
         * 
         * @param contentSecurityPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentSecurityPolicy(String contentSecurityPolicy);

        /**
         * <p/>
         * 
         * @param strictTransportSecurity
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strictTransportSecurity(String strictTransportSecurity);

        /**
         * <p/>
         * 
         * @param xContentTypeOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xContentTypeOptions(String xContentTypeOptions);

        /**
         * <p/>
         * 
         * @param xFrameOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xFrameOptions(String xFrameOptions);
    }

    static final class BuilderImpl extends IvsRealTimeResponse.BuilderImpl implements Builder {
        private String accessControlAllowOrigin;

        private String accessControlExposeHeaders;

        private String cacheControl;

        private String contentSecurityPolicy;

        private String strictTransportSecurity;

        private String xContentTypeOptions;

        private String xFrameOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(StopParticipantReplicationResponse model) {
            super(model);
            accessControlAllowOrigin(model.accessControlAllowOrigin);
            accessControlExposeHeaders(model.accessControlExposeHeaders);
            cacheControl(model.cacheControl);
            contentSecurityPolicy(model.contentSecurityPolicy);
            strictTransportSecurity(model.strictTransportSecurity);
            xContentTypeOptions(model.xContentTypeOptions);
            xFrameOptions(model.xFrameOptions);
        }

        public final String getAccessControlAllowOrigin() {
            return accessControlAllowOrigin;
        }

        public final void setAccessControlAllowOrigin(String accessControlAllowOrigin) {
            this.accessControlAllowOrigin = accessControlAllowOrigin;
        }

        @Override
        public final Builder accessControlAllowOrigin(String accessControlAllowOrigin) {
            this.accessControlAllowOrigin = accessControlAllowOrigin;
            return this;
        }

        public final String getAccessControlExposeHeaders() {
            return accessControlExposeHeaders;
        }

        public final void setAccessControlExposeHeaders(String accessControlExposeHeaders) {
            this.accessControlExposeHeaders = accessControlExposeHeaders;
        }

        @Override
        public final Builder accessControlExposeHeaders(String accessControlExposeHeaders) {
            this.accessControlExposeHeaders = accessControlExposeHeaders;
            return this;
        }

        public final String getCacheControl() {
            return cacheControl;
        }

        public final void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        @Override
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public final String getContentSecurityPolicy() {
            return contentSecurityPolicy;
        }

        public final void setContentSecurityPolicy(String contentSecurityPolicy) {
            this.contentSecurityPolicy = contentSecurityPolicy;
        }

        @Override
        public final Builder contentSecurityPolicy(String contentSecurityPolicy) {
            this.contentSecurityPolicy = contentSecurityPolicy;
            return this;
        }

        public final String getStrictTransportSecurity() {
            return strictTransportSecurity;
        }

        public final void setStrictTransportSecurity(String strictTransportSecurity) {
            this.strictTransportSecurity = strictTransportSecurity;
        }

        @Override
        public final Builder strictTransportSecurity(String strictTransportSecurity) {
            this.strictTransportSecurity = strictTransportSecurity;
            return this;
        }

        public final String getXContentTypeOptions() {
            return xContentTypeOptions;
        }

        public final void setXContentTypeOptions(String xContentTypeOptions) {
            this.xContentTypeOptions = xContentTypeOptions;
        }

        @Override
        public final Builder xContentTypeOptions(String xContentTypeOptions) {
            this.xContentTypeOptions = xContentTypeOptions;
            return this;
        }

        public final String getXFrameOptions() {
            return xFrameOptions;
        }

        public final void setXFrameOptions(String xFrameOptions) {
            this.xFrameOptions = xFrameOptions;
        }

        @Override
        public final Builder xFrameOptions(String xFrameOptions) {
            this.xFrameOptions = xFrameOptions;
            return this;
        }

        @Override
        public StopParticipantReplicationResponse build() {
            return new StopParticipantReplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
