/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.ivsrealtime.model.CreateEncoderConfigurationRequest;
import software.amazon.awssdk.services.ivsrealtime.model.CreateEncoderConfigurationResponse;
import software.amazon.awssdk.services.ivsrealtime.model.CreateIngestConfigurationRequest;
import software.amazon.awssdk.services.ivsrealtime.model.CreateIngestConfigurationResponse;
import software.amazon.awssdk.services.ivsrealtime.model.CreateParticipantTokenRequest;
import software.amazon.awssdk.services.ivsrealtime.model.CreateParticipantTokenResponse;
import software.amazon.awssdk.services.ivsrealtime.model.CreateStageRequest;
import software.amazon.awssdk.services.ivsrealtime.model.CreateStageResponse;
import software.amazon.awssdk.services.ivsrealtime.model.CreateStorageConfigurationRequest;
import software.amazon.awssdk.services.ivsrealtime.model.CreateStorageConfigurationResponse;
import software.amazon.awssdk.services.ivsrealtime.model.DeleteEncoderConfigurationRequest;
import software.amazon.awssdk.services.ivsrealtime.model.DeleteEncoderConfigurationResponse;
import software.amazon.awssdk.services.ivsrealtime.model.DeleteIngestConfigurationRequest;
import software.amazon.awssdk.services.ivsrealtime.model.DeleteIngestConfigurationResponse;
import software.amazon.awssdk.services.ivsrealtime.model.DeletePublicKeyRequest;
import software.amazon.awssdk.services.ivsrealtime.model.DeletePublicKeyResponse;
import software.amazon.awssdk.services.ivsrealtime.model.DeleteStageRequest;
import software.amazon.awssdk.services.ivsrealtime.model.DeleteStageResponse;
import software.amazon.awssdk.services.ivsrealtime.model.DeleteStorageConfigurationRequest;
import software.amazon.awssdk.services.ivsrealtime.model.DeleteStorageConfigurationResponse;
import software.amazon.awssdk.services.ivsrealtime.model.DisconnectParticipantRequest;
import software.amazon.awssdk.services.ivsrealtime.model.DisconnectParticipantResponse;
import software.amazon.awssdk.services.ivsrealtime.model.GetCompositionRequest;
import software.amazon.awssdk.services.ivsrealtime.model.GetCompositionResponse;
import software.amazon.awssdk.services.ivsrealtime.model.GetEncoderConfigurationRequest;
import software.amazon.awssdk.services.ivsrealtime.model.GetEncoderConfigurationResponse;
import software.amazon.awssdk.services.ivsrealtime.model.GetIngestConfigurationRequest;
import software.amazon.awssdk.services.ivsrealtime.model.GetIngestConfigurationResponse;
import software.amazon.awssdk.services.ivsrealtime.model.GetParticipantRequest;
import software.amazon.awssdk.services.ivsrealtime.model.GetParticipantResponse;
import software.amazon.awssdk.services.ivsrealtime.model.GetPublicKeyRequest;
import software.amazon.awssdk.services.ivsrealtime.model.GetPublicKeyResponse;
import software.amazon.awssdk.services.ivsrealtime.model.GetStageRequest;
import software.amazon.awssdk.services.ivsrealtime.model.GetStageResponse;
import software.amazon.awssdk.services.ivsrealtime.model.GetStageSessionRequest;
import software.amazon.awssdk.services.ivsrealtime.model.GetStageSessionResponse;
import software.amazon.awssdk.services.ivsrealtime.model.GetStorageConfigurationRequest;
import software.amazon.awssdk.services.ivsrealtime.model.GetStorageConfigurationResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ImportPublicKeyRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ImportPublicKeyResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ListCompositionsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListCompositionsResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ListEncoderConfigurationsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListEncoderConfigurationsResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ListIngestConfigurationsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListIngestConfigurationsResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantReplicasRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantReplicasResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ListStagesRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListStagesResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ListStorageConfigurationsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListStorageConfigurationsResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ivsrealtime.model.StartCompositionRequest;
import software.amazon.awssdk.services.ivsrealtime.model.StartCompositionResponse;
import software.amazon.awssdk.services.ivsrealtime.model.StartParticipantReplicationRequest;
import software.amazon.awssdk.services.ivsrealtime.model.StartParticipantReplicationResponse;
import software.amazon.awssdk.services.ivsrealtime.model.StopCompositionRequest;
import software.amazon.awssdk.services.ivsrealtime.model.StopCompositionResponse;
import software.amazon.awssdk.services.ivsrealtime.model.StopParticipantReplicationRequest;
import software.amazon.awssdk.services.ivsrealtime.model.StopParticipantReplicationResponse;
import software.amazon.awssdk.services.ivsrealtime.model.TagResourceRequest;
import software.amazon.awssdk.services.ivsrealtime.model.TagResourceResponse;
import software.amazon.awssdk.services.ivsrealtime.model.UntagResourceRequest;
import software.amazon.awssdk.services.ivsrealtime.model.UntagResourceResponse;
import software.amazon.awssdk.services.ivsrealtime.model.UpdateIngestConfigurationRequest;
import software.amazon.awssdk.services.ivsrealtime.model.UpdateIngestConfigurationResponse;
import software.amazon.awssdk.services.ivsrealtime.model.UpdateStageRequest;
import software.amazon.awssdk.services.ivsrealtime.model.UpdateStageResponse;
import software.amazon.awssdk.services.ivsrealtime.paginators.ListCompositionsPublisher;
import software.amazon.awssdk.services.ivsrealtime.paginators.ListEncoderConfigurationsPublisher;
import software.amazon.awssdk.services.ivsrealtime.paginators.ListIngestConfigurationsPublisher;
import software.amazon.awssdk.services.ivsrealtime.paginators.ListParticipantEventsPublisher;
import software.amazon.awssdk.services.ivsrealtime.paginators.ListParticipantReplicasPublisher;
import software.amazon.awssdk.services.ivsrealtime.paginators.ListParticipantsPublisher;
import software.amazon.awssdk.services.ivsrealtime.paginators.ListPublicKeysPublisher;
import software.amazon.awssdk.services.ivsrealtime.paginators.ListStageSessionsPublisher;
import software.amazon.awssdk.services.ivsrealtime.paginators.ListStagesPublisher;
import software.amazon.awssdk.services.ivsrealtime.paginators.ListStorageConfigurationsPublisher;

/**
 * Service client for accessing ivsrealtime asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * The Amazon Interactive Video Service (IVS) real-time API is REST compatible, using a standard HTTP API and an AWS
 * EventBridge event stream for responses. JSON is used for both requests and responses, including errors.
 * </p>
 * <p>
 * <b>Key Concepts</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Stage</b> — A virtual space where participants can exchange video in real time.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Participant token</b> — A token that authenticates a participant when they join a stage.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Participant object</b> — Represents participants (people) in the stage and contains information about them. When a
 * token is created, it includes a participant ID; when a participant uses that token to join a stage, the participant
 * is associated with that participant ID. There is a 1:1 mapping between participant tokens and participants.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For server-side composition:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Composition process</b> — Composites participants of a stage into a single video and forwards it to a set of
 * outputs (e.g., IVS channels). Composition operations support this process.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Composition</b> — Controls the look of the outputs, including how participants are positioned in the video.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For participant replication:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Source stage</b> — The stage where the participant originally joined, which is used as the source for replication.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Destination stage</b> — The stage to which the participant is replicated.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Replicated participant</b> — A participant in a stage that is replicated to one or more destination stages.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Replica participant</b> — A participant in a destination stage that is replicated from another stage (the source
 * stage).
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information about your IVS live stream, also see <a
 * href="https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started.html">Getting Started with Amazon IVS
 * Real-Time Streaming</a>.
 * </p>
 * <p>
 * <b>Tagging</b>
 * </p>
 * <p>
 * A <i>tag</i> is a metadata label that you assign to an AWS resource. A tag comprises a <i>key</i> and a <i>value</i>,
 * both set by you. For example, you might set a tag as <code>topic:nature</code> to label a particular video category.
 * See <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html">Best practices
 * and strategies</a> in <i>Tagging AWS Resources and Tag Editor</i> for details, including restrictions that apply to
 * tags and "Tag naming limits and requirements"; Amazon IVS stages has no service-specific constraints beyond what is
 * documented there.
 * </p>
 * <p>
 * Tags can help you identify and organize your AWS resources. For example, you can use the same tag for different
 * resources to indicate that they are related. You can also use tags to manage access (see <a
 * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Access Tags</a>).
 * </p>
 * <p>
 * The Amazon IVS real-time API has these tag-related operations: <a>TagResource</a>, <a>UntagResource</a>, and
 * <a>ListTagsForResource</a>. The following resource supports tagging: Stage.
 * </p>
 * <p>
 * At most 50 tags can be applied to a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IvsRealTimeAsyncClient extends AwsClient {
    String SERVICE_NAME = "ivs";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ivsrealtime";

    /**
     * <p>
     * Creates an EncoderConfiguration object.
     * </p>
     *
     * @param createEncoderConfigurationRequest
     * @return A Java Future containing the result of the CreateEncoderConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.CreateEncoderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateEncoderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEncoderConfigurationResponse> createEncoderConfiguration(
            CreateEncoderConfigurationRequest createEncoderConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an EncoderConfiguration object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEncoderConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEncoderConfigurationRequest#builder()}
     * </p>
     *
     * @param createEncoderConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.CreateEncoderConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateEncoderConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.CreateEncoderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateEncoderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEncoderConfigurationResponse> createEncoderConfiguration(
            Consumer<CreateEncoderConfigurationRequest.Builder> createEncoderConfigurationRequest) {
        return createEncoderConfiguration(CreateEncoderConfigurationRequest.builder()
                .applyMutation(createEncoderConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new IngestConfiguration resource, used to specify the ingest protocol for a stage.
     * </p>
     *
     * @param createIngestConfigurationRequest
     * @return A Java Future containing the result of the CreateIngestConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.CreateIngestConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateIngestConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIngestConfigurationResponse> createIngestConfiguration(
            CreateIngestConfigurationRequest createIngestConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new IngestConfiguration resource, used to specify the ingest protocol for a stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIngestConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateIngestConfigurationRequest#builder()}
     * </p>
     *
     * @param createIngestConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.CreateIngestConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateIngestConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.CreateIngestConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateIngestConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIngestConfigurationResponse> createIngestConfiguration(
            Consumer<CreateIngestConfigurationRequest.Builder> createIngestConfigurationRequest) {
        return createIngestConfiguration(CreateIngestConfigurationRequest.builder()
                .applyMutation(createIngestConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates an additional token for a specified stage. This can be done after stage creation or when tokens expire.
     * Tokens always are scoped to the stage for which they are created.
     * </p>
     * <p>
     * Encryption keys are owned by Amazon IVS and never used directly by your application.
     * </p>
     *
     * @param createParticipantTokenRequest
     * @return A Java Future containing the result of the CreateParticipantToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.CreateParticipantToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateParticipantToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateParticipantTokenResponse> createParticipantToken(
            CreateParticipantTokenRequest createParticipantTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an additional token for a specified stage. This can be done after stage creation or when tokens expire.
     * Tokens always are scoped to the stage for which they are created.
     * </p>
     * <p>
     * Encryption keys are owned by Amazon IVS and never used directly by your application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateParticipantTokenRequest.Builder} avoiding the
     * need to create one manually via {@link CreateParticipantTokenRequest#builder()}
     * </p>
     *
     * @param createParticipantTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.CreateParticipantTokenRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateParticipantToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.CreateParticipantToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateParticipantToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateParticipantTokenResponse> createParticipantToken(
            Consumer<CreateParticipantTokenRequest.Builder> createParticipantTokenRequest) {
        return createParticipantToken(CreateParticipantTokenRequest.builder().applyMutation(createParticipantTokenRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new stage (and optionally participant tokens).
     * </p>
     *
     * @param createStageRequest
     * @return A Java Future containing the result of the CreateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.CreateStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateStage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateStageResponse> createStage(CreateStageRequest createStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new stage (and optionally participant tokens).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStageRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStageRequest#builder()}
     * </p>
     *
     * @param createStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.CreateStageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.CreateStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateStage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateStageResponse> createStage(Consumer<CreateStageRequest.Builder> createStageRequest) {
        return createStage(CreateStageRequest.builder().applyMutation(createStageRequest).build());
    }

    /**
     * <p>
     * Creates a new storage configuration, used to enable recording to Amazon S3. When a StorageConfiguration is
     * created, IVS will modify the S3 bucketPolicy of the provided bucket. This will ensure that IVS has sufficient
     * permissions to write content to the provided bucket.
     * </p>
     *
     * @param createStorageConfigurationRequest
     * @return A Java Future containing the result of the CreateStorageConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.CreateStorageConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStorageConfigurationResponse> createStorageConfiguration(
            CreateStorageConfigurationRequest createStorageConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new storage configuration, used to enable recording to Amazon S3. When a StorageConfiguration is
     * created, IVS will modify the S3 bucketPolicy of the provided bucket. This will ensure that IVS has sufficient
     * permissions to write content to the provided bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStorageConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateStorageConfigurationRequest#builder()}
     * </p>
     *
     * @param createStorageConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.CreateStorageConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateStorageConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.CreateStorageConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStorageConfigurationResponse> createStorageConfiguration(
            Consumer<CreateStorageConfigurationRequest.Builder> createStorageConfigurationRequest) {
        return createStorageConfiguration(CreateStorageConfigurationRequest.builder()
                .applyMutation(createStorageConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes an EncoderConfiguration resource. Ensures that no Compositions are using this template; otherwise,
     * returns an error.
     * </p>
     *
     * @param deleteEncoderConfigurationRequest
     * @return A Java Future containing the result of the DeleteEncoderConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.DeleteEncoderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeleteEncoderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEncoderConfigurationResponse> deleteEncoderConfiguration(
            DeleteEncoderConfigurationRequest deleteEncoderConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an EncoderConfiguration resource. Ensures that no Compositions are using this template; otherwise,
     * returns an error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEncoderConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEncoderConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteEncoderConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.DeleteEncoderConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteEncoderConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.DeleteEncoderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeleteEncoderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEncoderConfigurationResponse> deleteEncoderConfiguration(
            Consumer<DeleteEncoderConfigurationRequest.Builder> deleteEncoderConfigurationRequest) {
        return deleteEncoderConfiguration(DeleteEncoderConfigurationRequest.builder()
                .applyMutation(deleteEncoderConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a specified IngestConfiguration, so it can no longer be used to broadcast. An IngestConfiguration cannot
     * be deleted if the publisher is actively streaming to a stage, unless <code>force</code> is set to
     * <code>true</code>.
     * </p>
     *
     * @param deleteIngestConfigurationRequest
     * @return A Java Future containing the result of the DeleteIngestConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.DeleteIngestConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeleteIngestConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIngestConfigurationResponse> deleteIngestConfiguration(
            DeleteIngestConfigurationRequest deleteIngestConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified IngestConfiguration, so it can no longer be used to broadcast. An IngestConfiguration cannot
     * be deleted if the publisher is actively streaming to a stage, unless <code>force</code> is set to
     * <code>true</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIngestConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteIngestConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteIngestConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.DeleteIngestConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteIngestConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.DeleteIngestConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeleteIngestConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIngestConfigurationResponse> deleteIngestConfiguration(
            Consumer<DeleteIngestConfigurationRequest.Builder> deleteIngestConfigurationRequest) {
        return deleteIngestConfiguration(DeleteIngestConfigurationRequest.builder()
                .applyMutation(deleteIngestConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified public key used to sign stage participant tokens. This invalidates future participant
     * tokens generated using the key pair’s private key.
     * </p>
     *
     * @param deletePublicKeyRequest
     * @return A Java Future containing the result of the DeletePublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.DeletePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeletePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePublicKeyResponse> deletePublicKey(DeletePublicKeyRequest deletePublicKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified public key used to sign stage participant tokens. This invalidates future participant
     * tokens generated using the key pair’s private key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePublicKeyRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePublicKeyRequest#builder()}
     * </p>
     *
     * @param deletePublicKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.DeletePublicKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.DeletePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeletePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePublicKeyResponse> deletePublicKey(
            Consumer<DeletePublicKeyRequest.Builder> deletePublicKeyRequest) {
        return deletePublicKey(DeletePublicKeyRequest.builder().applyMutation(deletePublicKeyRequest).build());
    }

    /**
     * <p>
     * Shuts down and deletes the specified stage (disconnecting all participants). This operation also removes the
     * <code>stageArn</code> from the associated <a>IngestConfiguration</a>, if there are participants using the
     * IngestConfiguration to publish to the stage.
     * </p>
     *
     * @param deleteStageRequest
     * @return A Java Future containing the result of the DeleteStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.DeleteStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeleteStage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStageResponse> deleteStage(DeleteStageRequest deleteStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Shuts down and deletes the specified stage (disconnecting all participants). This operation also removes the
     * <code>stageArn</code> from the associated <a>IngestConfiguration</a>, if there are participants using the
     * IngestConfiguration to publish to the stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStageRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStageRequest#builder()}
     * </p>
     *
     * @param deleteStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.DeleteStageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.DeleteStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeleteStage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteStageResponse> deleteStage(Consumer<DeleteStageRequest.Builder> deleteStageRequest) {
        return deleteStage(DeleteStageRequest.builder().applyMutation(deleteStageRequest).build());
    }

    /**
     * <p>
     * Deletes the storage configuration for the specified ARN.
     * </p>
     * <p>
     * If you try to delete a storage configuration that is used by a Composition, you will get an error (409
     * ConflictException). To avoid this, for all Compositions that reference the storage configuration, first use
     * <a>StopComposition</a> and wait for it to complete, then use DeleteStorageConfiguration.
     * </p>
     *
     * @param deleteStorageConfigurationRequest
     * @return A Java Future containing the result of the DeleteStorageConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.DeleteStorageConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeleteStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStorageConfigurationResponse> deleteStorageConfiguration(
            DeleteStorageConfigurationRequest deleteStorageConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the storage configuration for the specified ARN.
     * </p>
     * <p>
     * If you try to delete a storage configuration that is used by a Composition, you will get an error (409
     * ConflictException). To avoid this, for all Compositions that reference the storage configuration, first use
     * <a>StopComposition</a> and wait for it to complete, then use DeleteStorageConfiguration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStorageConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteStorageConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteStorageConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.DeleteStorageConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteStorageConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.DeleteStorageConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeleteStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStorageConfigurationResponse> deleteStorageConfiguration(
            Consumer<DeleteStorageConfigurationRequest.Builder> deleteStorageConfigurationRequest) {
        return deleteStorageConfiguration(DeleteStorageConfigurationRequest.builder()
                .applyMutation(deleteStorageConfigurationRequest).build());
    }

    /**
     * <p>
     * Disconnects a specified participant from a specified stage. If the participant is publishing using an
     * <a>IngestConfiguration</a>, DisconnectParticipant also updates the <code>stageArn</code> in the
     * IngestConfiguration to be an empty string.
     * </p>
     *
     * @param disconnectParticipantRequest
     * @return A Java Future containing the result of the DisconnectParticipant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.DisconnectParticipant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DisconnectParticipant"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisconnectParticipantResponse> disconnectParticipant(
            DisconnectParticipantRequest disconnectParticipantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disconnects a specified participant from a specified stage. If the participant is publishing using an
     * <a>IngestConfiguration</a>, DisconnectParticipant also updates the <code>stageArn</code> in the
     * IngestConfiguration to be an empty string.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisconnectParticipantRequest.Builder} avoiding the
     * need to create one manually via {@link DisconnectParticipantRequest#builder()}
     * </p>
     *
     * @param disconnectParticipantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.DisconnectParticipantRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisconnectParticipant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.DisconnectParticipant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DisconnectParticipant"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisconnectParticipantResponse> disconnectParticipant(
            Consumer<DisconnectParticipantRequest.Builder> disconnectParticipantRequest) {
        return disconnectParticipant(DisconnectParticipantRequest.builder().applyMutation(disconnectParticipantRequest).build());
    }

    /**
     * <p>
     * Get information about the specified Composition resource.
     * </p>
     *
     * @param getCompositionRequest
     * @return A Java Future containing the result of the GetComposition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.GetComposition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetComposition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCompositionResponse> getComposition(GetCompositionRequest getCompositionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about the specified Composition resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCompositionRequest.Builder} avoiding the need to
     * create one manually via {@link GetCompositionRequest#builder()}
     * </p>
     *
     * @param getCompositionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.GetCompositionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetComposition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.GetComposition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetComposition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCompositionResponse> getComposition(Consumer<GetCompositionRequest.Builder> getCompositionRequest) {
        return getComposition(GetCompositionRequest.builder().applyMutation(getCompositionRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified EncoderConfiguration resource.
     * </p>
     *
     * @param getEncoderConfigurationRequest
     * @return A Java Future containing the result of the GetEncoderConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.GetEncoderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetEncoderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEncoderConfigurationResponse> getEncoderConfiguration(
            GetEncoderConfigurationRequest getEncoderConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified EncoderConfiguration resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEncoderConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetEncoderConfigurationRequest#builder()}
     * </p>
     *
     * @param getEncoderConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.GetEncoderConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetEncoderConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.GetEncoderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetEncoderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEncoderConfigurationResponse> getEncoderConfiguration(
            Consumer<GetEncoderConfigurationRequest.Builder> getEncoderConfigurationRequest) {
        return getEncoderConfiguration(GetEncoderConfigurationRequest.builder().applyMutation(getEncoderConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about the specified IngestConfiguration.
     * </p>
     *
     * @param getIngestConfigurationRequest
     * @return A Java Future containing the result of the GetIngestConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.GetIngestConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetIngestConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIngestConfigurationResponse> getIngestConfiguration(
            GetIngestConfigurationRequest getIngestConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified IngestConfiguration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIngestConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetIngestConfigurationRequest#builder()}
     * </p>
     *
     * @param getIngestConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.GetIngestConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetIngestConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.GetIngestConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetIngestConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIngestConfigurationResponse> getIngestConfiguration(
            Consumer<GetIngestConfigurationRequest.Builder> getIngestConfigurationRequest) {
        return getIngestConfiguration(GetIngestConfigurationRequest.builder().applyMutation(getIngestConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about the specified participant token.
     * </p>
     *
     * @param getParticipantRequest
     * @return A Java Future containing the result of the GetParticipant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.GetParticipant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetParticipant" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetParticipantResponse> getParticipant(GetParticipantRequest getParticipantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified participant token.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetParticipantRequest.Builder} avoiding the need to
     * create one manually via {@link GetParticipantRequest#builder()}
     * </p>
     *
     * @param getParticipantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.GetParticipantRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetParticipant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.GetParticipant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetParticipant" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetParticipantResponse> getParticipant(Consumer<GetParticipantRequest.Builder> getParticipantRequest) {
        return getParticipant(GetParticipantRequest.builder().applyMutation(getParticipantRequest).build());
    }

    /**
     * <p>
     * Gets information for the specified public key.
     * </p>
     *
     * @param getPublicKeyRequest
     * @return A Java Future containing the result of the GetPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.GetPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPublicKeyResponse> getPublicKey(GetPublicKeyRequest getPublicKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information for the specified public key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPublicKeyRequest.Builder} avoiding the need to
     * create one manually via {@link GetPublicKeyRequest#builder()}
     * </p>
     *
     * @param getPublicKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.GetPublicKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.GetPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPublicKeyResponse> getPublicKey(Consumer<GetPublicKeyRequest.Builder> getPublicKeyRequest) {
        return getPublicKey(GetPublicKeyRequest.builder().applyMutation(getPublicKeyRequest).build());
    }

    /**
     * <p>
     * Gets information for the specified stage.
     * </p>
     *
     * @param getStageRequest
     * @return A Java Future containing the result of the GetStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.GetStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetStage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStageResponse> getStage(GetStageRequest getStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information for the specified stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStageRequest.Builder} avoiding the need to
     * create one manually via {@link GetStageRequest#builder()}
     * </p>
     *
     * @param getStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.GetStageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.GetStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetStage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetStageResponse> getStage(Consumer<GetStageRequest.Builder> getStageRequest) {
        return getStage(GetStageRequest.builder().applyMutation(getStageRequest).build());
    }

    /**
     * <p>
     * Gets information for the specified stage session.
     * </p>
     *
     * @param getStageSessionRequest
     * @return A Java Future containing the result of the GetStageSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.GetStageSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetStageSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetStageSessionResponse> getStageSession(GetStageSessionRequest getStageSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information for the specified stage session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStageSessionRequest.Builder} avoiding the need
     * to create one manually via {@link GetStageSessionRequest#builder()}
     * </p>
     *
     * @param getStageSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.GetStageSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetStageSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.GetStageSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetStageSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetStageSessionResponse> getStageSession(
            Consumer<GetStageSessionRequest.Builder> getStageSessionRequest) {
        return getStageSession(GetStageSessionRequest.builder().applyMutation(getStageSessionRequest).build());
    }

    /**
     * <p>
     * Gets the storage configuration for the specified ARN.
     * </p>
     *
     * @param getStorageConfigurationRequest
     * @return A Java Future containing the result of the GetStorageConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.GetStorageConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStorageConfigurationResponse> getStorageConfiguration(
            GetStorageConfigurationRequest getStorageConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the storage configuration for the specified ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStorageConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetStorageConfigurationRequest#builder()}
     * </p>
     *
     * @param getStorageConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.GetStorageConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetStorageConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.GetStorageConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStorageConfigurationResponse> getStorageConfiguration(
            Consumer<GetStorageConfigurationRequest.Builder> getStorageConfigurationRequest) {
        return getStorageConfiguration(GetStorageConfigurationRequest.builder().applyMutation(getStorageConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Import a public key to be used for signing stage participant tokens.
     * </p>
     *
     * @param importPublicKeyRequest
     * @return A Java Future containing the result of the ImportPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ImportPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ImportPublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ImportPublicKeyResponse> importPublicKey(ImportPublicKeyRequest importPublicKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Import a public key to be used for signing stage participant tokens.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportPublicKeyRequest.Builder} avoiding the need
     * to create one manually via {@link ImportPublicKeyRequest#builder()}
     * </p>
     *
     * @param importPublicKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ImportPublicKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ImportPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ImportPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ImportPublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ImportPublicKeyResponse> importPublicKey(
            Consumer<ImportPublicKeyRequest.Builder> importPublicKeyRequest) {
        return importPublicKey(ImportPublicKeyRequest.builder().applyMutation(importPublicKeyRequest).build());
    }

    /**
     * <p>
     * Gets summary information about all Compositions in your account, in the AWS region where the API request is
     * processed.
     * </p>
     *
     * @param listCompositionsRequest
     * @return A Java Future containing the result of the ListCompositions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListCompositions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListCompositions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCompositionsResponse> listCompositions(ListCompositionsRequest listCompositionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets summary information about all Compositions in your account, in the AWS region where the API request is
     * processed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCompositionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCompositionsRequest#builder()}
     * </p>
     *
     * @param listCompositionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListCompositionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCompositions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListCompositions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListCompositions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCompositionsResponse> listCompositions(
            Consumer<ListCompositionsRequest.Builder> listCompositionsRequest) {
        return listCompositions(ListCompositionsRequest.builder().applyMutation(listCompositionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCompositions(software.amazon.awssdk.services.ivsrealtime.model.ListCompositionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListCompositionsPublisher publisher = client.listCompositionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListCompositionsPublisher publisher = client.listCompositionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListCompositionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListCompositionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCompositions(software.amazon.awssdk.services.ivsrealtime.model.ListCompositionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCompositionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListCompositions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListCompositions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCompositionsPublisher listCompositionsPaginator(ListCompositionsRequest listCompositionsRequest) {
        return new ListCompositionsPublisher(this, listCompositionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCompositions(software.amazon.awssdk.services.ivsrealtime.model.ListCompositionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListCompositionsPublisher publisher = client.listCompositionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListCompositionsPublisher publisher = client.listCompositionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListCompositionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListCompositionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCompositions(software.amazon.awssdk.services.ivsrealtime.model.ListCompositionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCompositionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCompositionsRequest#builder()}
     * </p>
     *
     * @param listCompositionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListCompositionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListCompositions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListCompositions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCompositionsPublisher listCompositionsPaginator(Consumer<ListCompositionsRequest.Builder> listCompositionsRequest) {
        return listCompositionsPaginator(ListCompositionsRequest.builder().applyMutation(listCompositionsRequest).build());
    }

    /**
     * <p>
     * Gets summary information about all EncoderConfigurations in your account, in the AWS region where the API request
     * is processed.
     * </p>
     *
     * @param listEncoderConfigurationsRequest
     * @return A Java Future containing the result of the ListEncoderConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListEncoderConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListEncoderConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEncoderConfigurationsResponse> listEncoderConfigurations(
            ListEncoderConfigurationsRequest listEncoderConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets summary information about all EncoderConfigurations in your account, in the AWS region where the API request
     * is processed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEncoderConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEncoderConfigurationsRequest#builder()}
     * </p>
     *
     * @param listEncoderConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListEncoderConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListEncoderConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListEncoderConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListEncoderConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEncoderConfigurationsResponse> listEncoderConfigurations(
            Consumer<ListEncoderConfigurationsRequest.Builder> listEncoderConfigurationsRequest) {
        return listEncoderConfigurations(ListEncoderConfigurationsRequest.builder()
                .applyMutation(listEncoderConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEncoderConfigurations(software.amazon.awssdk.services.ivsrealtime.model.ListEncoderConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListEncoderConfigurationsPublisher publisher = client.listEncoderConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListEncoderConfigurationsPublisher publisher = client.listEncoderConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListEncoderConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListEncoderConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEncoderConfigurations(software.amazon.awssdk.services.ivsrealtime.model.ListEncoderConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEncoderConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListEncoderConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListEncoderConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEncoderConfigurationsPublisher listEncoderConfigurationsPaginator(
            ListEncoderConfigurationsRequest listEncoderConfigurationsRequest) {
        return new ListEncoderConfigurationsPublisher(this, listEncoderConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEncoderConfigurations(software.amazon.awssdk.services.ivsrealtime.model.ListEncoderConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListEncoderConfigurationsPublisher publisher = client.listEncoderConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListEncoderConfigurationsPublisher publisher = client.listEncoderConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListEncoderConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListEncoderConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEncoderConfigurations(software.amazon.awssdk.services.ivsrealtime.model.ListEncoderConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEncoderConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEncoderConfigurationsRequest#builder()}
     * </p>
     *
     * @param listEncoderConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListEncoderConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListEncoderConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListEncoderConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEncoderConfigurationsPublisher listEncoderConfigurationsPaginator(
            Consumer<ListEncoderConfigurationsRequest.Builder> listEncoderConfigurationsRequest) {
        return listEncoderConfigurationsPaginator(ListEncoderConfigurationsRequest.builder()
                .applyMutation(listEncoderConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists all IngestConfigurations in your account, in the AWS region where the API request is processed.
     * </p>
     *
     * @param listIngestConfigurationsRequest
     * @return A Java Future containing the result of the ListIngestConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListIngestConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListIngestConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIngestConfigurationsResponse> listIngestConfigurations(
            ListIngestConfigurationsRequest listIngestConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all IngestConfigurations in your account, in the AWS region where the API request is processed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngestConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListIngestConfigurationsRequest#builder()}
     * </p>
     *
     * @param listIngestConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListIngestConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListIngestConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListIngestConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListIngestConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIngestConfigurationsResponse> listIngestConfigurations(
            Consumer<ListIngestConfigurationsRequest.Builder> listIngestConfigurationsRequest) {
        return listIngestConfigurations(ListIngestConfigurationsRequest.builder().applyMutation(listIngestConfigurationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIngestConfigurations(software.amazon.awssdk.services.ivsrealtime.model.ListIngestConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListIngestConfigurationsPublisher publisher = client.listIngestConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListIngestConfigurationsPublisher publisher = client.listIngestConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListIngestConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListIngestConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngestConfigurations(software.amazon.awssdk.services.ivsrealtime.model.ListIngestConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIngestConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListIngestConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListIngestConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIngestConfigurationsPublisher listIngestConfigurationsPaginator(
            ListIngestConfigurationsRequest listIngestConfigurationsRequest) {
        return new ListIngestConfigurationsPublisher(this, listIngestConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIngestConfigurations(software.amazon.awssdk.services.ivsrealtime.model.ListIngestConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListIngestConfigurationsPublisher publisher = client.listIngestConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListIngestConfigurationsPublisher publisher = client.listIngestConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListIngestConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListIngestConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngestConfigurations(software.amazon.awssdk.services.ivsrealtime.model.ListIngestConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIngestConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListIngestConfigurationsRequest#builder()}
     * </p>
     *
     * @param listIngestConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListIngestConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListIngestConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListIngestConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIngestConfigurationsPublisher listIngestConfigurationsPaginator(
            Consumer<ListIngestConfigurationsRequest.Builder> listIngestConfigurationsRequest) {
        return listIngestConfigurationsPaginator(ListIngestConfigurationsRequest.builder()
                .applyMutation(listIngestConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists events for a specified participant that occurred during a specified stage session.
     * </p>
     *
     * @param listParticipantEventsRequest
     * @return A Java Future containing the result of the ListParticipantEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListParticipantEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipantEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListParticipantEventsResponse> listParticipantEvents(
            ListParticipantEventsRequest listParticipantEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists events for a specified participant that occurred during a specified stage session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListParticipantEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListParticipantEventsRequest#builder()}
     * </p>
     *
     * @param listParticipantEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListParticipantEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListParticipantEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipantEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListParticipantEventsResponse> listParticipantEvents(
            Consumer<ListParticipantEventsRequest.Builder> listParticipantEventsRequest) {
        return listParticipantEvents(ListParticipantEventsRequest.builder().applyMutation(listParticipantEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listParticipantEvents(software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListParticipantEventsPublisher publisher = client.listParticipantEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListParticipantEventsPublisher publisher = client.listParticipantEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listParticipantEvents(software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listParticipantEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListParticipantEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipantEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListParticipantEventsPublisher listParticipantEventsPaginator(
            ListParticipantEventsRequest listParticipantEventsRequest) {
        return new ListParticipantEventsPublisher(this, listParticipantEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listParticipantEvents(software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListParticipantEventsPublisher publisher = client.listParticipantEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListParticipantEventsPublisher publisher = client.listParticipantEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listParticipantEvents(software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListParticipantEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListParticipantEventsRequest#builder()}
     * </p>
     *
     * @param listParticipantEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListParticipantEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipantEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListParticipantEventsPublisher listParticipantEventsPaginator(
            Consumer<ListParticipantEventsRequest.Builder> listParticipantEventsRequest) {
        return listParticipantEventsPaginator(ListParticipantEventsRequest.builder().applyMutation(listParticipantEventsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the replicas for a participant from a source stage.
     * </p>
     *
     * @param listParticipantReplicasRequest
     * @return A Java Future containing the result of the ListParticipantReplicas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListParticipantReplicas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipantReplicas"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListParticipantReplicasResponse> listParticipantReplicas(
            ListParticipantReplicasRequest listParticipantReplicasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the replicas for a participant from a source stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListParticipantReplicasRequest.Builder} avoiding
     * the need to create one manually via {@link ListParticipantReplicasRequest#builder()}
     * </p>
     *
     * @param listParticipantReplicasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListParticipantReplicasRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListParticipantReplicas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListParticipantReplicas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipantReplicas"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListParticipantReplicasResponse> listParticipantReplicas(
            Consumer<ListParticipantReplicasRequest.Builder> listParticipantReplicasRequest) {
        return listParticipantReplicas(ListParticipantReplicasRequest.builder().applyMutation(listParticipantReplicasRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listParticipantReplicas(software.amazon.awssdk.services.ivsrealtime.model.ListParticipantReplicasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListParticipantReplicasPublisher publisher = client.listParticipantReplicasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListParticipantReplicasPublisher publisher = client.listParticipantReplicasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListParticipantReplicasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListParticipantReplicasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listParticipantReplicas(software.amazon.awssdk.services.ivsrealtime.model.ListParticipantReplicasRequest)}
     * operation.</b>
     * </p>
     *
     * @param listParticipantReplicasRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListParticipantReplicas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipantReplicas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListParticipantReplicasPublisher listParticipantReplicasPaginator(
            ListParticipantReplicasRequest listParticipantReplicasRequest) {
        return new ListParticipantReplicasPublisher(this, listParticipantReplicasRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listParticipantReplicas(software.amazon.awssdk.services.ivsrealtime.model.ListParticipantReplicasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListParticipantReplicasPublisher publisher = client.listParticipantReplicasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListParticipantReplicasPublisher publisher = client.listParticipantReplicasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListParticipantReplicasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListParticipantReplicasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listParticipantReplicas(software.amazon.awssdk.services.ivsrealtime.model.ListParticipantReplicasRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListParticipantReplicasRequest.Builder} avoiding
     * the need to create one manually via {@link ListParticipantReplicasRequest#builder()}
     * </p>
     *
     * @param listParticipantReplicasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListParticipantReplicasRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListParticipantReplicas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipantReplicas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListParticipantReplicasPublisher listParticipantReplicasPaginator(
            Consumer<ListParticipantReplicasRequest.Builder> listParticipantReplicasRequest) {
        return listParticipantReplicasPaginator(ListParticipantReplicasRequest.builder()
                .applyMutation(listParticipantReplicasRequest).build());
    }

    /**
     * <p>
     * Lists all participants in a specified stage session.
     * </p>
     *
     * @param listParticipantsRequest
     * @return A Java Future containing the result of the ListParticipants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListParticipants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipants" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListParticipantsResponse> listParticipants(ListParticipantsRequest listParticipantsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all participants in a specified stage session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListParticipantsRequest.Builder} avoiding the need
     * to create one manually via {@link ListParticipantsRequest#builder()}
     * </p>
     *
     * @param listParticipantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListParticipants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListParticipants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipants" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListParticipantsResponse> listParticipants(
            Consumer<ListParticipantsRequest.Builder> listParticipantsRequest) {
        return listParticipants(ListParticipantsRequest.builder().applyMutation(listParticipantsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listParticipants(software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListParticipantsPublisher publisher = client.listParticipantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListParticipantsPublisher publisher = client.listParticipantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listParticipants(software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listParticipantsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListParticipants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipants" target="_top">AWS
     *      API Documentation</a>
     */
    default ListParticipantsPublisher listParticipantsPaginator(ListParticipantsRequest listParticipantsRequest) {
        return new ListParticipantsPublisher(this, listParticipantsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listParticipants(software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListParticipantsPublisher publisher = client.listParticipantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListParticipantsPublisher publisher = client.listParticipantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listParticipants(software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListParticipantsRequest.Builder} avoiding the need
     * to create one manually via {@link ListParticipantsRequest#builder()}
     * </p>
     *
     * @param listParticipantsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListParticipants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListParticipants" target="_top">AWS
     *      API Documentation</a>
     */
    default ListParticipantsPublisher listParticipantsPaginator(Consumer<ListParticipantsRequest.Builder> listParticipantsRequest) {
        return listParticipantsPaginator(ListParticipantsRequest.builder().applyMutation(listParticipantsRequest).build());
    }

    /**
     * <p>
     * Gets summary information about all public keys in your account, in the AWS region where the API request is
     * processed.
     * </p>
     *
     * @param listPublicKeysRequest
     * @return A Java Future containing the result of the ListPublicKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListPublicKeys" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPublicKeysResponse> listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets summary information about all public keys in your account, in the AWS region where the API request is
     * processed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPublicKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListPublicKeysRequest#builder()}
     * </p>
     *
     * @param listPublicKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListPublicKeysRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPublicKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListPublicKeys" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPublicKeysResponse> listPublicKeys(Consumer<ListPublicKeysRequest.Builder> listPublicKeysRequest) {
        return listPublicKeys(ListPublicKeysRequest.builder().applyMutation(listPublicKeysRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPublicKeys(software.amazon.awssdk.services.ivsrealtime.model.ListPublicKeysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListPublicKeysPublisher publisher = client.listPublicKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListPublicKeysPublisher publisher = client.listPublicKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListPublicKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListPublicKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPublicKeys(software.amazon.awssdk.services.ivsrealtime.model.ListPublicKeysRequest)} operation.</b>
     * </p>
     *
     * @param listPublicKeysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListPublicKeys" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPublicKeysPublisher listPublicKeysPaginator(ListPublicKeysRequest listPublicKeysRequest) {
        return new ListPublicKeysPublisher(this, listPublicKeysRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPublicKeys(software.amazon.awssdk.services.ivsrealtime.model.ListPublicKeysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListPublicKeysPublisher publisher = client.listPublicKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListPublicKeysPublisher publisher = client.listPublicKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListPublicKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListPublicKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPublicKeys(software.amazon.awssdk.services.ivsrealtime.model.ListPublicKeysRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPublicKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListPublicKeysRequest#builder()}
     * </p>
     *
     * @param listPublicKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListPublicKeysRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListPublicKeys" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPublicKeysPublisher listPublicKeysPaginator(Consumer<ListPublicKeysRequest.Builder> listPublicKeysRequest) {
        return listPublicKeysPaginator(ListPublicKeysRequest.builder().applyMutation(listPublicKeysRequest).build());
    }

    /**
     * <p>
     * Gets all sessions for a specified stage.
     * </p>
     *
     * @param listStageSessionsRequest
     * @return A Java Future containing the result of the ListStageSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListStageSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStageSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStageSessionsResponse> listStageSessions(ListStageSessionsRequest listStageSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all sessions for a specified stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStageSessionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListStageSessionsRequest#builder()}
     * </p>
     *
     * @param listStageSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStageSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListStageSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStageSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStageSessionsResponse> listStageSessions(
            Consumer<ListStageSessionsRequest.Builder> listStageSessionsRequest) {
        return listStageSessions(ListStageSessionsRequest.builder().applyMutation(listStageSessionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStageSessions(software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListStageSessionsPublisher publisher = client.listStageSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListStageSessionsPublisher publisher = client.listStageSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStageSessions(software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStageSessionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListStageSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStageSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStageSessionsPublisher listStageSessionsPaginator(ListStageSessionsRequest listStageSessionsRequest) {
        return new ListStageSessionsPublisher(this, listStageSessionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStageSessions(software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListStageSessionsPublisher publisher = client.listStageSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListStageSessionsPublisher publisher = client.listStageSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStageSessions(software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStageSessionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListStageSessionsRequest#builder()}
     * </p>
     *
     * @param listStageSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListStageSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStageSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStageSessionsPublisher listStageSessionsPaginator(
            Consumer<ListStageSessionsRequest.Builder> listStageSessionsRequest) {
        return listStageSessionsPaginator(ListStageSessionsRequest.builder().applyMutation(listStageSessionsRequest).build());
    }

    /**
     * <p>
     * Gets summary information about all stages in your account, in the AWS region where the API request is processed.
     * </p>
     *
     * @param listStagesRequest
     * @return A Java Future containing the result of the ListStages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListStages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStagesResponse> listStages(ListStagesRequest listStagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets summary information about all stages in your account, in the AWS region where the API request is processed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListStagesRequest#builder()}
     * </p>
     *
     * @param listStagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListStagesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListStages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListStages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListStagesResponse> listStages(Consumer<ListStagesRequest.Builder> listStagesRequest) {
        return listStages(ListStagesRequest.builder().applyMutation(listStagesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listStages(software.amazon.awssdk.services.ivsrealtime.model.ListStagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListStagesPublisher publisher = client.listStagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListStagesPublisher publisher = client.listStagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListStagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListStagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStages(software.amazon.awssdk.services.ivsrealtime.model.ListStagesRequest)} operation.</b>
     * </p>
     *
     * @param listStagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListStages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStagesPublisher listStagesPaginator(ListStagesRequest listStagesRequest) {
        return new ListStagesPublisher(this, listStagesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listStages(software.amazon.awssdk.services.ivsrealtime.model.ListStagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListStagesPublisher publisher = client.listStagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListStagesPublisher publisher = client.listStagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListStagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListStagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStages(software.amazon.awssdk.services.ivsrealtime.model.ListStagesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListStagesRequest#builder()}
     * </p>
     *
     * @param listStagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListStagesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListStages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStagesPublisher listStagesPaginator(Consumer<ListStagesRequest.Builder> listStagesRequest) {
        return listStagesPaginator(ListStagesRequest.builder().applyMutation(listStagesRequest).build());
    }

    /**
     * <p>
     * Gets summary information about all storage configurations in your account, in the AWS region where the API
     * request is processed.
     * </p>
     *
     * @param listStorageConfigurationsRequest
     * @return A Java Future containing the result of the ListStorageConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListStorageConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStorageConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStorageConfigurationsResponse> listStorageConfigurations(
            ListStorageConfigurationsRequest listStorageConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets summary information about all storage configurations in your account, in the AWS region where the API
     * request is processed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStorageConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListStorageConfigurationsRequest#builder()}
     * </p>
     *
     * @param listStorageConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListStorageConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListStorageConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListStorageConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStorageConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStorageConfigurationsResponse> listStorageConfigurations(
            Consumer<ListStorageConfigurationsRequest.Builder> listStorageConfigurationsRequest) {
        return listStorageConfigurations(ListStorageConfigurationsRequest.builder()
                .applyMutation(listStorageConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStorageConfigurations(software.amazon.awssdk.services.ivsrealtime.model.ListStorageConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListStorageConfigurationsPublisher publisher = client.listStorageConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListStorageConfigurationsPublisher publisher = client.listStorageConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListStorageConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListStorageConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStorageConfigurations(software.amazon.awssdk.services.ivsrealtime.model.ListStorageConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStorageConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListStorageConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStorageConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStorageConfigurationsPublisher listStorageConfigurationsPaginator(
            ListStorageConfigurationsRequest listStorageConfigurationsRequest) {
        return new ListStorageConfigurationsPublisher(this, listStorageConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStorageConfigurations(software.amazon.awssdk.services.ivsrealtime.model.ListStorageConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListStorageConfigurationsPublisher publisher = client.listStorageConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ivsrealtime.paginators.ListStorageConfigurationsPublisher publisher = client.listStorageConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ivsrealtime.model.ListStorageConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ivsrealtime.model.ListStorageConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStorageConfigurations(software.amazon.awssdk.services.ivsrealtime.model.ListStorageConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStorageConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListStorageConfigurationsRequest#builder()}
     * </p>
     *
     * @param listStorageConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListStorageConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListStorageConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStorageConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStorageConfigurationsPublisher listStorageConfigurationsPaginator(
            Consumer<ListStorageConfigurationsRequest.Builder> listStorageConfigurationsRequest) {
        return listStorageConfigurationsPaginator(ListStorageConfigurationsRequest.builder()
                .applyMutation(listStorageConfigurationsRequest).build());
    }

    /**
     * <p>
     * Gets information about AWS tags for the specified ARN.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about AWS tags for the specified ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts a Composition from a stage based on the configuration provided in the request.
     * </p>
     * <p>
     * A Composition is an ephemeral resource that exists after this operation returns successfully. Composition stops
     * and the resource is deleted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When <a>StopComposition</a> is called.
     * </p>
     * </li>
     * <li>
     * <p>
     * After a 1-minute timeout, when all participants are disconnected from the stage.
     * </p>
     * </li>
     * <li>
     * <p>
     * After a 1-minute timeout, if there are no participants in the stage when StartComposition is called.
     * </p>
     * </li>
     * <li>
     * <p>
     * When broadcasting to the IVS channel fails and all retries are exhausted.
     * </p>
     * </li>
     * <li>
     * <p>
     * When broadcasting is disconnected and all attempts to reconnect are exhausted.
     * </p>
     * </li>
     * </ul>
     *
     * @param startCompositionRequest
     * @return A Java Future containing the result of the StartComposition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.StartComposition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/StartComposition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartCompositionResponse> startComposition(StartCompositionRequest startCompositionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a Composition from a stage based on the configuration provided in the request.
     * </p>
     * <p>
     * A Composition is an ephemeral resource that exists after this operation returns successfully. Composition stops
     * and the resource is deleted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When <a>StopComposition</a> is called.
     * </p>
     * </li>
     * <li>
     * <p>
     * After a 1-minute timeout, when all participants are disconnected from the stage.
     * </p>
     * </li>
     * <li>
     * <p>
     * After a 1-minute timeout, if there are no participants in the stage when StartComposition is called.
     * </p>
     * </li>
     * <li>
     * <p>
     * When broadcasting to the IVS channel fails and all retries are exhausted.
     * </p>
     * </li>
     * <li>
     * <p>
     * When broadcasting is disconnected and all attempts to reconnect are exhausted.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCompositionRequest.Builder} avoiding the need
     * to create one manually via {@link StartCompositionRequest#builder()}
     * </p>
     *
     * @param startCompositionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.StartCompositionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartComposition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.StartComposition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/StartComposition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartCompositionResponse> startComposition(
            Consumer<StartCompositionRequest.Builder> startCompositionRequest) {
        return startComposition(StartCompositionRequest.builder().applyMutation(startCompositionRequest).build());
    }

    /**
     * <p>
     * Starts replicating a publishing participant from a source stage to a destination stage.
     * </p>
     *
     * @param startParticipantReplicationRequest
     * @return A Java Future containing the result of the StartParticipantReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.StartParticipantReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/StartParticipantReplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartParticipantReplicationResponse> startParticipantReplication(
            StartParticipantReplicationRequest startParticipantReplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts replicating a publishing participant from a source stage to a destination stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartParticipantReplicationRequest.Builder}
     * avoiding the need to create one manually via {@link StartParticipantReplicationRequest#builder()}
     * </p>
     *
     * @param startParticipantReplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.StartParticipantReplicationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartParticipantReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.StartParticipantReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/StartParticipantReplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartParticipantReplicationResponse> startParticipantReplication(
            Consumer<StartParticipantReplicationRequest.Builder> startParticipantReplicationRequest) {
        return startParticipantReplication(StartParticipantReplicationRequest.builder()
                .applyMutation(startParticipantReplicationRequest).build());
    }

    /**
     * <p>
     * Stops and deletes a Composition resource. Any broadcast from the Composition resource is stopped.
     * </p>
     *
     * @param stopCompositionRequest
     * @return A Java Future containing the result of the StopComposition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.StopComposition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/StopComposition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopCompositionResponse> stopComposition(StopCompositionRequest stopCompositionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops and deletes a Composition resource. Any broadcast from the Composition resource is stopped.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopCompositionRequest.Builder} avoiding the need
     * to create one manually via {@link StopCompositionRequest#builder()}
     * </p>
     *
     * @param stopCompositionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.StopCompositionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopComposition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.StopComposition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/StopComposition" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopCompositionResponse> stopComposition(
            Consumer<StopCompositionRequest.Builder> stopCompositionRequest) {
        return stopComposition(StopCompositionRequest.builder().applyMutation(stopCompositionRequest).build());
    }

    /**
     * <p>
     * Stops a replicated participant session.
     * </p>
     *
     * @param stopParticipantReplicationRequest
     * @return A Java Future containing the result of the StopParticipantReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.StopParticipantReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/StopParticipantReplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopParticipantReplicationResponse> stopParticipantReplication(
            StopParticipantReplicationRequest stopParticipantReplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a replicated participant session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopParticipantReplicationRequest.Builder} avoiding
     * the need to create one manually via {@link StopParticipantReplicationRequest#builder()}
     * </p>
     *
     * @param stopParticipantReplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.StopParticipantReplicationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StopParticipantReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.StopParticipantReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/StopParticipantReplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopParticipantReplicationResponse> stopParticipantReplication(
            Consumer<StopParticipantReplicationRequest.Builder> stopParticipantReplicationRequest) {
        return stopParticipantReplication(StopParticipantReplicationRequest.builder()
                .applyMutation(stopParticipantReplicationRequest).build());
    }

    /**
     * <p>
     * Adds or updates tags for the AWS resource with the specified ARN.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates tags for the AWS resource with the specified ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from the resource with the specified ARN.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the resource with the specified ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>InternalServerException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a specified IngestConfiguration. Only the stage ARN attached to the IngestConfiguration can be updated.
     * An IngestConfiguration that is active cannot be updated.
     * </p>
     *
     * @param updateIngestConfigurationRequest
     * @return A Java Future containing the result of the UpdateIngestConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.UpdateIngestConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/UpdateIngestConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIngestConfigurationResponse> updateIngestConfiguration(
            UpdateIngestConfigurationRequest updateIngestConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a specified IngestConfiguration. Only the stage ARN attached to the IngestConfiguration can be updated.
     * An IngestConfiguration that is active cannot be updated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIngestConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateIngestConfigurationRequest#builder()}
     * </p>
     *
     * @param updateIngestConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.UpdateIngestConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateIngestConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.UpdateIngestConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/UpdateIngestConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIngestConfigurationResponse> updateIngestConfiguration(
            Consumer<UpdateIngestConfigurationRequest.Builder> updateIngestConfigurationRequest) {
        return updateIngestConfiguration(UpdateIngestConfigurationRequest.builder()
                .applyMutation(updateIngestConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates a stage’s configuration.
     * </p>
     *
     * @param updateStageRequest
     * @return A Java Future containing the result of the UpdateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.UpdateStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/UpdateStage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateStageResponse> updateStage(UpdateStageRequest updateStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a stage’s configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStageRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStageRequest#builder()}
     * </p>
     *
     * @param updateStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ivsrealtime.model.UpdateStageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>ValidationException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>ConflictException</li>
     *         <li>PendingVerificationException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IvsRealTimeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IvsRealTimeAsyncClient.UpdateStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/UpdateStage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateStageResponse> updateStage(Consumer<UpdateStageRequest.Builder> updateStageRequest) {
        return updateStage(UpdateStageRequest.builder().applyMutation(updateStageRequest).build());
    }

    @Override
    default IvsRealTimeServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link IvsRealTimeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IvsRealTimeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IvsRealTimeAsyncClient}.
     */
    static IvsRealTimeAsyncClientBuilder builder() {
        return new DefaultIvsRealTimeAsyncClientBuilder();
    }
}
