/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a configuration of thumbnails for recorded video for a <a>Composition</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompositionThumbnailConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CompositionThumbnailConfiguration.Builder, CompositionThumbnailConfiguration> {
    private static final SdkField<Integer> TARGET_INTERVAL_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("targetIntervalSeconds").getter(getter(CompositionThumbnailConfiguration::targetIntervalSeconds))
            .setter(setter(Builder::targetIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIntervalSeconds").build())
            .build();

    private static final SdkField<List<String>> STORAGE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("storage")
            .getter(getter(CompositionThumbnailConfiguration::storageAsStrings))
            .setter(setter(Builder::storageWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storage").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_INTERVAL_SECONDS_FIELD,
            STORAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer targetIntervalSeconds;

    private final List<String> storage;

    private CompositionThumbnailConfiguration(BuilderImpl builder) {
        this.targetIntervalSeconds = builder.targetIntervalSeconds;
        this.storage = builder.storage;
    }

    /**
     * <p>
     * The targeted thumbnail-generation interval in seconds. Default: 60.
     * </p>
     * 
     * @return The targeted thumbnail-generation interval in seconds. Default: 60.
     */
    public final Integer targetIntervalSeconds() {
        return targetIntervalSeconds;
    }

    /**
     * <p>
     * Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated thumbnails
     * in a serial manner, to the media/thumbnails/(width)x(height) directory, where (width) and (height) are the width
     * and height of the thumbnail. <code>LATEST</code> saves the latest thumbnail in
     * media/latest_thumbnail/(width)x(height)/thumb.jpg and overwrites it at the interval specified by
     * <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code>. Default:
     * <code>SEQUENTIAL</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStorage} method.
     * </p>
     * 
     * @return Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
     *         thumbnails in a serial manner, to the media/thumbnails/(width)x(height) directory, where (width) and
     *         (height) are the width and height of the thumbnail. <code>LATEST</code> saves the latest thumbnail in
     *         media/latest_thumbnail/(width)x(height)/thumb.jpg and overwrites it at the interval specified by
     *         <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code>.
     *         Default: <code>SEQUENTIAL</code>.
     */
    public final List<ThumbnailStorageType> storage() {
        return ThumbnailStorageTypeListCopier.copyStringToEnum(storage);
    }

    /**
     * For responses, this returns true if the service returned a value for the Storage property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStorage() {
        return storage != null && !(storage instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated thumbnails
     * in a serial manner, to the media/thumbnails/(width)x(height) directory, where (width) and (height) are the width
     * and height of the thumbnail. <code>LATEST</code> saves the latest thumbnail in
     * media/latest_thumbnail/(width)x(height)/thumb.jpg and overwrites it at the interval specified by
     * <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code>. Default:
     * <code>SEQUENTIAL</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStorage} method.
     * </p>
     * 
     * @return Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
     *         thumbnails in a serial manner, to the media/thumbnails/(width)x(height) directory, where (width) and
     *         (height) are the width and height of the thumbnail. <code>LATEST</code> saves the latest thumbnail in
     *         media/latest_thumbnail/(width)x(height)/thumb.jpg and overwrites it at the interval specified by
     *         <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code>.
     *         Default: <code>SEQUENTIAL</code>.
     */
    public final List<String> storageAsStrings() {
        return storage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasStorage() ? storageAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositionThumbnailConfiguration)) {
            return false;
        }
        CompositionThumbnailConfiguration other = (CompositionThumbnailConfiguration) obj;
        return Objects.equals(targetIntervalSeconds(), other.targetIntervalSeconds()) && hasStorage() == other.hasStorage()
                && Objects.equals(storageAsStrings(), other.storageAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompositionThumbnailConfiguration").add("TargetIntervalSeconds", targetIntervalSeconds())
                .add("Storage", hasStorage() ? storageAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetIntervalSeconds":
            return Optional.ofNullable(clazz.cast(targetIntervalSeconds()));
        case "storage":
            return Optional.ofNullable(clazz.cast(storageAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("targetIntervalSeconds", TARGET_INTERVAL_SECONDS_FIELD);
        map.put("storage", STORAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompositionThumbnailConfiguration, T> g) {
        return obj -> g.apply((CompositionThumbnailConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompositionThumbnailConfiguration> {
        /**
         * <p>
         * The targeted thumbnail-generation interval in seconds. Default: 60.
         * </p>
         * 
         * @param targetIntervalSeconds
         *        The targeted thumbnail-generation interval in seconds. Default: 60.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIntervalSeconds(Integer targetIntervalSeconds);

        /**
         * <p>
         * Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
         * thumbnails in a serial manner, to the media/thumbnails/(width)x(height) directory, where (width) and (height)
         * are the width and height of the thumbnail. <code>LATEST</code> saves the latest thumbnail in
         * media/latest_thumbnail/(width)x(height)/thumb.jpg and overwrites it at the interval specified by
         * <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code>.
         * Default: <code>SEQUENTIAL</code>.
         * </p>
         * 
         * @param storage
         *        Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
         *        thumbnails in a serial manner, to the media/thumbnails/(width)x(height) directory, where (width) and
         *        (height) are the width and height of the thumbnail. <code>LATEST</code> saves the latest thumbnail in
         *        media/latest_thumbnail/(width)x(height)/thumb.jpg and overwrites it at the interval specified by
         *        <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and
         *        <code>LATEST</code>. Default: <code>SEQUENTIAL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageWithStrings(Collection<String> storage);

        /**
         * <p>
         * Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
         * thumbnails in a serial manner, to the media/thumbnails/(width)x(height) directory, where (width) and (height)
         * are the width and height of the thumbnail. <code>LATEST</code> saves the latest thumbnail in
         * media/latest_thumbnail/(width)x(height)/thumb.jpg and overwrites it at the interval specified by
         * <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code>.
         * Default: <code>SEQUENTIAL</code>.
         * </p>
         * 
         * @param storage
         *        Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
         *        thumbnails in a serial manner, to the media/thumbnails/(width)x(height) directory, where (width) and
         *        (height) are the width and height of the thumbnail. <code>LATEST</code> saves the latest thumbnail in
         *        media/latest_thumbnail/(width)x(height)/thumb.jpg and overwrites it at the interval specified by
         *        <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and
         *        <code>LATEST</code>. Default: <code>SEQUENTIAL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageWithStrings(String... storage);

        /**
         * <p>
         * Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
         * thumbnails in a serial manner, to the media/thumbnails/(width)x(height) directory, where (width) and (height)
         * are the width and height of the thumbnail. <code>LATEST</code> saves the latest thumbnail in
         * media/latest_thumbnail/(width)x(height)/thumb.jpg and overwrites it at the interval specified by
         * <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code>.
         * Default: <code>SEQUENTIAL</code>.
         * </p>
         * 
         * @param storage
         *        Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
         *        thumbnails in a serial manner, to the media/thumbnails/(width)x(height) directory, where (width) and
         *        (height) are the width and height of the thumbnail. <code>LATEST</code> saves the latest thumbnail in
         *        media/latest_thumbnail/(width)x(height)/thumb.jpg and overwrites it at the interval specified by
         *        <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and
         *        <code>LATEST</code>. Default: <code>SEQUENTIAL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(Collection<ThumbnailStorageType> storage);

        /**
         * <p>
         * Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
         * thumbnails in a serial manner, to the media/thumbnails/(width)x(height) directory, where (width) and (height)
         * are the width and height of the thumbnail. <code>LATEST</code> saves the latest thumbnail in
         * media/latest_thumbnail/(width)x(height)/thumb.jpg and overwrites it at the interval specified by
         * <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and <code>LATEST</code>.
         * Default: <code>SEQUENTIAL</code>.
         * </p>
         * 
         * @param storage
         *        Indicates the format in which thumbnails are recorded. <code>SEQUENTIAL</code> records all generated
         *        thumbnails in a serial manner, to the media/thumbnails/(width)x(height) directory, where (width) and
         *        (height) are the width and height of the thumbnail. <code>LATEST</code> saves the latest thumbnail in
         *        media/latest_thumbnail/(width)x(height)/thumb.jpg and overwrites it at the interval specified by
         *        <code>targetIntervalSeconds</code>. You can enable both <code>SEQUENTIAL</code> and
         *        <code>LATEST</code>. Default: <code>SEQUENTIAL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(ThumbnailStorageType... storage);
    }

    static final class BuilderImpl implements Builder {
        private Integer targetIntervalSeconds;

        private List<String> storage = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CompositionThumbnailConfiguration model) {
            targetIntervalSeconds(model.targetIntervalSeconds);
            storageWithStrings(model.storage);
        }

        public final Integer getTargetIntervalSeconds() {
            return targetIntervalSeconds;
        }

        public final void setTargetIntervalSeconds(Integer targetIntervalSeconds) {
            this.targetIntervalSeconds = targetIntervalSeconds;
        }

        @Override
        public final Builder targetIntervalSeconds(Integer targetIntervalSeconds) {
            this.targetIntervalSeconds = targetIntervalSeconds;
            return this;
        }

        public final Collection<String> getStorage() {
            if (storage instanceof SdkAutoConstructList) {
                return null;
            }
            return storage;
        }

        public final void setStorage(Collection<String> storage) {
            this.storage = ThumbnailStorageTypeListCopier.copy(storage);
        }

        @Override
        public final Builder storageWithStrings(Collection<String> storage) {
            this.storage = ThumbnailStorageTypeListCopier.copy(storage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageWithStrings(String... storage) {
            storageWithStrings(Arrays.asList(storage));
            return this;
        }

        @Override
        public final Builder storage(Collection<ThumbnailStorageType> storage) {
            this.storage = ThumbnailStorageTypeListCopier.copyEnumToString(storage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storage(ThumbnailStorageType... storage) {
            storage(Arrays.asList(storage));
            return this;
        }

        @Override
        public CompositionThumbnailConfiguration build() {
            return new CompositionThumbnailConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
