/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStageSessionRequest extends IvsRealTimeRequest implements
        ToCopyableBuilder<GetStageSessionRequest.Builder, GetStageSessionRequest> {
    private static final SdkField<String> STAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageArn").getter(getter(GetStageSessionRequest::stageArn)).setter(setter(Builder::stageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageArn").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(GetStageSessionRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_ARN_FIELD,
            SESSION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stageArn;

    private final String sessionId;

    private GetStageSessionRequest(BuilderImpl builder) {
        super(builder);
        this.stageArn = builder.stageArn;
        this.sessionId = builder.sessionId;
    }

    /**
     * <p>
     * ARN of the stage for which the information is to be retrieved.
     * </p>
     * 
     * @return ARN of the stage for which the information is to be retrieved.
     */
    public final String stageArn() {
        return stageArn;
    }

    /**
     * <p>
     * ID of a session within the stage.
     * </p>
     * 
     * @return ID of a session within the stage.
     */
    public final String sessionId() {
        return sessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stageArn());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStageSessionRequest)) {
            return false;
        }
        GetStageSessionRequest other = (GetStageSessionRequest) obj;
        return Objects.equals(stageArn(), other.stageArn()) && Objects.equals(sessionId(), other.sessionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStageSessionRequest").add("StageArn", stageArn()).add("SessionId", sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stageArn":
            return Optional.ofNullable(clazz.cast(stageArn()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stageArn", STAGE_ARN_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStageSessionRequest, T> g) {
        return obj -> g.apply((GetStageSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IvsRealTimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetStageSessionRequest> {
        /**
         * <p>
         * ARN of the stage for which the information is to be retrieved.
         * </p>
         * 
         * @param stageArn
         *        ARN of the stage for which the information is to be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageArn(String stageArn);

        /**
         * <p>
         * ID of a session within the stage.
         * </p>
         * 
         * @param sessionId
         *        ID of a session within the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRealTimeRequest.BuilderImpl implements Builder {
        private String stageArn;

        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStageSessionRequest model) {
            super(model);
            stageArn(model.stageArn);
            sessionId(model.sessionId);
        }

        public final String getStageArn() {
            return stageArn;
        }

        public final void setStageArn(String stageArn) {
            this.stageArn = stageArn;
        }

        @Override
        public final Builder stageArn(String stageArn) {
            this.stageArn = stageArn;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetStageSessionRequest build() {
            return new GetStageSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
