/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about an IngestConfiguration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngestConfigurationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<IngestConfigurationSummary.Builder, IngestConfigurationSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(IngestConfigurationSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(IngestConfigurationSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> INGEST_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ingestProtocol").getter(getter(IngestConfigurationSummary::ingestProtocolAsString))
            .setter(setter(Builder::ingestProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestProtocol").build()).build();

    private static final SdkField<String> STAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageArn").getter(getter(IngestConfigurationSummary::stageArn)).setter(setter(Builder::stageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageArn").build()).build();

    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("participantId").getter(getter(IngestConfigurationSummary::participantId))
            .setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(IngestConfigurationSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(IngestConfigurationSummary::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            INGEST_PROTOCOL_FIELD, STAGE_ARN_FIELD, PARTICIPANT_ID_FIELD, STATE_FIELD, USER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String ingestProtocol;

    private final String stageArn;

    private final String participantId;

    private final String state;

    private final String userId;

    private IngestConfigurationSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.ingestProtocol = builder.ingestProtocol;
        this.stageArn = builder.stageArn;
        this.participantId = builder.participantId;
        this.state = builder.state;
        this.userId = builder.userId;
    }

    /**
     * <p>
     * Ingest name.
     * </p>
     * 
     * @return Ingest name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Ingest configuration ARN.
     * </p>
     * 
     * @return Ingest configuration ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Type of ingest protocol that the user employs for broadcasting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestProtocol}
     * will return {@link IngestProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ingestProtocolAsString}.
     * </p>
     * 
     * @return Type of ingest protocol that the user employs for broadcasting.
     * @see IngestProtocol
     */
    public final IngestProtocol ingestProtocol() {
        return IngestProtocol.fromValue(ingestProtocol);
    }

    /**
     * <p>
     * Type of ingest protocol that the user employs for broadcasting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ingestProtocol}
     * will return {@link IngestProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ingestProtocolAsString}.
     * </p>
     * 
     * @return Type of ingest protocol that the user employs for broadcasting.
     * @see IngestProtocol
     */
    public final String ingestProtocolAsString() {
        return ingestProtocol;
    }

    /**
     * <p>
     * ARN of the stage with which the IngestConfiguration is associated.
     * </p>
     * 
     * @return ARN of the stage with which the IngestConfiguration is associated.
     */
    public final String stageArn() {
        return stageArn;
    }

    /**
     * <p>
     * ID of the participant within the stage.
     * </p>
     * 
     * @return ID of the participant within the stage.
     */
    public final String participantId() {
        return participantId;
    }

    /**
     * <p>
     * State of the ingest configuration. It is <code>ACTIVE</code> if a publisher currently is publishing to the stage
     * associated with the ingest configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link IngestConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return State of the ingest configuration. It is <code>ACTIVE</code> if a publisher currently is publishing to
     *         the stage associated with the ingest configuration.
     * @see IngestConfigurationState
     */
    public final IngestConfigurationState state() {
        return IngestConfigurationState.fromValue(state);
    }

    /**
     * <p>
     * State of the ingest configuration. It is <code>ACTIVE</code> if a publisher currently is publishing to the stage
     * associated with the ingest configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link IngestConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return State of the ingest configuration. It is <code>ACTIVE</code> if a publisher currently is publishing to
     *         the stage associated with the ingest configuration.
     * @see IngestConfigurationState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Customer-assigned name to help identify the participant using the IngestConfiguration; this can be used to link a
     * participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. <i>This field is exposed
     * to all stage participants and should not be used for personally identifying, confidential, or sensitive
     * information.</i>
     * </p>
     * 
     * @return Customer-assigned name to help identify the participant using the IngestConfiguration; this can be used
     *         to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text.
     *         <i>This field is exposed to all stage participants and should not be used for personally identifying,
     *         confidential, or sensitive information.</i>
     */
    public final String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(ingestProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stageArn());
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestConfigurationSummary)) {
            return false;
        }
        IngestConfigurationSummary other = (IngestConfigurationSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(ingestProtocolAsString(), other.ingestProtocolAsString())
                && Objects.equals(stageArn(), other.stageArn()) && Objects.equals(participantId(), other.participantId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(userId(), other.userId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngestConfigurationSummary").add("Name", name()).add("Arn", arn())
                .add("IngestProtocol", ingestProtocolAsString()).add("StageArn", stageArn())
                .add("ParticipantId", participantId()).add("State", stateAsString()).add("UserId", userId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ingestProtocol":
            return Optional.ofNullable(clazz.cast(ingestProtocolAsString()));
        case "stageArn":
            return Optional.ofNullable(clazz.cast(stageArn()));
        case "participantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("ingestProtocol", INGEST_PROTOCOL_FIELD);
        map.put("stageArn", STAGE_ARN_FIELD);
        map.put("participantId", PARTICIPANT_ID_FIELD);
        map.put("state", STATE_FIELD);
        map.put("userId", USER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngestConfigurationSummary, T> g) {
        return obj -> g.apply((IngestConfigurationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngestConfigurationSummary> {
        /**
         * <p>
         * Ingest name.
         * </p>
         * 
         * @param name
         *        Ingest name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Ingest configuration ARN.
         * </p>
         * 
         * @param arn
         *        Ingest configuration ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Type of ingest protocol that the user employs for broadcasting.
         * </p>
         * 
         * @param ingestProtocol
         *        Type of ingest protocol that the user employs for broadcasting.
         * @see IngestProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestProtocol
         */
        Builder ingestProtocol(String ingestProtocol);

        /**
         * <p>
         * Type of ingest protocol that the user employs for broadcasting.
         * </p>
         * 
         * @param ingestProtocol
         *        Type of ingest protocol that the user employs for broadcasting.
         * @see IngestProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestProtocol
         */
        Builder ingestProtocol(IngestProtocol ingestProtocol);

        /**
         * <p>
         * ARN of the stage with which the IngestConfiguration is associated.
         * </p>
         * 
         * @param stageArn
         *        ARN of the stage with which the IngestConfiguration is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageArn(String stageArn);

        /**
         * <p>
         * ID of the participant within the stage.
         * </p>
         * 
         * @param participantId
         *        ID of the participant within the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);

        /**
         * <p>
         * State of the ingest configuration. It is <code>ACTIVE</code> if a publisher currently is publishing to the
         * stage associated with the ingest configuration.
         * </p>
         * 
         * @param state
         *        State of the ingest configuration. It is <code>ACTIVE</code> if a publisher currently is publishing to
         *        the stage associated with the ingest configuration.
         * @see IngestConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestConfigurationState
         */
        Builder state(String state);

        /**
         * <p>
         * State of the ingest configuration. It is <code>ACTIVE</code> if a publisher currently is publishing to the
         * stage associated with the ingest configuration.
         * </p>
         * 
         * @param state
         *        State of the ingest configuration. It is <code>ACTIVE</code> if a publisher currently is publishing to
         *        the stage associated with the ingest configuration.
         * @see IngestConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestConfigurationState
         */
        Builder state(IngestConfigurationState state);

        /**
         * <p>
         * Customer-assigned name to help identify the participant using the IngestConfiguration; this can be used to
         * link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. <i>This field
         * is exposed to all stage participants and should not be used for personally identifying, confidential, or
         * sensitive information.</i>
         * </p>
         * 
         * @param userId
         *        Customer-assigned name to help identify the participant using the IngestConfiguration; this can be
         *        used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded
         *        text. <i>This field is exposed to all stage participants and should not be used for personally
         *        identifying, confidential, or sensitive information.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String ingestProtocol;

        private String stageArn;

        private String participantId;

        private String state;

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestConfigurationSummary model) {
            name(model.name);
            arn(model.arn);
            ingestProtocol(model.ingestProtocol);
            stageArn(model.stageArn);
            participantId(model.participantId);
            state(model.state);
            userId(model.userId);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getIngestProtocol() {
            return ingestProtocol;
        }

        public final void setIngestProtocol(String ingestProtocol) {
            this.ingestProtocol = ingestProtocol;
        }

        @Override
        public final Builder ingestProtocol(String ingestProtocol) {
            this.ingestProtocol = ingestProtocol;
            return this;
        }

        @Override
        public final Builder ingestProtocol(IngestProtocol ingestProtocol) {
            this.ingestProtocol(ingestProtocol == null ? null : ingestProtocol.toString());
            return this;
        }

        public final String getStageArn() {
            return stageArn;
        }

        public final void setStageArn(String stageArn) {
            this.stageArn = stageArn;
        }

        @Override
        public final Builder stageArn(String stageArn) {
            this.stageArn = stageArn;
            return this;
        }

        public final String getParticipantId() {
            return participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IngestConfigurationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public IngestConfigurationSummary build() {
            return new IngestConfigurationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
