/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the replicated destination stage for a participant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParticipantReplica implements SdkPojo, Serializable,
        ToCopyableBuilder<ParticipantReplica.Builder, ParticipantReplica> {
    private static final SdkField<String> SOURCE_STAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceStageArn").getter(getter(ParticipantReplica::sourceStageArn))
            .setter(setter(Builder::sourceStageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceStageArn").build()).build();

    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("participantId").getter(getter(ParticipantReplica::participantId)).setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantId").build()).build();

    private static final SdkField<String> SOURCE_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceSessionId").getter(getter(ParticipantReplica::sourceSessionId))
            .setter(setter(Builder::sourceSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSessionId").build()).build();

    private static final SdkField<String> DESTINATION_STAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationStageArn").getter(getter(ParticipantReplica::destinationStageArn))
            .setter(setter(Builder::destinationStageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationStageArn").build())
            .build();

    private static final SdkField<String> DESTINATION_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationSessionId").getter(getter(ParticipantReplica::destinationSessionId))
            .setter(setter(Builder::destinationSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSessionId").build())
            .build();

    private static final SdkField<String> REPLICATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicationState").getter(getter(ParticipantReplica::replicationStateAsString))
            .setter(setter(Builder::replicationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_STAGE_ARN_FIELD,
            PARTICIPANT_ID_FIELD, SOURCE_SESSION_ID_FIELD, DESTINATION_STAGE_ARN_FIELD, DESTINATION_SESSION_ID_FIELD,
            REPLICATION_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceStageArn;

    private final String participantId;

    private final String sourceSessionId;

    private final String destinationStageArn;

    private final String destinationSessionId;

    private final String replicationState;

    private ParticipantReplica(BuilderImpl builder) {
        this.sourceStageArn = builder.sourceStageArn;
        this.participantId = builder.participantId;
        this.sourceSessionId = builder.sourceSessionId;
        this.destinationStageArn = builder.destinationStageArn;
        this.destinationSessionId = builder.destinationSessionId;
        this.replicationState = builder.replicationState;
    }

    /**
     * <p>
     * ARN of the stage from which this participant is replicated.
     * </p>
     * 
     * @return ARN of the stage from which this participant is replicated.
     */
    public final String sourceStageArn() {
        return sourceStageArn;
    }

    /**
     * <p>
     * Participant ID of the publisher that will be replicated. This is assigned by IVS and returned by
     * <a>CreateParticipantToken</a> or the <code>jti</code> (JWT ID) used to <a href=
     * "https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started-distribute-tokens.html#getting-started-distribute-tokens-self-signed"
     * > create a self signed token</a>.
     * </p>
     * 
     * @return Participant ID of the publisher that will be replicated. This is assigned by IVS and returned by
     *         <a>CreateParticipantToken</a> or the <code>jti</code> (JWT ID) used to <a href=
     *         "https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started-distribute-tokens.html#getting-started-distribute-tokens-self-signed"
     *         > create a self signed token</a>.
     */
    public final String participantId() {
        return participantId;
    }

    /**
     * <p>
     * ID of the session within the source stage.
     * </p>
     * 
     * @return ID of the session within the source stage.
     */
    public final String sourceSessionId() {
        return sourceSessionId;
    }

    /**
     * <p>
     * ARN of the stage where the participant is replicated.
     * </p>
     * 
     * @return ARN of the stage where the participant is replicated.
     */
    public final String destinationStageArn() {
        return destinationStageArn;
    }

    /**
     * <p>
     * ID of the session within the destination stage.
     * </p>
     * 
     * @return ID of the session within the destination stage.
     */
    public final String destinationSessionId() {
        return destinationSessionId;
    }

    /**
     * <p>
     * Replica’s current replication state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationState}
     * will return {@link ReplicationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicationStateAsString}.
     * </p>
     * 
     * @return Replica’s current replication state.
     * @see ReplicationState
     */
    public final ReplicationState replicationState() {
        return ReplicationState.fromValue(replicationState);
    }

    /**
     * <p>
     * Replica’s current replication state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationState}
     * will return {@link ReplicationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicationStateAsString}.
     * </p>
     * 
     * @return Replica’s current replication state.
     * @see ReplicationState
     */
    public final String replicationStateAsString() {
        return replicationState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceStageArn());
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationStageArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(replicationStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantReplica)) {
            return false;
        }
        ParticipantReplica other = (ParticipantReplica) obj;
        return Objects.equals(sourceStageArn(), other.sourceStageArn()) && Objects.equals(participantId(), other.participantId())
                && Objects.equals(sourceSessionId(), other.sourceSessionId())
                && Objects.equals(destinationStageArn(), other.destinationStageArn())
                && Objects.equals(destinationSessionId(), other.destinationSessionId())
                && Objects.equals(replicationStateAsString(), other.replicationStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParticipantReplica").add("SourceStageArn", sourceStageArn())
                .add("ParticipantId", participantId()).add("SourceSessionId", sourceSessionId())
                .add("DestinationStageArn", destinationStageArn()).add("DestinationSessionId", destinationSessionId())
                .add("ReplicationState", replicationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceStageArn":
            return Optional.ofNullable(clazz.cast(sourceStageArn()));
        case "participantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        case "sourceSessionId":
            return Optional.ofNullable(clazz.cast(sourceSessionId()));
        case "destinationStageArn":
            return Optional.ofNullable(clazz.cast(destinationStageArn()));
        case "destinationSessionId":
            return Optional.ofNullable(clazz.cast(destinationSessionId()));
        case "replicationState":
            return Optional.ofNullable(clazz.cast(replicationStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceStageArn", SOURCE_STAGE_ARN_FIELD);
        map.put("participantId", PARTICIPANT_ID_FIELD);
        map.put("sourceSessionId", SOURCE_SESSION_ID_FIELD);
        map.put("destinationStageArn", DESTINATION_STAGE_ARN_FIELD);
        map.put("destinationSessionId", DESTINATION_SESSION_ID_FIELD);
        map.put("replicationState", REPLICATION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParticipantReplica, T> g) {
        return obj -> g.apply((ParticipantReplica) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParticipantReplica> {
        /**
         * <p>
         * ARN of the stage from which this participant is replicated.
         * </p>
         * 
         * @param sourceStageArn
         *        ARN of the stage from which this participant is replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceStageArn(String sourceStageArn);

        /**
         * <p>
         * Participant ID of the publisher that will be replicated. This is assigned by IVS and returned by
         * <a>CreateParticipantToken</a> or the <code>jti</code> (JWT ID) used to <a href=
         * "https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started-distribute-tokens.html#getting-started-distribute-tokens-self-signed"
         * > create a self signed token</a>.
         * </p>
         * 
         * @param participantId
         *        Participant ID of the publisher that will be replicated. This is assigned by IVS and returned by
         *        <a>CreateParticipantToken</a> or the <code>jti</code> (JWT ID) used to <a href=
         *        "https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started-distribute-tokens.html#getting-started-distribute-tokens-self-signed"
         *        > create a self signed token</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);

        /**
         * <p>
         * ID of the session within the source stage.
         * </p>
         * 
         * @param sourceSessionId
         *        ID of the session within the source stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSessionId(String sourceSessionId);

        /**
         * <p>
         * ARN of the stage where the participant is replicated.
         * </p>
         * 
         * @param destinationStageArn
         *        ARN of the stage where the participant is replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationStageArn(String destinationStageArn);

        /**
         * <p>
         * ID of the session within the destination stage.
         * </p>
         * 
         * @param destinationSessionId
         *        ID of the session within the destination stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSessionId(String destinationSessionId);

        /**
         * <p>
         * Replica’s current replication state.
         * </p>
         * 
         * @param replicationState
         *        Replica’s current replication state.
         * @see ReplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationState
         */
        Builder replicationState(String replicationState);

        /**
         * <p>
         * Replica’s current replication state.
         * </p>
         * 
         * @param replicationState
         *        Replica’s current replication state.
         * @see ReplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationState
         */
        Builder replicationState(ReplicationState replicationState);
    }

    static final class BuilderImpl implements Builder {
        private String sourceStageArn;

        private String participantId;

        private String sourceSessionId;

        private String destinationStageArn;

        private String destinationSessionId;

        private String replicationState;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantReplica model) {
            sourceStageArn(model.sourceStageArn);
            participantId(model.participantId);
            sourceSessionId(model.sourceSessionId);
            destinationStageArn(model.destinationStageArn);
            destinationSessionId(model.destinationSessionId);
            replicationState(model.replicationState);
        }

        public final String getSourceStageArn() {
            return sourceStageArn;
        }

        public final void setSourceStageArn(String sourceStageArn) {
            this.sourceStageArn = sourceStageArn;
        }

        @Override
        public final Builder sourceStageArn(String sourceStageArn) {
            this.sourceStageArn = sourceStageArn;
            return this;
        }

        public final String getParticipantId() {
            return participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getSourceSessionId() {
            return sourceSessionId;
        }

        public final void setSourceSessionId(String sourceSessionId) {
            this.sourceSessionId = sourceSessionId;
        }

        @Override
        public final Builder sourceSessionId(String sourceSessionId) {
            this.sourceSessionId = sourceSessionId;
            return this;
        }

        public final String getDestinationStageArn() {
            return destinationStageArn;
        }

        public final void setDestinationStageArn(String destinationStageArn) {
            this.destinationStageArn = destinationStageArn;
        }

        @Override
        public final Builder destinationStageArn(String destinationStageArn) {
            this.destinationStageArn = destinationStageArn;
            return this;
        }

        public final String getDestinationSessionId() {
            return destinationSessionId;
        }

        public final void setDestinationSessionId(String destinationSessionId) {
            this.destinationSessionId = destinationSessionId;
        }

        @Override
        public final Builder destinationSessionId(String destinationSessionId) {
            this.destinationSessionId = destinationSessionId;
            return this;
        }

        public final String getReplicationState() {
            return replicationState;
        }

        public final void setReplicationState(String replicationState) {
            this.replicationState = replicationState;
        }

        @Override
        public final Builder replicationState(String replicationState) {
            this.replicationState = replicationState;
            return this;
        }

        @Override
        public final Builder replicationState(ReplicationState replicationState) {
            this.replicationState(replicationState == null ? null : replicationState.toString());
            return this;
        }

        @Override
        public ParticipantReplica build() {
            return new ParticipantReplica(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
