/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartParticipantReplicationRequest extends IvsRealTimeRequest implements
        ToCopyableBuilder<StartParticipantReplicationRequest.Builder, StartParticipantReplicationRequest> {
    private static final SdkField<String> SOURCE_STAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceStageArn").getter(getter(StartParticipantReplicationRequest::sourceStageArn))
            .setter(setter(Builder::sourceStageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceStageArn").build()).build();

    private static final SdkField<String> DESTINATION_STAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationStageArn").getter(getter(StartParticipantReplicationRequest::destinationStageArn))
            .setter(setter(Builder::destinationStageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationStageArn").build())
            .build();

    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("participantId").getter(getter(StartParticipantReplicationRequest::participantId))
            .setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantId").build()).build();

    private static final SdkField<Integer> RECONNECT_WINDOW_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("reconnectWindowSeconds").getter(getter(StartParticipantReplicationRequest::reconnectWindowSeconds))
            .setter(setter(Builder::reconnectWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reconnectWindowSeconds").build())
            .build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("attributes")
            .getter(getter(StartParticipantReplicationRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_STAGE_ARN_FIELD,
            DESTINATION_STAGE_ARN_FIELD, PARTICIPANT_ID_FIELD, RECONNECT_WINDOW_SECONDS_FIELD, ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sourceStageArn;

    private final String destinationStageArn;

    private final String participantId;

    private final Integer reconnectWindowSeconds;

    private final Map<String, String> attributes;

    private StartParticipantReplicationRequest(BuilderImpl builder) {
        super(builder);
        this.sourceStageArn = builder.sourceStageArn;
        this.destinationStageArn = builder.destinationStageArn;
        this.participantId = builder.participantId;
        this.reconnectWindowSeconds = builder.reconnectWindowSeconds;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * ARN of the stage where the participant is publishing.
     * </p>
     * 
     * @return ARN of the stage where the participant is publishing.
     */
    public final String sourceStageArn() {
        return sourceStageArn;
    }

    /**
     * <p>
     * ARN of the stage to which the participant will be replicated.
     * </p>
     * 
     * @return ARN of the stage to which the participant will be replicated.
     */
    public final String destinationStageArn() {
        return destinationStageArn;
    }

    /**
     * <p>
     * Participant ID of the publisher that will be replicated. This is assigned by IVS and returned by
     * <a>CreateParticipantToken</a> or the <code>jti</code> (JWT ID) used to <a href=
     * "https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started-distribute-tokens.html#getting-started-distribute-tokens-self-signed"
     * >create a self signed token</a>.
     * </p>
     * 
     * @return Participant ID of the publisher that will be replicated. This is assigned by IVS and returned by
     *         <a>CreateParticipantToken</a> or the <code>jti</code> (JWT ID) used to <a href=
     *         "https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started-distribute-tokens.html#getting-started-distribute-tokens-self-signed"
     *         >create a self signed token</a>.
     */
    public final String participantId() {
        return participantId;
    }

    /**
     * <p>
     * If the participant disconnects and then reconnects within the specified interval, replication will continue to be
     * <code>ACTIVE</code>. Default: 0.
     * </p>
     * 
     * @return If the participant disconnects and then reconnects within the specified interval, replication will
     *         continue to be <code>ACTIVE</code>. Default: 0.
     */
    public final Integer reconnectWindowSeconds() {
        return reconnectWindowSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Application-provided attributes to set on the replicated participant in the destination stage. Map keys and
     * values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is exposed
     * to all stage participants and should not be used for personally identifying, confidential, or sensitive
     * information.</i>
     * </p>
     * <p>
     * These attributes are merged with any attributes set for this participant when creating the token. If there is
     * overlap in keys, the values in these attributes are replaced.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return Application-provided attributes to set on the replicated participant in the destination stage. Map keys
     *         and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field
     *         is exposed to all stage participants and should not be used for personally identifying, confidential, or
     *         sensitive information.</i> </p>
     *         <p>
     *         These attributes are merged with any attributes set for this participant when creating the token. If
     *         there is overlap in keys, the values in these attributes are replaced.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceStageArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationStageArn());
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        hashCode = 31 * hashCode + Objects.hashCode(reconnectWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartParticipantReplicationRequest)) {
            return false;
        }
        StartParticipantReplicationRequest other = (StartParticipantReplicationRequest) obj;
        return Objects.equals(sourceStageArn(), other.sourceStageArn())
                && Objects.equals(destinationStageArn(), other.destinationStageArn())
                && Objects.equals(participantId(), other.participantId())
                && Objects.equals(reconnectWindowSeconds(), other.reconnectWindowSeconds())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartParticipantReplicationRequest").add("SourceStageArn", sourceStageArn())
                .add("DestinationStageArn", destinationStageArn()).add("ParticipantId", participantId())
                .add("ReconnectWindowSeconds", reconnectWindowSeconds()).add("Attributes", hasAttributes() ? attributes() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceStageArn":
            return Optional.ofNullable(clazz.cast(sourceStageArn()));
        case "destinationStageArn":
            return Optional.ofNullable(clazz.cast(destinationStageArn()));
        case "participantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        case "reconnectWindowSeconds":
            return Optional.ofNullable(clazz.cast(reconnectWindowSeconds()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceStageArn", SOURCE_STAGE_ARN_FIELD);
        map.put("destinationStageArn", DESTINATION_STAGE_ARN_FIELD);
        map.put("participantId", PARTICIPANT_ID_FIELD);
        map.put("reconnectWindowSeconds", RECONNECT_WINDOW_SECONDS_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartParticipantReplicationRequest, T> g) {
        return obj -> g.apply((StartParticipantReplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IvsRealTimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartParticipantReplicationRequest> {
        /**
         * <p>
         * ARN of the stage where the participant is publishing.
         * </p>
         * 
         * @param sourceStageArn
         *        ARN of the stage where the participant is publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceStageArn(String sourceStageArn);

        /**
         * <p>
         * ARN of the stage to which the participant will be replicated.
         * </p>
         * 
         * @param destinationStageArn
         *        ARN of the stage to which the participant will be replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationStageArn(String destinationStageArn);

        /**
         * <p>
         * Participant ID of the publisher that will be replicated. This is assigned by IVS and returned by
         * <a>CreateParticipantToken</a> or the <code>jti</code> (JWT ID) used to <a href=
         * "https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started-distribute-tokens.html#getting-started-distribute-tokens-self-signed"
         * >create a self signed token</a>.
         * </p>
         * 
         * @param participantId
         *        Participant ID of the publisher that will be replicated. This is assigned by IVS and returned by
         *        <a>CreateParticipantToken</a> or the <code>jti</code> (JWT ID) used to <a href=
         *        "https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started-distribute-tokens.html#getting-started-distribute-tokens-self-signed"
         *        >create a self signed token</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);

        /**
         * <p>
         * If the participant disconnects and then reconnects within the specified interval, replication will continue
         * to be <code>ACTIVE</code>. Default: 0.
         * </p>
         * 
         * @param reconnectWindowSeconds
         *        If the participant disconnects and then reconnects within the specified interval, replication will
         *        continue to be <code>ACTIVE</code>. Default: 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reconnectWindowSeconds(Integer reconnectWindowSeconds);

        /**
         * <p>
         * Application-provided attributes to set on the replicated participant in the destination stage. Map keys and
         * values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. <i>This field is
         * exposed to all stage participants and should not be used for personally identifying, confidential, or
         * sensitive information.</i>
         * </p>
         * <p>
         * These attributes are merged with any attributes set for this participant when creating the token. If there is
         * overlap in keys, the values in these attributes are replaced.
         * </p>
         * 
         * @param attributes
         *        Application-provided attributes to set on the replicated participant in the destination stage. Map
         *        keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total.
         *        <i>This field is exposed to all stage participants and should not be used for personally identifying,
         *        confidential, or sensitive information.</i> </p>
         *        <p>
         *        These attributes are merged with any attributes set for this participant when creating the token. If
         *        there is overlap in keys, the values in these attributes are replaced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRealTimeRequest.BuilderImpl implements Builder {
        private String sourceStageArn;

        private String destinationStageArn;

        private String participantId;

        private Integer reconnectWindowSeconds;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartParticipantReplicationRequest model) {
            super(model);
            sourceStageArn(model.sourceStageArn);
            destinationStageArn(model.destinationStageArn);
            participantId(model.participantId);
            reconnectWindowSeconds(model.reconnectWindowSeconds);
            attributes(model.attributes);
        }

        public final String getSourceStageArn() {
            return sourceStageArn;
        }

        public final void setSourceStageArn(String sourceStageArn) {
            this.sourceStageArn = sourceStageArn;
        }

        @Override
        public final Builder sourceStageArn(String sourceStageArn) {
            this.sourceStageArn = sourceStageArn;
            return this;
        }

        public final String getDestinationStageArn() {
            return destinationStageArn;
        }

        public final void setDestinationStageArn(String destinationStageArn) {
            this.destinationStageArn = destinationStageArn;
        }

        @Override
        public final Builder destinationStageArn(String destinationStageArn) {
            this.destinationStageArn = destinationStageArn;
            return this;
        }

        public final String getParticipantId() {
            return participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final Integer getReconnectWindowSeconds() {
            return reconnectWindowSeconds;
        }

        public final void setReconnectWindowSeconds(Integer reconnectWindowSeconds) {
            this.reconnectWindowSeconds = reconnectWindowSeconds;
        }

        @Override
        public final Builder reconnectWindowSeconds(Integer reconnectWindowSeconds) {
            this.reconnectWindowSeconds = reconnectWindowSeconds;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = ParticipantAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = ParticipantAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartParticipantReplicationRequest build() {
            return new StartParticipantReplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
