/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopParticipantReplicationRequest extends IvsRealTimeRequest implements
        ToCopyableBuilder<StopParticipantReplicationRequest.Builder, StopParticipantReplicationRequest> {
    private static final SdkField<String> SOURCE_STAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceStageArn").getter(getter(StopParticipantReplicationRequest::sourceStageArn))
            .setter(setter(Builder::sourceStageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceStageArn").build()).build();

    private static final SdkField<String> DESTINATION_STAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationStageArn").getter(getter(StopParticipantReplicationRequest::destinationStageArn))
            .setter(setter(Builder::destinationStageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationStageArn").build())
            .build();

    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("participantId").getter(getter(StopParticipantReplicationRequest::participantId))
            .setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_STAGE_ARN_FIELD,
            DESTINATION_STAGE_ARN_FIELD, PARTICIPANT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sourceStageArn;

    private final String destinationStageArn;

    private final String participantId;

    private StopParticipantReplicationRequest(BuilderImpl builder) {
        super(builder);
        this.sourceStageArn = builder.sourceStageArn;
        this.destinationStageArn = builder.destinationStageArn;
        this.participantId = builder.participantId;
    }

    /**
     * <p>
     * ARN of the stage where the participant is publishing.
     * </p>
     * 
     * @return ARN of the stage where the participant is publishing.
     */
    public final String sourceStageArn() {
        return sourceStageArn;
    }

    /**
     * <p>
     * ARN of the stage where the participant has been replicated.
     * </p>
     * 
     * @return ARN of the stage where the participant has been replicated.
     */
    public final String destinationStageArn() {
        return destinationStageArn;
    }

    /**
     * <p>
     * Participant ID of the publisher that has been replicated. This is assigned by IVS and returned by
     * <a>CreateParticipantToken</a> or the <code>jti</code> (JWT ID) used to <a href=
     * "https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started-distribute-tokens.html#getting-started-distribute-tokens-self-signed"
     * > create a self signed token</a>.
     * </p>
     * 
     * @return Participant ID of the publisher that has been replicated. This is assigned by IVS and returned by
     *         <a>CreateParticipantToken</a> or the <code>jti</code> (JWT ID) used to <a href=
     *         "https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started-distribute-tokens.html#getting-started-distribute-tokens-self-signed"
     *         > create a self signed token</a>.
     */
    public final String participantId() {
        return participantId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceStageArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationStageArn());
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopParticipantReplicationRequest)) {
            return false;
        }
        StopParticipantReplicationRequest other = (StopParticipantReplicationRequest) obj;
        return Objects.equals(sourceStageArn(), other.sourceStageArn())
                && Objects.equals(destinationStageArn(), other.destinationStageArn())
                && Objects.equals(participantId(), other.participantId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopParticipantReplicationRequest").add("SourceStageArn", sourceStageArn())
                .add("DestinationStageArn", destinationStageArn()).add("ParticipantId", participantId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceStageArn":
            return Optional.ofNullable(clazz.cast(sourceStageArn()));
        case "destinationStageArn":
            return Optional.ofNullable(clazz.cast(destinationStageArn()));
        case "participantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceStageArn", SOURCE_STAGE_ARN_FIELD);
        map.put("destinationStageArn", DESTINATION_STAGE_ARN_FIELD);
        map.put("participantId", PARTICIPANT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopParticipantReplicationRequest, T> g) {
        return obj -> g.apply((StopParticipantReplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IvsRealTimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StopParticipantReplicationRequest> {
        /**
         * <p>
         * ARN of the stage where the participant is publishing.
         * </p>
         * 
         * @param sourceStageArn
         *        ARN of the stage where the participant is publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceStageArn(String sourceStageArn);

        /**
         * <p>
         * ARN of the stage where the participant has been replicated.
         * </p>
         * 
         * @param destinationStageArn
         *        ARN of the stage where the participant has been replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationStageArn(String destinationStageArn);

        /**
         * <p>
         * Participant ID of the publisher that has been replicated. This is assigned by IVS and returned by
         * <a>CreateParticipantToken</a> or the <code>jti</code> (JWT ID) used to <a href=
         * "https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started-distribute-tokens.html#getting-started-distribute-tokens-self-signed"
         * > create a self signed token</a>.
         * </p>
         * 
         * @param participantId
         *        Participant ID of the publisher that has been replicated. This is assigned by IVS and returned by
         *        <a>CreateParticipantToken</a> or the <code>jti</code> (JWT ID) used to <a href=
         *        "https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started-distribute-tokens.html#getting-started-distribute-tokens-self-signed"
         *        > create a self signed token</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRealTimeRequest.BuilderImpl implements Builder {
        private String sourceStageArn;

        private String destinationStageArn;

        private String participantId;

        private BuilderImpl() {
        }

        private BuilderImpl(StopParticipantReplicationRequest model) {
            super(model);
            sourceStageArn(model.sourceStageArn);
            destinationStageArn(model.destinationStageArn);
            participantId(model.participantId);
        }

        public final String getSourceStageArn() {
            return sourceStageArn;
        }

        public final void setSourceStageArn(String sourceStageArn) {
            this.sourceStageArn = sourceStageArn;
        }

        @Override
        public final Builder sourceStageArn(String sourceStageArn) {
            this.sourceStageArn = sourceStageArn;
            return this;
        }

        public final String getDestinationStageArn() {
            return destinationStageArn;
        }

        public final void setDestinationStageArn(String destinationStageArn) {
            this.destinationStageArn = destinationStageArn;
        }

        @Override
        public final Builder destinationStageArn(String destinationStageArn) {
            this.destinationStageArn = destinationStageArn;
            return this;
        }

        public final String getParticipantId() {
            return participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopParticipantReplicationRequest build() {
            return new StopParticipantReplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
