/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStageRequest extends IvsRealTimeRequest implements
        ToCopyableBuilder<UpdateStageRequest.Builder, UpdateStageRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdateStageRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateStageRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<AutoParticipantRecordingConfiguration> AUTO_PARTICIPANT_RECORDING_CONFIGURATION_FIELD = SdkField
            .<AutoParticipantRecordingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("autoParticipantRecordingConfiguration")
            .getter(getter(UpdateStageRequest::autoParticipantRecordingConfiguration))
            .setter(setter(Builder::autoParticipantRecordingConfiguration))
            .constructor(AutoParticipantRecordingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("autoParticipantRecordingConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            AUTO_PARTICIPANT_RECORDING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String name;

    private final AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration;

    private UpdateStageRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.autoParticipantRecordingConfiguration = builder.autoParticipantRecordingConfiguration;
    }

    /**
     * <p>
     * ARN of the stage to be updated.
     * </p>
     * 
     * @return ARN of the stage to be updated.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Name of the stage to be updated.
     * </p>
     * 
     * @return Name of the stage to be updated.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Configuration object for individual participant recording, to attach to the stage. Note that this cannot be
     * updated while recording is active.
     * </p>
     * 
     * @return Configuration object for individual participant recording, to attach to the stage. Note that this cannot
     *         be updated while recording is active.
     */
    public final AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration() {
        return autoParticipantRecordingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(autoParticipantRecordingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStageRequest)) {
            return false;
        }
        UpdateStageRequest other = (UpdateStageRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(autoParticipantRecordingConfiguration(), other.autoParticipantRecordingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStageRequest").add("Arn", arn()).add("Name", name())
                .add("AutoParticipantRecordingConfiguration", autoParticipantRecordingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "autoParticipantRecordingConfiguration":
            return Optional.ofNullable(clazz.cast(autoParticipantRecordingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("autoParticipantRecordingConfiguration", AUTO_PARTICIPANT_RECORDING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStageRequest, T> g) {
        return obj -> g.apply((UpdateStageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IvsRealTimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStageRequest> {
        /**
         * <p>
         * ARN of the stage to be updated.
         * </p>
         * 
         * @param arn
         *        ARN of the stage to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Name of the stage to be updated.
         * </p>
         * 
         * @param name
         *        Name of the stage to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Configuration object for individual participant recording, to attach to the stage. Note that this cannot be
         * updated while recording is active.
         * </p>
         * 
         * @param autoParticipantRecordingConfiguration
         *        Configuration object for individual participant recording, to attach to the stage. Note that this
         *        cannot be updated while recording is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration);

        /**
         * <p>
         * Configuration object for individual participant recording, to attach to the stage. Note that this cannot be
         * updated while recording is active.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutoParticipantRecordingConfiguration.Builder} avoiding the need to create one manually via
         * {@link AutoParticipantRecordingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoParticipantRecordingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #autoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration)}.
         * 
         * @param autoParticipantRecordingConfiguration
         *        a consumer that will call methods on {@link AutoParticipantRecordingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration)
         */
        default Builder autoParticipantRecordingConfiguration(
                Consumer<AutoParticipantRecordingConfiguration.Builder> autoParticipantRecordingConfiguration) {
            return autoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration.builder()
                    .applyMutation(autoParticipantRecordingConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IvsRealTimeRequest.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStageRequest model) {
            super(model);
            arn(model.arn);
            name(model.name);
            autoParticipantRecordingConfiguration(model.autoParticipantRecordingConfiguration);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AutoParticipantRecordingConfiguration.Builder getAutoParticipantRecordingConfiguration() {
            return autoParticipantRecordingConfiguration != null ? autoParticipantRecordingConfiguration.toBuilder() : null;
        }

        public final void setAutoParticipantRecordingConfiguration(
                AutoParticipantRecordingConfiguration.BuilderImpl autoParticipantRecordingConfiguration) {
            this.autoParticipantRecordingConfiguration = autoParticipantRecordingConfiguration != null ? autoParticipantRecordingConfiguration
                    .build() : null;
        }

        @Override
        public final Builder autoParticipantRecordingConfiguration(
                AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration) {
            this.autoParticipantRecordingConfiguration = autoParticipantRecordingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStageRequest build() {
            return new UpdateStageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
