/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.KafkaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBootstrapBrokersResponse
extends KafkaResponse
implements ToCopyableBuilder<Builder, GetBootstrapBrokersResponse> {
    private static final SdkField<String> BOOTSTRAP_BROKER_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBootstrapBrokersResponse.getter(GetBootstrapBrokersResponse::bootstrapBrokerString)).setter(GetBootstrapBrokersResponse.setter(Builder::bootstrapBrokerString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootstrapBrokerString").build()}).build();
    private static final SdkField<String> BOOTSTRAP_BROKER_STRING_TLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBootstrapBrokersResponse.getter(GetBootstrapBrokersResponse::bootstrapBrokerStringTls)).setter(GetBootstrapBrokersResponse.setter(Builder::bootstrapBrokerStringTls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootstrapBrokerStringTls").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOTSTRAP_BROKER_STRING_FIELD, BOOTSTRAP_BROKER_STRING_TLS_FIELD));
    private final String bootstrapBrokerString;
    private final String bootstrapBrokerStringTls;

    private GetBootstrapBrokersResponse(BuilderImpl builder) {
        super(builder);
        this.bootstrapBrokerString = builder.bootstrapBrokerString;
        this.bootstrapBrokerStringTls = builder.bootstrapBrokerStringTls;
    }

    public String bootstrapBrokerString() {
        return this.bootstrapBrokerString;
    }

    public String bootstrapBrokerStringTls() {
        return this.bootstrapBrokerStringTls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bootstrapBrokerString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bootstrapBrokerStringTls());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBootstrapBrokersResponse)) {
            return false;
        }
        GetBootstrapBrokersResponse other = (GetBootstrapBrokersResponse)((Object)obj);
        return Objects.equals(this.bootstrapBrokerString(), other.bootstrapBrokerString()) && Objects.equals(this.bootstrapBrokerStringTls(), other.bootstrapBrokerStringTls());
    }

    public String toString() {
        return ToString.builder((String)"GetBootstrapBrokersResponse").add("BootstrapBrokerString", (Object)this.bootstrapBrokerString()).add("BootstrapBrokerStringTls", (Object)this.bootstrapBrokerStringTls()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BootstrapBrokerString": {
                return Optional.ofNullable(clazz.cast(this.bootstrapBrokerString()));
            }
            case "BootstrapBrokerStringTls": {
                return Optional.ofNullable(clazz.cast(this.bootstrapBrokerStringTls()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBootstrapBrokersResponse, T> g) {
        return obj -> g.apply((GetBootstrapBrokersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaResponse.BuilderImpl
    implements Builder {
        private String bootstrapBrokerString;
        private String bootstrapBrokerStringTls;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBootstrapBrokersResponse model) {
            super(model);
            this.bootstrapBrokerString(model.bootstrapBrokerString);
            this.bootstrapBrokerStringTls(model.bootstrapBrokerStringTls);
        }

        public final String getBootstrapBrokerString() {
            return this.bootstrapBrokerString;
        }

        @Override
        public final Builder bootstrapBrokerString(String bootstrapBrokerString) {
            this.bootstrapBrokerString = bootstrapBrokerString;
            return this;
        }

        public final void setBootstrapBrokerString(String bootstrapBrokerString) {
            this.bootstrapBrokerString = bootstrapBrokerString;
        }

        public final String getBootstrapBrokerStringTls() {
            return this.bootstrapBrokerStringTls;
        }

        @Override
        public final Builder bootstrapBrokerStringTls(String bootstrapBrokerStringTls) {
            this.bootstrapBrokerStringTls = bootstrapBrokerStringTls;
            return this;
        }

        public final void setBootstrapBrokerStringTls(String bootstrapBrokerStringTls) {
            this.bootstrapBrokerStringTls = bootstrapBrokerStringTls;
        }

        @Override
        public GetBootstrapBrokersResponse build() {
            return new GetBootstrapBrokersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KafkaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBootstrapBrokersResponse> {
        public Builder bootstrapBrokerString(String var1);

        public Builder bootstrapBrokerStringTls(String var1);
    }
}

