/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAssociateScramSecretResponse extends KafkaResponse implements
        ToCopyableBuilder<BatchAssociateScramSecretResponse.Builder, BatchAssociateScramSecretResponse> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(BatchAssociateScramSecretResponse::clusterArn))
            .setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<List<UnprocessedScramSecret>> UNPROCESSED_SCRAM_SECRETS_FIELD = SdkField
            .<List<UnprocessedScramSecret>> builder(MarshallingType.LIST)
            .memberName("UnprocessedScramSecrets")
            .getter(getter(BatchAssociateScramSecretResponse::unprocessedScramSecrets))
            .setter(setter(Builder::unprocessedScramSecrets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedScramSecrets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedScramSecret> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedScramSecret::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            UNPROCESSED_SCRAM_SECRETS_FIELD));

    private final String clusterArn;

    private final List<UnprocessedScramSecret> unprocessedScramSecrets;

    private BatchAssociateScramSecretResponse(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.unprocessedScramSecrets = builder.unprocessedScramSecrets;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) of the cluster.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the cluster.
     *         </p>
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * Returns true if the UnprocessedScramSecrets property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasUnprocessedScramSecrets() {
        return unprocessedScramSecrets != null && !(unprocessedScramSecrets instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * List of errors when associating secrets to cluster.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnprocessedScramSecrets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <p>
     *         List of errors when associating secrets to cluster.
     *         </p>
     */
    public final List<UnprocessedScramSecret> unprocessedScramSecrets() {
        return unprocessedScramSecrets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedScramSecrets() ? unprocessedScramSecrets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateScramSecretResponse)) {
            return false;
        }
        BatchAssociateScramSecretResponse other = (BatchAssociateScramSecretResponse) obj;
        return Objects.equals(clusterArn(), other.clusterArn())
                && hasUnprocessedScramSecrets() == other.hasUnprocessedScramSecrets()
                && Objects.equals(unprocessedScramSecrets(), other.unprocessedScramSecrets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAssociateScramSecretResponse").add("ClusterArn", clusterArn())
                .add("UnprocessedScramSecrets", hasUnprocessedScramSecrets() ? unprocessedScramSecrets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "UnprocessedScramSecrets":
            return Optional.ofNullable(clazz.cast(unprocessedScramSecrets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateScramSecretResponse, T> g) {
        return obj -> g.apply((BatchAssociateScramSecretResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchAssociateScramSecretResponse> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) of the cluster.
         * </p>
         * 
         * @param clusterArn
         *        <p>
         *        The Amazon Resource Name (ARN) of the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         *
         * <p>
         * List of errors when associating secrets to cluster.
         * </p>
         * 
         * @param unprocessedScramSecrets
         *        <p>
         *        List of errors when associating secrets to cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedScramSecrets(Collection<UnprocessedScramSecret> unprocessedScramSecrets);

        /**
         *
         * <p>
         * List of errors when associating secrets to cluster.
         * </p>
         * 
         * @param unprocessedScramSecrets
         *        <p>
         *        List of errors when associating secrets to cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedScramSecrets(UnprocessedScramSecret... unprocessedScramSecrets);

        /**
         *
         * <p>
         * List of errors when associating secrets to cluster.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link List<UnprocessedScramSecret>.Builder} avoiding
         * the need to create one manually via {@link List<UnprocessedScramSecret>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UnprocessedScramSecret>.Builder#build()} is called
         * immediately and its result is passed to {@link #unprocessedScramSecrets(List<UnprocessedScramSecret>)}.
         * 
         * @param unprocessedScramSecrets
         *        a consumer that will call methods on {@link List<UnprocessedScramSecret>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedScramSecrets(List<UnprocessedScramSecret>)
         */
        Builder unprocessedScramSecrets(Consumer<UnprocessedScramSecret.Builder>... unprocessedScramSecrets);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private String clusterArn;

        private List<UnprocessedScramSecret> unprocessedScramSecrets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateScramSecretResponse model) {
            super(model);
            clusterArn(model.clusterArn);
            unprocessedScramSecrets(model.unprocessedScramSecrets);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final List<UnprocessedScramSecret.Builder> getUnprocessedScramSecrets() {
            List<UnprocessedScramSecret.Builder> result = ___listOfUnprocessedScramSecretCopier
                    .copyToBuilder(this.unprocessedScramSecrets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder unprocessedScramSecrets(Collection<UnprocessedScramSecret> unprocessedScramSecrets) {
            this.unprocessedScramSecrets = ___listOfUnprocessedScramSecretCopier.copy(unprocessedScramSecrets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedScramSecrets(UnprocessedScramSecret... unprocessedScramSecrets) {
            unprocessedScramSecrets(Arrays.asList(unprocessedScramSecrets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedScramSecrets(Consumer<UnprocessedScramSecret.Builder>... unprocessedScramSecrets) {
            unprocessedScramSecrets(Stream.of(unprocessedScramSecrets)
                    .map(c -> UnprocessedScramSecret.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedScramSecrets(Collection<UnprocessedScramSecret.BuilderImpl> unprocessedScramSecrets) {
            this.unprocessedScramSecrets = ___listOfUnprocessedScramSecretCopier.copyFromBuilder(unprocessedScramSecrets);
        }

        @Override
        public BatchAssociateScramSecretResponse build() {
            return new BatchAssociateScramSecretResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
