/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * The settings for encrypting data in transit.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionInTransit implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionInTransit.Builder, EncryptionInTransit> {
    private static final SdkField<String> CLIENT_BROKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientBroker").getter(getter(EncryptionInTransit::clientBrokerAsString))
            .setter(setter(Builder::clientBroker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientBroker").build()).build();

    private static final SdkField<Boolean> IN_CLUSTER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InCluster").getter(getter(EncryptionInTransit::inCluster)).setter(setter(Builder::inCluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inCluster").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_BROKER_FIELD,
            IN_CLUSTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientBroker;

    private final Boolean inCluster;

    private EncryptionInTransit(BuilderImpl builder) {
        this.clientBroker = builder.clientBroker;
        this.inCluster = builder.inCluster;
    }

    /**
     *
     * <p>
     * Indicates the encryption setting for data in transit between clients and brokers. The following are the possible
     * values.
     * </p>
     * <p>
     * TLS means that client-broker communication is enabled with TLS only.
     * </p>
     * <p>
     * TLS_PLAINTEXT means that client-broker communication is enabled for both TLS-encrypted, as well as plaintext
     * data.
     * </p>
     * <p>
     * PLAINTEXT means that client-broker communication is enabled in plaintext only.
     * </p>
     * <p>
     * The default value is TLS_PLAINTEXT.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientBroker} will
     * return {@link ClientBroker#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clientBrokerAsString}.
     * </p>
     * 
     * @return <p>
     *         Indicates the encryption setting for data in transit between clients and brokers. The following are the
     *         possible values.
     *         </p>
     *         <p>
     *         TLS means that client-broker communication is enabled with TLS only.
     *         </p>
     *         <p>
     *         TLS_PLAINTEXT means that client-broker communication is enabled for both TLS-encrypted, as well as
     *         plaintext data.
     *         </p>
     *         <p>
     *         PLAINTEXT means that client-broker communication is enabled in plaintext only.
     *         </p>
     *         <p>
     *         The default value is TLS_PLAINTEXT.
     *         </p>
     * @see ClientBroker
     */
    public final ClientBroker clientBroker() {
        return ClientBroker.fromValue(clientBroker);
    }

    /**
     *
     * <p>
     * Indicates the encryption setting for data in transit between clients and brokers. The following are the possible
     * values.
     * </p>
     * <p>
     * TLS means that client-broker communication is enabled with TLS only.
     * </p>
     * <p>
     * TLS_PLAINTEXT means that client-broker communication is enabled for both TLS-encrypted, as well as plaintext
     * data.
     * </p>
     * <p>
     * PLAINTEXT means that client-broker communication is enabled in plaintext only.
     * </p>
     * <p>
     * The default value is TLS_PLAINTEXT.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientBroker} will
     * return {@link ClientBroker#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clientBrokerAsString}.
     * </p>
     * 
     * @return <p>
     *         Indicates the encryption setting for data in transit between clients and brokers. The following are the
     *         possible values.
     *         </p>
     *         <p>
     *         TLS means that client-broker communication is enabled with TLS only.
     *         </p>
     *         <p>
     *         TLS_PLAINTEXT means that client-broker communication is enabled for both TLS-encrypted, as well as
     *         plaintext data.
     *         </p>
     *         <p>
     *         PLAINTEXT means that client-broker communication is enabled in plaintext only.
     *         </p>
     *         <p>
     *         The default value is TLS_PLAINTEXT.
     *         </p>
     * @see ClientBroker
     */
    public final String clientBrokerAsString() {
        return clientBroker;
    }

    /**
     *
     * <p>
     * When set to true, it indicates that data communication among the broker nodes of the cluster is encrypted. When
     * set to false, the communication happens in plaintext.
     * </p>
     * <p>
     * The default value is true.
     * </p>
     * 
     * @return <p>
     *         When set to true, it indicates that data communication among the broker nodes of the cluster is
     *         encrypted. When set to false, the communication happens in plaintext.
     *         </p>
     *         <p>
     *         The default value is true.
     *         </p>
     */
    public final Boolean inCluster() {
        return inCluster;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientBrokerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inCluster());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionInTransit)) {
            return false;
        }
        EncryptionInTransit other = (EncryptionInTransit) obj;
        return Objects.equals(clientBrokerAsString(), other.clientBrokerAsString())
                && Objects.equals(inCluster(), other.inCluster());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionInTransit").add("ClientBroker", clientBrokerAsString()).add("InCluster", inCluster())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientBroker":
            return Optional.ofNullable(clazz.cast(clientBrokerAsString()));
        case "InCluster":
            return Optional.ofNullable(clazz.cast(inCluster()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionInTransit, T> g) {
        return obj -> g.apply((EncryptionInTransit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionInTransit> {
        /**
         *
         * <p>
         * Indicates the encryption setting for data in transit between clients and brokers. The following are the
         * possible values.
         * </p>
         * <p>
         * TLS means that client-broker communication is enabled with TLS only.
         * </p>
         * <p>
         * TLS_PLAINTEXT means that client-broker communication is enabled for both TLS-encrypted, as well as plaintext
         * data.
         * </p>
         * <p>
         * PLAINTEXT means that client-broker communication is enabled in plaintext only.
         * </p>
         * <p>
         * The default value is TLS_PLAINTEXT.
         * </p>
         * 
         * @param clientBroker
         *        <p>
         *        Indicates the encryption setting for data in transit between clients and brokers. The following are
         *        the possible values.
         *        </p>
         *        <p>
         *        TLS means that client-broker communication is enabled with TLS only.
         *        </p>
         *        <p>
         *        TLS_PLAINTEXT means that client-broker communication is enabled for both TLS-encrypted, as well as
         *        plaintext data.
         *        </p>
         *        <p>
         *        PLAINTEXT means that client-broker communication is enabled in plaintext only.
         *        </p>
         *        <p>
         *        The default value is TLS_PLAINTEXT.
         *        </p>
         * @see ClientBroker
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientBroker
         */
        Builder clientBroker(String clientBroker);

        /**
         *
         * <p>
         * Indicates the encryption setting for data in transit between clients and brokers. The following are the
         * possible values.
         * </p>
         * <p>
         * TLS means that client-broker communication is enabled with TLS only.
         * </p>
         * <p>
         * TLS_PLAINTEXT means that client-broker communication is enabled for both TLS-encrypted, as well as plaintext
         * data.
         * </p>
         * <p>
         * PLAINTEXT means that client-broker communication is enabled in plaintext only.
         * </p>
         * <p>
         * The default value is TLS_PLAINTEXT.
         * </p>
         * 
         * @param clientBroker
         *        <p>
         *        Indicates the encryption setting for data in transit between clients and brokers. The following are
         *        the possible values.
         *        </p>
         *        <p>
         *        TLS means that client-broker communication is enabled with TLS only.
         *        </p>
         *        <p>
         *        TLS_PLAINTEXT means that client-broker communication is enabled for both TLS-encrypted, as well as
         *        plaintext data.
         *        </p>
         *        <p>
         *        PLAINTEXT means that client-broker communication is enabled in plaintext only.
         *        </p>
         *        <p>
         *        The default value is TLS_PLAINTEXT.
         *        </p>
         * @see ClientBroker
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientBroker
         */
        Builder clientBroker(ClientBroker clientBroker);

        /**
         *
         * <p>
         * When set to true, it indicates that data communication among the broker nodes of the cluster is encrypted.
         * When set to false, the communication happens in plaintext.
         * </p>
         * <p>
         * The default value is true.
         * </p>
         * 
         * @param inCluster
         *        <p>
         *        When set to true, it indicates that data communication among the broker nodes of the cluster is
         *        encrypted. When set to false, the communication happens in plaintext.
         *        </p>
         *        <p>
         *        The default value is true.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inCluster(Boolean inCluster);
    }

    static final class BuilderImpl implements Builder {
        private String clientBroker;

        private Boolean inCluster;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionInTransit model) {
            clientBroker(model.clientBroker);
            inCluster(model.inCluster);
        }

        public final String getClientBroker() {
            return clientBroker;
        }

        @Override
        public final Builder clientBroker(String clientBroker) {
            this.clientBroker = clientBroker;
            return this;
        }

        @Override
        public final Builder clientBroker(ClientBroker clientBroker) {
            this.clientBroker(clientBroker == null ? null : clientBroker.toString());
            return this;
        }

        public final void setClientBroker(String clientBroker) {
            this.clientBroker = clientBroker;
        }

        public final Boolean getInCluster() {
            return inCluster;
        }

        @Override
        public final Builder inCluster(Boolean inCluster) {
            this.inCluster = inCluster;
            return this;
        }

        public final void setInCluster(Boolean inCluster) {
            this.inCluster = inCluster;
        }

        @Override
        public EncryptionInTransit build() {
            return new EncryptionInTransit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
