/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Returns information about an error state of the cluster.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class ErrorInfo implements SdkPojo, Serializable, ToCopyableBuilder<ErrorInfo.Builder, ErrorInfo> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(ErrorInfo::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorString").getter(getter(ErrorInfo::errorString)).setter(setter(Builder::errorString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorString").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            ERROR_STRING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final String errorString;

    private ErrorInfo(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorString = builder.errorString;
    }

    /**
     *
     * <p>
     * A number describing the error programmatically.
     * </p>
     * 
     * @return <p>
     *         A number describing the error programmatically.
     *         </p>
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     *
     * <p>
     * An optional field to provide more details about the error.
     * </p>
     * 
     * @return <p>
     *         An optional field to provide more details about the error.
     *         </p>
     */
    public final String errorString() {
        return errorString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorInfo)) {
            return false;
        }
        ErrorInfo other = (ErrorInfo) obj;
        return Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorString(), other.errorString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ErrorInfo").add("ErrorCode", errorCode()).add("ErrorString", errorString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorString":
            return Optional.ofNullable(clazz.cast(errorString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ErrorInfo, T> g) {
        return obj -> g.apply((ErrorInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ErrorInfo> {
        /**
         *
         * <p>
         * A number describing the error programmatically.
         * </p>
         * 
         * @param errorCode
         *        <p>
         *        A number describing the error programmatically.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         *
         * <p>
         * An optional field to provide more details about the error.
         * </p>
         * 
         * @param errorString
         *        <p>
         *        An optional field to provide more details about the error.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorString(String errorString);
    }

    static final class BuilderImpl implements Builder {
        private String errorCode;

        private String errorString;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorInfo model) {
            errorCode(model.errorCode);
            errorString(model.errorString);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorString() {
            return errorString;
        }

        @Override
        public final Builder errorString(String errorString) {
            this.errorString = errorString;
            return this;
        }

        public final void setErrorString(String errorString) {
            this.errorString = errorString;
        }

        @Override
        public ErrorInfo build() {
            return new ErrorInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
