/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCompatibleKafkaVersionsResponse extends KafkaResponse implements
        ToCopyableBuilder<GetCompatibleKafkaVersionsResponse.Builder, GetCompatibleKafkaVersionsResponse> {
    private static final SdkField<List<CompatibleKafkaVersion>> COMPATIBLE_KAFKA_VERSIONS_FIELD = SdkField
            .<List<CompatibleKafkaVersion>> builder(MarshallingType.LIST)
            .memberName("CompatibleKafkaVersions")
            .getter(getter(GetCompatibleKafkaVersionsResponse::compatibleKafkaVersions))
            .setter(setter(Builder::compatibleKafkaVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatibleKafkaVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CompatibleKafkaVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(CompatibleKafkaVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COMPATIBLE_KAFKA_VERSIONS_FIELD));

    private final List<CompatibleKafkaVersion> compatibleKafkaVersions;

    private GetCompatibleKafkaVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.compatibleKafkaVersions = builder.compatibleKafkaVersions;
    }

    /**
     * Returns true if the CompatibleKafkaVersions property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCompatibleKafkaVersions() {
        return compatibleKafkaVersions != null && !(compatibleKafkaVersions instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * A list of CompatibleKafkaVersion objects.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCompatibleKafkaVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <p>
     *         A list of CompatibleKafkaVersion objects.
     *         </p>
     */
    public final List<CompatibleKafkaVersion> compatibleKafkaVersions() {
        return compatibleKafkaVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCompatibleKafkaVersions() ? compatibleKafkaVersions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCompatibleKafkaVersionsResponse)) {
            return false;
        }
        GetCompatibleKafkaVersionsResponse other = (GetCompatibleKafkaVersionsResponse) obj;
        return hasCompatibleKafkaVersions() == other.hasCompatibleKafkaVersions()
                && Objects.equals(compatibleKafkaVersions(), other.compatibleKafkaVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCompatibleKafkaVersionsResponse")
                .add("CompatibleKafkaVersions", hasCompatibleKafkaVersions() ? compatibleKafkaVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompatibleKafkaVersions":
            return Optional.ofNullable(clazz.cast(compatibleKafkaVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCompatibleKafkaVersionsResponse, T> g) {
        return obj -> g.apply((GetCompatibleKafkaVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCompatibleKafkaVersionsResponse> {
        /**
         *
         * <p>
         * A list of CompatibleKafkaVersion objects.
         * </p>
         * 
         * @param compatibleKafkaVersions
         *        <p>
         *        A list of CompatibleKafkaVersion objects.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleKafkaVersions(Collection<CompatibleKafkaVersion> compatibleKafkaVersions);

        /**
         *
         * <p>
         * A list of CompatibleKafkaVersion objects.
         * </p>
         * 
         * @param compatibleKafkaVersions
         *        <p>
         *        A list of CompatibleKafkaVersion objects.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleKafkaVersions(CompatibleKafkaVersion... compatibleKafkaVersions);

        /**
         *
         * <p>
         * A list of CompatibleKafkaVersion objects.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link List<CompatibleKafkaVersion>.Builder} avoiding
         * the need to create one manually via {@link List<CompatibleKafkaVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CompatibleKafkaVersion>.Builder#build()} is called
         * immediately and its result is passed to {@link #compatibleKafkaVersions(List<CompatibleKafkaVersion>)}.
         * 
         * @param compatibleKafkaVersions
         *        a consumer that will call methods on {@link List<CompatibleKafkaVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compatibleKafkaVersions(List<CompatibleKafkaVersion>)
         */
        Builder compatibleKafkaVersions(Consumer<CompatibleKafkaVersion.Builder>... compatibleKafkaVersions);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private List<CompatibleKafkaVersion> compatibleKafkaVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCompatibleKafkaVersionsResponse model) {
            super(model);
            compatibleKafkaVersions(model.compatibleKafkaVersions);
        }

        public final List<CompatibleKafkaVersion.Builder> getCompatibleKafkaVersions() {
            List<CompatibleKafkaVersion.Builder> result = ___listOfCompatibleKafkaVersionCopier
                    .copyToBuilder(this.compatibleKafkaVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder compatibleKafkaVersions(Collection<CompatibleKafkaVersion> compatibleKafkaVersions) {
            this.compatibleKafkaVersions = ___listOfCompatibleKafkaVersionCopier.copy(compatibleKafkaVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleKafkaVersions(CompatibleKafkaVersion... compatibleKafkaVersions) {
            compatibleKafkaVersions(Arrays.asList(compatibleKafkaVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleKafkaVersions(Consumer<CompatibleKafkaVersion.Builder>... compatibleKafkaVersions) {
            compatibleKafkaVersions(Stream.of(compatibleKafkaVersions)
                    .map(c -> CompatibleKafkaVersion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCompatibleKafkaVersions(Collection<CompatibleKafkaVersion.BuilderImpl> compatibleKafkaVersions) {
            this.compatibleKafkaVersions = ___listOfCompatibleKafkaVersionCopier.copyFromBuilder(compatibleKafkaVersions);
        }

        @Override
        public GetCompatibleKafkaVersionsResponse build() {
            return new GetCompatibleKafkaVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
