/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClusterOperationsResponse extends KafkaResponse implements
        ToCopyableBuilder<ListClusterOperationsResponse.Builder, ListClusterOperationsResponse> {
    private static final SdkField<List<ClusterOperationInfo>> CLUSTER_OPERATION_INFO_LIST_FIELD = SdkField
            .<List<ClusterOperationInfo>> builder(MarshallingType.LIST)
            .memberName("ClusterOperationInfoList")
            .getter(getter(ListClusterOperationsResponse::clusterOperationInfoList))
            .setter(setter(Builder::clusterOperationInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterOperationInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterOperationInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterOperationInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListClusterOperationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLUSTER_OPERATION_INFO_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<ClusterOperationInfo> clusterOperationInfoList;

    private final String nextToken;

    private ListClusterOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.clusterOperationInfoList = builder.clusterOperationInfoList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ClusterOperationInfoList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasClusterOperationInfoList() {
        return clusterOperationInfoList != null && !(clusterOperationInfoList instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * An array of cluster operation information objects.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasClusterOperationInfoList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <p>
     *         An array of cluster operation information objects.
     *         </p>
     */
    public final List<ClusterOperationInfo> clusterOperationInfoList() {
        return clusterOperationInfoList;
    }

    /**
     *
     * <p>
     * If the response of ListClusterOperations is truncated, it returns a NextToken in the response. This Nexttoken
     * should be sent in the subsequent request to ListClusterOperations.
     * </p>
     * 
     * @return <p>
     *         If the response of ListClusterOperations is truncated, it returns a NextToken in the response. This
     *         Nexttoken should be sent in the subsequent request to ListClusterOperations.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterOperationInfoList() ? clusterOperationInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterOperationsResponse)) {
            return false;
        }
        ListClusterOperationsResponse other = (ListClusterOperationsResponse) obj;
        return hasClusterOperationInfoList() == other.hasClusterOperationInfoList()
                && Objects.equals(clusterOperationInfoList(), other.clusterOperationInfoList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListClusterOperationsResponse")
                .add("ClusterOperationInfoList", hasClusterOperationInfoList() ? clusterOperationInfoList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterOperationInfoList":
            return Optional.ofNullable(clazz.cast(clusterOperationInfoList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClusterOperationsResponse, T> g) {
        return obj -> g.apply((ListClusterOperationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListClusterOperationsResponse> {
        /**
         *
         * <p>
         * An array of cluster operation information objects.
         * </p>
         * 
         * @param clusterOperationInfoList
         *        <p>
         *        An array of cluster operation information objects.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterOperationInfoList(Collection<ClusterOperationInfo> clusterOperationInfoList);

        /**
         *
         * <p>
         * An array of cluster operation information objects.
         * </p>
         * 
         * @param clusterOperationInfoList
         *        <p>
         *        An array of cluster operation information objects.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterOperationInfoList(ClusterOperationInfo... clusterOperationInfoList);

        /**
         *
         * <p>
         * An array of cluster operation information objects.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link List<ClusterOperationInfo>.Builder} avoiding the
         * need to create one manually via {@link List<ClusterOperationInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ClusterOperationInfo>.Builder#build()} is called immediately
         * and its result is passed to {@link #clusterOperationInfoList(List<ClusterOperationInfo>)}.
         * 
         * @param clusterOperationInfoList
         *        a consumer that will call methods on {@link List<ClusterOperationInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterOperationInfoList(List<ClusterOperationInfo>)
         */
        Builder clusterOperationInfoList(Consumer<ClusterOperationInfo.Builder>... clusterOperationInfoList);

        /**
         *
         * <p>
         * If the response of ListClusterOperations is truncated, it returns a NextToken in the response. This Nexttoken
         * should be sent in the subsequent request to ListClusterOperations.
         * </p>
         * 
         * @param nextToken
         *        <p>
         *        If the response of ListClusterOperations is truncated, it returns a NextToken in the response. This
         *        Nexttoken should be sent in the subsequent request to ListClusterOperations.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private List<ClusterOperationInfo> clusterOperationInfoList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterOperationsResponse model) {
            super(model);
            clusterOperationInfoList(model.clusterOperationInfoList);
            nextToken(model.nextToken);
        }

        public final List<ClusterOperationInfo.Builder> getClusterOperationInfoList() {
            List<ClusterOperationInfo.Builder> result = ___listOfClusterOperationInfoCopier
                    .copyToBuilder(this.clusterOperationInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder clusterOperationInfoList(Collection<ClusterOperationInfo> clusterOperationInfoList) {
            this.clusterOperationInfoList = ___listOfClusterOperationInfoCopier.copy(clusterOperationInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterOperationInfoList(ClusterOperationInfo... clusterOperationInfoList) {
            clusterOperationInfoList(Arrays.asList(clusterOperationInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterOperationInfoList(Consumer<ClusterOperationInfo.Builder>... clusterOperationInfoList) {
            clusterOperationInfoList(Stream.of(clusterOperationInfoList)
                    .map(c -> ClusterOperationInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusterOperationInfoList(Collection<ClusterOperationInfo.BuilderImpl> clusterOperationInfoList) {
            this.clusterOperationInfoList = ___listOfClusterOperationInfoCopier.copyFromBuilder(clusterOperationInfoList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListClusterOperationsResponse build() {
            return new ListClusterOperationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
