/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Information about cluster attributes that can be updated via update APIs.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class MutableClusterInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<MutableClusterInfo.Builder, MutableClusterInfo> {
    private static final SdkField<List<BrokerEBSVolumeInfo>> BROKER_EBS_VOLUME_INFO_FIELD = SdkField
            .<List<BrokerEBSVolumeInfo>> builder(MarshallingType.LIST)
            .memberName("BrokerEBSVolumeInfo")
            .getter(getter(MutableClusterInfo::brokerEBSVolumeInfo))
            .setter(setter(Builder::brokerEBSVolumeInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerEBSVolumeInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BrokerEBSVolumeInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(BrokerEBSVolumeInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ConfigurationInfo> CONFIGURATION_INFO_FIELD = SdkField
            .<ConfigurationInfo> builder(MarshallingType.SDK_POJO).memberName("ConfigurationInfo")
            .getter(getter(MutableClusterInfo::configurationInfo)).setter(setter(Builder::configurationInfo))
            .constructor(ConfigurationInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationInfo").build()).build();

    private static final SdkField<Integer> NUMBER_OF_BROKER_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfBrokerNodes").getter(getter(MutableClusterInfo::numberOfBrokerNodes))
            .setter(setter(Builder::numberOfBrokerNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfBrokerNodes").build())
            .build();

    private static final SdkField<String> ENHANCED_MONITORING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnhancedMonitoring").getter(getter(MutableClusterInfo::enhancedMonitoringAsString))
            .setter(setter(Builder::enhancedMonitoring))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedMonitoring").build())
            .build();

    private static final SdkField<OpenMonitoring> OPEN_MONITORING_FIELD = SdkField
            .<OpenMonitoring> builder(MarshallingType.SDK_POJO).memberName("OpenMonitoring")
            .getter(getter(MutableClusterInfo::openMonitoring)).setter(setter(Builder::openMonitoring))
            .constructor(OpenMonitoring::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openMonitoring").build()).build();

    private static final SdkField<String> KAFKA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KafkaVersion").getter(getter(MutableClusterInfo::kafkaVersion)).setter(setter(Builder::kafkaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaVersion").build()).build();

    private static final SdkField<LoggingInfo> LOGGING_INFO_FIELD = SdkField.<LoggingInfo> builder(MarshallingType.SDK_POJO)
            .memberName("LoggingInfo").getter(getter(MutableClusterInfo::loggingInfo)).setter(setter(Builder::loggingInfo))
            .constructor(LoggingInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingInfo").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(MutableClusterInfo::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_EBS_VOLUME_INFO_FIELD,
            CONFIGURATION_INFO_FIELD, NUMBER_OF_BROKER_NODES_FIELD, ENHANCED_MONITORING_FIELD, OPEN_MONITORING_FIELD,
            KAFKA_VERSION_FIELD, LOGGING_INFO_FIELD, INSTANCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<BrokerEBSVolumeInfo> brokerEBSVolumeInfo;

    private final ConfigurationInfo configurationInfo;

    private final Integer numberOfBrokerNodes;

    private final String enhancedMonitoring;

    private final OpenMonitoring openMonitoring;

    private final String kafkaVersion;

    private final LoggingInfo loggingInfo;

    private final String instanceType;

    private MutableClusterInfo(BuilderImpl builder) {
        this.brokerEBSVolumeInfo = builder.brokerEBSVolumeInfo;
        this.configurationInfo = builder.configurationInfo;
        this.numberOfBrokerNodes = builder.numberOfBrokerNodes;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.openMonitoring = builder.openMonitoring;
        this.kafkaVersion = builder.kafkaVersion;
        this.loggingInfo = builder.loggingInfo;
        this.instanceType = builder.instanceType;
    }

    /**
     * Returns true if the BrokerEBSVolumeInfo property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasBrokerEBSVolumeInfo() {
        return brokerEBSVolumeInfo != null && !(brokerEBSVolumeInfo instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * Specifies the size of the EBS volume and the ID of the associated broker.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBrokerEBSVolumeInfo()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <p>
     *         Specifies the size of the EBS volume and the ID of the associated broker.
     *         </p>
     */
    public final List<BrokerEBSVolumeInfo> brokerEBSVolumeInfo() {
        return brokerEBSVolumeInfo;
    }

    /**
     *
     * <p>
     * Information about the changes in the configuration of the brokers.
     * </p>
     * 
     * @return <p>
     *         Information about the changes in the configuration of the brokers.
     *         </p>
     */
    public final ConfigurationInfo configurationInfo() {
        return configurationInfo;
    }

    /**
     *
     * <p>
     * The number of broker nodes in the cluster.
     * </p>
     * 
     * @return <p>
     *         The number of broker nodes in the cluster.
     *         </p>
     */
    public final Integer numberOfBrokerNodes() {
        return numberOfBrokerNodes;
    }

    /**
     *
     * <p>
     * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedMonitoring} will return {@link EnhancedMonitoring#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #enhancedMonitoringAsString}.
     * </p>
     * 
     * @return <p>
     *         Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
     *         </p>
     * @see EnhancedMonitoring
     */
    public final EnhancedMonitoring enhancedMonitoring() {
        return EnhancedMonitoring.fromValue(enhancedMonitoring);
    }

    /**
     *
     * <p>
     * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedMonitoring} will return {@link EnhancedMonitoring#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #enhancedMonitoringAsString}.
     * </p>
     * 
     * @return <p>
     *         Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
     *         </p>
     * @see EnhancedMonitoring
     */
    public final String enhancedMonitoringAsString() {
        return enhancedMonitoring;
    }

    /**
     *
     * <p>
     * The settings for open monitoring.
     * </p>
     * 
     * @return <p>
     *         The settings for open monitoring.
     *         </p>
     */
    public final OpenMonitoring openMonitoring() {
        return openMonitoring;
    }

    /**
     *
     * <p>
     * The Kafka version.
     * </p>
     * 
     * @return <p>
     *         The Kafka version.
     *         </p>
     */
    public final String kafkaVersion() {
        return kafkaVersion;
    }

    /**
     * Returns the value of the LoggingInfo property for this object.
     * 
     * @return The value of the LoggingInfo property for this object.
     */
    public final LoggingInfo loggingInfo() {
        return loggingInfo;
    }

    /**
     *
     * <p>
     * Information about the Amazon MSK broker type.
     * </p>
     * 
     * @return <p>
     *         Information about the Amazon MSK broker type.
     *         </p>
     */
    public final String instanceType() {
        return instanceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBrokerEBSVolumeInfo() ? brokerEBSVolumeInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configurationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfBrokerNodes());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedMonitoringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(openMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(kafkaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(loggingInfo());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MutableClusterInfo)) {
            return false;
        }
        MutableClusterInfo other = (MutableClusterInfo) obj;
        return hasBrokerEBSVolumeInfo() == other.hasBrokerEBSVolumeInfo()
                && Objects.equals(brokerEBSVolumeInfo(), other.brokerEBSVolumeInfo())
                && Objects.equals(configurationInfo(), other.configurationInfo())
                && Objects.equals(numberOfBrokerNodes(), other.numberOfBrokerNodes())
                && Objects.equals(enhancedMonitoringAsString(), other.enhancedMonitoringAsString())
                && Objects.equals(openMonitoring(), other.openMonitoring())
                && Objects.equals(kafkaVersion(), other.kafkaVersion()) && Objects.equals(loggingInfo(), other.loggingInfo())
                && Objects.equals(instanceType(), other.instanceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MutableClusterInfo")
                .add("BrokerEBSVolumeInfo", hasBrokerEBSVolumeInfo() ? brokerEBSVolumeInfo() : null)
                .add("ConfigurationInfo", configurationInfo()).add("NumberOfBrokerNodes", numberOfBrokerNodes())
                .add("EnhancedMonitoring", enhancedMonitoringAsString()).add("OpenMonitoring", openMonitoring())
                .add("KafkaVersion", kafkaVersion()).add("LoggingInfo", loggingInfo()).add("InstanceType", instanceType())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BrokerEBSVolumeInfo":
            return Optional.ofNullable(clazz.cast(brokerEBSVolumeInfo()));
        case "ConfigurationInfo":
            return Optional.ofNullable(clazz.cast(configurationInfo()));
        case "NumberOfBrokerNodes":
            return Optional.ofNullable(clazz.cast(numberOfBrokerNodes()));
        case "EnhancedMonitoring":
            return Optional.ofNullable(clazz.cast(enhancedMonitoringAsString()));
        case "OpenMonitoring":
            return Optional.ofNullable(clazz.cast(openMonitoring()));
        case "KafkaVersion":
            return Optional.ofNullable(clazz.cast(kafkaVersion()));
        case "LoggingInfo":
            return Optional.ofNullable(clazz.cast(loggingInfo()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MutableClusterInfo, T> g) {
        return obj -> g.apply((MutableClusterInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MutableClusterInfo> {
        /**
         *
         * <p>
         * Specifies the size of the EBS volume and the ID of the associated broker.
         * </p>
         * 
         * @param brokerEBSVolumeInfo
         *        <p>
         *        Specifies the size of the EBS volume and the ID of the associated broker.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerEBSVolumeInfo(Collection<BrokerEBSVolumeInfo> brokerEBSVolumeInfo);

        /**
         *
         * <p>
         * Specifies the size of the EBS volume and the ID of the associated broker.
         * </p>
         * 
         * @param brokerEBSVolumeInfo
         *        <p>
         *        Specifies the size of the EBS volume and the ID of the associated broker.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerEBSVolumeInfo(BrokerEBSVolumeInfo... brokerEBSVolumeInfo);

        /**
         *
         * <p>
         * Specifies the size of the EBS volume and the ID of the associated broker.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link List<BrokerEBSVolumeInfo>.Builder} avoiding the
         * need to create one manually via {@link List<BrokerEBSVolumeInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BrokerEBSVolumeInfo>.Builder#build()} is called immediately
         * and its result is passed to {@link #brokerEBSVolumeInfo(List<BrokerEBSVolumeInfo>)}.
         * 
         * @param brokerEBSVolumeInfo
         *        a consumer that will call methods on {@link List<BrokerEBSVolumeInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brokerEBSVolumeInfo(List<BrokerEBSVolumeInfo>)
         */
        Builder brokerEBSVolumeInfo(Consumer<BrokerEBSVolumeInfo.Builder>... brokerEBSVolumeInfo);

        /**
         *
         * <p>
         * Information about the changes in the configuration of the brokers.
         * </p>
         * 
         * @param configurationInfo
         *        <p>
         *        Information about the changes in the configuration of the brokers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationInfo(ConfigurationInfo configurationInfo);

        /**
         *
         * <p>
         * Information about the changes in the configuration of the brokers.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link ConfigurationInfo.Builder} avoiding the need to
         * create one manually via {@link ConfigurationInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigurationInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #configurationInfo(ConfigurationInfo)}.
         * 
         * @param configurationInfo
         *        a consumer that will call methods on {@link ConfigurationInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationInfo(ConfigurationInfo)
         */
        default Builder configurationInfo(Consumer<ConfigurationInfo.Builder> configurationInfo) {
            return configurationInfo(ConfigurationInfo.builder().applyMutation(configurationInfo).build());
        }

        /**
         *
         * <p>
         * The number of broker nodes in the cluster.
         * </p>
         * 
         * @param numberOfBrokerNodes
         *        <p>
         *        The number of broker nodes in the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfBrokerNodes(Integer numberOfBrokerNodes);

        /**
         *
         * <p>
         * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
         * </p>
         * 
         * @param enhancedMonitoring
         *        <p>
         *        Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this
         *        cluster.
         *        </p>
         * @see EnhancedMonitoring
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedMonitoring
         */
        Builder enhancedMonitoring(String enhancedMonitoring);

        /**
         *
         * <p>
         * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
         * </p>
         * 
         * @param enhancedMonitoring
         *        <p>
         *        Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this
         *        cluster.
         *        </p>
         * @see EnhancedMonitoring
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedMonitoring
         */
        Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring);

        /**
         *
         * <p>
         * The settings for open monitoring.
         * </p>
         * 
         * @param openMonitoring
         *        <p>
         *        The settings for open monitoring.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openMonitoring(OpenMonitoring openMonitoring);

        /**
         *
         * <p>
         * The settings for open monitoring.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link OpenMonitoring.Builder} avoiding the need to
         * create one manually via {@link OpenMonitoring#builder()}.
         *
         * When the {@link Consumer} completes, {@link OpenMonitoring.Builder#build()} is called immediately and its
         * result is passed to {@link #openMonitoring(OpenMonitoring)}.
         * 
         * @param openMonitoring
         *        a consumer that will call methods on {@link OpenMonitoring.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openMonitoring(OpenMonitoring)
         */
        default Builder openMonitoring(Consumer<OpenMonitoring.Builder> openMonitoring) {
            return openMonitoring(OpenMonitoring.builder().applyMutation(openMonitoring).build());
        }

        /**
         *
         * <p>
         * The Kafka version.
         * </p>
         * 
         * @param kafkaVersion
         *        <p>
         *        The Kafka version.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaVersion(String kafkaVersion);

        /**
         * Sets the value of the LoggingInfo property for this object.
         *
         * @param loggingInfo
         *        The new value for the LoggingInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingInfo(LoggingInfo loggingInfo);

        /**
         * Sets the value of the LoggingInfo property for this object.
         *
         * This is a convenience that creates an instance of the {@link LoggingInfo.Builder} avoiding the need to create
         * one manually via {@link LoggingInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #loggingInfo(LoggingInfo)}.
         * 
         * @param loggingInfo
         *        a consumer that will call methods on {@link LoggingInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingInfo(LoggingInfo)
         */
        default Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return loggingInfo(LoggingInfo.builder().applyMutation(loggingInfo).build());
        }

        /**
         *
         * <p>
         * Information about the Amazon MSK broker type.
         * </p>
         * 
         * @param instanceType
         *        <p>
         *        Information about the Amazon MSK broker type.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);
    }

    static final class BuilderImpl implements Builder {
        private List<BrokerEBSVolumeInfo> brokerEBSVolumeInfo = DefaultSdkAutoConstructList.getInstance();

        private ConfigurationInfo configurationInfo;

        private Integer numberOfBrokerNodes;

        private String enhancedMonitoring;

        private OpenMonitoring openMonitoring;

        private String kafkaVersion;

        private LoggingInfo loggingInfo;

        private String instanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(MutableClusterInfo model) {
            brokerEBSVolumeInfo(model.brokerEBSVolumeInfo);
            configurationInfo(model.configurationInfo);
            numberOfBrokerNodes(model.numberOfBrokerNodes);
            enhancedMonitoring(model.enhancedMonitoring);
            openMonitoring(model.openMonitoring);
            kafkaVersion(model.kafkaVersion);
            loggingInfo(model.loggingInfo);
            instanceType(model.instanceType);
        }

        public final List<BrokerEBSVolumeInfo.Builder> getBrokerEBSVolumeInfo() {
            List<BrokerEBSVolumeInfo.Builder> result = ___listOfBrokerEBSVolumeInfoCopier.copyToBuilder(this.brokerEBSVolumeInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder brokerEBSVolumeInfo(Collection<BrokerEBSVolumeInfo> brokerEBSVolumeInfo) {
            this.brokerEBSVolumeInfo = ___listOfBrokerEBSVolumeInfoCopier.copy(brokerEBSVolumeInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerEBSVolumeInfo(BrokerEBSVolumeInfo... brokerEBSVolumeInfo) {
            brokerEBSVolumeInfo(Arrays.asList(brokerEBSVolumeInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerEBSVolumeInfo(Consumer<BrokerEBSVolumeInfo.Builder>... brokerEBSVolumeInfo) {
            brokerEBSVolumeInfo(Stream.of(brokerEBSVolumeInfo).map(c -> BrokerEBSVolumeInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBrokerEBSVolumeInfo(Collection<BrokerEBSVolumeInfo.BuilderImpl> brokerEBSVolumeInfo) {
            this.brokerEBSVolumeInfo = ___listOfBrokerEBSVolumeInfoCopier.copyFromBuilder(brokerEBSVolumeInfo);
        }

        public final ConfigurationInfo.Builder getConfigurationInfo() {
            return configurationInfo != null ? configurationInfo.toBuilder() : null;
        }

        @Override
        public final Builder configurationInfo(ConfigurationInfo configurationInfo) {
            this.configurationInfo = configurationInfo;
            return this;
        }

        public final void setConfigurationInfo(ConfigurationInfo.BuilderImpl configurationInfo) {
            this.configurationInfo = configurationInfo != null ? configurationInfo.build() : null;
        }

        public final Integer getNumberOfBrokerNodes() {
            return numberOfBrokerNodes;
        }

        @Override
        public final Builder numberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        public final void setNumberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
        }

        public final String getEnhancedMonitoring() {
            return enhancedMonitoring;
        }

        @Override
        public final Builder enhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        @Override
        public final Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring) {
            this.enhancedMonitoring(enhancedMonitoring == null ? null : enhancedMonitoring.toString());
            return this;
        }

        public final void setEnhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
        }

        public final OpenMonitoring.Builder getOpenMonitoring() {
            return openMonitoring != null ? openMonitoring.toBuilder() : null;
        }

        @Override
        public final Builder openMonitoring(OpenMonitoring openMonitoring) {
            this.openMonitoring = openMonitoring;
            return this;
        }

        public final void setOpenMonitoring(OpenMonitoring.BuilderImpl openMonitoring) {
            this.openMonitoring = openMonitoring != null ? openMonitoring.build() : null;
        }

        public final String getKafkaVersion() {
            return kafkaVersion;
        }

        @Override
        public final Builder kafkaVersion(String kafkaVersion) {
            this.kafkaVersion = kafkaVersion;
            return this;
        }

        public final void setKafkaVersion(String kafkaVersion) {
            this.kafkaVersion = kafkaVersion;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return loggingInfo != null ? loggingInfo.toBuilder() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public MutableClusterInfo build() {
            return new MutableClusterInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
