/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClusterConfigurationRequest extends KafkaRequest implements
        ToCopyableBuilder<UpdateClusterConfigurationRequest.Builder, UpdateClusterConfigurationRequest> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(UpdateClusterConfigurationRequest::clusterArn))
            .setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()).build();

    private static final SdkField<ConfigurationInfo> CONFIGURATION_INFO_FIELD = SdkField
            .<ConfigurationInfo> builder(MarshallingType.SDK_POJO).memberName("ConfigurationInfo")
            .getter(getter(UpdateClusterConfigurationRequest::configurationInfo)).setter(setter(Builder::configurationInfo))
            .constructor(ConfigurationInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationInfo").build()).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(UpdateClusterConfigurationRequest::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            CONFIGURATION_INFO_FIELD, CURRENT_VERSION_FIELD));

    private final String clusterArn;

    private final ConfigurationInfo configurationInfo;

    private final String currentVersion;

    private UpdateClusterConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.configurationInfo = builder.configurationInfo;
        this.currentVersion = builder.currentVersion;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     *         </p>
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     *
     * <p>
     * Represents the configuration that you want MSK to use for the brokers in a cluster.
     * </p>
     * 
     * @return <p>
     *         Represents the configuration that you want MSK to use for the brokers in a cluster.
     *         </p>
     */
    public final ConfigurationInfo configurationInfo() {
        return configurationInfo;
    }

    /**
     *
     * <p>
     * The version of the cluster that needs to be updated.
     * </p>
     * 
     * @return <p>
     *         The version of the cluster that needs to be updated.
     *         </p>
     */
    public final String currentVersion() {
        return currentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(configurationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterConfigurationRequest)) {
            return false;
        }
        UpdateClusterConfigurationRequest other = (UpdateClusterConfigurationRequest) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(configurationInfo(), other.configurationInfo())
                && Objects.equals(currentVersion(), other.currentVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateClusterConfigurationRequest").add("ClusterArn", clusterArn())
                .add("ConfigurationInfo", configurationInfo()).add("CurrentVersion", currentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "ConfigurationInfo":
            return Optional.ofNullable(clazz.cast(configurationInfo()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateClusterConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateClusterConfigurationRequest> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         * </p>
         * 
         * @param clusterArn
         *        <p>
         *        The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         *
         * <p>
         * Represents the configuration that you want MSK to use for the brokers in a cluster.
         * </p>
         * 
         * @param configurationInfo
         *        <p>
         *        Represents the configuration that you want MSK to use for the brokers in a cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationInfo(ConfigurationInfo configurationInfo);

        /**
         *
         * <p>
         * Represents the configuration that you want MSK to use for the brokers in a cluster.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link ConfigurationInfo.Builder} avoiding the need to
         * create one manually via {@link ConfigurationInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigurationInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #configurationInfo(ConfigurationInfo)}.
         * 
         * @param configurationInfo
         *        a consumer that will call methods on {@link ConfigurationInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationInfo(ConfigurationInfo)
         */
        default Builder configurationInfo(Consumer<ConfigurationInfo.Builder> configurationInfo) {
            return configurationInfo(ConfigurationInfo.builder().applyMutation(configurationInfo).build());
        }

        /**
         *
         * <p>
         * The version of the cluster that needs to be updated.
         * </p>
         * 
         * @param currentVersion
         *        <p>
         *        The version of the cluster that needs to be updated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private String clusterArn;

        private ConfigurationInfo configurationInfo;

        private String currentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterConfigurationRequest model) {
            super(model);
            clusterArn(model.clusterArn);
            configurationInfo(model.configurationInfo);
            currentVersion(model.currentVersion);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final ConfigurationInfo.Builder getConfigurationInfo() {
            return configurationInfo != null ? configurationInfo.toBuilder() : null;
        }

        @Override
        public final Builder configurationInfo(ConfigurationInfo configurationInfo) {
            this.configurationInfo = configurationInfo;
            return this;
        }

        public final void setConfigurationInfo(ConfigurationInfo.BuilderImpl configurationInfo) {
            this.configurationInfo = configurationInfo != null ? configurationInfo.build() : null;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterConfigurationRequest build() {
            return new UpdateClusterConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
