/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClusterV2Request extends KafkaRequest implements
        ToCopyableBuilder<CreateClusterV2Request.Builder, CreateClusterV2Request> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(CreateClusterV2Request::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateClusterV2Request::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ProvisionedRequest> PROVISIONED_FIELD = SdkField
            .<ProvisionedRequest> builder(MarshallingType.SDK_POJO).memberName("Provisioned")
            .getter(getter(CreateClusterV2Request::provisioned)).setter(setter(Builder::provisioned))
            .constructor(ProvisionedRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioned").build()).build();

    private static final SdkField<ServerlessRequest> SERVERLESS_FIELD = SdkField
            .<ServerlessRequest> builder(MarshallingType.SDK_POJO).memberName("Serverless")
            .getter(getter(CreateClusterV2Request::serverless)).setter(setter(Builder::serverless))
            .constructor(ServerlessRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverless").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            TAGS_FIELD, PROVISIONED_FIELD, SERVERLESS_FIELD));

    private final String clusterName;

    private final Map<String, String> tags;

    private final ProvisionedRequest provisioned;

    private final ServerlessRequest serverless;

    private CreateClusterV2Request(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.tags = builder.tags;
        this.provisioned = builder.provisioned;
        this.serverless = builder.serverless;
    }

    /**
     *
     * <p>
     * The name of the cluster.
     * </p>
     * 
     * @return <p>
     *         The name of the cluster.
     *         </p>
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     *
     * <p>
     * A map of tags that you want the cluster to have.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return <p>
     *         A map of tags that you want the cluster to have.
     *         </p>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     *
     * <p>
     * Information about the provisioned cluster.
     * </p>
     * 
     * @return <p>
     *         Information about the provisioned cluster.
     *         </p>
     */
    public final ProvisionedRequest provisioned() {
        return provisioned;
    }

    /**
     *
     * <p>
     * Information about the serverless cluster.
     * </p>
     * 
     * @return <p>
     *         Information about the serverless cluster.
     *         </p>
     */
    public final ServerlessRequest serverless() {
        return serverless;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(provisioned());
        hashCode = 31 * hashCode + Objects.hashCode(serverless());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterV2Request)) {
            return false;
        }
        CreateClusterV2Request other = (CreateClusterV2Request) obj;
        return Objects.equals(clusterName(), other.clusterName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(provisioned(), other.provisioned())
                && Objects.equals(serverless(), other.serverless());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateClusterV2Request").add("ClusterName", clusterName())
                .add("Tags", hasTags() ? tags() : null).add("Provisioned", provisioned()).add("Serverless", serverless()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Provisioned":
            return Optional.ofNullable(clazz.cast(provisioned()));
        case "Serverless":
            return Optional.ofNullable(clazz.cast(serverless()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterV2Request, T> g) {
        return obj -> g.apply((CreateClusterV2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateClusterV2Request> {
        /**
         *
         * <p>
         * The name of the cluster.
         * </p>
         * 
         * @param clusterName
         *        <p>
         *        The name of the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         *
         * <p>
         * A map of tags that you want the cluster to have.
         * </p>
         * 
         * @param tags
         *        <p>
         *        A map of tags that you want the cluster to have.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         *
         * <p>
         * Information about the provisioned cluster.
         * </p>
         * 
         * @param provisioned
         *        <p>
         *        Information about the provisioned cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioned(ProvisionedRequest provisioned);

        /**
         *
         * <p>
         * Information about the provisioned cluster.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link ProvisionedRequest.Builder} avoiding the need to
         * create one manually via {@link ProvisionedRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisionedRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #provisioned(ProvisionedRequest)}.
         * 
         * @param provisioned
         *        a consumer that will call methods on {@link ProvisionedRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioned(ProvisionedRequest)
         */
        default Builder provisioned(Consumer<ProvisionedRequest.Builder> provisioned) {
            return provisioned(ProvisionedRequest.builder().applyMutation(provisioned).build());
        }

        /**
         *
         * <p>
         * Information about the serverless cluster.
         * </p>
         * 
         * @param serverless
         *        <p>
         *        Information about the serverless cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverless(ServerlessRequest serverless);

        /**
         *
         * <p>
         * Information about the serverless cluster.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link ServerlessRequest.Builder} avoiding the need to
         * create one manually via {@link ServerlessRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServerlessRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #serverless(ServerlessRequest)}.
         * 
         * @param serverless
         *        a consumer that will call methods on {@link ServerlessRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverless(ServerlessRequest)
         */
        default Builder serverless(Consumer<ServerlessRequest.Builder> serverless) {
            return serverless(ServerlessRequest.builder().applyMutation(serverless).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private String clusterName;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private ProvisionedRequest provisioned;

        private ServerlessRequest serverless;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterV2Request model) {
            super(model);
            clusterName(model.clusterName);
            tags(model.tags);
            provisioned(model.provisioned);
            serverless(model.serverless);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        @Transient
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final ProvisionedRequest.Builder getProvisioned() {
            return provisioned != null ? provisioned.toBuilder() : null;
        }

        public final void setProvisioned(ProvisionedRequest.BuilderImpl provisioned) {
            this.provisioned = provisioned != null ? provisioned.build() : null;
        }

        @Override
        @Transient
        public final Builder provisioned(ProvisionedRequest provisioned) {
            this.provisioned = provisioned;
            return this;
        }

        public final ServerlessRequest.Builder getServerless() {
            return serverless != null ? serverless.toBuilder() : null;
        }

        public final void setServerless(ServerlessRequest.BuilderImpl serverless) {
            this.serverless = serverless != null ? serverless.build() : null;
        }

        @Override
        @Transient
        public final Builder serverless(ServerlessRequest serverless) {
            this.serverless = serverless;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterV2Request build() {
            return new CreateClusterV2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
