/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterOperationRequest extends KafkaRequest implements
        ToCopyableBuilder<DescribeClusterOperationRequest.Builder, DescribeClusterOperationRequest> {
    private static final SdkField<String> CLUSTER_OPERATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterOperationArn").getter(getter(DescribeClusterOperationRequest::clusterOperationArn))
            .setter(setter(Builder::clusterOperationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterOperationArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_OPERATION_ARN_FIELD));

    private final String clusterOperationArn;

    private DescribeClusterOperationRequest(BuilderImpl builder) {
        super(builder);
        this.clusterOperationArn = builder.clusterOperationArn;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the MSK cluster operation.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) that uniquely identifies the MSK cluster operation.
     *         </p>
     */
    public final String clusterOperationArn() {
        return clusterOperationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterOperationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterOperationRequest)) {
            return false;
        }
        DescribeClusterOperationRequest other = (DescribeClusterOperationRequest) obj;
        return Objects.equals(clusterOperationArn(), other.clusterOperationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClusterOperationRequest").add("ClusterOperationArn", clusterOperationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterOperationArn":
            return Optional.ofNullable(clazz.cast(clusterOperationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterOperationRequest, T> g) {
        return obj -> g.apply((DescribeClusterOperationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClusterOperationRequest> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the MSK cluster operation.
         * </p>
         * 
         * @param clusterOperationArn
         *        <p>
         *        The Amazon Resource Name (ARN) that uniquely identifies the MSK cluster operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterOperationArn(String clusterOperationArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private String clusterOperationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterOperationRequest model) {
            super(model);
            clusterOperationArn(model.clusterOperationArn);
        }

        public final String getClusterOperationArn() {
            return clusterOperationArn;
        }

        public final void setClusterOperationArn(String clusterOperationArn) {
            this.clusterOperationArn = clusterOperationArn;
        }

        @Override
        @Transient
        public final Builder clusterOperationArn(String clusterOperationArn) {
            this.clusterOperationArn = clusterOperationArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeClusterOperationRequest build() {
            return new DescribeClusterOperationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
