/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClustersV2Response extends KafkaResponse implements
        ToCopyableBuilder<ListClustersV2Response.Builder, ListClustersV2Response> {
    private static final SdkField<List<Cluster>> CLUSTER_INFO_LIST_FIELD = SdkField
            .<List<Cluster>> builder(MarshallingType.LIST)
            .memberName("ClusterInfoList")
            .getter(getter(ListClustersV2Response::clusterInfoList))
            .setter(setter(Builder::clusterInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Cluster> builder(MarshallingType.SDK_POJO)
                                            .constructor(Cluster::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListClustersV2Response::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_INFO_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Cluster> clusterInfoList;

    private final String nextToken;

    private ListClustersV2Response(BuilderImpl builder) {
        super(builder);
        this.clusterInfoList = builder.clusterInfoList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterInfoList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClusterInfoList() {
        return clusterInfoList != null && !(clusterInfoList instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * Information on each of the MSK clusters in the response.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterInfoList} method.
     * </p>
     * 
     * @return <p>
     *         Information on each of the MSK clusters in the response.
     *         </p>
     */
    public final List<Cluster> clusterInfoList() {
        return clusterInfoList;
    }

    /**
     *
     * <p>
     * The paginated results marker. When the result of a ListClusters operation is truncated, the call returns
     * NextToken in the response. To get another batch of clusters, provide this token in your next request.
     * </p>
     * 
     * @return <p>
     *         The paginated results marker. When the result of a ListClusters operation is truncated, the call returns
     *         NextToken in the response. To get another batch of clusters, provide this token in your next request.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterInfoList() ? clusterInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersV2Response)) {
            return false;
        }
        ListClustersV2Response other = (ListClustersV2Response) obj;
        return hasClusterInfoList() == other.hasClusterInfoList() && Objects.equals(clusterInfoList(), other.clusterInfoList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListClustersV2Response").add("ClusterInfoList", hasClusterInfoList() ? clusterInfoList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterInfoList":
            return Optional.ofNullable(clazz.cast(clusterInfoList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClustersV2Response, T> g) {
        return obj -> g.apply((ListClustersV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListClustersV2Response> {
        /**
         *
         * <p>
         * Information on each of the MSK clusters in the response.
         * </p>
         * 
         * @param clusterInfoList
         *        <p>
         *        Information on each of the MSK clusters in the response.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterInfoList(Collection<Cluster> clusterInfoList);

        /**
         *
         * <p>
         * Information on each of the MSK clusters in the response.
         * </p>
         * 
         * @param clusterInfoList
         *        <p>
         *        Information on each of the MSK clusters in the response.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterInfoList(Cluster... clusterInfoList);

        /**
         *
         * <p>
         * Information on each of the MSK clusters in the response.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link List<Cluster>.Builder} avoiding the need to
         * create one manually via {@link List<Cluster>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Cluster>.Builder#build()} is called immediately and its
         * result is passed to {@link #clusterInfoList(List<Cluster>)}.
         * 
         * @param clusterInfoList
         *        a consumer that will call methods on {@link List<Cluster>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterInfoList(List<Cluster>)
         */
        Builder clusterInfoList(Consumer<Cluster.Builder>... clusterInfoList);

        /**
         *
         * <p>
         * The paginated results marker. When the result of a ListClusters operation is truncated, the call returns
         * NextToken in the response. To get another batch of clusters, provide this token in your next request.
         * </p>
         * 
         * @param nextToken
         *        <p>
         *        The paginated results marker. When the result of a ListClusters operation is truncated, the call
         *        returns NextToken in the response. To get another batch of clusters, provide this token in your next
         *        request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private List<Cluster> clusterInfoList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersV2Response model) {
            super(model);
            clusterInfoList(model.clusterInfoList);
            nextToken(model.nextToken);
        }

        public final List<Cluster.Builder> getClusterInfoList() {
            List<Cluster.Builder> result = ___listOfClusterCopier.copyToBuilder(this.clusterInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterInfoList(Collection<Cluster.BuilderImpl> clusterInfoList) {
            this.clusterInfoList = ___listOfClusterCopier.copyFromBuilder(clusterInfoList);
        }

        @Override
        @Transient
        public final Builder clusterInfoList(Collection<Cluster> clusterInfoList) {
            this.clusterInfoList = ___listOfClusterCopier.copy(clusterInfoList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterInfoList(Cluster... clusterInfoList) {
            clusterInfoList(Arrays.asList(clusterInfoList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterInfoList(Consumer<Cluster.Builder>... clusterInfoList) {
            clusterInfoList(Stream.of(clusterInfoList).map(c -> Cluster.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListClustersV2Response build() {
            return new ListClustersV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
