/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * JMX and Node monitoring for the MSK cluster.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenMonitoringInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<OpenMonitoringInfo.Builder, OpenMonitoringInfo> {
    private static final SdkField<PrometheusInfo> PROMETHEUS_FIELD = SdkField.<PrometheusInfo> builder(MarshallingType.SDK_POJO)
            .memberName("Prometheus").getter(getter(OpenMonitoringInfo::prometheus)).setter(setter(Builder::prometheus))
            .constructor(PrometheusInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prometheus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMETHEUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final PrometheusInfo prometheus;

    private OpenMonitoringInfo(BuilderImpl builder) {
        this.prometheus = builder.prometheus;
    }

    /**
     *
     * <p>
     * Prometheus settings.
     * </p>
     * 
     * @return <p>
     *         Prometheus settings.
     *         </p>
     */
    public final PrometheusInfo prometheus() {
        return prometheus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prometheus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenMonitoringInfo)) {
            return false;
        }
        OpenMonitoringInfo other = (OpenMonitoringInfo) obj;
        return Objects.equals(prometheus(), other.prometheus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenMonitoringInfo").add("Prometheus", prometheus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Prometheus":
            return Optional.ofNullable(clazz.cast(prometheus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpenMonitoringInfo, T> g) {
        return obj -> g.apply((OpenMonitoringInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenMonitoringInfo> {
        /**
         *
         * <p>
         * Prometheus settings.
         * </p>
         * 
         * @param prometheus
         *        <p>
         *        Prometheus settings.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prometheus(PrometheusInfo prometheus);

        /**
         *
         * <p>
         * Prometheus settings.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link PrometheusInfo.Builder} avoiding the need to
         * create one manually via {@link PrometheusInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link PrometheusInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #prometheus(PrometheusInfo)}.
         * 
         * @param prometheus
         *        a consumer that will call methods on {@link PrometheusInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prometheus(PrometheusInfo)
         */
        default Builder prometheus(Consumer<PrometheusInfo.Builder> prometheus) {
            return prometheus(PrometheusInfo.builder().applyMutation(prometheus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PrometheusInfo prometheus;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenMonitoringInfo model) {
            prometheus(model.prometheus);
        }

        public final PrometheusInfo.Builder getPrometheus() {
            return prometheus != null ? prometheus.toBuilder() : null;
        }

        public final void setPrometheus(PrometheusInfo.BuilderImpl prometheus) {
            this.prometheus = prometheus != null ? prometheus.build() : null;
        }

        @Override
        @Transient
        public final Builder prometheus(PrometheusInfo prometheus) {
            this.prometheus = prometheus;
            return this;
        }

        @Override
        public OpenMonitoringInfo build() {
            return new OpenMonitoringInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
