/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Prometheus settings.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrometheusInfo implements SdkPojo, Serializable, ToCopyableBuilder<PrometheusInfo.Builder, PrometheusInfo> {
    private static final SdkField<JmxExporterInfo> JMX_EXPORTER_FIELD = SdkField
            .<JmxExporterInfo> builder(MarshallingType.SDK_POJO).memberName("JmxExporter")
            .getter(getter(PrometheusInfo::jmxExporter)).setter(setter(Builder::jmxExporter))
            .constructor(JmxExporterInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jmxExporter").build()).build();

    private static final SdkField<NodeExporterInfo> NODE_EXPORTER_FIELD = SdkField
            .<NodeExporterInfo> builder(MarshallingType.SDK_POJO).memberName("NodeExporter")
            .getter(getter(PrometheusInfo::nodeExporter)).setter(setter(Builder::nodeExporter))
            .constructor(NodeExporterInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeExporter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JMX_EXPORTER_FIELD,
            NODE_EXPORTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final JmxExporterInfo jmxExporter;

    private final NodeExporterInfo nodeExporter;

    private PrometheusInfo(BuilderImpl builder) {
        this.jmxExporter = builder.jmxExporter;
        this.nodeExporter = builder.nodeExporter;
    }

    /**
     *
     * <p>
     * Indicates whether you want to turn on or turn off the JMX Exporter.
     * </p>
     * 
     * @return <p>
     *         Indicates whether you want to turn on or turn off the JMX Exporter.
     *         </p>
     */
    public final JmxExporterInfo jmxExporter() {
        return jmxExporter;
    }

    /**
     *
     * <p>
     * Indicates whether you want to turn on or turn off the Node Exporter.
     * </p>
     * 
     * @return <p>
     *         Indicates whether you want to turn on or turn off the Node Exporter.
     *         </p>
     */
    public final NodeExporterInfo nodeExporter() {
        return nodeExporter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jmxExporter());
        hashCode = 31 * hashCode + Objects.hashCode(nodeExporter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrometheusInfo)) {
            return false;
        }
        PrometheusInfo other = (PrometheusInfo) obj;
        return Objects.equals(jmxExporter(), other.jmxExporter()) && Objects.equals(nodeExporter(), other.nodeExporter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrometheusInfo").add("JmxExporter", jmxExporter()).add("NodeExporter", nodeExporter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JmxExporter":
            return Optional.ofNullable(clazz.cast(jmxExporter()));
        case "NodeExporter":
            return Optional.ofNullable(clazz.cast(nodeExporter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrometheusInfo, T> g) {
        return obj -> g.apply((PrometheusInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrometheusInfo> {
        /**
         *
         * <p>
         * Indicates whether you want to turn on or turn off the JMX Exporter.
         * </p>
         * 
         * @param jmxExporter
         *        <p>
         *        Indicates whether you want to turn on or turn off the JMX Exporter.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jmxExporter(JmxExporterInfo jmxExporter);

        /**
         *
         * <p>
         * Indicates whether you want to turn on or turn off the JMX Exporter.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link JmxExporterInfo.Builder} avoiding the need to
         * create one manually via {@link JmxExporterInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link JmxExporterInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #jmxExporter(JmxExporterInfo)}.
         * 
         * @param jmxExporter
         *        a consumer that will call methods on {@link JmxExporterInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jmxExporter(JmxExporterInfo)
         */
        default Builder jmxExporter(Consumer<JmxExporterInfo.Builder> jmxExporter) {
            return jmxExporter(JmxExporterInfo.builder().applyMutation(jmxExporter).build());
        }

        /**
         *
         * <p>
         * Indicates whether you want to turn on or turn off the Node Exporter.
         * </p>
         * 
         * @param nodeExporter
         *        <p>
         *        Indicates whether you want to turn on or turn off the Node Exporter.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeExporter(NodeExporterInfo nodeExporter);

        /**
         *
         * <p>
         * Indicates whether you want to turn on or turn off the Node Exporter.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link NodeExporterInfo.Builder} avoiding the need to
         * create one manually via {@link NodeExporterInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link NodeExporterInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #nodeExporter(NodeExporterInfo)}.
         * 
         * @param nodeExporter
         *        a consumer that will call methods on {@link NodeExporterInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeExporter(NodeExporterInfo)
         */
        default Builder nodeExporter(Consumer<NodeExporterInfo.Builder> nodeExporter) {
            return nodeExporter(NodeExporterInfo.builder().applyMutation(nodeExporter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private JmxExporterInfo jmxExporter;

        private NodeExporterInfo nodeExporter;

        private BuilderImpl() {
        }

        private BuilderImpl(PrometheusInfo model) {
            jmxExporter(model.jmxExporter);
            nodeExporter(model.nodeExporter);
        }

        public final JmxExporterInfo.Builder getJmxExporter() {
            return jmxExporter != null ? jmxExporter.toBuilder() : null;
        }

        public final void setJmxExporter(JmxExporterInfo.BuilderImpl jmxExporter) {
            this.jmxExporter = jmxExporter != null ? jmxExporter.build() : null;
        }

        @Override
        @Transient
        public final Builder jmxExporter(JmxExporterInfo jmxExporter) {
            this.jmxExporter = jmxExporter;
            return this;
        }

        public final NodeExporterInfo.Builder getNodeExporter() {
            return nodeExporter != null ? nodeExporter.toBuilder() : null;
        }

        public final void setNodeExporter(NodeExporterInfo.BuilderImpl nodeExporter) {
            this.nodeExporter = nodeExporter != null ? nodeExporter.build() : null;
        }

        @Override
        @Transient
        public final Builder nodeExporter(NodeExporterInfo nodeExporter) {
            this.nodeExporter = nodeExporter;
            return this;
        }

        @Override
        public PrometheusInfo build() {
            return new PrometheusInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
