/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterOperationResponse extends KafkaResponse implements
        ToCopyableBuilder<DescribeClusterOperationResponse.Builder, DescribeClusterOperationResponse> {
    private static final SdkField<ClusterOperationInfo> CLUSTER_OPERATION_INFO_FIELD = SdkField
            .<ClusterOperationInfo> builder(MarshallingType.SDK_POJO).memberName("ClusterOperationInfo")
            .getter(getter(DescribeClusterOperationResponse::clusterOperationInfo)).setter(setter(Builder::clusterOperationInfo))
            .constructor(ClusterOperationInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterOperationInfo").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_OPERATION_INFO_FIELD));

    private final ClusterOperationInfo clusterOperationInfo;

    private DescribeClusterOperationResponse(BuilderImpl builder) {
        super(builder);
        this.clusterOperationInfo = builder.clusterOperationInfo;
    }

    /**
     *
     * <p>
     * Cluster operation information
     * </p>
     * 
     * @return <p>
     *         Cluster operation information
     *         </p>
     */
    public final ClusterOperationInfo clusterOperationInfo() {
        return clusterOperationInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterOperationInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterOperationResponse)) {
            return false;
        }
        DescribeClusterOperationResponse other = (DescribeClusterOperationResponse) obj;
        return Objects.equals(clusterOperationInfo(), other.clusterOperationInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClusterOperationResponse").add("ClusterOperationInfo", clusterOperationInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterOperationInfo":
            return Optional.ofNullable(clazz.cast(clusterOperationInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterOperationResponse, T> g) {
        return obj -> g.apply((DescribeClusterOperationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClusterOperationResponse> {
        /**
         *
         * <p>
         * Cluster operation information
         * </p>
         * 
         * @param clusterOperationInfo
         *        <p>
         *        Cluster operation information
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterOperationInfo(ClusterOperationInfo clusterOperationInfo);

        /**
         *
         * <p>
         * Cluster operation information
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link ClusterOperationInfo.Builder} avoiding
         * the need to create one manually via {@link ClusterOperationInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClusterOperationInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #clusterOperationInfo(ClusterOperationInfo)}.
         * 
         * @param clusterOperationInfo
         *        a consumer that will call methods on {@link ClusterOperationInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterOperationInfo(ClusterOperationInfo)
         */
        default Builder clusterOperationInfo(Consumer<ClusterOperationInfo.Builder> clusterOperationInfo) {
            return clusterOperationInfo(ClusterOperationInfo.builder().applyMutation(clusterOperationInfo).build());
        }
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private ClusterOperationInfo clusterOperationInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterOperationResponse model) {
            super(model);
            clusterOperationInfo(model.clusterOperationInfo);
        }

        public final ClusterOperationInfo.Builder getClusterOperationInfo() {
            return clusterOperationInfo != null ? clusterOperationInfo.toBuilder() : null;
        }

        public final void setClusterOperationInfo(ClusterOperationInfo.BuilderImpl clusterOperationInfo) {
            this.clusterOperationInfo = clusterOperationInfo != null ? clusterOperationInfo.build() : null;
        }

        @Override
        public final Builder clusterOperationInfo(ClusterOperationInfo clusterOperationInfo) {
            this.clusterOperationInfo = clusterOperationInfo;
            return this;
        }

        @Override
        public DescribeClusterOperationResponse build() {
            return new DescribeClusterOperationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
