/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Contains information about the EBS storage volumes attached to Apache Kafka broker nodes.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class EBSStorageInfo implements SdkPojo, Serializable, ToCopyableBuilder<EBSStorageInfo.Builder, EBSStorageInfo> {
    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField
            .<ProvisionedThroughput> builder(MarshallingType.SDK_POJO).memberName("ProvisionedThroughput")
            .getter(getter(EBSStorageInfo::provisionedThroughput)).setter(setter(Builder::provisionedThroughput))
            .constructor(ProvisionedThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedThroughput").build())
            .build();

    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSize").getter(getter(EBSStorageInfo::volumeSize)).setter(setter(Builder::volumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONED_THROUGHPUT_FIELD,
            VOLUME_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ProvisionedThroughput provisionedThroughput;

    private final Integer volumeSize;

    private EBSStorageInfo(BuilderImpl builder) {
        this.provisionedThroughput = builder.provisionedThroughput;
        this.volumeSize = builder.volumeSize;
    }

    /**
     * EBS volume provisioned throughput information.
     * 
     * @return EBS volume provisioned throughput information.
     */
    public final ProvisionedThroughput provisionedThroughput() {
        return provisionedThroughput;
    }

    /**
     *
     * <p>
     * The size in GiB of the EBS volume for the data drive on each broker node.
     * </p>
     * 
     * @return <p>
     *         The size in GiB of the EBS volume for the data drive on each broker node.
     *         </p>
     */
    public final Integer volumeSize() {
        return volumeSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EBSStorageInfo)) {
            return false;
        }
        EBSStorageInfo other = (EBSStorageInfo) obj;
        return Objects.equals(provisionedThroughput(), other.provisionedThroughput())
                && Objects.equals(volumeSize(), other.volumeSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EBSStorageInfo").add("ProvisionedThroughput", provisionedThroughput())
                .add("VolumeSize", volumeSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisionedThroughput":
            return Optional.ofNullable(clazz.cast(provisionedThroughput()));
        case "VolumeSize":
            return Optional.ofNullable(clazz.cast(volumeSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EBSStorageInfo, T> g) {
        return obj -> g.apply((EBSStorageInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EBSStorageInfo> {
        /**
         * EBS volume provisioned throughput information.
         * 
         * @param provisionedThroughput
         *        EBS volume provisioned throughput information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput);

        /**
         * EBS volume provisioned throughput information. This is a convenience method that creates an instance of the
         * {@link ProvisionedThroughput.Builder} avoiding the need to create one manually via
         * {@link ProvisionedThroughput#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProvisionedThroughput.Builder#build()} is called immediately and
         * its result is passed to {@link #provisionedThroughput(ProvisionedThroughput)}.
         * 
         * @param provisionedThroughput
         *        a consumer that will call methods on {@link ProvisionedThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughput(ProvisionedThroughput)
         */
        default Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return provisionedThroughput(ProvisionedThroughput.builder().applyMutation(provisionedThroughput).build());
        }

        /**
         *
         * <p>
         * The size in GiB of the EBS volume for the data drive on each broker node.
         * </p>
         * 
         * @param volumeSize
         *        <p>
         *        The size in GiB of the EBS volume for the data drive on each broker node.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Integer volumeSize);
    }

    static final class BuilderImpl implements Builder {
        private ProvisionedThroughput provisionedThroughput;

        private Integer volumeSize;

        private BuilderImpl() {
        }

        private BuilderImpl(EBSStorageInfo model) {
            provisionedThroughput(model.provisionedThroughput);
            volumeSize(model.volumeSize);
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return provisionedThroughput != null ? provisionedThroughput.toBuilder() : null;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final Integer getVolumeSize() {
            return volumeSize;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        @Override
        public EBSStorageInfo build() {
            return new EBSStorageInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
