/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Serverless cluster request.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerlessRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerlessRequest.Builder, ServerlessRequest> {
    private static final SdkField<List<VpcConfig>> VPC_CONFIGS_FIELD = SdkField
            .<List<VpcConfig>> builder(MarshallingType.LIST)
            .memberName("VpcConfigs")
            .getter(getter(ServerlessRequest::vpcConfigs))
            .setter(setter(Builder::vpcConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ServerlessClientAuthentication> CLIENT_AUTHENTICATION_FIELD = SdkField
            .<ServerlessClientAuthentication> builder(MarshallingType.SDK_POJO).memberName("ClientAuthentication")
            .getter(getter(ServerlessRequest::clientAuthentication)).setter(setter(Builder::clientAuthentication))
            .constructor(ServerlessClientAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientAuthentication").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONFIGS_FIELD,
            CLIENT_AUTHENTICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<VpcConfig> vpcConfigs;

    private final ServerlessClientAuthentication clientAuthentication;

    private ServerlessRequest(BuilderImpl builder) {
        this.vpcConfigs = builder.vpcConfigs;
        this.clientAuthentication = builder.clientAuthentication;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcConfigs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVpcConfigs() {
        return vpcConfigs != null && !(vpcConfigs instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * The configuration of the Amazon VPCs for the cluster.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcConfigs} method.
     * </p>
     * 
     * @return <p>
     *         The configuration of the Amazon VPCs for the cluster.
     *         </p>
     */
    public final List<VpcConfig> vpcConfigs() {
        return vpcConfigs;
    }

    /**
     *
     * <p>
     * Includes all client authentication information.
     * </p>
     * 
     * @return <p>
     *         Includes all client authentication information.
     *         </p>
     */
    public final ServerlessClientAuthentication clientAuthentication() {
        return clientAuthentication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcConfigs() ? vpcConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientAuthentication());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerlessRequest)) {
            return false;
        }
        ServerlessRequest other = (ServerlessRequest) obj;
        return hasVpcConfigs() == other.hasVpcConfigs() && Objects.equals(vpcConfigs(), other.vpcConfigs())
                && Objects.equals(clientAuthentication(), other.clientAuthentication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerlessRequest").add("VpcConfigs", hasVpcConfigs() ? vpcConfigs() : null)
                .add("ClientAuthentication", clientAuthentication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcConfigs":
            return Optional.ofNullable(clazz.cast(vpcConfigs()));
        case "ClientAuthentication":
            return Optional.ofNullable(clazz.cast(clientAuthentication()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerlessRequest, T> g) {
        return obj -> g.apply((ServerlessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerlessRequest> {
        /**
         *
         * <p>
         * The configuration of the Amazon VPCs for the cluster.
         * </p>
         * 
         * @param vpcConfigs
         *        <p>
         *        The configuration of the Amazon VPCs for the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfigs(Collection<VpcConfig> vpcConfigs);

        /**
         *
         * <p>
         * The configuration of the Amazon VPCs for the cluster.
         * </p>
         * 
         * @param vpcConfigs
         *        <p>
         *        The configuration of the Amazon VPCs for the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfigs(VpcConfig... vpcConfigs);

        /**
         *
         * <p>
         * The configuration of the Amazon VPCs for the cluster.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link List<VpcConfig>.Builder} avoiding the
         * need to create one manually via {@link List<VpcConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcConfig>.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfigs(List<VpcConfig>)}.
         * 
         * @param vpcConfigs
         *        a consumer that will call methods on {@link List<VpcConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfigs(List<VpcConfig>)
         */
        Builder vpcConfigs(Consumer<VpcConfig.Builder>... vpcConfigs);

        /**
         *
         * <p>
         * Includes all client authentication information.
         * </p>
         * 
         * @param clientAuthentication
         *        <p>
         *        Includes all client authentication information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientAuthentication(ServerlessClientAuthentication clientAuthentication);

        /**
         *
         * <p>
         * Includes all client authentication information.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link ServerlessClientAuthentication.Builder}
         * avoiding the need to create one manually via {@link ServerlessClientAuthentication#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServerlessClientAuthentication.Builder#build()} is called
         * immediately and its result is passed to {@link #clientAuthentication(ServerlessClientAuthentication)}.
         * 
         * @param clientAuthentication
         *        a consumer that will call methods on {@link ServerlessClientAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientAuthentication(ServerlessClientAuthentication)
         */
        default Builder clientAuthentication(Consumer<ServerlessClientAuthentication.Builder> clientAuthentication) {
            return clientAuthentication(ServerlessClientAuthentication.builder().applyMutation(clientAuthentication).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<VpcConfig> vpcConfigs = DefaultSdkAutoConstructList.getInstance();

        private ServerlessClientAuthentication clientAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerlessRequest model) {
            vpcConfigs(model.vpcConfigs);
            clientAuthentication(model.clientAuthentication);
        }

        public final List<VpcConfig.Builder> getVpcConfigs() {
            List<VpcConfig.Builder> result = ___listOfVpcConfigCopier.copyToBuilder(this.vpcConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcConfigs(Collection<VpcConfig.BuilderImpl> vpcConfigs) {
            this.vpcConfigs = ___listOfVpcConfigCopier.copyFromBuilder(vpcConfigs);
        }

        @Override
        public final Builder vpcConfigs(Collection<VpcConfig> vpcConfigs) {
            this.vpcConfigs = ___listOfVpcConfigCopier.copy(vpcConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConfigs(VpcConfig... vpcConfigs) {
            vpcConfigs(Arrays.asList(vpcConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConfigs(Consumer<VpcConfig.Builder>... vpcConfigs) {
            vpcConfigs(Stream.of(vpcConfigs).map(c -> VpcConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ServerlessClientAuthentication.Builder getClientAuthentication() {
            return clientAuthentication != null ? clientAuthentication.toBuilder() : null;
        }

        public final void setClientAuthentication(ServerlessClientAuthentication.BuilderImpl clientAuthentication) {
            this.clientAuthentication = clientAuthentication != null ? clientAuthentication.build() : null;
        }

        @Override
        public final Builder clientAuthentication(ServerlessClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        @Override
        public ServerlessRequest build() {
            return new ServerlessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
