/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Request body for UpdateConnectivity.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectivityRequest extends KafkaRequest implements
        ToCopyableBuilder<UpdateConnectivityRequest.Builder, UpdateConnectivityRequest> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(UpdateConnectivityRequest::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()).build();

    private static final SdkField<ConnectivityInfo> CONNECTIVITY_INFO_FIELD = SdkField
            .<ConnectivityInfo> builder(MarshallingType.SDK_POJO).memberName("ConnectivityInfo")
            .getter(getter(UpdateConnectivityRequest::connectivityInfo)).setter(setter(Builder::connectivityInfo))
            .constructor(ConnectivityInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectivityInfo").build()).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(UpdateConnectivityRequest::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            CONNECTIVITY_INFO_FIELD, CURRENT_VERSION_FIELD));

    private final String clusterArn;

    private final ConnectivityInfo connectivityInfo;

    private final String currentVersion;

    private UpdateConnectivityRequest(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.connectivityInfo = builder.connectivityInfo;
        this.currentVersion = builder.currentVersion;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) of the configuration.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the configuration.
     *         </p>
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     *
     * <p>
     * Information about the broker access configuration.
     * </p>
     * 
     * @return <p>
     *         Information about the broker access configuration.
     *         </p>
     */
    public final ConnectivityInfo connectivityInfo() {
        return connectivityInfo;
    }

    /**
     *
     * <p>
     * The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an MSK cluster
     * to find its version. When this update operation is successful, it generates a new cluster version.
     * </p>
     * 
     * @return <p>
     *         The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an MSK
     *         cluster to find its version. When this update operation is successful, it generates a new cluster
     *         version.
     *         </p>
     */
    public final String currentVersion() {
        return currentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectivityInfo());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectivityRequest)) {
            return false;
        }
        UpdateConnectivityRequest other = (UpdateConnectivityRequest) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(connectivityInfo(), other.connectivityInfo())
                && Objects.equals(currentVersion(), other.currentVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectivityRequest").add("ClusterArn", clusterArn())
                .add("ConnectivityInfo", connectivityInfo()).add("CurrentVersion", currentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "ConnectivityInfo":
            return Optional.ofNullable(clazz.cast(connectivityInfo()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectivityRequest, T> g) {
        return obj -> g.apply((UpdateConnectivityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConnectivityRequest> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) of the configuration.
         * </p>
         * 
         * @param clusterArn
         *        <p>
         *        The Amazon Resource Name (ARN) of the configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         *
         * <p>
         * Information about the broker access configuration.
         * </p>
         * 
         * @param connectivityInfo
         *        <p>
         *        Information about the broker access configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectivityInfo(ConnectivityInfo connectivityInfo);

        /**
         *
         * <p>
         * Information about the broker access configuration.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link ConnectivityInfo.Builder} avoiding the
         * need to create one manually via {@link ConnectivityInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectivityInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #connectivityInfo(ConnectivityInfo)}.
         * 
         * @param connectivityInfo
         *        a consumer that will call methods on {@link ConnectivityInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectivityInfo(ConnectivityInfo)
         */
        default Builder connectivityInfo(Consumer<ConnectivityInfo.Builder> connectivityInfo) {
            return connectivityInfo(ConnectivityInfo.builder().applyMutation(connectivityInfo).build());
        }

        /**
         *
         * <p>
         * The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an MSK
         * cluster to find its version. When this update operation is successful, it generates a new cluster version.
         * </p>
         * 
         * @param currentVersion
         *        <p>
         *        The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an
         *        MSK cluster to find its version. When this update operation is successful, it generates a new cluster
         *        version.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private String clusterArn;

        private ConnectivityInfo connectivityInfo;

        private String currentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectivityRequest model) {
            super(model);
            clusterArn(model.clusterArn);
            connectivityInfo(model.connectivityInfo);
            currentVersion(model.currentVersion);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final ConnectivityInfo.Builder getConnectivityInfo() {
            return connectivityInfo != null ? connectivityInfo.toBuilder() : null;
        }

        public final void setConnectivityInfo(ConnectivityInfo.BuilderImpl connectivityInfo) {
            this.connectivityInfo = connectivityInfo != null ? connectivityInfo.build() : null;
        }

        @Override
        public final Builder connectivityInfo(ConnectivityInfo connectivityInfo) {
            this.connectivityInfo = connectivityInfo;
            return this;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectivityRequest build() {
            return new UpdateConnectivityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
