/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Returns information about a cluster.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterInfo implements SdkPojo, Serializable, ToCopyableBuilder<ClusterInfo.Builder, ClusterInfo> {
    private static final SdkField<String> ACTIVE_OPERATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveOperationArn").getter(getter(ClusterInfo::activeOperationArn))
            .setter(setter(Builder::activeOperationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeOperationArn").build())
            .build();

    private static final SdkField<BrokerNodeGroupInfo> BROKER_NODE_GROUP_INFO_FIELD = SdkField
            .<BrokerNodeGroupInfo> builder(MarshallingType.SDK_POJO).memberName("BrokerNodeGroupInfo")
            .getter(getter(ClusterInfo::brokerNodeGroupInfo)).setter(setter(Builder::brokerNodeGroupInfo))
            .constructor(BrokerNodeGroupInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerNodeGroupInfo").build())
            .build();

    private static final SdkField<ClientAuthentication> CLIENT_AUTHENTICATION_FIELD = SdkField
            .<ClientAuthentication> builder(MarshallingType.SDK_POJO).memberName("ClientAuthentication")
            .getter(getter(ClusterInfo::clientAuthentication)).setter(setter(Builder::clientAuthentication))
            .constructor(ClientAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientAuthentication").build())
            .build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(ClusterInfo::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(ClusterInfo::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(ClusterInfo::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<BrokerSoftwareInfo> CURRENT_BROKER_SOFTWARE_INFO_FIELD = SdkField
            .<BrokerSoftwareInfo> builder(MarshallingType.SDK_POJO).memberName("CurrentBrokerSoftwareInfo")
            .getter(getter(ClusterInfo::currentBrokerSoftwareInfo)).setter(setter(Builder::currentBrokerSoftwareInfo))
            .constructor(BrokerSoftwareInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentBrokerSoftwareInfo").build())
            .build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(ClusterInfo::currentVersion)).setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()).build();

    private static final SdkField<EncryptionInfo> ENCRYPTION_INFO_FIELD = SdkField
            .<EncryptionInfo> builder(MarshallingType.SDK_POJO).memberName("EncryptionInfo")
            .getter(getter(ClusterInfo::encryptionInfo)).setter(setter(Builder::encryptionInfo))
            .constructor(EncryptionInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionInfo").build()).build();

    private static final SdkField<String> ENHANCED_MONITORING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnhancedMonitoring").getter(getter(ClusterInfo::enhancedMonitoringAsString))
            .setter(setter(Builder::enhancedMonitoring))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedMonitoring").build())
            .build();

    private static final SdkField<OpenMonitoring> OPEN_MONITORING_FIELD = SdkField
            .<OpenMonitoring> builder(MarshallingType.SDK_POJO).memberName("OpenMonitoring")
            .getter(getter(ClusterInfo::openMonitoring)).setter(setter(Builder::openMonitoring))
            .constructor(OpenMonitoring::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openMonitoring").build()).build();

    private static final SdkField<LoggingInfo> LOGGING_INFO_FIELD = SdkField.<LoggingInfo> builder(MarshallingType.SDK_POJO)
            .memberName("LoggingInfo").getter(getter(ClusterInfo::loggingInfo)).setter(setter(Builder::loggingInfo))
            .constructor(LoggingInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingInfo").build()).build();

    private static final SdkField<Integer> NUMBER_OF_BROKER_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfBrokerNodes").getter(getter(ClusterInfo::numberOfBrokerNodes))
            .setter(setter(Builder::numberOfBrokerNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfBrokerNodes").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ClusterInfo::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<StateInfo> STATE_INFO_FIELD = SdkField.<StateInfo> builder(MarshallingType.SDK_POJO)
            .memberName("StateInfo").getter(getter(ClusterInfo::stateInfo)).setter(setter(Builder::stateInfo))
            .constructor(StateInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateInfo").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(ClusterInfo::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ZOOKEEPER_CONNECT_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ZookeeperConnectString").getter(getter(ClusterInfo::zookeeperConnectString))
            .setter(setter(Builder::zookeeperConnectString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperConnectString").build())
            .build();

    private static final SdkField<String> ZOOKEEPER_CONNECT_STRING_TLS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ZookeeperConnectStringTls").getter(getter(ClusterInfo::zookeeperConnectStringTls))
            .setter(setter(Builder::zookeeperConnectStringTls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperConnectStringTls").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_OPERATION_ARN_FIELD,
            BROKER_NODE_GROUP_INFO_FIELD, CLIENT_AUTHENTICATION_FIELD, CLUSTER_ARN_FIELD, CLUSTER_NAME_FIELD,
            CREATION_TIME_FIELD, CURRENT_BROKER_SOFTWARE_INFO_FIELD, CURRENT_VERSION_FIELD, ENCRYPTION_INFO_FIELD,
            ENHANCED_MONITORING_FIELD, OPEN_MONITORING_FIELD, LOGGING_INFO_FIELD, NUMBER_OF_BROKER_NODES_FIELD, STATE_FIELD,
            STATE_INFO_FIELD, TAGS_FIELD, ZOOKEEPER_CONNECT_STRING_FIELD, ZOOKEEPER_CONNECT_STRING_TLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String activeOperationArn;

    private final BrokerNodeGroupInfo brokerNodeGroupInfo;

    private final ClientAuthentication clientAuthentication;

    private final String clusterArn;

    private final String clusterName;

    private final Instant creationTime;

    private final BrokerSoftwareInfo currentBrokerSoftwareInfo;

    private final String currentVersion;

    private final EncryptionInfo encryptionInfo;

    private final String enhancedMonitoring;

    private final OpenMonitoring openMonitoring;

    private final LoggingInfo loggingInfo;

    private final Integer numberOfBrokerNodes;

    private final String state;

    private final StateInfo stateInfo;

    private final Map<String, String> tags;

    private final String zookeeperConnectString;

    private final String zookeeperConnectStringTls;

    private ClusterInfo(BuilderImpl builder) {
        this.activeOperationArn = builder.activeOperationArn;
        this.brokerNodeGroupInfo = builder.brokerNodeGroupInfo;
        this.clientAuthentication = builder.clientAuthentication;
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.creationTime = builder.creationTime;
        this.currentBrokerSoftwareInfo = builder.currentBrokerSoftwareInfo;
        this.currentVersion = builder.currentVersion;
        this.encryptionInfo = builder.encryptionInfo;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.openMonitoring = builder.openMonitoring;
        this.loggingInfo = builder.loggingInfo;
        this.numberOfBrokerNodes = builder.numberOfBrokerNodes;
        this.state = builder.state;
        this.stateInfo = builder.stateInfo;
        this.tags = builder.tags;
        this.zookeeperConnectString = builder.zookeeperConnectString;
        this.zookeeperConnectStringTls = builder.zookeeperConnectStringTls;
    }

    /**
     *
     * <p>
     * Arn of active cluster operation.
     * </p>
     * 
     * @return <p>
     *         Arn of active cluster operation.
     *         </p>
     */
    public final String activeOperationArn() {
        return activeOperationArn;
    }

    /**
     *
     * <p>
     * Information about the broker nodes.
     * </p>
     * 
     * @return <p>
     *         Information about the broker nodes.
     *         </p>
     */
    public final BrokerNodeGroupInfo brokerNodeGroupInfo() {
        return brokerNodeGroupInfo;
    }

    /**
     *
     * <p>
     * Includes all client authentication information.
     * </p>
     * 
     * @return <p>
     *         Includes all client authentication information.
     *         </p>
     */
    public final ClientAuthentication clientAuthentication() {
        return clientAuthentication;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     *         </p>
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     *
     * <p>
     * The name of the cluster.
     * </p>
     * 
     * @return <p>
     *         The name of the cluster.
     *         </p>
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     *
     * <p>
     * The time when the cluster was created.
     * </p>
     * 
     * @return <p>
     *         The time when the cluster was created.
     *         </p>
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     *
     * <p>
     * Information about the version of software currently deployed on the Apache Kafka brokers in the cluster.
     * </p>
     * 
     * @return <p>
     *         Information about the version of software currently deployed on the Apache Kafka brokers in the cluster.
     *         </p>
     */
    public final BrokerSoftwareInfo currentBrokerSoftwareInfo() {
        return currentBrokerSoftwareInfo;
    }

    /**
     *
     * <p>
     * The current version of the MSK cluster.
     * </p>
     * 
     * @return <p>
     *         The current version of the MSK cluster.
     *         </p>
     */
    public final String currentVersion() {
        return currentVersion;
    }

    /**
     *
     * <p>
     * Includes all encryption-related information.
     * </p>
     * 
     * @return <p>
     *         Includes all encryption-related information.
     *         </p>
     */
    public final EncryptionInfo encryptionInfo() {
        return encryptionInfo;
    }

    /**
     *
     * <p>
     * Specifies which metrics are gathered for the MSK cluster. This property has the following possible values:
     * DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION. For a list of the metrics associated with
     * each of these levels of monitoring, see <a
     * href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedMonitoring} will return {@link EnhancedMonitoring#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #enhancedMonitoringAsString}.
     * </p>
     * 
     * @return <p>
     *         Specifies which metrics are gathered for the MSK cluster. This property has the following possible
     *         values: DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION. For a list of the metrics
     *         associated with each of these levels of monitoring, see <a
     *         href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.
     *         </p>
     * @see EnhancedMonitoring
     */
    public final EnhancedMonitoring enhancedMonitoring() {
        return EnhancedMonitoring.fromValue(enhancedMonitoring);
    }

    /**
     *
     * <p>
     * Specifies which metrics are gathered for the MSK cluster. This property has the following possible values:
     * DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION. For a list of the metrics associated with
     * each of these levels of monitoring, see <a
     * href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedMonitoring} will return {@link EnhancedMonitoring#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #enhancedMonitoringAsString}.
     * </p>
     * 
     * @return <p>
     *         Specifies which metrics are gathered for the MSK cluster. This property has the following possible
     *         values: DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION. For a list of the metrics
     *         associated with each of these levels of monitoring, see <a
     *         href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.
     *         </p>
     * @see EnhancedMonitoring
     */
    public final String enhancedMonitoringAsString() {
        return enhancedMonitoring;
    }

    /**
     *
     * <p>
     * Settings for open monitoring using Prometheus.
     * </p>
     * 
     * @return <p>
     *         Settings for open monitoring using Prometheus.
     *         </p>
     */
    public final OpenMonitoring openMonitoring() {
        return openMonitoring;
    }

    /**
     * Returns the value of the LoggingInfo property for this object.
     * 
     * @return The value of the LoggingInfo property for this object.
     */
    public final LoggingInfo loggingInfo() {
        return loggingInfo;
    }

    /**
     *
     * <p>
     * The number of broker nodes in the cluster.
     * </p>
     * 
     * @return <p>
     *         The number of broker nodes in the cluster.
     *         </p>
     */
    public final Integer numberOfBrokerNodes() {
        return numberOfBrokerNodes;
    }

    /**
     *
     * <p>
     * The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE,
     * REBOOTING_BROKER, and UPDATING.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ClusterState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <p>
     *         The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING,
     *         MAINTENANCE, REBOOTING_BROKER, and UPDATING.
     *         </p>
     * @see ClusterState
     */
    public final ClusterState state() {
        return ClusterState.fromValue(state);
    }

    /**
     *
     * <p>
     * The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE,
     * REBOOTING_BROKER, and UPDATING.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ClusterState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <p>
     *         The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING,
     *         MAINTENANCE, REBOOTING_BROKER, and UPDATING.
     *         </p>
     * @see ClusterState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * Returns the value of the StateInfo property for this object.
     * 
     * @return The value of the StateInfo property for this object.
     */
    public final StateInfo stateInfo() {
        return stateInfo;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     *
     * <p>
     * Tags attached to the cluster.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return <p>
     *         Tags attached to the cluster.
     *         </p>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     *
     * <p>
     * The connection string to use to connect to the Apache ZooKeeper cluster.
     * </p>
     * 
     * @return <p>
     *         The connection string to use to connect to the Apache ZooKeeper cluster.
     *         </p>
     */
    public final String zookeeperConnectString() {
        return zookeeperConnectString;
    }

    /**
     *
     * <p>
     * The connection string to use to connect to zookeeper cluster on Tls port.
     * </p>
     * 
     * @return <p>
     *         The connection string to use to connect to zookeeper cluster on Tls port.
     *         </p>
     */
    public final String zookeeperConnectStringTls() {
        return zookeeperConnectStringTls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeOperationArn());
        hashCode = 31 * hashCode + Objects.hashCode(brokerNodeGroupInfo());
        hashCode = 31 * hashCode + Objects.hashCode(clientAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(currentBrokerSoftwareInfo());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedMonitoringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(openMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(loggingInfo());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfBrokerNodes());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(zookeeperConnectString());
        hashCode = 31 * hashCode + Objects.hashCode(zookeeperConnectStringTls());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterInfo)) {
            return false;
        }
        ClusterInfo other = (ClusterInfo) obj;
        return Objects.equals(activeOperationArn(), other.activeOperationArn())
                && Objects.equals(brokerNodeGroupInfo(), other.brokerNodeGroupInfo())
                && Objects.equals(clientAuthentication(), other.clientAuthentication())
                && Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(currentBrokerSoftwareInfo(), other.currentBrokerSoftwareInfo())
                && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(encryptionInfo(), other.encryptionInfo())
                && Objects.equals(enhancedMonitoringAsString(), other.enhancedMonitoringAsString())
                && Objects.equals(openMonitoring(), other.openMonitoring()) && Objects.equals(loggingInfo(), other.loggingInfo())
                && Objects.equals(numberOfBrokerNodes(), other.numberOfBrokerNodes())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(stateInfo(), other.stateInfo())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(zookeeperConnectString(), other.zookeeperConnectString())
                && Objects.equals(zookeeperConnectStringTls(), other.zookeeperConnectStringTls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterInfo").add("ActiveOperationArn", activeOperationArn())
                .add("BrokerNodeGroupInfo", brokerNodeGroupInfo()).add("ClientAuthentication", clientAuthentication())
                .add("ClusterArn", clusterArn()).add("ClusterName", clusterName()).add("CreationTime", creationTime())
                .add("CurrentBrokerSoftwareInfo", currentBrokerSoftwareInfo()).add("CurrentVersion", currentVersion())
                .add("EncryptionInfo", encryptionInfo()).add("EnhancedMonitoring", enhancedMonitoringAsString())
                .add("OpenMonitoring", openMonitoring()).add("LoggingInfo", loggingInfo())
                .add("NumberOfBrokerNodes", numberOfBrokerNodes()).add("State", stateAsString()).add("StateInfo", stateInfo())
                .add("Tags", hasTags() ? tags() : null).add("ZookeeperConnectString", zookeeperConnectString())
                .add("ZookeeperConnectStringTls", zookeeperConnectStringTls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveOperationArn":
            return Optional.ofNullable(clazz.cast(activeOperationArn()));
        case "BrokerNodeGroupInfo":
            return Optional.ofNullable(clazz.cast(brokerNodeGroupInfo()));
        case "ClientAuthentication":
            return Optional.ofNullable(clazz.cast(clientAuthentication()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CurrentBrokerSoftwareInfo":
            return Optional.ofNullable(clazz.cast(currentBrokerSoftwareInfo()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "EncryptionInfo":
            return Optional.ofNullable(clazz.cast(encryptionInfo()));
        case "EnhancedMonitoring":
            return Optional.ofNullable(clazz.cast(enhancedMonitoringAsString()));
        case "OpenMonitoring":
            return Optional.ofNullable(clazz.cast(openMonitoring()));
        case "LoggingInfo":
            return Optional.ofNullable(clazz.cast(loggingInfo()));
        case "NumberOfBrokerNodes":
            return Optional.ofNullable(clazz.cast(numberOfBrokerNodes()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateInfo":
            return Optional.ofNullable(clazz.cast(stateInfo()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ZookeeperConnectString":
            return Optional.ofNullable(clazz.cast(zookeeperConnectString()));
        case "ZookeeperConnectStringTls":
            return Optional.ofNullable(clazz.cast(zookeeperConnectStringTls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterInfo, T> g) {
        return obj -> g.apply((ClusterInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterInfo> {
        /**
         *
         * <p>
         * Arn of active cluster operation.
         * </p>
         * 
         * @param activeOperationArn
         *        <p>
         *        Arn of active cluster operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeOperationArn(String activeOperationArn);

        /**
         *
         * <p>
         * Information about the broker nodes.
         * </p>
         * 
         * @param brokerNodeGroupInfo
         *        <p>
         *        Information about the broker nodes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerNodeGroupInfo(BrokerNodeGroupInfo brokerNodeGroupInfo);

        /**
         *
         * <p>
         * Information about the broker nodes.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link BrokerNodeGroupInfo.Builder} avoiding the
         * need to create one manually via {@link BrokerNodeGroupInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BrokerNodeGroupInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #brokerNodeGroupInfo(BrokerNodeGroupInfo)}.
         * 
         * @param brokerNodeGroupInfo
         *        a consumer that will call methods on {@link BrokerNodeGroupInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brokerNodeGroupInfo(BrokerNodeGroupInfo)
         */
        default Builder brokerNodeGroupInfo(Consumer<BrokerNodeGroupInfo.Builder> brokerNodeGroupInfo) {
            return brokerNodeGroupInfo(BrokerNodeGroupInfo.builder().applyMutation(brokerNodeGroupInfo).build());
        }

        /**
         *
         * <p>
         * Includes all client authentication information.
         * </p>
         * 
         * @param clientAuthentication
         *        <p>
         *        Includes all client authentication information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientAuthentication(ClientAuthentication clientAuthentication);

        /**
         *
         * <p>
         * Includes all client authentication information.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link ClientAuthentication.Builder} avoiding
         * the need to create one manually via {@link ClientAuthentication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientAuthentication.Builder#build()} is called immediately and
         * its result is passed to {@link #clientAuthentication(ClientAuthentication)}.
         * 
         * @param clientAuthentication
         *        a consumer that will call methods on {@link ClientAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientAuthentication(ClientAuthentication)
         */
        default Builder clientAuthentication(Consumer<ClientAuthentication.Builder> clientAuthentication) {
            return clientAuthentication(ClientAuthentication.builder().applyMutation(clientAuthentication).build());
        }

        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         * </p>
         * 
         * @param clusterArn
         *        <p>
         *        The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         *
         * <p>
         * The name of the cluster.
         * </p>
         * 
         * @param clusterName
         *        <p>
         *        The name of the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         *
         * <p>
         * The time when the cluster was created.
         * </p>
         * 
         * @param creationTime
         *        <p>
         *        The time when the cluster was created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         *
         * <p>
         * Information about the version of software currently deployed on the Apache Kafka brokers in the cluster.
         * </p>
         * 
         * @param currentBrokerSoftwareInfo
         *        <p>
         *        Information about the version of software currently deployed on the Apache Kafka brokers in the
         *        cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo currentBrokerSoftwareInfo);

        /**
         *
         * <p>
         * Information about the version of software currently deployed on the Apache Kafka brokers in the cluster.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link BrokerSoftwareInfo.Builder} avoiding the
         * need to create one manually via {@link BrokerSoftwareInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BrokerSoftwareInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #currentBrokerSoftwareInfo(BrokerSoftwareInfo)}.
         * 
         * @param currentBrokerSoftwareInfo
         *        a consumer that will call methods on {@link BrokerSoftwareInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentBrokerSoftwareInfo(BrokerSoftwareInfo)
         */
        default Builder currentBrokerSoftwareInfo(Consumer<BrokerSoftwareInfo.Builder> currentBrokerSoftwareInfo) {
            return currentBrokerSoftwareInfo(BrokerSoftwareInfo.builder().applyMutation(currentBrokerSoftwareInfo).build());
        }

        /**
         *
         * <p>
         * The current version of the MSK cluster.
         * </p>
         * 
         * @param currentVersion
         *        <p>
         *        The current version of the MSK cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         *
         * <p>
         * Includes all encryption-related information.
         * </p>
         * 
         * @param encryptionInfo
         *        <p>
         *        Includes all encryption-related information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionInfo(EncryptionInfo encryptionInfo);

        /**
         *
         * <p>
         * Includes all encryption-related information.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link EncryptionInfo.Builder} avoiding the need
         * to create one manually via {@link EncryptionInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionInfo(EncryptionInfo)}.
         * 
         * @param encryptionInfo
         *        a consumer that will call methods on {@link EncryptionInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionInfo(EncryptionInfo)
         */
        default Builder encryptionInfo(Consumer<EncryptionInfo.Builder> encryptionInfo) {
            return encryptionInfo(EncryptionInfo.builder().applyMutation(encryptionInfo).build());
        }

        /**
         *
         * <p>
         * Specifies which metrics are gathered for the MSK cluster. This property has the following possible values:
         * DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION. For a list of the metrics associated
         * with each of these levels of monitoring, see <a
         * href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.
         * </p>
         * 
         * @param enhancedMonitoring
         *        <p>
         *        Specifies which metrics are gathered for the MSK cluster. This property has the following possible
         *        values: DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION. For a list of the
         *        metrics associated with each of these levels of monitoring, see <a
         *        href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.
         *        </p>
         * @see EnhancedMonitoring
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedMonitoring
         */
        Builder enhancedMonitoring(String enhancedMonitoring);

        /**
         *
         * <p>
         * Specifies which metrics are gathered for the MSK cluster. This property has the following possible values:
         * DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION. For a list of the metrics associated
         * with each of these levels of monitoring, see <a
         * href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.
         * </p>
         * 
         * @param enhancedMonitoring
         *        <p>
         *        Specifies which metrics are gathered for the MSK cluster. This property has the following possible
         *        values: DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION. For a list of the
         *        metrics associated with each of these levels of monitoring, see <a
         *        href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring</a>.
         *        </p>
         * @see EnhancedMonitoring
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedMonitoring
         */
        Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring);

        /**
         *
         * <p>
         * Settings for open monitoring using Prometheus.
         * </p>
         * 
         * @param openMonitoring
         *        <p>
         *        Settings for open monitoring using Prometheus.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openMonitoring(OpenMonitoring openMonitoring);

        /**
         *
         * <p>
         * Settings for open monitoring using Prometheus.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link OpenMonitoring.Builder} avoiding the need
         * to create one manually via {@link OpenMonitoring#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenMonitoring.Builder#build()} is called immediately and its
         * result is passed to {@link #openMonitoring(OpenMonitoring)}.
         * 
         * @param openMonitoring
         *        a consumer that will call methods on {@link OpenMonitoring.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openMonitoring(OpenMonitoring)
         */
        default Builder openMonitoring(Consumer<OpenMonitoring.Builder> openMonitoring) {
            return openMonitoring(OpenMonitoring.builder().applyMutation(openMonitoring).build());
        }

        /**
         * Sets the value of the LoggingInfo property for this object.
         *
         * @param loggingInfo
         *        The new value for the LoggingInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingInfo(LoggingInfo loggingInfo);

        /**
         * Sets the value of the LoggingInfo property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LoggingInfo.Builder} avoiding the need to
         * create one manually via {@link LoggingInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #loggingInfo(LoggingInfo)}.
         * 
         * @param loggingInfo
         *        a consumer that will call methods on {@link LoggingInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingInfo(LoggingInfo)
         */
        default Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return loggingInfo(LoggingInfo.builder().applyMutation(loggingInfo).build());
        }

        /**
         *
         * <p>
         * The number of broker nodes in the cluster.
         * </p>
         * 
         * @param numberOfBrokerNodes
         *        <p>
         *        The number of broker nodes in the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfBrokerNodes(Integer numberOfBrokerNodes);

        /**
         *
         * <p>
         * The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE,
         * REBOOTING_BROKER, and UPDATING.
         * </p>
         * 
         * @param state
         *        <p>
         *        The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING,
         *        MAINTENANCE, REBOOTING_BROKER, and UPDATING.
         *        </p>
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder state(String state);

        /**
         *
         * <p>
         * The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE,
         * REBOOTING_BROKER, and UPDATING.
         * </p>
         * 
         * @param state
         *        <p>
         *        The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING,
         *        MAINTENANCE, REBOOTING_BROKER, and UPDATING.
         *        </p>
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder state(ClusterState state);

        /**
         * Sets the value of the StateInfo property for this object.
         *
         * @param stateInfo
         *        The new value for the StateInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateInfo(StateInfo stateInfo);

        /**
         * Sets the value of the StateInfo property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StateInfo.Builder} avoiding the need to
         * create one manually via {@link StateInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StateInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #stateInfo(StateInfo)}.
         * 
         * @param stateInfo
         *        a consumer that will call methods on {@link StateInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateInfo(StateInfo)
         */
        default Builder stateInfo(Consumer<StateInfo.Builder> stateInfo) {
            return stateInfo(StateInfo.builder().applyMutation(stateInfo).build());
        }

        /**
         *
         * <p>
         * Tags attached to the cluster.
         * </p>
         * 
         * @param tags
         *        <p>
         *        Tags attached to the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         *
         * <p>
         * The connection string to use to connect to the Apache ZooKeeper cluster.
         * </p>
         * 
         * @param zookeeperConnectString
         *        <p>
         *        The connection string to use to connect to the Apache ZooKeeper cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zookeeperConnectString(String zookeeperConnectString);

        /**
         *
         * <p>
         * The connection string to use to connect to zookeeper cluster on Tls port.
         * </p>
         * 
         * @param zookeeperConnectStringTls
         *        <p>
         *        The connection string to use to connect to zookeeper cluster on Tls port.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zookeeperConnectStringTls(String zookeeperConnectStringTls);
    }

    static final class BuilderImpl implements Builder {
        private String activeOperationArn;

        private BrokerNodeGroupInfo brokerNodeGroupInfo;

        private ClientAuthentication clientAuthentication;

        private String clusterArn;

        private String clusterName;

        private Instant creationTime;

        private BrokerSoftwareInfo currentBrokerSoftwareInfo;

        private String currentVersion;

        private EncryptionInfo encryptionInfo;

        private String enhancedMonitoring;

        private OpenMonitoring openMonitoring;

        private LoggingInfo loggingInfo;

        private Integer numberOfBrokerNodes;

        private String state;

        private StateInfo stateInfo;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String zookeeperConnectString;

        private String zookeeperConnectStringTls;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterInfo model) {
            activeOperationArn(model.activeOperationArn);
            brokerNodeGroupInfo(model.brokerNodeGroupInfo);
            clientAuthentication(model.clientAuthentication);
            clusterArn(model.clusterArn);
            clusterName(model.clusterName);
            creationTime(model.creationTime);
            currentBrokerSoftwareInfo(model.currentBrokerSoftwareInfo);
            currentVersion(model.currentVersion);
            encryptionInfo(model.encryptionInfo);
            enhancedMonitoring(model.enhancedMonitoring);
            openMonitoring(model.openMonitoring);
            loggingInfo(model.loggingInfo);
            numberOfBrokerNodes(model.numberOfBrokerNodes);
            state(model.state);
            stateInfo(model.stateInfo);
            tags(model.tags);
            zookeeperConnectString(model.zookeeperConnectString);
            zookeeperConnectStringTls(model.zookeeperConnectStringTls);
        }

        public final String getActiveOperationArn() {
            return activeOperationArn;
        }

        public final void setActiveOperationArn(String activeOperationArn) {
            this.activeOperationArn = activeOperationArn;
        }

        @Override
        public final Builder activeOperationArn(String activeOperationArn) {
            this.activeOperationArn = activeOperationArn;
            return this;
        }

        public final BrokerNodeGroupInfo.Builder getBrokerNodeGroupInfo() {
            return brokerNodeGroupInfo != null ? brokerNodeGroupInfo.toBuilder() : null;
        }

        public final void setBrokerNodeGroupInfo(BrokerNodeGroupInfo.BuilderImpl brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo != null ? brokerNodeGroupInfo.build() : null;
        }

        @Override
        public final Builder brokerNodeGroupInfo(BrokerNodeGroupInfo brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo;
            return this;
        }

        public final ClientAuthentication.Builder getClientAuthentication() {
            return clientAuthentication != null ? clientAuthentication.toBuilder() : null;
        }

        public final void setClientAuthentication(ClientAuthentication.BuilderImpl clientAuthentication) {
            this.clientAuthentication = clientAuthentication != null ? clientAuthentication.build() : null;
        }

        @Override
        public final Builder clientAuthentication(ClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final BrokerSoftwareInfo.Builder getCurrentBrokerSoftwareInfo() {
            return currentBrokerSoftwareInfo != null ? currentBrokerSoftwareInfo.toBuilder() : null;
        }

        public final void setCurrentBrokerSoftwareInfo(BrokerSoftwareInfo.BuilderImpl currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo != null ? currentBrokerSoftwareInfo.build() : null;
        }

        @Override
        public final Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo;
            return this;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final EncryptionInfo.Builder getEncryptionInfo() {
            return encryptionInfo != null ? encryptionInfo.toBuilder() : null;
        }

        public final void setEncryptionInfo(EncryptionInfo.BuilderImpl encryptionInfo) {
            this.encryptionInfo = encryptionInfo != null ? encryptionInfo.build() : null;
        }

        @Override
        public final Builder encryptionInfo(EncryptionInfo encryptionInfo) {
            this.encryptionInfo = encryptionInfo;
            return this;
        }

        public final String getEnhancedMonitoring() {
            return enhancedMonitoring;
        }

        public final void setEnhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
        }

        @Override
        public final Builder enhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        @Override
        public final Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring) {
            this.enhancedMonitoring(enhancedMonitoring == null ? null : enhancedMonitoring.toString());
            return this;
        }

        public final OpenMonitoring.Builder getOpenMonitoring() {
            return openMonitoring != null ? openMonitoring.toBuilder() : null;
        }

        public final void setOpenMonitoring(OpenMonitoring.BuilderImpl openMonitoring) {
            this.openMonitoring = openMonitoring != null ? openMonitoring.build() : null;
        }

        @Override
        public final Builder openMonitoring(OpenMonitoring openMonitoring) {
            this.openMonitoring = openMonitoring;
            return this;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return loggingInfo != null ? loggingInfo.toBuilder() : null;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final Integer getNumberOfBrokerNodes() {
            return numberOfBrokerNodes;
        }

        public final void setNumberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
        }

        @Override
        public final Builder numberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ClusterState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final StateInfo.Builder getStateInfo() {
            return stateInfo != null ? stateInfo.toBuilder() : null;
        }

        public final void setStateInfo(StateInfo.BuilderImpl stateInfo) {
            this.stateInfo = stateInfo != null ? stateInfo.build() : null;
        }

        @Override
        public final Builder stateInfo(StateInfo stateInfo) {
            this.stateInfo = stateInfo;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getZookeeperConnectString() {
            return zookeeperConnectString;
        }

        public final void setZookeeperConnectString(String zookeeperConnectString) {
            this.zookeeperConnectString = zookeeperConnectString;
        }

        @Override
        public final Builder zookeeperConnectString(String zookeeperConnectString) {
            this.zookeeperConnectString = zookeeperConnectString;
            return this;
        }

        public final String getZookeeperConnectStringTls() {
            return zookeeperConnectStringTls;
        }

        public final void setZookeeperConnectStringTls(String zookeeperConnectStringTls) {
            this.zookeeperConnectStringTls = zookeeperConnectStringTls;
        }

        @Override
        public final Builder zookeeperConnectStringTls(String zookeeperConnectStringTls) {
            this.zookeeperConnectStringTls = zookeeperConnectStringTls;
            return this;
        }

        @Override
        public ClusterInfo build() {
            return new ClusterInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
