/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Step taken during a cluster operation.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterOperationStep implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterOperationStep.Builder, ClusterOperationStep> {
    private static final SdkField<ClusterOperationStepInfo> STEP_INFO_FIELD = SdkField
            .<ClusterOperationStepInfo> builder(MarshallingType.SDK_POJO).memberName("StepInfo")
            .getter(getter(ClusterOperationStep::stepInfo)).setter(setter(Builder::stepInfo))
            .constructor(ClusterOperationStepInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepInfo").build()).build();

    private static final SdkField<String> STEP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StepName").getter(getter(ClusterOperationStep::stepName)).setter(setter(Builder::stepName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_INFO_FIELD,
            STEP_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final ClusterOperationStepInfo stepInfo;

    private final String stepName;

    private ClusterOperationStep(BuilderImpl builder) {
        this.stepInfo = builder.stepInfo;
        this.stepName = builder.stepName;
    }

    /**
     *
     * <p>
     * Information about the step and its status.
     * </p>
     * 
     * @return <p>
     *         Information about the step and its status.
     *         </p>
     */
    public final ClusterOperationStepInfo stepInfo() {
        return stepInfo;
    }

    /**
     *
     * <p>
     * The name of the step.
     * </p>
     * 
     * @return <p>
     *         The name of the step.
     *         </p>
     */
    public final String stepName() {
        return stepName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepInfo());
        hashCode = 31 * hashCode + Objects.hashCode(stepName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterOperationStep)) {
            return false;
        }
        ClusterOperationStep other = (ClusterOperationStep) obj;
        return Objects.equals(stepInfo(), other.stepInfo()) && Objects.equals(stepName(), other.stepName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterOperationStep").add("StepInfo", stepInfo()).add("StepName", stepName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StepInfo":
            return Optional.ofNullable(clazz.cast(stepInfo()));
        case "StepName":
            return Optional.ofNullable(clazz.cast(stepName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterOperationStep, T> g) {
        return obj -> g.apply((ClusterOperationStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterOperationStep> {
        /**
         *
         * <p>
         * Information about the step and its status.
         * </p>
         * 
         * @param stepInfo
         *        <p>
         *        Information about the step and its status.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepInfo(ClusterOperationStepInfo stepInfo);

        /**
         *
         * <p>
         * Information about the step and its status.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link ClusterOperationStepInfo.Builder} avoiding the
         * need to create one manually via {@link ClusterOperationStepInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClusterOperationStepInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #stepInfo(ClusterOperationStepInfo)}.
         * 
         * @param stepInfo
         *        a consumer that will call methods on {@link ClusterOperationStepInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepInfo(ClusterOperationStepInfo)
         */
        default Builder stepInfo(Consumer<ClusterOperationStepInfo.Builder> stepInfo) {
            return stepInfo(ClusterOperationStepInfo.builder().applyMutation(stepInfo).build());
        }

        /**
         *
         * <p>
         * The name of the step.
         * </p>
         * 
         * @param stepName
         *        <p>
         *        The name of the step.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepName(String stepName);
    }

    static final class BuilderImpl implements Builder {
        private ClusterOperationStepInfo stepInfo;

        private String stepName;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterOperationStep model) {
            stepInfo(model.stepInfo);
            stepName(model.stepName);
        }

        public final ClusterOperationStepInfo.Builder getStepInfo() {
            return stepInfo != null ? stepInfo.toBuilder() : null;
        }

        public final void setStepInfo(ClusterOperationStepInfo.BuilderImpl stepInfo) {
            this.stepInfo = stepInfo != null ? stepInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder stepInfo(ClusterOperationStepInfo stepInfo) {
            this.stepInfo = stepInfo;
            return this;
        }

        public final String getStepName() {
            return stepName;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        @Override
        @Transient
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        @Override
        public ClusterOperationStep build() {
            return new ClusterOperationStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
