/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingInfo implements SdkPojo, Serializable, ToCopyableBuilder<LoggingInfo.Builder, LoggingInfo> {
    private static final SdkField<BrokerLogs> BROKER_LOGS_FIELD = SdkField.<BrokerLogs> builder(MarshallingType.SDK_POJO)
            .memberName("BrokerLogs").getter(getter(LoggingInfo::brokerLogs)).setter(setter(Builder::brokerLogs))
            .constructor(BrokerLogs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerLogs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_LOGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final BrokerLogs brokerLogs;

    private LoggingInfo(BuilderImpl builder) {
        this.brokerLogs = builder.brokerLogs;
    }

    /**
     * Returns the value of the BrokerLogs property for this object.
     * 
     * @return The value of the BrokerLogs property for this object.
     */
    public final BrokerLogs brokerLogs() {
        return brokerLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(brokerLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingInfo)) {
            return false;
        }
        LoggingInfo other = (LoggingInfo) obj;
        return Objects.equals(brokerLogs(), other.brokerLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoggingInfo").add("BrokerLogs", brokerLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BrokerLogs":
            return Optional.ofNullable(clazz.cast(brokerLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingInfo, T> g) {
        return obj -> g.apply((LoggingInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingInfo> {
        /**
         * Sets the value of the BrokerLogs property for this object.
         *
         * @param brokerLogs
         *        The new value for the BrokerLogs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerLogs(BrokerLogs brokerLogs);

        /**
         * Sets the value of the BrokerLogs property for this object.
         *
         * This is a convenience that creates an instance of the {@link BrokerLogs.Builder} avoiding the need to create
         * one manually via {@link BrokerLogs#builder()}.
         *
         * When the {@link Consumer} completes, {@link BrokerLogs.Builder#build()} is called immediately and its result
         * is passed to {@link #brokerLogs(BrokerLogs)}.
         * 
         * @param brokerLogs
         *        a consumer that will call methods on {@link BrokerLogs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brokerLogs(BrokerLogs)
         */
        default Builder brokerLogs(Consumer<BrokerLogs.Builder> brokerLogs) {
            return brokerLogs(BrokerLogs.builder().applyMutation(brokerLogs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BrokerLogs brokerLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingInfo model) {
            brokerLogs(model.brokerLogs);
        }

        public final BrokerLogs.Builder getBrokerLogs() {
            return brokerLogs != null ? brokerLogs.toBuilder() : null;
        }

        public final void setBrokerLogs(BrokerLogs.BuilderImpl brokerLogs) {
            this.brokerLogs = brokerLogs != null ? brokerLogs.build() : null;
        }

        @Override
        @Transient
        public final Builder brokerLogs(BrokerLogs brokerLogs) {
            this.brokerLogs = brokerLogs;
            return this;
        }

        @Override
        public LoggingInfo build() {
            return new LoggingInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
