/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Returns information about an error.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnauthorizedException extends KafkaException implements
        ToCopyableBuilder<UnauthorizedException.Builder, UnauthorizedException> {
    private static final SdkField<String> INVALID_PARAMETER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvalidParameter").getter(getter(UnauthorizedException::invalidParameter))
            .setter(setter(Builder::invalidParameter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invalidParameter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALID_PARAMETER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String invalidParameter;

    private UnauthorizedException(BuilderImpl builder) {
        super(builder);
        this.invalidParameter = builder.invalidParameter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     *
     * <p>
     * The parameter that caused the error.
     * </p>
     * 
     * @return <p>
     *         The parameter that caused the error.
     *         </p>
     */
    public String invalidParameter() {
        return invalidParameter;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnauthorizedException, T> g) {
        return obj -> g.apply((UnauthorizedException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnauthorizedException>, KafkaException.Builder {
        /**
         *
         * <p>
         * The parameter that caused the error.
         * </p>
         * 
         * @param invalidParameter
         *        <p>
         *        The parameter that caused the error.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidParameter(String invalidParameter);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends KafkaException.BuilderImpl implements Builder {
        private String invalidParameter;

        private BuilderImpl() {
        }

        private BuilderImpl(UnauthorizedException model) {
            super(model);
            invalidParameter(model.invalidParameter);
        }

        public final String getInvalidParameter() {
            return invalidParameter;
        }

        public final void setInvalidParameter(String invalidParameter) {
            this.invalidParameter = invalidParameter;
        }

        @Override
        @Transient
        public final Builder invalidParameter(String invalidParameter) {
            this.invalidParameter = invalidParameter;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public UnauthorizedException build() {
            return new UnauthorizedException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
