/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * The client VPC connection object.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientVpcConnection implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientVpcConnection.Builder, ClientVpcConnection> {
    private static final SdkField<String> AUTHENTICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Authentication").getter(getter(ClientVpcConnection::authentication))
            .setter(setter(Builder::authentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authentication").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(ClientVpcConnection::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ClientVpcConnection::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> VPC_CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcConnectionArn").getter(getter(ClientVpcConnection::vpcConnectionArn))
            .setter(setter(Builder::vpcConnectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConnectionArn").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(ClientVpcConnection::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_FIELD,
            CREATION_TIME_FIELD, STATE_FIELD, VPC_CONNECTION_ARN_FIELD, OWNER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String authentication;

    private final Instant creationTime;

    private final String state;

    private final String vpcConnectionArn;

    private final String owner;

    private ClientVpcConnection(BuilderImpl builder) {
        this.authentication = builder.authentication;
        this.creationTime = builder.creationTime;
        this.state = builder.state;
        this.vpcConnectionArn = builder.vpcConnectionArn;
        this.owner = builder.owner;
    }

    /**
     *
     * <p>
     * Information about the auth scheme of Vpc Connection.
     * </p>
     * 
     * @return <p>
     *         Information about the auth scheme of Vpc Connection.
     *         </p>
     */
    public final String authentication() {
        return authentication;
    }

    /**
     *
     * <p>
     * Creation time of the Vpc Connection.
     * </p>
     * 
     * @return <p>
     *         Creation time of the Vpc Connection.
     *         </p>
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     *
     * <p>
     * State of the Vpc Connection.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpcConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <p>
     *         State of the Vpc Connection.
     *         </p>
     * @see VpcConnectionState
     */
    public final VpcConnectionState state() {
        return VpcConnectionState.fromValue(state);
    }

    /**
     *
     * <p>
     * State of the Vpc Connection.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpcConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <p>
     *         State of the Vpc Connection.
     *         </p>
     * @see VpcConnectionState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     *
     * <p>
     * The ARN that identifies the Vpc Connection.
     * </p>
     * 
     * @return <p>
     *         The ARN that identifies the Vpc Connection.
     *         </p>
     */
    public final String vpcConnectionArn() {
        return vpcConnectionArn;
    }

    /**
     *
     * <p>
     * The Owner of the Vpc Connection.
     * </p>
     * 
     * @return <p>
     *         The Owner of the Vpc Connection.
     *         </p>
     */
    public final String owner() {
        return owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authentication());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientVpcConnection)) {
            return false;
        }
        ClientVpcConnection other = (ClientVpcConnection) obj;
        return Objects.equals(authentication(), other.authentication()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(vpcConnectionArn(), other.vpcConnectionArn()) && Objects.equals(owner(), other.owner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientVpcConnection").add("Authentication", authentication())
                .add("CreationTime", creationTime()).add("State", stateAsString()).add("VpcConnectionArn", vpcConnectionArn())
                .add("Owner", owner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Authentication":
            return Optional.ofNullable(clazz.cast(authentication()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "VpcConnectionArn":
            return Optional.ofNullable(clazz.cast(vpcConnectionArn()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientVpcConnection, T> g) {
        return obj -> g.apply((ClientVpcConnection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientVpcConnection> {
        /**
         *
         * <p>
         * Information about the auth scheme of Vpc Connection.
         * </p>
         * 
         * @param authentication
         *        <p>
         *        Information about the auth scheme of Vpc Connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authentication(String authentication);

        /**
         *
         * <p>
         * Creation time of the Vpc Connection.
         * </p>
         * 
         * @param creationTime
         *        <p>
         *        Creation time of the Vpc Connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         *
         * <p>
         * State of the Vpc Connection.
         * </p>
         * 
         * @param state
         *        <p>
         *        State of the Vpc Connection.
         *        </p>
         * @see VpcConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcConnectionState
         */
        Builder state(String state);

        /**
         *
         * <p>
         * State of the Vpc Connection.
         * </p>
         * 
         * @param state
         *        <p>
         *        State of the Vpc Connection.
         *        </p>
         * @see VpcConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcConnectionState
         */
        Builder state(VpcConnectionState state);

        /**
         *
         * <p>
         * The ARN that identifies the Vpc Connection.
         * </p>
         * 
         * @param vpcConnectionArn
         *        <p>
         *        The ARN that identifies the Vpc Connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnectionArn(String vpcConnectionArn);

        /**
         *
         * <p>
         * The Owner of the Vpc Connection.
         * </p>
         * 
         * @param owner
         *        <p>
         *        The Owner of the Vpc Connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);
    }

    static final class BuilderImpl implements Builder {
        private String authentication;

        private Instant creationTime;

        private String state;

        private String vpcConnectionArn;

        private String owner;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientVpcConnection model) {
            authentication(model.authentication);
            creationTime(model.creationTime);
            state(model.state);
            vpcConnectionArn(model.vpcConnectionArn);
            owner(model.owner);
        }

        public final String getAuthentication() {
            return authentication;
        }

        public final void setAuthentication(String authentication) {
            this.authentication = authentication;
        }

        @Override
        public final Builder authentication(String authentication) {
            this.authentication = authentication;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcConnectionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getVpcConnectionArn() {
            return vpcConnectionArn;
        }

        public final void setVpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
        }

        @Override
        public final Builder vpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public ClientVpcConnection build() {
            return new ClientVpcConnection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
