/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfigurationRequest extends KafkaRequest implements
        ToCopyableBuilder<UpdateConfigurationRequest.Builder, UpdateConfigurationRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateConfigurationRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateConfigurationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<SdkBytes> SERVER_PROPERTIES_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("ServerProperties").getter(getter(UpdateConfigurationRequest::serverProperties))
            .setter(setter(Builder::serverProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD,
            SERVER_PROPERTIES_FIELD));

    private final String arn;

    private final String description;

    private final SdkBytes serverProperties;

    private UpdateConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.description = builder.description;
        this.serverProperties = builder.serverProperties;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) of the configuration.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the configuration.
     *         </p>
     */
    public final String arn() {
        return arn;
    }

    /**
     *
     * <p>
     * The description of the configuration revision.
     * </p>
     * 
     * @return <p>
     *         The description of the configuration revision.
     *         </p>
     */
    public final String description() {
        return description;
    }

    /**
     *
     * <p>
     * Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that the
     * contents of the file are base64 encoded. When using the AWS Management Console, the SDK, or the AWS CLI, the
     * contents of <filename>server.properties</filename> can be in plaintext.
     * </p>
     * 
     * @return <p>
     *         Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that the
     *         contents of the file are base64 encoded. When using the AWS Management Console, the SDK, or the AWS CLI,
     *         the contents of <filename>server.properties</filename> can be in plaintext.
     *         </p>
     */
    public final SdkBytes serverProperties() {
        return serverProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(serverProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationRequest)) {
            return false;
        }
        UpdateConfigurationRequest other = (UpdateConfigurationRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(description(), other.description())
                && Objects.equals(serverProperties(), other.serverProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConfigurationRequest").add("Arn", arn()).add("Description", description())
                .add("ServerProperties", serverProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ServerProperties":
            return Optional.ofNullable(clazz.cast(serverProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConfigurationRequest> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) of the configuration.
         * </p>
         * 
         * @param arn
         *        <p>
         *        The Amazon Resource Name (ARN) of the configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         *
         * <p>
         * The description of the configuration revision.
         * </p>
         * 
         * @param description
         *        <p>
         *        The description of the configuration revision.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         *
         * <p>
         * Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that the
         * contents of the file are base64 encoded. When using the AWS Management Console, the SDK, or the AWS CLI, the
         * contents of <filename>server.properties</filename> can be in plaintext.
         * </p>
         * 
         * @param serverProperties
         *        <p>
         *        Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that
         *        the contents of the file are base64 encoded. When using the AWS Management Console, the SDK, or the
         *        AWS CLI, the contents of <filename>server.properties</filename> can be in plaintext.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverProperties(SdkBytes serverProperties);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private String arn;

        private String description;

        private SdkBytes serverProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationRequest model) {
            super(model);
            arn(model.arn);
            description(model.description);
            serverProperties(model.serverProperties);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ByteBuffer getServerProperties() {
            return serverProperties == null ? null : serverProperties.asByteBuffer();
        }

        public final void setServerProperties(ByteBuffer serverProperties) {
            serverProperties(serverProperties == null ? null : SdkBytes.fromByteBuffer(serverProperties));
        }

        @Override
        public final Builder serverProperties(SdkBytes serverProperties) {
            this.serverProperties = serverProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigurationRequest build() {
            return new UpdateConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
