/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.kafka.model.BatchAssociateScramSecretRequest;
import software.amazon.awssdk.services.kafka.model.BatchAssociateScramSecretResponse;
import software.amazon.awssdk.services.kafka.model.BatchDisassociateScramSecretRequest;
import software.amazon.awssdk.services.kafka.model.BatchDisassociateScramSecretResponse;
import software.amazon.awssdk.services.kafka.model.CreateClusterRequest;
import software.amazon.awssdk.services.kafka.model.CreateClusterResponse;
import software.amazon.awssdk.services.kafka.model.CreateClusterV2Request;
import software.amazon.awssdk.services.kafka.model.CreateClusterV2Response;
import software.amazon.awssdk.services.kafka.model.CreateConfigurationRequest;
import software.amazon.awssdk.services.kafka.model.CreateConfigurationResponse;
import software.amazon.awssdk.services.kafka.model.CreateReplicatorRequest;
import software.amazon.awssdk.services.kafka.model.CreateReplicatorResponse;
import software.amazon.awssdk.services.kafka.model.CreateVpcConnectionRequest;
import software.amazon.awssdk.services.kafka.model.CreateVpcConnectionResponse;
import software.amazon.awssdk.services.kafka.model.DeleteClusterPolicyRequest;
import software.amazon.awssdk.services.kafka.model.DeleteClusterPolicyResponse;
import software.amazon.awssdk.services.kafka.model.DeleteClusterRequest;
import software.amazon.awssdk.services.kafka.model.DeleteClusterResponse;
import software.amazon.awssdk.services.kafka.model.DeleteConfigurationRequest;
import software.amazon.awssdk.services.kafka.model.DeleteConfigurationResponse;
import software.amazon.awssdk.services.kafka.model.DeleteReplicatorRequest;
import software.amazon.awssdk.services.kafka.model.DeleteReplicatorResponse;
import software.amazon.awssdk.services.kafka.model.DeleteVpcConnectionRequest;
import software.amazon.awssdk.services.kafka.model.DeleteVpcConnectionResponse;
import software.amazon.awssdk.services.kafka.model.DescribeClusterOperationRequest;
import software.amazon.awssdk.services.kafka.model.DescribeClusterOperationResponse;
import software.amazon.awssdk.services.kafka.model.DescribeClusterOperationV2Request;
import software.amazon.awssdk.services.kafka.model.DescribeClusterOperationV2Response;
import software.amazon.awssdk.services.kafka.model.DescribeClusterRequest;
import software.amazon.awssdk.services.kafka.model.DescribeClusterResponse;
import software.amazon.awssdk.services.kafka.model.DescribeClusterV2Request;
import software.amazon.awssdk.services.kafka.model.DescribeClusterV2Response;
import software.amazon.awssdk.services.kafka.model.DescribeConfigurationRequest;
import software.amazon.awssdk.services.kafka.model.DescribeConfigurationResponse;
import software.amazon.awssdk.services.kafka.model.DescribeConfigurationRevisionRequest;
import software.amazon.awssdk.services.kafka.model.DescribeConfigurationRevisionResponse;
import software.amazon.awssdk.services.kafka.model.DescribeReplicatorRequest;
import software.amazon.awssdk.services.kafka.model.DescribeReplicatorResponse;
import software.amazon.awssdk.services.kafka.model.DescribeVpcConnectionRequest;
import software.amazon.awssdk.services.kafka.model.DescribeVpcConnectionResponse;
import software.amazon.awssdk.services.kafka.model.GetBootstrapBrokersRequest;
import software.amazon.awssdk.services.kafka.model.GetBootstrapBrokersResponse;
import software.amazon.awssdk.services.kafka.model.GetClusterPolicyRequest;
import software.amazon.awssdk.services.kafka.model.GetClusterPolicyResponse;
import software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsRequest;
import software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsResponse;
import software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsRequest;
import software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsResponse;
import software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest;
import software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse;
import software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Request;
import software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Response;
import software.amazon.awssdk.services.kafka.model.ListClustersRequest;
import software.amazon.awssdk.services.kafka.model.ListClustersResponse;
import software.amazon.awssdk.services.kafka.model.ListClustersV2Request;
import software.amazon.awssdk.services.kafka.model.ListClustersV2Response;
import software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest;
import software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse;
import software.amazon.awssdk.services.kafka.model.ListConfigurationsRequest;
import software.amazon.awssdk.services.kafka.model.ListConfigurationsResponse;
import software.amazon.awssdk.services.kafka.model.ListKafkaVersionsRequest;
import software.amazon.awssdk.services.kafka.model.ListKafkaVersionsResponse;
import software.amazon.awssdk.services.kafka.model.ListNodesRequest;
import software.amazon.awssdk.services.kafka.model.ListNodesResponse;
import software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest;
import software.amazon.awssdk.services.kafka.model.ListReplicatorsResponse;
import software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest;
import software.amazon.awssdk.services.kafka.model.ListScramSecretsResponse;
import software.amazon.awssdk.services.kafka.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.kafka.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.kafka.model.ListVpcConnectionsRequest;
import software.amazon.awssdk.services.kafka.model.ListVpcConnectionsResponse;
import software.amazon.awssdk.services.kafka.model.PutClusterPolicyRequest;
import software.amazon.awssdk.services.kafka.model.PutClusterPolicyResponse;
import software.amazon.awssdk.services.kafka.model.RebootBrokerRequest;
import software.amazon.awssdk.services.kafka.model.RebootBrokerResponse;
import software.amazon.awssdk.services.kafka.model.RejectClientVpcConnectionRequest;
import software.amazon.awssdk.services.kafka.model.RejectClientVpcConnectionResponse;
import software.amazon.awssdk.services.kafka.model.TagResourceRequest;
import software.amazon.awssdk.services.kafka.model.TagResourceResponse;
import software.amazon.awssdk.services.kafka.model.UntagResourceRequest;
import software.amazon.awssdk.services.kafka.model.UntagResourceResponse;
import software.amazon.awssdk.services.kafka.model.UpdateBrokerCountRequest;
import software.amazon.awssdk.services.kafka.model.UpdateBrokerCountResponse;
import software.amazon.awssdk.services.kafka.model.UpdateBrokerStorageRequest;
import software.amazon.awssdk.services.kafka.model.UpdateBrokerStorageResponse;
import software.amazon.awssdk.services.kafka.model.UpdateBrokerTypeRequest;
import software.amazon.awssdk.services.kafka.model.UpdateBrokerTypeResponse;
import software.amazon.awssdk.services.kafka.model.UpdateClusterConfigurationRequest;
import software.amazon.awssdk.services.kafka.model.UpdateClusterConfigurationResponse;
import software.amazon.awssdk.services.kafka.model.UpdateClusterKafkaVersionRequest;
import software.amazon.awssdk.services.kafka.model.UpdateClusterKafkaVersionResponse;
import software.amazon.awssdk.services.kafka.model.UpdateConfigurationRequest;
import software.amazon.awssdk.services.kafka.model.UpdateConfigurationResponse;
import software.amazon.awssdk.services.kafka.model.UpdateConnectivityRequest;
import software.amazon.awssdk.services.kafka.model.UpdateConnectivityResponse;
import software.amazon.awssdk.services.kafka.model.UpdateMonitoringRequest;
import software.amazon.awssdk.services.kafka.model.UpdateMonitoringResponse;
import software.amazon.awssdk.services.kafka.model.UpdateReplicationInfoRequest;
import software.amazon.awssdk.services.kafka.model.UpdateReplicationInfoResponse;
import software.amazon.awssdk.services.kafka.model.UpdateSecurityRequest;
import software.amazon.awssdk.services.kafka.model.UpdateSecurityResponse;
import software.amazon.awssdk.services.kafka.model.UpdateStorageRequest;
import software.amazon.awssdk.services.kafka.model.UpdateStorageResponse;
import software.amazon.awssdk.services.kafka.paginators.ListClientVpcConnectionsPublisher;
import software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsPublisher;
import software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsV2Publisher;
import software.amazon.awssdk.services.kafka.paginators.ListClustersPublisher;
import software.amazon.awssdk.services.kafka.paginators.ListClustersV2Publisher;
import software.amazon.awssdk.services.kafka.paginators.ListConfigurationRevisionsPublisher;
import software.amazon.awssdk.services.kafka.paginators.ListConfigurationsPublisher;
import software.amazon.awssdk.services.kafka.paginators.ListKafkaVersionsPublisher;
import software.amazon.awssdk.services.kafka.paginators.ListNodesPublisher;
import software.amazon.awssdk.services.kafka.paginators.ListReplicatorsPublisher;
import software.amazon.awssdk.services.kafka.paginators.ListScramSecretsPublisher;
import software.amazon.awssdk.services.kafka.paginators.ListVpcConnectionsPublisher;

/**
 * Service client for accessing Kafka asynchronously. This can be created using the static {@link #builder()} method.The
 * asynchronous client performs non-blocking I/O when configured with any {@link SdkAsyncHttpClient} supported in the
 * SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in some cases such
 * as credentials retrieval and endpoint discovery as part of the async API call.
 *
 *
 * <p>
 * The operations for managing an Amazon MSK cluster.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface KafkaAsyncClient extends AwsClient {
    String SERVICE_NAME = "kafka";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "kafka";

    /**
     *
     * <p>
     * Associates one or more Scram Secrets with an Amazon MSK cluster.
     * </p>
     * 
     *
     * @param batchAssociateScramSecretRequest
     *        <p>
     *        Associates sasl scram secrets to cluster.
     *        </p>
     * @return A Java Future containing the result of the BatchAssociateScramSecret operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.BatchAssociateScramSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/BatchAssociateScramSecret"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAssociateScramSecretResponse> batchAssociateScramSecret(
            BatchAssociateScramSecretRequest batchAssociateScramSecretRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Associates one or more Scram Secrets with an Amazon MSK cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchAssociateScramSecretRequest.Builder} avoiding
     * the need to create one manually via {@link BatchAssociateScramSecretRequest#builder()}
     * </p>
     *
     * @param batchAssociateScramSecretRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.BatchAssociateScramSecretRequest.Builder} to create a
     *        request.
     *        <p>
     *        Associates sasl scram secrets to cluster.
     *        </p>
     * @return A Java Future containing the result of the BatchAssociateScramSecret operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.BatchAssociateScramSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/BatchAssociateScramSecret"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAssociateScramSecretResponse> batchAssociateScramSecret(
            Consumer<BatchAssociateScramSecretRequest.Builder> batchAssociateScramSecretRequest) {
        return batchAssociateScramSecret(BatchAssociateScramSecretRequest.builder()
                .applyMutation(batchAssociateScramSecretRequest).build());
    }

    /**
     *
     * <p>
     * Disassociates one or more Scram Secrets from an Amazon MSK cluster.
     * </p>
     * 
     *
     * @param batchDisassociateScramSecretRequest
     *        <p>
     *        Disassociates sasl scram secrets to cluster.
     *        </p>
     * @return A Java Future containing the result of the BatchDisassociateScramSecret operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.BatchDisassociateScramSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/BatchDisassociateScramSecret"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisassociateScramSecretResponse> batchDisassociateScramSecret(
            BatchDisassociateScramSecretRequest batchDisassociateScramSecretRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Disassociates one or more Scram Secrets from an Amazon MSK cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDisassociateScramSecretRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDisassociateScramSecretRequest#builder()}
     * </p>
     *
     * @param batchDisassociateScramSecretRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.BatchDisassociateScramSecretRequest.Builder} to create
     *        a request.
     *        <p>
     *        Disassociates sasl scram secrets to cluster.
     *        </p>
     * @return A Java Future containing the result of the BatchDisassociateScramSecret operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.BatchDisassociateScramSecret
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/BatchDisassociateScramSecret"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisassociateScramSecretResponse> batchDisassociateScramSecret(
            Consumer<BatchDisassociateScramSecretRequest.Builder> batchDisassociateScramSecretRequest) {
        return batchDisassociateScramSecret(BatchDisassociateScramSecretRequest.builder()
                .applyMutation(batchDisassociateScramSecretRequest).build());
    }

    /**
     *
     * <p>
     * Creates a new MSK cluster.
     * </p>
     * 
     *
     * @param createClusterRequest
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>ConflictException
     *         <p>
     *         This cluster name already exists. Retry your request using another name.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Creates a new MSK cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateClusterRequest#builder()}
     * </p>
     *
     * @param createClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.CreateClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>ConflictException
     *         <p>
     *         This cluster name already exists. Retry your request using another name.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClusterResponse> createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest) {
        return createCluster(CreateClusterRequest.builder().applyMutation(createClusterRequest).build());
    }

    /**
     *
     * <p>
     * Creates a new MSK cluster.
     * </p>
     * 
     *
     * @param createClusterV2Request
     * @return A Java Future containing the result of the CreateClusterV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>ConflictException
     *         <p>
     *         This cluster name already exists. Retry your request using another name.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.CreateClusterV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateClusterV2" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClusterV2Response> createClusterV2(CreateClusterV2Request createClusterV2Request) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Creates a new MSK cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterV2Request.Builder} avoiding the need
     * to create one manually via {@link CreateClusterV2Request#builder()}
     * </p>
     *
     * @param createClusterV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.CreateClusterV2Request.Builder} to create a request.
     * @return A Java Future containing the result of the CreateClusterV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>ConflictException
     *         <p>
     *         This cluster name already exists. Retry your request using another name.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.CreateClusterV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateClusterV2" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClusterV2Response> createClusterV2(
            Consumer<CreateClusterV2Request.Builder> createClusterV2Request) {
        return createClusterV2(CreateClusterV2Request.builder().applyMutation(createClusterV2Request).build());
    }

    /**
     *
     * <p>
     * Creates a new MSK configuration.
     * </p>
     * 
     *
     * @param createConfigurationRequest
     * @return A Java Future containing the result of the CreateConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>ConflictException
     *         <p>
     *         This cluster name already exists. Retry your request using another name.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.CreateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateConfigurationResponse> createConfiguration(
            CreateConfigurationRequest createConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Creates a new MSK configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateConfigurationRequest#builder()}
     * </p>
     *
     * @param createConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.CreateConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>ConflictException
     *         <p>
     *         This cluster name already exists. Retry your request using another name.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.CreateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateConfigurationResponse> createConfiguration(
            Consumer<CreateConfigurationRequest.Builder> createConfigurationRequest) {
        return createConfiguration(CreateConfigurationRequest.builder().applyMutation(createConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates the replicator.
     * </p>
     *
     * @param createReplicatorRequest
     *        Creates a replicator using the specified configuration.
     * @return A Java Future containing the result of the CreateReplicator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. This replicator name already exists. Retry your
     *         request with another name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.CreateReplicator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateReplicator" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateReplicatorResponse> createReplicator(CreateReplicatorRequest createReplicatorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the replicator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplicatorRequest.Builder} avoiding the need
     * to create one manually via {@link CreateReplicatorRequest#builder()}
     * </p>
     *
     * @param createReplicatorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.CreateReplicatorRequest.Builder} to create a request.
     *        Creates a replicator using the specified configuration.
     * @return A Java Future containing the result of the CreateReplicator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>ConflictException HTTP Status Code 409: Conflict. This replicator name already exists. Retry your
     *         request with another name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.CreateReplicator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateReplicator" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateReplicatorResponse> createReplicator(
            Consumer<CreateReplicatorRequest.Builder> createReplicatorRequest) {
        return createReplicator(CreateReplicatorRequest.builder().applyMutation(createReplicatorRequest).build());
    }

    /**
     *
     * <p>
     * Creates a new MSK VPC connection.
     * </p>
     * 
     *
     * @param createVpcConnectionRequest
     * @return A Java Future containing the result of the CreateVpcConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.CreateVpcConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateVpcConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVpcConnectionResponse> createVpcConnection(
            CreateVpcConnectionRequest createVpcConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Creates a new MSK VPC connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcConnectionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVpcConnectionRequest#builder()}
     * </p>
     *
     * @param createVpcConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.CreateVpcConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVpcConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.CreateVpcConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateVpcConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVpcConnectionResponse> createVpcConnection(
            Consumer<CreateVpcConnectionRequest.Builder> createVpcConnectionRequest) {
        return createVpcConnection(CreateVpcConnectionRequest.builder().applyMutation(createVpcConnectionRequest).build());
    }

    /**
     *
     * <p>
     * Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.
     * </p>
     * 
     *
     * @param deleteClusterRequest
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClusterResponse> deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteClusterRequest#builder()}
     * </p>
     *
     * @param deleteClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DeleteClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClusterResponse> deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest) {
        return deleteCluster(DeleteClusterRequest.builder().applyMutation(deleteClusterRequest).build());
    }

    /**
     *
     * <p>
     * Deletes the MSK cluster policy specified by the Amazon Resource Name (ARN) in the request.
     * </p>
     * 
     *
     * @param deleteClusterPolicyRequest
     * @return A Java Future containing the result of the DeleteClusterPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DeleteClusterPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteClusterPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClusterPolicyResponse> deleteClusterPolicy(
            DeleteClusterPolicyRequest deleteClusterPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Deletes the MSK cluster policy specified by the Amazon Resource Name (ARN) in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteClusterPolicyRequest#builder()}
     * </p>
     *
     * @param deleteClusterPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DeleteClusterPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteClusterPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DeleteClusterPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteClusterPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClusterPolicyResponse> deleteClusterPolicy(
            Consumer<DeleteClusterPolicyRequest.Builder> deleteClusterPolicyRequest) {
        return deleteClusterPolicy(DeleteClusterPolicyRequest.builder().applyMutation(deleteClusterPolicyRequest).build());
    }

    /**
     *
     * <p>
     * Deletes an MSK Configuration.
     * </p>
     * 
     *
     * @param deleteConfigurationRequest
     * @return A Java Future containing the result of the DeleteConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DeleteConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationResponse> deleteConfiguration(
            DeleteConfigurationRequest deleteConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Deletes an MSK Configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DeleteConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DeleteConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationResponse> deleteConfiguration(
            Consumer<DeleteConfigurationRequest.Builder> deleteConfigurationRequest) {
        return deleteConfiguration(DeleteConfigurationRequest.builder().applyMutation(deleteConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a replicator.
     * </p>
     *
     * @param deleteReplicatorRequest
     * @return A Java Future containing the result of the DeleteReplicator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DeleteReplicator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteReplicator" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReplicatorResponse> deleteReplicator(DeleteReplicatorRequest deleteReplicatorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a replicator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicatorRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteReplicatorRequest#builder()}
     * </p>
     *
     * @param deleteReplicatorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DeleteReplicatorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteReplicator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DeleteReplicator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteReplicator" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReplicatorResponse> deleteReplicator(
            Consumer<DeleteReplicatorRequest.Builder> deleteReplicatorRequest) {
        return deleteReplicator(DeleteReplicatorRequest.builder().applyMutation(deleteReplicatorRequest).build());
    }

    /**
     *
     * <p>
     * Deletes a MSK VPC connection.
     * </p>
     * 
     *
     * @param deleteVpcConnectionRequest
     * @return A Java Future containing the result of the DeleteVpcConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DeleteVpcConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteVpcConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVpcConnectionResponse> deleteVpcConnection(
            DeleteVpcConnectionRequest deleteVpcConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Deletes a MSK VPC connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcConnectionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVpcConnectionRequest#builder()}
     * </p>
     *
     * @param deleteVpcConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DeleteVpcConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVpcConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DeleteVpcConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteVpcConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVpcConnectionResponse> deleteVpcConnection(
            Consumer<DeleteVpcConnectionRequest.Builder> deleteVpcConnectionRequest) {
        return deleteVpcConnection(DeleteVpcConnectionRequest.builder().applyMutation(deleteVpcConnectionRequest).build());
    }

    /**
     *
     * <p>
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     * </p>
     * 
     *
     * @param describeClusterRequest
     * @return A Java Future containing the result of the DescribeCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeClusterResponse> describeCluster(DescribeClusterRequest describeClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClusterRequest#builder()}
     * </p>
     *
     * @param describeClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DescribeClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeClusterResponse> describeCluster(
            Consumer<DescribeClusterRequest.Builder> describeClusterRequest) {
        return describeCluster(DescribeClusterRequest.builder().applyMutation(describeClusterRequest).build());
    }

    /**
     *
     * <p>
     * Returns a description of the cluster operation specified by the ARN.
     * </p>
     * 
     *
     * @param describeClusterOperationRequest
     * @return A Java Future containing the result of the DescribeClusterOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DescribeClusterOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterOperationResponse> describeClusterOperation(
            DescribeClusterOperationRequest describeClusterOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a description of the cluster operation specified by the ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterOperationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterOperationRequest#builder()}
     * </p>
     *
     * @param describeClusterOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DescribeClusterOperationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeClusterOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DescribeClusterOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterOperationResponse> describeClusterOperation(
            Consumer<DescribeClusterOperationRequest.Builder> describeClusterOperationRequest) {
        return describeClusterOperation(DescribeClusterOperationRequest.builder().applyMutation(describeClusterOperationRequest)
                .build());
    }

    /**
     *
     * <p>
     * Returns a description of the cluster operation specified by the ARN.
     * </p>
     *
     *
     * @param describeClusterOperationV2Request
     * @return A Java Future containing the result of the DescribeClusterOperationV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DescribeClusterOperationV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterOperationV2"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterOperationV2Response> describeClusterOperationV2(
            DescribeClusterOperationV2Request describeClusterOperationV2Request) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a description of the cluster operation specified by the ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterOperationV2Request.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterOperationV2Request#builder()}
     * </p>
     *
     * @param describeClusterOperationV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DescribeClusterOperationV2Request.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeClusterOperationV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DescribeClusterOperationV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterOperationV2"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterOperationV2Response> describeClusterOperationV2(
            Consumer<DescribeClusterOperationV2Request.Builder> describeClusterOperationV2Request) {
        return describeClusterOperationV2(DescribeClusterOperationV2Request.builder()
                .applyMutation(describeClusterOperationV2Request).build());
    }

    /**
     *
     * <p>
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     * </p>
     * 
     *
     * @param describeClusterV2Request
     * @return A Java Future containing the result of the DescribeClusterV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DescribeClusterV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterV2" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeClusterV2Response> describeClusterV2(DescribeClusterV2Request describeClusterV2Request) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterV2Request.Builder} avoiding the need
     * to create one manually via {@link DescribeClusterV2Request#builder()}
     * </p>
     *
     * @param describeClusterV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DescribeClusterV2Request.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeClusterV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DescribeClusterV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeClusterV2" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeClusterV2Response> describeClusterV2(
            Consumer<DescribeClusterV2Request.Builder> describeClusterV2Request) {
        return describeClusterV2(DescribeClusterV2Request.builder().applyMutation(describeClusterV2Request).build());
    }

    /**
     *
     * <p>
     * Returns a description of this MSK configuration.
     * </p>
     * 
     *
     * @param describeConfigurationRequest
     * @return A Java Future containing the result of the DescribeConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DescribeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationResponse> describeConfiguration(
            DescribeConfigurationRequest describeConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a description of this MSK configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConfigurationRequest#builder()}
     * </p>
     *
     * @param describeConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DescribeConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DescribeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationResponse> describeConfiguration(
            Consumer<DescribeConfigurationRequest.Builder> describeConfigurationRequest) {
        return describeConfiguration(DescribeConfigurationRequest.builder().applyMutation(describeConfigurationRequest).build());
    }

    /**
     *
     * <p>
     * Returns a description of this revision of the configuration.
     * </p>
     * 
     *
     * @param describeConfigurationRevisionRequest
     * @return A Java Future containing the result of the DescribeConfigurationRevision operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DescribeConfigurationRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeConfigurationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationRevisionResponse> describeConfigurationRevision(
            DescribeConfigurationRevisionRequest describeConfigurationRevisionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a description of this revision of the configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationRevisionRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationRevisionRequest#builder()}
     * </p>
     *
     * @param describeConfigurationRevisionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DescribeConfigurationRevisionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeConfigurationRevision operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DescribeConfigurationRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeConfigurationRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConfigurationRevisionResponse> describeConfigurationRevision(
            Consumer<DescribeConfigurationRevisionRequest.Builder> describeConfigurationRevisionRequest) {
        return describeConfigurationRevision(DescribeConfigurationRevisionRequest.builder()
                .applyMutation(describeConfigurationRevisionRequest).build());
    }

    /**
     * <p>
     * Describes a replicator.
     * </p>
     *
     * @param describeReplicatorRequest
     * @return A Java Future containing the result of the DescribeReplicator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DescribeReplicator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeReplicator" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeReplicatorResponse> describeReplicator(DescribeReplicatorRequest describeReplicatorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a replicator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicatorRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReplicatorRequest#builder()}
     * </p>
     *
     * @param describeReplicatorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DescribeReplicatorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeReplicator operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DescribeReplicator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeReplicator" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeReplicatorResponse> describeReplicator(
            Consumer<DescribeReplicatorRequest.Builder> describeReplicatorRequest) {
        return describeReplicator(DescribeReplicatorRequest.builder().applyMutation(describeReplicatorRequest).build());
    }

    /**
     *
     * <p>
     * Returns a description of this MSK VPC connection.
     * </p>
     * 
     *
     * @param describeVpcConnectionRequest
     * @return A Java Future containing the result of the DescribeVpcConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DescribeVpcConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeVpcConnection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeVpcConnectionResponse> describeVpcConnection(
            DescribeVpcConnectionRequest describeVpcConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a description of this MSK VPC connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVpcConnectionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVpcConnectionRequest#builder()}
     * </p>
     *
     * @param describeVpcConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.DescribeVpcConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeVpcConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.DescribeVpcConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeVpcConnection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeVpcConnectionResponse> describeVpcConnection(
            Consumer<DescribeVpcConnectionRequest.Builder> describeVpcConnectionRequest) {
        return describeVpcConnection(DescribeVpcConnectionRequest.builder().applyMutation(describeVpcConnectionRequest).build());
    }

    /**
     *
     * <p>
     * A list of brokers that a client application can use to bootstrap.
     * </p>
     * 
     *
     * @param getBootstrapBrokersRequest
     * @return A Java Future containing the result of the GetBootstrapBrokers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ConflictException
     *         <p>
     *         This cluster name already exists. Retry your request using another name.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.GetBootstrapBrokers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetBootstrapBrokers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBootstrapBrokersResponse> getBootstrapBrokers(
            GetBootstrapBrokersRequest getBootstrapBrokersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * A list of brokers that a client application can use to bootstrap.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBootstrapBrokersRequest.Builder} avoiding the
     * need to create one manually via {@link GetBootstrapBrokersRequest#builder()}
     * </p>
     *
     * @param getBootstrapBrokersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.GetBootstrapBrokersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetBootstrapBrokers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ConflictException
     *         <p>
     *         This cluster name already exists. Retry your request using another name.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.GetBootstrapBrokers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetBootstrapBrokers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBootstrapBrokersResponse> getBootstrapBrokers(
            Consumer<GetBootstrapBrokersRequest.Builder> getBootstrapBrokersRequest) {
        return getBootstrapBrokers(GetBootstrapBrokersRequest.builder().applyMutation(getBootstrapBrokersRequest).build());
    }

    /**
     *
     * <p>
     * Get the MSK cluster policy specified by the Amazon Resource Name (ARN) in the request.
     * </p>
     * 
     *
     * @param getClusterPolicyRequest
     * @return A Java Future containing the result of the GetClusterPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.GetClusterPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetClusterPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetClusterPolicyResponse> getClusterPolicy(GetClusterPolicyRequest getClusterPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Get the MSK cluster policy specified by the Amazon Resource Name (ARN) in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClusterPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetClusterPolicyRequest#builder()}
     * </p>
     *
     * @param getClusterPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.GetClusterPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetClusterPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.GetClusterPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetClusterPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetClusterPolicyResponse> getClusterPolicy(
            Consumer<GetClusterPolicyRequest.Builder> getClusterPolicyRequest) {
        return getClusterPolicy(GetClusterPolicyRequest.builder().applyMutation(getClusterPolicyRequest).build());
    }

    /**
     *
     * <p>
     * Gets the Apache Kafka versions to which you can update the MSK cluster.
     * </p>
     * 
     *
     * @param getCompatibleKafkaVersionsRequest
     * @return A Java Future containing the result of the GetCompatibleKafkaVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException n
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         n</li>
     *         <li>UnauthorizedException n
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         n</li>
     *         <li>InternalServerErrorException n
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         n</li>
     *         <li>ForbiddenException n
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         n</li>
     *         <li>NotFoundException n
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         n</li>
     *         <li>ServiceUnavailableException n
     *         <p>
     *         503 response
     *         </p>
     *         n</li>
     *         <li>TooManyRequestsException n
     *         <p>
     *         429 response
     *         </p>
     *         n</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.GetCompatibleKafkaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetCompatibleKafkaVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCompatibleKafkaVersionsResponse> getCompatibleKafkaVersions(
            GetCompatibleKafkaVersionsRequest getCompatibleKafkaVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Gets the Apache Kafka versions to which you can update the MSK cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCompatibleKafkaVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetCompatibleKafkaVersionsRequest#builder()}
     * </p>
     *
     * @param getCompatibleKafkaVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.GetCompatibleKafkaVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCompatibleKafkaVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException n
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         n</li>
     *         <li>UnauthorizedException n
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         n</li>
     *         <li>InternalServerErrorException n
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         n</li>
     *         <li>ForbiddenException n
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         n</li>
     *         <li>NotFoundException n
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         n</li>
     *         <li>ServiceUnavailableException n
     *         <p>
     *         503 response
     *         </p>
     *         n</li>
     *         <li>TooManyRequestsException n
     *         <p>
     *         429 response
     *         </p>
     *         n</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.GetCompatibleKafkaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetCompatibleKafkaVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCompatibleKafkaVersionsResponse> getCompatibleKafkaVersions(
            Consumer<GetCompatibleKafkaVersionsRequest.Builder> getCompatibleKafkaVersionsRequest) {
        return getCompatibleKafkaVersions(GetCompatibleKafkaVersionsRequest.builder()
                .applyMutation(getCompatibleKafkaVersionsRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of all the VPC connections in this Region.
     * </p>
     * 
     *
     * @param listClientVpcConnectionsRequest
     * @return A Java Future containing the result of the ListClientVpcConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClientVpcConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClientVpcConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListClientVpcConnectionsResponse> listClientVpcConnections(
            ListClientVpcConnectionsRequest listClientVpcConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of all the VPC connections in this Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClientVpcConnectionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListClientVpcConnectionsRequest#builder()}
     * </p>
     *
     * @param listClientVpcConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListClientVpcConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClientVpcConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClientVpcConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListClientVpcConnectionsResponse> listClientVpcConnections(
            Consumer<ListClientVpcConnectionsRequest.Builder> listClientVpcConnectionsRequest) {
        return listClientVpcConnections(ListClientVpcConnectionsRequest.builder().applyMutation(listClientVpcConnectionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClientVpcConnections(software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClientVpcConnectionsPublisher publisher = client.listClientVpcConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClientVpcConnectionsPublisher publisher = client.listClientVpcConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClientVpcConnections(software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listClientVpcConnectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClientVpcConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClientVpcConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClientVpcConnectionsPublisher listClientVpcConnectionsPaginator(
            ListClientVpcConnectionsRequest listClientVpcConnectionsRequest) {
        return new ListClientVpcConnectionsPublisher(this, listClientVpcConnectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClientVpcConnections(software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClientVpcConnectionsPublisher publisher = client.listClientVpcConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClientVpcConnectionsPublisher publisher = client.listClientVpcConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClientVpcConnections(software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClientVpcConnectionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListClientVpcConnectionsRequest#builder()}
     * </p>
     *
     * @param listClientVpcConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClientVpcConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClientVpcConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListClientVpcConnectionsPublisher listClientVpcConnectionsPaginator(
            Consumer<ListClientVpcConnectionsRequest.Builder> listClientVpcConnectionsRequest) {
        return listClientVpcConnectionsPaginator(ListClientVpcConnectionsRequest.builder()
                .applyMutation(listClientVpcConnectionsRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of all the operations that have been performed on the specified MSK cluster.
     * </p>
     * 
     *
     * @param listClusterOperationsRequest
     * @return A Java Future containing the result of the ListClusterOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClusterOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListClusterOperationsResponse> listClusterOperations(
            ListClusterOperationsRequest listClusterOperationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of all the operations that have been performed on the specified MSK cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClusterOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListClusterOperationsRequest#builder()}
     * </p>
     *
     * @param listClusterOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListClusterOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClusterOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListClusterOperationsResponse> listClusterOperations(
            Consumer<ListClusterOperationsRequest.Builder> listClusterOperationsRequest) {
        return listClusterOperations(ListClusterOperationsRequest.builder().applyMutation(listClusterOperationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusterOperations(software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsPublisher publisher = client.listClusterOperationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsPublisher publisher = client.listClusterOperationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusterOperations(software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listClusterOperationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClusterOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClusterOperationsPublisher listClusterOperationsPaginator(
            ListClusterOperationsRequest listClusterOperationsRequest) {
        return new ListClusterOperationsPublisher(this, listClusterOperationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusterOperations(software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsPublisher publisher = client.listClusterOperationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsPublisher publisher = client.listClusterOperationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListClusterOperationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusterOperations(software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClusterOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListClusterOperationsRequest#builder()}
     * </p>
     *
     * @param listClusterOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClusterOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClusterOperationsPublisher listClusterOperationsPaginator(
            Consumer<ListClusterOperationsRequest.Builder> listClusterOperationsRequest) {
        return listClusterOperationsPaginator(ListClusterOperationsRequest.builder().applyMutation(listClusterOperationsRequest)
                .build());
    }

    /**
     *
     * <p>
     * Returns a list of all the operations that have been performed on the specified MSK cluster.
     * </p>
     * 
     *
     * @param listClusterOperationsV2Request
     * @return A Java Future containing the result of the ListClusterOperationsV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClusterOperationsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperationsV2" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListClusterOperationsV2Response> listClusterOperationsV2(
            ListClusterOperationsV2Request listClusterOperationsV2Request) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of all the operations that have been performed on the specified MSK cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClusterOperationsV2Request.Builder} avoiding
     * the need to create one manually via {@link ListClusterOperationsV2Request#builder()}
     * </p>
     *
     * @param listClusterOperationsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Request.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListClusterOperationsV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClusterOperationsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperationsV2" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListClusterOperationsV2Response> listClusterOperationsV2(
            Consumer<ListClusterOperationsV2Request.Builder> listClusterOperationsV2Request) {
        return listClusterOperationsV2(ListClusterOperationsV2Request.builder().applyMutation(listClusterOperationsV2Request)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusterOperationsV2(software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Request)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsV2Publisher publisher = client.listClusterOperationsV2Paginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsV2Publisher publisher = client.listClusterOperationsV2Paginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Response>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Response response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusterOperationsV2(software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Request)}
     * operation.</b>
     * </p>
     *
     * @param listClusterOperationsV2Request
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClusterOperationsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperationsV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClusterOperationsV2Publisher listClusterOperationsV2Paginator(
            ListClusterOperationsV2Request listClusterOperationsV2Request) {
        return new ListClusterOperationsV2Publisher(this, listClusterOperationsV2Request);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listClusterOperationsV2(software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Request)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsV2Publisher publisher = client.listClusterOperationsV2Paginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClusterOperationsV2Publisher publisher = client.listClusterOperationsV2Paginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Response>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Response response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusterOperationsV2(software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Request)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClusterOperationsV2Request.Builder} avoiding
     * the need to create one manually via {@link ListClusterOperationsV2Request#builder()}
     * </p>
     *
     * @param listClusterOperationsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClusterOperationsV2Request.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         HTTP Status Code 400: Bad request due to incorrect input. Correct your request and then retry it.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         HTTP Status Code 401: Unauthorized request. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         HTTP Status Code 500: Unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         HTTP Status Code 403: Access forbidden. Correct your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         HTTP Status Code 404: Resource not found due to incorrect input. Correct your request and then retry it.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         HTTP Status Code 503: Service Unavailable. Retrying your request in some time might resolve the issue.
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         HTTP Status Code 429: Limit exceeded. Resource limit reached.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClusterOperationsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusterOperationsV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClusterOperationsV2Publisher listClusterOperationsV2Paginator(
            Consumer<ListClusterOperationsV2Request.Builder> listClusterOperationsV2Request) {
        return listClusterOperationsV2Paginator(ListClusterOperationsV2Request.builder()
                .applyMutation(listClusterOperationsV2Request).build());
    }

    /**
     *
     * <p>
     * Returns a list of all the MSK clusters in the current Region.
     * </p>
     * 
     *
     * @param listClustersRequest
     * @return A Java Future containing the result of the ListClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListClustersResponse> listClusters(ListClustersRequest listClustersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of all the MSK clusters in the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClustersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListClustersResponse> listClusters(Consumer<ListClustersRequest.Builder> listClustersRequest) {
        return listClusters(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of all the MSK clusters in the current Region.
     * </p>
     * 
     *
     * @return A Java Future containing the result of the ListClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListClustersResponse> listClusters() {
        return listClusters(ListClustersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.kafka.model.ListClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.kafka.model.ListClustersRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersPublisher listClustersPaginator() {
        return listClustersPaginator(ListClustersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.kafka.model.ListClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.kafka.model.ListClustersRequest)} operation.</b>
     * </p>
     *
     * @param listClustersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersPublisher listClustersPaginator(ListClustersRequest listClustersRequest) {
        return new ListClustersPublisher(this, listClustersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.kafka.model.ListClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.kafka.model.ListClustersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClustersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersPublisher listClustersPaginator(Consumer<ListClustersRequest.Builder> listClustersRequest) {
        return listClustersPaginator(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of all the MSK clusters in the current Region.
     * </p>
     * 
     *
     * @param listClustersV2Request
     * @return A Java Future containing the result of the ListClustersV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClustersV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClustersV2" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListClustersV2Response> listClustersV2(ListClustersV2Request listClustersV2Request) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of all the MSK clusters in the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersV2Request.Builder} avoiding the need to
     * create one manually via {@link ListClustersV2Request#builder()}
     * </p>
     *
     * @param listClustersV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClustersV2Request.Builder} to create a request.
     * @return A Java Future containing the result of the ListClustersV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClustersV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClustersV2" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListClustersV2Response> listClustersV2(Consumer<ListClustersV2Request.Builder> listClustersV2Request) {
        return listClustersV2(ListClustersV2Request.builder().applyMutation(listClustersV2Request).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listClustersV2(software.amazon.awssdk.services.kafka.model.ListClustersV2Request)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersV2Publisher publisher = client.listClustersV2Paginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersV2Publisher publisher = client.listClustersV2Paginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListClustersV2Response>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListClustersV2Response response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClustersV2(software.amazon.awssdk.services.kafka.model.ListClustersV2Request)} operation.</b>
     * </p>
     *
     * @param listClustersV2Request
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClustersV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClustersV2" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersV2Publisher listClustersV2Paginator(ListClustersV2Request listClustersV2Request) {
        return new ListClustersV2Publisher(this, listClustersV2Request);
    }

    /**
     * <p>
     * This is a variant of {@link #listClustersV2(software.amazon.awssdk.services.kafka.model.ListClustersV2Request)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersV2Publisher publisher = client.listClustersV2Paginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListClustersV2Publisher publisher = client.listClustersV2Paginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListClustersV2Response>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListClustersV2Response response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClustersV2(software.amazon.awssdk.services.kafka.model.ListClustersV2Request)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersV2Request.Builder} avoiding the need to
     * create one manually via {@link ListClustersV2Request#builder()}
     * </p>
     *
     * @param listClustersV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListClustersV2Request.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListClustersV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClustersV2" target="_top">AWS API
     *      Documentation</a>
     */
    default ListClustersV2Publisher listClustersV2Paginator(Consumer<ListClustersV2Request.Builder> listClustersV2Request) {
        return listClustersV2Paginator(ListClustersV2Request.builder().applyMutation(listClustersV2Request).build());
    }

    /**
     *
     * <p>
     * Returns a list of all the MSK configurations in this Region.
     * </p>
     * 
     *
     * @param listConfigurationRevisionsRequest
     * @return A Java Future containing the result of the ListConfigurationRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListConfigurationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConfigurationRevisionsResponse> listConfigurationRevisions(
            ListConfigurationRevisionsRequest listConfigurationRevisionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of all the MSK configurations in this Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListConfigurationRevisionsRequest#builder()}
     * </p>
     *
     * @param listConfigurationRevisionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListConfigurationRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListConfigurationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConfigurationRevisionsResponse> listConfigurationRevisions(
            Consumer<ListConfigurationRevisionsRequest.Builder> listConfigurationRevisionsRequest) {
        return listConfigurationRevisions(ListConfigurationRevisionsRequest.builder()
                .applyMutation(listConfigurationRevisionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationRevisions(software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListConfigurationRevisionsPublisher publisher = client.listConfigurationRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListConfigurationRevisionsPublisher publisher = client.listConfigurationRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationRevisions(software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfigurationRevisionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListConfigurationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationRevisionsPublisher listConfigurationRevisionsPaginator(
            ListConfigurationRevisionsRequest listConfigurationRevisionsRequest) {
        return new ListConfigurationRevisionsPublisher(this, listConfigurationRevisionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationRevisions(software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListConfigurationRevisionsPublisher publisher = client.listConfigurationRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListConfigurationRevisionsPublisher publisher = client.listConfigurationRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationRevisions(software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListConfigurationRevisionsRequest#builder()}
     * </p>
     *
     * @param listConfigurationRevisionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListConfigurationRevisionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListConfigurationRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurationRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationRevisionsPublisher listConfigurationRevisionsPaginator(
            Consumer<ListConfigurationRevisionsRequest.Builder> listConfigurationRevisionsRequest) {
        return listConfigurationRevisionsPaginator(ListConfigurationRevisionsRequest.builder()
                .applyMutation(listConfigurationRevisionsRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of all the MSK configurations in this Region.
     * </p>
     * 
     *
     * @param listConfigurationsRequest
     * @return A Java Future containing the result of the ListConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListConfigurationsResponse> listConfigurations(ListConfigurationsRequest listConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of all the MSK configurations in this Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationsRequest#builder()}
     * </p>
     *
     * @param listConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListConfigurationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListConfigurationsResponse> listConfigurations(
            Consumer<ListConfigurationsRequest.Builder> listConfigurationsRequest) {
        return listConfigurations(ListConfigurationsRequest.builder().applyMutation(listConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurations(software.amazon.awssdk.services.kafka.model.ListConfigurationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListConfigurationsPublisher publisher = client.listConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListConfigurationsPublisher publisher = client.listConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurations(software.amazon.awssdk.services.kafka.model.ListConfigurationsRequest)} operation.</b>
     * </p>
     *
     * @param listConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConfigurationsPublisher listConfigurationsPaginator(ListConfigurationsRequest listConfigurationsRequest) {
        return new ListConfigurationsPublisher(this, listConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurations(software.amazon.awssdk.services.kafka.model.ListConfigurationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListConfigurationsPublisher publisher = client.listConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListConfigurationsPublisher publisher = client.listConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurations(software.amazon.awssdk.services.kafka.model.ListConfigurationsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationsRequest#builder()}
     * </p>
     *
     * @param listConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListConfigurationsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListConfigurations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConfigurationsPublisher listConfigurationsPaginator(
            Consumer<ListConfigurationsRequest.Builder> listConfigurationsRequest) {
        return listConfigurationsPaginator(ListConfigurationsRequest.builder().applyMutation(listConfigurationsRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of Apache Kafka versions.
     * </p>
     * 
     *
     * @param listKafkaVersionsRequest
     * @return A Java Future containing the result of the ListKafkaVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListKafkaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListKafkaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListKafkaVersionsResponse> listKafkaVersions(ListKafkaVersionsRequest listKafkaVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of Apache Kafka versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKafkaVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListKafkaVersionsRequest#builder()}
     * </p>
     *
     * @param listKafkaVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListKafkaVersionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListKafkaVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListKafkaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListKafkaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListKafkaVersionsResponse> listKafkaVersions(
            Consumer<ListKafkaVersionsRequest.Builder> listKafkaVersionsRequest) {
        return listKafkaVersions(ListKafkaVersionsRequest.builder().applyMutation(listKafkaVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listKafkaVersions(software.amazon.awssdk.services.kafka.model.ListKafkaVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListKafkaVersionsPublisher publisher = client.listKafkaVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListKafkaVersionsPublisher publisher = client.listKafkaVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListKafkaVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListKafkaVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKafkaVersions(software.amazon.awssdk.services.kafka.model.ListKafkaVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listKafkaVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListKafkaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListKafkaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKafkaVersionsPublisher listKafkaVersionsPaginator(ListKafkaVersionsRequest listKafkaVersionsRequest) {
        return new ListKafkaVersionsPublisher(this, listKafkaVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listKafkaVersions(software.amazon.awssdk.services.kafka.model.ListKafkaVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListKafkaVersionsPublisher publisher = client.listKafkaVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListKafkaVersionsPublisher publisher = client.listKafkaVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListKafkaVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListKafkaVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKafkaVersions(software.amazon.awssdk.services.kafka.model.ListKafkaVersionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKafkaVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListKafkaVersionsRequest#builder()}
     * </p>
     *
     * @param listKafkaVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListKafkaVersionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListKafkaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListKafkaVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListKafkaVersionsPublisher listKafkaVersionsPaginator(
            Consumer<ListKafkaVersionsRequest.Builder> listKafkaVersionsRequest) {
        return listKafkaVersionsPaginator(ListKafkaVersionsRequest.builder().applyMutation(listKafkaVersionsRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of the broker nodes in the cluster.
     * </p>
     * 
     *
     * @param listNodesRequest
     * @return A Java Future containing the result of the ListNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListNodesResponse> listNodes(ListNodesRequest listNodesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of the broker nodes in the cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNodesRequest#builder()}
     * </p>
     *
     * @param listNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListNodesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListNodesResponse> listNodes(Consumer<ListNodesRequest.Builder> listNodesRequest) {
        return listNodes(ListNodesRequest.builder().applyMutation(listNodesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listNodes(software.amazon.awssdk.services.kafka.model.ListNodesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListNodesPublisher publisher = client.listNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListNodesPublisher publisher = client.listNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodes(software.amazon.awssdk.services.kafka.model.ListNodesRequest)} operation.</b>
     * </p>
     *
     * @param listNodesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodesPublisher listNodesPaginator(ListNodesRequest listNodesRequest) {
        return new ListNodesPublisher(this, listNodesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listNodes(software.amazon.awssdk.services.kafka.model.ListNodesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListNodesPublisher publisher = client.listNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListNodesPublisher publisher = client.listNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodes(software.amazon.awssdk.services.kafka.model.ListNodesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNodesRequest#builder()}
     * </p>
     *
     * @param listNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListNodesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListNodesPublisher listNodesPaginator(Consumer<ListNodesRequest.Builder> listNodesRequest) {
        return listNodesPaginator(ListNodesRequest.builder().applyMutation(listNodesRequest).build());
    }

    /**
     * <p>
     * Lists the replicators.
     * </p>
     *
     * @param listReplicatorsRequest
     * @return A Java Future containing the result of the ListReplicators operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListReplicators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListReplicators" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReplicatorsResponse> listReplicators(ListReplicatorsRequest listReplicatorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the replicators.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReplicatorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReplicatorsRequest#builder()}
     * </p>
     *
     * @param listReplicatorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListReplicators operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListReplicators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListReplicators" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReplicatorsResponse> listReplicators(
            Consumer<ListReplicatorsRequest.Builder> listReplicatorsRequest) {
        return listReplicators(ListReplicatorsRequest.builder().applyMutation(listReplicatorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listReplicators(software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListReplicatorsPublisher publisher = client.listReplicatorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListReplicatorsPublisher publisher = client.listReplicatorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListReplicatorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListReplicatorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReplicators(software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest)} operation.</b>
     * </p>
     *
     * @param listReplicatorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListReplicators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListReplicators" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReplicatorsPublisher listReplicatorsPaginator(ListReplicatorsRequest listReplicatorsRequest) {
        return new ListReplicatorsPublisher(this, listReplicatorsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listReplicators(software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListReplicatorsPublisher publisher = client.listReplicatorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListReplicatorsPublisher publisher = client.listReplicatorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListReplicatorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListReplicatorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReplicators(software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReplicatorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReplicatorsRequest#builder()}
     * </p>
     *
     * @param listReplicatorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListReplicatorsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListReplicators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListReplicators" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReplicatorsPublisher listReplicatorsPaginator(Consumer<ListReplicatorsRequest.Builder> listReplicatorsRequest) {
        return listReplicatorsPaginator(ListReplicatorsRequest.builder().applyMutation(listReplicatorsRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of the Scram Secrets associated with an Amazon MSK cluster.
     * </p>
     * 
     *
     * @param listScramSecretsRequest
     * @return A Java Future containing the result of the ListScramSecrets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListScramSecrets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListScramSecrets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListScramSecretsResponse> listScramSecrets(ListScramSecretsRequest listScramSecretsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of the Scram Secrets associated with an Amazon MSK cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScramSecretsRequest.Builder} avoiding the need
     * to create one manually via {@link ListScramSecretsRequest#builder()}
     * </p>
     *
     * @param listScramSecretsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListScramSecrets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListScramSecrets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListScramSecrets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListScramSecretsResponse> listScramSecrets(
            Consumer<ListScramSecretsRequest.Builder> listScramSecretsRequest) {
        return listScramSecrets(ListScramSecretsRequest.builder().applyMutation(listScramSecretsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listScramSecrets(software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListScramSecretsPublisher publisher = client.listScramSecretsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListScramSecretsPublisher publisher = client.listScramSecretsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListScramSecretsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListScramSecretsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScramSecrets(software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest)} operation.</b>
     * </p>
     *
     * @param listScramSecretsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListScramSecrets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListScramSecrets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListScramSecretsPublisher listScramSecretsPaginator(ListScramSecretsRequest listScramSecretsRequest) {
        return new ListScramSecretsPublisher(this, listScramSecretsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listScramSecrets(software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListScramSecretsPublisher publisher = client.listScramSecretsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListScramSecretsPublisher publisher = client.listScramSecretsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListScramSecretsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListScramSecretsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScramSecrets(software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScramSecretsRequest.Builder} avoiding the need
     * to create one manually via {@link ListScramSecretsRequest#builder()}
     * </p>
     *
     * @param listScramSecretsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListScramSecrets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListScramSecrets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListScramSecretsPublisher listScramSecretsPaginator(Consumer<ListScramSecretsRequest.Builder> listScramSecretsRequest) {
        return listScramSecretsPaginator(ListScramSecretsRequest.builder().applyMutation(listScramSecretsRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of the tags associated with the specified resource.
     * </p>
     * 
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of the tags associated with the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     *
     * <p>
     * Returns a list of all the VPC connections in this Region.
     * </p>
     * 
     *
     * @param listVpcConnectionsRequest
     * @return A Java Future containing the result of the ListVpcConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListVpcConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListVpcConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListVpcConnectionsResponse> listVpcConnections(ListVpcConnectionsRequest listVpcConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns a list of all the VPC connections in this Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpcConnectionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListVpcConnectionsRequest#builder()}
     * </p>
     *
     * @param listVpcConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListVpcConnectionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListVpcConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListVpcConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListVpcConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListVpcConnectionsResponse> listVpcConnections(
            Consumer<ListVpcConnectionsRequest.Builder> listVpcConnectionsRequest) {
        return listVpcConnections(ListVpcConnectionsRequest.builder().applyMutation(listVpcConnectionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVpcConnections(software.amazon.awssdk.services.kafka.model.ListVpcConnectionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListVpcConnectionsPublisher publisher = client.listVpcConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListVpcConnectionsPublisher publisher = client.listVpcConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListVpcConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListVpcConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVpcConnections(software.amazon.awssdk.services.kafka.model.ListVpcConnectionsRequest)} operation.</b>
     * </p>
     *
     * @param listVpcConnectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListVpcConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListVpcConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVpcConnectionsPublisher listVpcConnectionsPaginator(ListVpcConnectionsRequest listVpcConnectionsRequest) {
        return new ListVpcConnectionsPublisher(this, listVpcConnectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVpcConnections(software.amazon.awssdk.services.kafka.model.ListVpcConnectionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListVpcConnectionsPublisher publisher = client.listVpcConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kafka.paginators.ListVpcConnectionsPublisher publisher = client.listVpcConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kafka.model.ListVpcConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kafka.model.ListVpcConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVpcConnections(software.amazon.awssdk.services.kafka.model.ListVpcConnectionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpcConnectionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListVpcConnectionsRequest#builder()}
     * </p>
     *
     * @param listVpcConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.ListVpcConnectionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.ListVpcConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListVpcConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVpcConnectionsPublisher listVpcConnectionsPaginator(
            Consumer<ListVpcConnectionsRequest.Builder> listVpcConnectionsRequest) {
        return listVpcConnectionsPaginator(ListVpcConnectionsRequest.builder().applyMutation(listVpcConnectionsRequest).build());
    }

    /**
     *
     * <p>
     * Creates or updates the MSK cluster policy specified by the cluster Amazon Resource Name (ARN) in the request.
     * </p>
     * 
     *
     * @param putClusterPolicyRequest
     * @return A Java Future containing the result of the PutClusterPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.PutClusterPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/PutClusterPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutClusterPolicyResponse> putClusterPolicy(PutClusterPolicyRequest putClusterPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Creates or updates the MSK cluster policy specified by the cluster Amazon Resource Name (ARN) in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutClusterPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutClusterPolicyRequest#builder()}
     * </p>
     *
     * @param putClusterPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.PutClusterPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutClusterPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.PutClusterPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/PutClusterPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutClusterPolicyResponse> putClusterPolicy(
            Consumer<PutClusterPolicyRequest.Builder> putClusterPolicyRequest) {
        return putClusterPolicy(PutClusterPolicyRequest.builder().applyMutation(putClusterPolicyRequest).build());
    }

    /**
     * Reboots brokers.
     *
     * @param rebootBrokerRequest
     *        Reboots a node.
     * @return A Java Future containing the result of the RebootBroker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.RebootBroker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/RebootBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RebootBrokerResponse> rebootBroker(RebootBrokerRequest rebootBrokerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Reboots brokers.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootBrokerRequest.Builder} avoiding the need to
     * create one manually via {@link RebootBrokerRequest#builder()}
     * </p>
     *
     * @param rebootBrokerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.RebootBrokerRequest.Builder} to create a request.
     *        Reboots a node.
     * @return A Java Future containing the result of the RebootBroker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.RebootBroker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/RebootBroker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RebootBrokerResponse> rebootBroker(Consumer<RebootBrokerRequest.Builder> rebootBrokerRequest) {
        return rebootBroker(RebootBrokerRequest.builder().applyMutation(rebootBrokerRequest).build());
    }

    /**
     *
     * <p>
     * Returns empty response.
     * </p>
     * 
     *
     * @param rejectClientVpcConnectionRequest
     * @return A Java Future containing the result of the RejectClientVpcConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.RejectClientVpcConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/RejectClientVpcConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectClientVpcConnectionResponse> rejectClientVpcConnection(
            RejectClientVpcConnectionRequest rejectClientVpcConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Returns empty response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectClientVpcConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link RejectClientVpcConnectionRequest#builder()}
     * </p>
     *
     * @param rejectClientVpcConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.RejectClientVpcConnectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RejectClientVpcConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.RejectClientVpcConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/RejectClientVpcConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectClientVpcConnectionResponse> rejectClientVpcConnection(
            Consumer<RejectClientVpcConnectionRequest.Builder> rejectClientVpcConnectionRequest) {
        return rejectClientVpcConnection(RejectClientVpcConnectionRequest.builder()
                .applyMutation(rejectClientVpcConnectionRequest).build());
    }

    /**
     *
     * <p>
     * Adds tags to the specified MSK resource.
     * </p>
     * 
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Adds tags to the specified MSK resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     *
     * <p>
     * Removes the tags associated with the keys that are provided in the query.
     * </p>
     * 
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Removes the tags associated with the keys that are provided in the query.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     *
     * <p>
     * Updates the number of broker nodes in the cluster.
     * </p>
     * 
     *
     * @param updateBrokerCountRequest
     * @return A Java Future containing the result of the UpdateBrokerCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateBrokerCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerCount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBrokerCountResponse> updateBrokerCount(UpdateBrokerCountRequest updateBrokerCountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Updates the number of broker nodes in the cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBrokerCountRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBrokerCountRequest#builder()}
     * </p>
     *
     * @param updateBrokerCountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateBrokerCountRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateBrokerCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateBrokerCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerCount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBrokerCountResponse> updateBrokerCount(
            Consumer<UpdateBrokerCountRequest.Builder> updateBrokerCountRequest) {
        return updateBrokerCount(UpdateBrokerCountRequest.builder().applyMutation(updateBrokerCountRequest).build());
    }

    /**
     *
     * <p>
     * Updates the EBS storage associated with MSK brokers.
     * </p>
     * 
     *
     * @param updateBrokerStorageRequest
     * @return A Java Future containing the result of the UpdateBrokerStorage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateBrokerStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerStorage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBrokerStorageResponse> updateBrokerStorage(
            UpdateBrokerStorageRequest updateBrokerStorageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Updates the EBS storage associated with MSK brokers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBrokerStorageRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBrokerStorageRequest#builder()}
     * </p>
     *
     * @param updateBrokerStorageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateBrokerStorageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateBrokerStorage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateBrokerStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerStorage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBrokerStorageResponse> updateBrokerStorage(
            Consumer<UpdateBrokerStorageRequest.Builder> updateBrokerStorageRequest) {
        return updateBrokerStorage(UpdateBrokerStorageRequest.builder().applyMutation(updateBrokerStorageRequest).build());
    }

    /**
     *
     * <p>
     * Updates EC2 instance type.
     * </p>
     * 
     *
     * @param updateBrokerTypeRequest
     * @return A Java Future containing the result of the UpdateBrokerType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateBrokerType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBrokerTypeResponse> updateBrokerType(UpdateBrokerTypeRequest updateBrokerTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Updates EC2 instance type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBrokerTypeRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBrokerTypeRequest#builder()}
     * </p>
     *
     * @param updateBrokerTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateBrokerTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateBrokerType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateBrokerType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateBrokerType" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBrokerTypeResponse> updateBrokerType(
            Consumer<UpdateBrokerTypeRequest.Builder> updateBrokerTypeRequest) {
        return updateBrokerType(UpdateBrokerTypeRequest.builder().applyMutation(updateBrokerTypeRequest).build());
    }

    /**
     *
     * <p>
     * Updates the cluster with the configuration that is specified in the request body.
     * </p>
     * 
     *
     * @param updateClusterConfigurationRequest
     * @return A Java Future containing the result of the UpdateClusterConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateClusterConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateClusterConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateClusterConfigurationResponse> updateClusterConfiguration(
            UpdateClusterConfigurationRequest updateClusterConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Updates the cluster with the configuration that is specified in the request body.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClusterConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateClusterConfigurationRequest#builder()}
     * </p>
     *
     * @param updateClusterConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateClusterConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateClusterConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateClusterConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateClusterConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateClusterConfigurationResponse> updateClusterConfiguration(
            Consumer<UpdateClusterConfigurationRequest.Builder> updateClusterConfigurationRequest) {
        return updateClusterConfiguration(UpdateClusterConfigurationRequest.builder()
                .applyMutation(updateClusterConfigurationRequest).build());
    }

    /**
     *
     * <p>
     * Updates the Apache Kafka version for the cluster.
     * </p>
     * 
     *
     * @param updateClusterKafkaVersionRequest
     * @return A Java Future containing the result of the UpdateClusterKafkaVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateClusterKafkaVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateClusterKafkaVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateClusterKafkaVersionResponse> updateClusterKafkaVersion(
            UpdateClusterKafkaVersionRequest updateClusterKafkaVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Updates the Apache Kafka version for the cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateClusterKafkaVersionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateClusterKafkaVersionRequest#builder()}
     * </p>
     *
     * @param updateClusterKafkaVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateClusterKafkaVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateClusterKafkaVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         429 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateClusterKafkaVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateClusterKafkaVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateClusterKafkaVersionResponse> updateClusterKafkaVersion(
            Consumer<UpdateClusterKafkaVersionRequest.Builder> updateClusterKafkaVersionRequest) {
        return updateClusterKafkaVersion(UpdateClusterKafkaVersionRequest.builder()
                .applyMutation(updateClusterKafkaVersionRequest).build());
    }

    /**
     *
     * <p>
     * Updates an MSK configuration.
     * </p>
     * 
     *
     * @param updateConfigurationRequest
     * @return A Java Future containing the result of the UpdateConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationResponse> updateConfiguration(
            UpdateConfigurationRequest updateConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Updates an MSK configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateConfigurationRequest#builder()}
     * </p>
     *
     * @param updateConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateConfiguration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationResponse> updateConfiguration(
            Consumer<UpdateConfigurationRequest.Builder> updateConfigurationRequest) {
        return updateConfiguration(UpdateConfigurationRequest.builder().applyMutation(updateConfigurationRequest).build());
    }

    /**
     *
     * <p>
     * Updates the cluster's connectivity configuration.
     * </p>
     * 
     *
     * @param updateConnectivityRequest
     *        Request body for UpdateConnectivity.
     * @return A Java Future containing the result of the UpdateConnectivity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateConnectivity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateConnectivity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateConnectivityResponse> updateConnectivity(UpdateConnectivityRequest updateConnectivityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Updates the cluster's connectivity configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectivityRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateConnectivityRequest#builder()}
     * </p>
     *
     * @param updateConnectivityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateConnectivityRequest.Builder} to create a request.
     *        Request body for UpdateConnectivity.
     * @return A Java Future containing the result of the UpdateConnectivity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateConnectivity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateConnectivity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateConnectivityResponse> updateConnectivity(
            Consumer<UpdateConnectivityRequest.Builder> updateConnectivityRequest) {
        return updateConnectivity(UpdateConnectivityRequest.builder().applyMutation(updateConnectivityRequest).build());
    }

    /**
     *
     * <p>
     * Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics
     * you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with
     * Prometheus.
     * </p>
     * 
     *
     * @param updateMonitoringRequest
     *        Request body for UpdateMonitoring.
     * @return A Java Future containing the result of the UpdateMonitoring operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateMonitoring
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateMonitoring" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateMonitoringResponse> updateMonitoring(UpdateMonitoringRequest updateMonitoringRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics
     * you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with
     * Prometheus.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMonitoringRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateMonitoringRequest#builder()}
     * </p>
     *
     * @param updateMonitoringRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateMonitoringRequest.Builder} to create a request.
     *        Request body for UpdateMonitoring.
     * @return A Java Future containing the result of the UpdateMonitoring operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException
     *         <p>
     *         503 response
     *         </p>
     *         </li>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateMonitoring
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateMonitoring" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateMonitoringResponse> updateMonitoring(
            Consumer<UpdateMonitoringRequest.Builder> updateMonitoringRequest) {
        return updateMonitoring(UpdateMonitoringRequest.builder().applyMutation(updateMonitoringRequest).build());
    }

    /**
     * <p>
     * Updates replication info of a replicator.
     * </p>
     *
     * @param updateReplicationInfoRequest
     *        Update information relating to replication between a given source and target Kafka cluster.
     * @return A Java Future containing the result of the UpdateReplicationInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateReplicationInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateReplicationInfo" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateReplicationInfoResponse> updateReplicationInfo(
            UpdateReplicationInfoRequest updateReplicationInfoRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates replication info of a replicator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReplicationInfoRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateReplicationInfoRequest#builder()}
     * </p>
     *
     * @param updateReplicationInfoRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateReplicationInfoRequest.Builder} to create a
     *        request. Update information relating to replication between a given source and target Kafka cluster.
     * @return A Java Future containing the result of the UpdateReplicationInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateReplicationInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateReplicationInfo" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateReplicationInfoResponse> updateReplicationInfo(
            Consumer<UpdateReplicationInfoRequest.Builder> updateReplicationInfoRequest) {
        return updateReplicationInfo(UpdateReplicationInfoRequest.builder().applyMutation(updateReplicationInfoRequest).build());
    }

    /**
     *
     * <p>
     * Updates the security settings for the cluster. You can use this operation to specify encryption and
     * authentication on existing clusters.
     * </p>
     * 
     *
     * @param updateSecurityRequest
     * @return A Java Future containing the result of the UpdateSecurity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         The service cannot complete the request.
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         The request throughput limit was exceeded.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateSecurity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateSecurity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSecurityResponse> updateSecurity(UpdateSecurityRequest updateSecurityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * <p>
     * Updates the security settings for the cluster. You can use this operation to specify encryption and
     * authentication on existing clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSecurityRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSecurityRequest#builder()}
     * </p>
     *
     * @param updateSecurityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateSecurityRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSecurity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException
     *         <p>
     *         The request isn't valid because the input is incorrect. Correct your input and then submit it again.
     *         </p>
     *         </li>
     *         <li>UnauthorizedException
     *         <p>
     *         The request is not authorized. The provided credentials couldn't be validated.
     *         </p>
     *         </li>
     *         <li>InternalServerErrorException
     *         <p>
     *         There was an unexpected internal server error. Retrying your request might resolve the issue.
     *         </p>
     *         </li>
     *         <li>ForbiddenException
     *         <p>
     *         Access forbidden. Check your credentials and then retry your request.
     *         </p>
     *         </li>
     *         <li>NotFoundException
     *         <p>
     *         The resource could not be found due to incorrect input. Correct the input, then retry the request.
     *         </p>
     *         </li>
     *         <li>ServiceUnavailableException
     *         <p>
     *         The service cannot complete the request.
     *         </p>
     *         </li>
     *         <li>TooManyRequestsException
     *         <p>
     *         The request throughput limit was exceeded.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateSecurity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateSecurity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSecurityResponse> updateSecurity(Consumer<UpdateSecurityRequest.Builder> updateSecurityRequest) {
        return updateSecurity(UpdateSecurityRequest.builder().applyMutation(updateSecurityRequest).build());
    }

    /**
     * Updates cluster broker volume size (or) sets cluster storage mode to TIERED.
     *
     * @param updateStorageRequest
     *        <p>
     *        Request object for UpdateStorage api. Its used to update the storage attributes for the cluster.
     *        </p>
     * @return A Java Future containing the result of the UpdateStorage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateStorage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateStorageResponse> updateStorage(UpdateStorageRequest updateStorageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates cluster broker volume size (or) sets cluster storage mode to TIERED.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStorageRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStorageRequest#builder()}
     * </p>
     *
     * @param updateStorageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kafka.model.UpdateStorageRequest.Builder} to create a request.
     *        <p>
     *        Request object for UpdateStorage api. Its used to update the storage attributes for the cluster.
     *        </p>
     * @return A Java Future containing the result of the UpdateStorage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException HTTP Status Code 400: Bad request due to incorrect input. Correct your request
     *         and then retry it.</li>
     *         <li>UnauthorizedException HTTP Status Code 401: Unauthorized request. The provided credentials couldn't
     *         be validated.</li>
     *         <li>InternalServerErrorException HTTP Status Code 500: Unexpected internal server error. Retrying your
     *         request might resolve the issue.</li>
     *         <li>ForbiddenException HTTP Status Code 403: Access forbidden. Correct your credentials and then retry
     *         your request.</li>
     *         <li>NotFoundException HTTP Status Code 404: Resource not found due to incorrect input. Correct your
     *         request and then retry it.</li>
     *         <li>ServiceUnavailableException HTTP Status Code 503: Service Unavailable. Retrying your request in some
     *         time might resolve the issue.</li>
     *         <li>TooManyRequestsException HTTP Status Code 429: Limit exceeded. Resource limit reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KafkaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KafkaAsyncClient.UpdateStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UpdateStorage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateStorageResponse> updateStorage(Consumer<UpdateStorageRequest.Builder> updateStorageRequest) {
        return updateStorage(UpdateStorageRequest.builder().applyMutation(updateStorageRequest).build());
    }

    @Override
    default KafkaServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link KafkaAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static KafkaAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link KafkaAsyncClient}.
     */
    static KafkaAsyncClientBuilder builder() {
        return new DefaultKafkaAsyncClientBuilder();
    }
}
