/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationRevisionResponse extends KafkaResponse implements
        ToCopyableBuilder<DescribeConfigurationRevisionResponse.Builder, DescribeConfigurationRevisionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeConfigurationRevisionResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(DescribeConfigurationRevisionResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeConfigurationRevisionResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Long> REVISION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Revision")
            .getter(getter(DescribeConfigurationRevisionResponse::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final SdkField<SdkBytes> SERVER_PROPERTIES_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("ServerProperties").getter(getter(DescribeConfigurationRevisionResponse::serverProperties))
            .setter(setter(Builder::serverProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIME_FIELD, DESCRIPTION_FIELD, REVISION_FIELD, SERVER_PROPERTIES_FIELD));

    private final String arn;

    private final Instant creationTime;

    private final String description;

    private final Long revision;

    private final SdkBytes serverProperties;

    private DescribeConfigurationRevisionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.revision = builder.revision;
        this.serverProperties = builder.serverProperties;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) of the configuration.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the configuration.
     *         </p>
     */
    public final String arn() {
        return arn;
    }

    /**
     *
     * <p>
     * The time when the configuration was created.
     * </p>
     * 
     * @return <p>
     *         The time when the configuration was created.
     *         </p>
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     *
     * <p>
     * The description of the configuration.
     * </p>
     * 
     * @return <p>
     *         The description of the configuration.
     *         </p>
     */
    public final String description() {
        return description;
    }

    /**
     *
     * <p>
     * The revision number.
     * </p>
     * 
     * @return <p>
     *         The revision number.
     *         </p>
     */
    public final Long revision() {
        return revision;
    }

    /**
     *
     * <p>
     * Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that the
     * contents of the file are base64 encoded. When using the AWS Management Console, the SDK, or the AWS CLI, the
     * contents of <filename>server.properties</filename> can be in plaintext.
     * </p>
     * 
     * @return <p>
     *         Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that the
     *         contents of the file are base64 encoded. When using the AWS Management Console, the SDK, or the AWS CLI,
     *         the contents of <filename>server.properties</filename> can be in plaintext.
     *         </p>
     */
    public final SdkBytes serverProperties() {
        return serverProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(serverProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRevisionResponse)) {
            return false;
        }
        DescribeConfigurationRevisionResponse other = (DescribeConfigurationRevisionResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(description(), other.description()) && Objects.equals(revision(), other.revision())
                && Objects.equals(serverProperties(), other.serverProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConfigurationRevisionResponse").add("Arn", arn()).add("CreationTime", creationTime())
                .add("Description", description()).add("Revision", revision()).add("ServerProperties", serverProperties())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "ServerProperties":
            return Optional.ofNullable(clazz.cast(serverProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationRevisionResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationRevisionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConfigurationRevisionResponse> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) of the configuration.
         * </p>
         * 
         * @param arn
         *        <p>
         *        The Amazon Resource Name (ARN) of the configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         *
         * <p>
         * The time when the configuration was created.
         * </p>
         * 
         * @param creationTime
         *        <p>
         *        The time when the configuration was created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         *
         * <p>
         * The description of the configuration.
         * </p>
         * 
         * @param description
         *        <p>
         *        The description of the configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         *
         * <p>
         * The revision number.
         * </p>
         * 
         * @param revision
         *        <p>
         *        The revision number.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(Long revision);

        /**
         *
         * <p>
         * Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that the
         * contents of the file are base64 encoded. When using the AWS Management Console, the SDK, or the AWS CLI, the
         * contents of <filename>server.properties</filename> can be in plaintext.
         * </p>
         * 
         * @param serverProperties
         *        <p>
         *        Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that
         *        the contents of the file are base64 encoded. When using the AWS Management Console, the SDK, or the
         *        AWS CLI, the contents of <filename>server.properties</filename> can be in plaintext.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverProperties(SdkBytes serverProperties);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant creationTime;

        private String description;

        private Long revision;

        private SdkBytes serverProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRevisionResponse model) {
            super(model);
            arn(model.arn);
            creationTime(model.creationTime);
            description(model.description);
            revision(model.revision);
            serverProperties(model.serverProperties);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Long getRevision() {
            return revision;
        }

        public final void setRevision(Long revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(Long revision) {
            this.revision = revision;
            return this;
        }

        public final ByteBuffer getServerProperties() {
            return serverProperties == null ? null : serverProperties.asByteBuffer();
        }

        public final void setServerProperties(ByteBuffer serverProperties) {
            serverProperties(serverProperties == null ? null : SdkBytes.fromByteBuffer(serverProperties));
        }

        @Override
        public final Builder serverProperties(SdkBytes serverProperties) {
            this.serverProperties = serverProperties;
            return this;
        }

        @Override
        public DescribeConfigurationRevisionResponse build() {
            return new DescribeConfigurationRevisionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
