/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * VPC connectivity access control for brokers.
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcConnectivity implements SdkPojo, Serializable, ToCopyableBuilder<VpcConnectivity.Builder, VpcConnectivity> {
    private static final SdkField<VpcConnectivityClientAuthentication> CLIENT_AUTHENTICATION_FIELD = SdkField
            .<VpcConnectivityClientAuthentication> builder(MarshallingType.SDK_POJO).memberName("ClientAuthentication")
            .getter(getter(VpcConnectivity::clientAuthentication)).setter(setter(Builder::clientAuthentication))
            .constructor(VpcConnectivityClientAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientAuthentication").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_AUTHENTICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final VpcConnectivityClientAuthentication clientAuthentication;

    private VpcConnectivity(BuilderImpl builder) {
        this.clientAuthentication = builder.clientAuthentication;
    }

    /**
     *
     * <p>
     * Includes all client authentication information for VPC connectivity.
     * </p>
     * 
     * @return <p>
     *         Includes all client authentication information for VPC connectivity.
     *         </p>
     */
    public final VpcConnectivityClientAuthentication clientAuthentication() {
        return clientAuthentication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientAuthentication());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConnectivity)) {
            return false;
        }
        VpcConnectivity other = (VpcConnectivity) obj;
        return Objects.equals(clientAuthentication(), other.clientAuthentication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcConnectivity").add("ClientAuthentication", clientAuthentication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientAuthentication":
            return Optional.ofNullable(clazz.cast(clientAuthentication()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcConnectivity, T> g) {
        return obj -> g.apply((VpcConnectivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcConnectivity> {
        /**
         *
         * <p>
         * Includes all client authentication information for VPC connectivity.
         * </p>
         * 
         * @param clientAuthentication
         *        <p>
         *        Includes all client authentication information for VPC connectivity.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientAuthentication(VpcConnectivityClientAuthentication clientAuthentication);

        /**
         *
         * <p>
         * Includes all client authentication information for VPC connectivity.
         * </p>
         * 
         * This is a convenience method that creates an instance of the
         * {@link VpcConnectivityClientAuthentication.Builder} avoiding the need to create one manually via
         * {@link VpcConnectivityClientAuthentication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConnectivityClientAuthentication.Builder#build()} is called
         * immediately and its result is passed to {@link #clientAuthentication(VpcConnectivityClientAuthentication)}.
         * 
         * @param clientAuthentication
         *        a consumer that will call methods on {@link VpcConnectivityClientAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientAuthentication(VpcConnectivityClientAuthentication)
         */
        default Builder clientAuthentication(Consumer<VpcConnectivityClientAuthentication.Builder> clientAuthentication) {
            return clientAuthentication(VpcConnectivityClientAuthentication.builder().applyMutation(clientAuthentication).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VpcConnectivityClientAuthentication clientAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConnectivity model) {
            clientAuthentication(model.clientAuthentication);
        }

        public final VpcConnectivityClientAuthentication.Builder getClientAuthentication() {
            return clientAuthentication != null ? clientAuthentication.toBuilder() : null;
        }

        public final void setClientAuthentication(VpcConnectivityClientAuthentication.BuilderImpl clientAuthentication) {
            this.clientAuthentication = clientAuthentication != null ? clientAuthentication.build() : null;
        }

        @Override
        public final Builder clientAuthentication(VpcConnectivityClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        @Override
        public VpcConnectivity build() {
            return new VpcConnectivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
