/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfReplicationInfoDescriptionCopier {
    static List<ReplicationInfoDescription> copy(
            Collection<? extends ReplicationInfoDescription> __listOfReplicationInfoDescriptionParam) {
        List<ReplicationInfoDescription> list;
        if (__listOfReplicationInfoDescriptionParam == null
                || __listOfReplicationInfoDescriptionParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ReplicationInfoDescription> modifiableList = new ArrayList<>(__listOfReplicationInfoDescriptionParam.size());
            __listOfReplicationInfoDescriptionParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ReplicationInfoDescription> copyFromBuilder(
            Collection<? extends ReplicationInfoDescription.Builder> __listOfReplicationInfoDescriptionParam) {
        List<ReplicationInfoDescription> list;
        if (__listOfReplicationInfoDescriptionParam == null
                || __listOfReplicationInfoDescriptionParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ReplicationInfoDescription> modifiableList = new ArrayList<>(__listOfReplicationInfoDescriptionParam.size());
            __listOfReplicationInfoDescriptionParam.forEach(entry -> {
                ReplicationInfoDescription member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ReplicationInfoDescription.Builder> copyToBuilder(
            Collection<? extends ReplicationInfoDescription> __listOfReplicationInfoDescriptionParam) {
        List<ReplicationInfoDescription.Builder> list;
        if (__listOfReplicationInfoDescriptionParam == null
                || __listOfReplicationInfoDescriptionParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ReplicationInfoDescription.Builder> modifiableList = new ArrayList<>(
                    __listOfReplicationInfoDescriptionParam.size());
            __listOfReplicationInfoDescriptionParam.forEach(entry -> {
                ReplicationInfoDescription.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
