/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Specifies the EBS volume upgrade information. The broker identifier must be set to the keyword ALL. This means the
 * changes apply to all the brokers in the cluster.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrokerEBSVolumeInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<BrokerEBSVolumeInfo.Builder, BrokerEBSVolumeInfo> {
    private static final SdkField<String> KAFKA_BROKER_NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KafkaBrokerNodeId").getter(getter(BrokerEBSVolumeInfo::kafkaBrokerNodeId))
            .setter(setter(Builder::kafkaBrokerNodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaBrokerNodeId").build()).build();

    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField
            .<ProvisionedThroughput> builder(MarshallingType.SDK_POJO).memberName("ProvisionedThroughput")
            .getter(getter(BrokerEBSVolumeInfo::provisionedThroughput)).setter(setter(Builder::provisionedThroughput))
            .constructor(ProvisionedThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedThroughput").build())
            .build();

    private static final SdkField<Integer> VOLUME_SIZE_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSizeGB").getter(getter(BrokerEBSVolumeInfo::volumeSizeGB)).setter(setter(Builder::volumeSizeGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeSizeGB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KAFKA_BROKER_NODE_ID_FIELD,
            PROVISIONED_THROUGHPUT_FIELD, VOLUME_SIZE_GB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("kafkaBrokerNodeId", KAFKA_BROKER_NODE_ID_FIELD);
                    put("provisionedThroughput", PROVISIONED_THROUGHPUT_FIELD);
                    put("volumeSizeGB", VOLUME_SIZE_GB_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String kafkaBrokerNodeId;

    private final ProvisionedThroughput provisionedThroughput;

    private final Integer volumeSizeGB;

    private BrokerEBSVolumeInfo(BuilderImpl builder) {
        this.kafkaBrokerNodeId = builder.kafkaBrokerNodeId;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.volumeSizeGB = builder.volumeSizeGB;
    }

    /**
     *
     * <p>
     * The ID of the broker to update.
     * </p>
     * 
     * @return <p>
     *         The ID of the broker to update.
     *         </p>
     */
    public final String kafkaBrokerNodeId() {
        return kafkaBrokerNodeId;
    }

    /**
     *
     * <p>
     * EBS volume provisioned throughput information.
     * </p>
     * 
     * @return <p>
     *         EBS volume provisioned throughput information.
     *         </p>
     */
    public final ProvisionedThroughput provisionedThroughput() {
        return provisionedThroughput;
    }

    /**
     *
     * <p>
     * Size of the EBS volume to update.
     * </p>
     * 
     * @return <p>
     *         Size of the EBS volume to update.
     *         </p>
     */
    public final Integer volumeSizeGB() {
        return volumeSizeGB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kafkaBrokerNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeGB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerEBSVolumeInfo)) {
            return false;
        }
        BrokerEBSVolumeInfo other = (BrokerEBSVolumeInfo) obj;
        return Objects.equals(kafkaBrokerNodeId(), other.kafkaBrokerNodeId())
                && Objects.equals(provisionedThroughput(), other.provisionedThroughput())
                && Objects.equals(volumeSizeGB(), other.volumeSizeGB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrokerEBSVolumeInfo").add("KafkaBrokerNodeId", kafkaBrokerNodeId())
                .add("ProvisionedThroughput", provisionedThroughput()).add("VolumeSizeGB", volumeSizeGB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KafkaBrokerNodeId":
            return Optional.ofNullable(clazz.cast(kafkaBrokerNodeId()));
        case "ProvisionedThroughput":
            return Optional.ofNullable(clazz.cast(provisionedThroughput()));
        case "VolumeSizeGB":
            return Optional.ofNullable(clazz.cast(volumeSizeGB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BrokerEBSVolumeInfo, T> g) {
        return obj -> g.apply((BrokerEBSVolumeInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrokerEBSVolumeInfo> {
        /**
         *
         * <p>
         * The ID of the broker to update.
         * </p>
         * 
         * @param kafkaBrokerNodeId
         *        <p>
         *        The ID of the broker to update.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaBrokerNodeId(String kafkaBrokerNodeId);

        /**
         *
         * <p>
         * EBS volume provisioned throughput information.
         * </p>
         * 
         * @param provisionedThroughput
         *        <p>
         *        EBS volume provisioned throughput information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput);

        /**
         *
         * <p>
         * EBS volume provisioned throughput information.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link ProvisionedThroughput.Builder} avoiding
         * the need to create one manually via {@link ProvisionedThroughput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisionedThroughput.Builder#build()} is called immediately and
         * its result is passed to {@link #provisionedThroughput(ProvisionedThroughput)}.
         * 
         * @param provisionedThroughput
         *        a consumer that will call methods on {@link ProvisionedThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughput(ProvisionedThroughput)
         */
        default Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return provisionedThroughput(ProvisionedThroughput.builder().applyMutation(provisionedThroughput).build());
        }

        /**
         *
         * <p>
         * Size of the EBS volume to update.
         * </p>
         * 
         * @param volumeSizeGB
         *        <p>
         *        Size of the EBS volume to update.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeGB(Integer volumeSizeGB);
    }

    static final class BuilderImpl implements Builder {
        private String kafkaBrokerNodeId;

        private ProvisionedThroughput provisionedThroughput;

        private Integer volumeSizeGB;

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerEBSVolumeInfo model) {
            kafkaBrokerNodeId(model.kafkaBrokerNodeId);
            provisionedThroughput(model.provisionedThroughput);
            volumeSizeGB(model.volumeSizeGB);
        }

        public final String getKafkaBrokerNodeId() {
            return kafkaBrokerNodeId;
        }

        public final void setKafkaBrokerNodeId(String kafkaBrokerNodeId) {
            this.kafkaBrokerNodeId = kafkaBrokerNodeId;
        }

        @Override
        public final Builder kafkaBrokerNodeId(String kafkaBrokerNodeId) {
            this.kafkaBrokerNodeId = kafkaBrokerNodeId;
            return this;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return provisionedThroughput != null ? provisionedThroughput.toBuilder() : null;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final Integer getVolumeSizeGB() {
            return volumeSizeGB;
        }

        public final void setVolumeSizeGB(Integer volumeSizeGB) {
            this.volumeSizeGB = volumeSizeGB;
        }

        @Override
        public final Builder volumeSizeGB(Integer volumeSizeGB) {
            this.volumeSizeGB = volumeSizeGB;
            return this;
        }

        @Override
        public BrokerEBSVolumeInfo build() {
            return new BrokerEBSVolumeInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
