/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Includes all client authentication information.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientAuthentication implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientAuthentication.Builder, ClientAuthentication> {
    private static final SdkField<Sasl> SASL_FIELD = SdkField.<Sasl> builder(MarshallingType.SDK_POJO).memberName("Sasl")
            .getter(getter(ClientAuthentication::sasl)).setter(setter(Builder::sasl)).constructor(Sasl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sasl").build()).build();

    private static final SdkField<Tls> TLS_FIELD = SdkField.<Tls> builder(MarshallingType.SDK_POJO).memberName("Tls")
            .getter(getter(ClientAuthentication::tls)).setter(setter(Builder::tls)).constructor(Tls::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tls").build()).build();

    private static final SdkField<Unauthenticated> UNAUTHENTICATED_FIELD = SdkField
            .<Unauthenticated> builder(MarshallingType.SDK_POJO).memberName("Unauthenticated")
            .getter(getter(ClientAuthentication::unauthenticated)).setter(setter(Builder::unauthenticated))
            .constructor(Unauthenticated::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unauthenticated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SASL_FIELD, TLS_FIELD,
            UNAUTHENTICATED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("sasl", SASL_FIELD);
                    put("tls", TLS_FIELD);
                    put("unauthenticated", UNAUTHENTICATED_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Sasl sasl;

    private final Tls tls;

    private final Unauthenticated unauthenticated;

    private ClientAuthentication(BuilderImpl builder) {
        this.sasl = builder.sasl;
        this.tls = builder.tls;
        this.unauthenticated = builder.unauthenticated;
    }

    /**
     *
     * <p>
     * Details for ClientAuthentication using SASL.
     * </p>
     * 
     * @return <p>
     *         Details for ClientAuthentication using SASL.
     *         </p>
     */
    public final Sasl sasl() {
        return sasl;
    }

    /**
     *
     * <p>
     * Details for ClientAuthentication using TLS.
     * </p>
     * 
     * @return <p>
     *         Details for ClientAuthentication using TLS.
     *         </p>
     */
    public final Tls tls() {
        return tls;
    }

    /**
     *
     * <p>
     * Contains information about unauthenticated traffic to the cluster.
     * </p>
     * 
     * @return <p>
     *         Contains information about unauthenticated traffic to the cluster.
     *         </p>
     */
    public final Unauthenticated unauthenticated() {
        return unauthenticated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sasl());
        hashCode = 31 * hashCode + Objects.hashCode(tls());
        hashCode = 31 * hashCode + Objects.hashCode(unauthenticated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientAuthentication)) {
            return false;
        }
        ClientAuthentication other = (ClientAuthentication) obj;
        return Objects.equals(sasl(), other.sasl()) && Objects.equals(tls(), other.tls())
                && Objects.equals(unauthenticated(), other.unauthenticated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientAuthentication").add("Sasl", sasl()).add("Tls", tls())
                .add("Unauthenticated", unauthenticated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sasl":
            return Optional.ofNullable(clazz.cast(sasl()));
        case "Tls":
            return Optional.ofNullable(clazz.cast(tls()));
        case "Unauthenticated":
            return Optional.ofNullable(clazz.cast(unauthenticated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClientAuthentication, T> g) {
        return obj -> g.apply((ClientAuthentication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientAuthentication> {
        /**
         *
         * <p>
         * Details for ClientAuthentication using SASL.
         * </p>
         * 
         * @param sasl
         *        <p>
         *        Details for ClientAuthentication using SASL.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sasl(Sasl sasl);

        /**
         *
         * <p>
         * Details for ClientAuthentication using SASL.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link Sasl.Builder} avoiding the need to create
         * one manually via {@link Sasl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Sasl.Builder#build()} is called immediately and its result is
         * passed to {@link #sasl(Sasl)}.
         * 
         * @param sasl
         *        a consumer that will call methods on {@link Sasl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sasl(Sasl)
         */
        default Builder sasl(Consumer<Sasl.Builder> sasl) {
            return sasl(Sasl.builder().applyMutation(sasl).build());
        }

        /**
         *
         * <p>
         * Details for ClientAuthentication using TLS.
         * </p>
         * 
         * @param tls
         *        <p>
         *        Details for ClientAuthentication using TLS.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tls(Tls tls);

        /**
         *
         * <p>
         * Details for ClientAuthentication using TLS.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link Tls.Builder} avoiding the need to create
         * one manually via {@link Tls#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Tls.Builder#build()} is called immediately and its result is
         * passed to {@link #tls(Tls)}.
         * 
         * @param tls
         *        a consumer that will call methods on {@link Tls.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tls(Tls)
         */
        default Builder tls(Consumer<Tls.Builder> tls) {
            return tls(Tls.builder().applyMutation(tls).build());
        }

        /**
         *
         * <p>
         * Contains information about unauthenticated traffic to the cluster.
         * </p>
         * 
         * @param unauthenticated
         *        <p>
         *        Contains information about unauthenticated traffic to the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unauthenticated(Unauthenticated unauthenticated);

        /**
         *
         * <p>
         * Contains information about unauthenticated traffic to the cluster.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link Unauthenticated.Builder} avoiding the
         * need to create one manually via {@link Unauthenticated#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Unauthenticated.Builder#build()} is called immediately and its
         * result is passed to {@link #unauthenticated(Unauthenticated)}.
         * 
         * @param unauthenticated
         *        a consumer that will call methods on {@link Unauthenticated.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unauthenticated(Unauthenticated)
         */
        default Builder unauthenticated(Consumer<Unauthenticated.Builder> unauthenticated) {
            return unauthenticated(Unauthenticated.builder().applyMutation(unauthenticated).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Sasl sasl;

        private Tls tls;

        private Unauthenticated unauthenticated;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientAuthentication model) {
            sasl(model.sasl);
            tls(model.tls);
            unauthenticated(model.unauthenticated);
        }

        public final Sasl.Builder getSasl() {
            return sasl != null ? sasl.toBuilder() : null;
        }

        public final void setSasl(Sasl.BuilderImpl sasl) {
            this.sasl = sasl != null ? sasl.build() : null;
        }

        @Override
        public final Builder sasl(Sasl sasl) {
            this.sasl = sasl;
            return this;
        }

        public final Tls.Builder getTls() {
            return tls != null ? tls.toBuilder() : null;
        }

        public final void setTls(Tls.BuilderImpl tls) {
            this.tls = tls != null ? tls.build() : null;
        }

        @Override
        public final Builder tls(Tls tls) {
            this.tls = tls;
            return this;
        }

        public final Unauthenticated.Builder getUnauthenticated() {
            return unauthenticated != null ? unauthenticated.toBuilder() : null;
        }

        public final void setUnauthenticated(Unauthenticated.BuilderImpl unauthenticated) {
            this.unauthenticated = unauthenticated != null ? unauthenticated.build() : null;
        }

        @Override
        public final Builder unauthenticated(Unauthenticated unauthenticated) {
            this.unauthenticated = unauthenticated;
            return this;
        }

        @Override
        public ClientAuthentication build() {
            return new ClientAuthentication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
