/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Returns information about a cluster operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterOperationV2 implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterOperationV2.Builder, ClusterOperationV2> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(ClusterOperationV2::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterType").getter(getter(ClusterOperationV2::clusterTypeAsString))
            .setter(setter(Builder::clusterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterType").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(ClusterOperationV2::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime")
            .getter(getter(ClusterOperationV2::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<ErrorInfo> ERROR_INFO_FIELD = SdkField.<ErrorInfo> builder(MarshallingType.SDK_POJO)
            .memberName("ErrorInfo").getter(getter(ClusterOperationV2::errorInfo)).setter(setter(Builder::errorInfo))
            .constructor(ErrorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()).build();

    private static final SdkField<String> OPERATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationArn").getter(getter(ClusterOperationV2::operationArn)).setter(setter(Builder::operationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationArn").build()).build();

    private static final SdkField<String> OPERATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationState").getter(getter(ClusterOperationV2::operationState))
            .setter(setter(Builder::operationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationState").build()).build();

    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationType").getter(getter(ClusterOperationV2::operationType)).setter(setter(Builder::operationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()).build();

    private static final SdkField<ClusterOperationV2Provisioned> PROVISIONED_FIELD = SdkField
            .<ClusterOperationV2Provisioned> builder(MarshallingType.SDK_POJO).memberName("Provisioned")
            .getter(getter(ClusterOperationV2::provisioned)).setter(setter(Builder::provisioned))
            .constructor(ClusterOperationV2Provisioned::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioned").build()).build();

    private static final SdkField<ClusterOperationV2Serverless> SERVERLESS_FIELD = SdkField
            .<ClusterOperationV2Serverless> builder(MarshallingType.SDK_POJO).memberName("Serverless")
            .getter(getter(ClusterOperationV2::serverless)).setter(setter(Builder::serverless))
            .constructor(ClusterOperationV2Serverless::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverless").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            CLUSTER_TYPE_FIELD, START_TIME_FIELD, END_TIME_FIELD, ERROR_INFO_FIELD, OPERATION_ARN_FIELD, OPERATION_STATE_FIELD,
            OPERATION_TYPE_FIELD, PROVISIONED_FIELD, SERVERLESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("clusterArn", CLUSTER_ARN_FIELD);
                    put("clusterType", CLUSTER_TYPE_FIELD);
                    put("startTime", START_TIME_FIELD);
                    put("endTime", END_TIME_FIELD);
                    put("errorInfo", ERROR_INFO_FIELD);
                    put("operationArn", OPERATION_ARN_FIELD);
                    put("operationState", OPERATION_STATE_FIELD);
                    put("operationType", OPERATION_TYPE_FIELD);
                    put("provisioned", PROVISIONED_FIELD);
                    put("serverless", SERVERLESS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String clusterArn;

    private final String clusterType;

    private final Instant startTime;

    private final Instant endTime;

    private final ErrorInfo errorInfo;

    private final String operationArn;

    private final String operationState;

    private final String operationType;

    private final ClusterOperationV2Provisioned provisioned;

    private final ClusterOperationV2Serverless serverless;

    private ClusterOperationV2(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.clusterType = builder.clusterType;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.errorInfo = builder.errorInfo;
        this.operationArn = builder.operationArn;
        this.operationState = builder.operationState;
        this.operationType = builder.operationType;
        this.provisioned = builder.provisioned;
        this.serverless = builder.serverless;
    }

    /**
     *
     * <p>
     * ARN of the cluster.
     * </p>
     * 
     * @return <p>
     *         ARN of the cluster.
     *         </p>
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     *
     * <p>
     * Type of the backend cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterType} will
     * return {@link ClusterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterTypeAsString}.
     * </p>
     * 
     * @return <p>
     *         Type of the backend cluster.
     *         </p>
     * @see ClusterType
     */
    public final ClusterType clusterType() {
        return ClusterType.fromValue(clusterType);
    }

    /**
     *
     * <p>
     * Type of the backend cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterType} will
     * return {@link ClusterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterTypeAsString}.
     * </p>
     * 
     * @return <p>
     *         Type of the backend cluster.
     *         </p>
     * @see ClusterType
     */
    public final String clusterTypeAsString() {
        return clusterType;
    }

    /**
     *
     * <p>
     * The time at which operation was started.
     * </p>
     * 
     * @return <p>
     *         The time at which operation was started.
     *         </p>
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     *
     * <p>
     * The time at which the operation finished.
     * </p>
     * 
     * @return <p>
     *         The time at which the operation finished.
     *         </p>
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     *
     * <p>
     * If cluster operation failed from an error, it describes the error.
     * </p>
     * 
     * @return <p>
     *         If cluster operation failed from an error, it describes the error.
     *         </p>
     */
    public final ErrorInfo errorInfo() {
        return errorInfo;
    }

    /**
     *
     * <p>
     * ARN of the cluster operation.
     * </p>
     * 
     * @return <p>
     *         ARN of the cluster operation.
     *         </p>
     */
    public final String operationArn() {
        return operationArn;
    }

    /**
     *
     * <p>
     * State of the cluster operation.
     * </p>
     * 
     * @return <p>
     *         State of the cluster operation.
     *         </p>
     */
    public final String operationState() {
        return operationState;
    }

    /**
     *
     * <p>
     * Type of the cluster operation.
     * </p>
     * 
     * @return <p>
     *         Type of the cluster operation.
     *         </p>
     */
    public final String operationType() {
        return operationType;
    }

    /**
     *
     * <p>
     * Properties of a provisioned cluster.
     * </p>
     * 
     * @return <p>
     *         Properties of a provisioned cluster.
     *         </p>
     */
    public final ClusterOperationV2Provisioned provisioned() {
        return provisioned;
    }

    /**
     *
     * <p>
     * Properties of a serverless cluster.
     * </p>
     * 
     * @return <p>
     *         Properties of a serverless cluster.
     *         </p>
     */
    public final ClusterOperationV2Serverless serverless() {
        return serverless;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(operationArn());
        hashCode = 31 * hashCode + Objects.hashCode(operationState());
        hashCode = 31 * hashCode + Objects.hashCode(operationType());
        hashCode = 31 * hashCode + Objects.hashCode(provisioned());
        hashCode = 31 * hashCode + Objects.hashCode(serverless());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterOperationV2)) {
            return false;
        }
        ClusterOperationV2 other = (ClusterOperationV2) obj;
        return Objects.equals(clusterArn(), other.clusterArn())
                && Objects.equals(clusterTypeAsString(), other.clusterTypeAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(errorInfo(), other.errorInfo()) && Objects.equals(operationArn(), other.operationArn())
                && Objects.equals(operationState(), other.operationState())
                && Objects.equals(operationType(), other.operationType()) && Objects.equals(provisioned(), other.provisioned())
                && Objects.equals(serverless(), other.serverless());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterOperationV2").add("ClusterArn", clusterArn()).add("ClusterType", clusterTypeAsString())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("ErrorInfo", errorInfo())
                .add("OperationArn", operationArn()).add("OperationState", operationState())
                .add("OperationType", operationType()).add("Provisioned", provisioned()).add("Serverless", serverless()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "ClusterType":
            return Optional.ofNullable(clazz.cast(clusterTypeAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "ErrorInfo":
            return Optional.ofNullable(clazz.cast(errorInfo()));
        case "OperationArn":
            return Optional.ofNullable(clazz.cast(operationArn()));
        case "OperationState":
            return Optional.ofNullable(clazz.cast(operationState()));
        case "OperationType":
            return Optional.ofNullable(clazz.cast(operationType()));
        case "Provisioned":
            return Optional.ofNullable(clazz.cast(provisioned()));
        case "Serverless":
            return Optional.ofNullable(clazz.cast(serverless()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClusterOperationV2, T> g) {
        return obj -> g.apply((ClusterOperationV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterOperationV2> {
        /**
         *
         * <p>
         * ARN of the cluster.
         * </p>
         * 
         * @param clusterArn
         *        <p>
         *        ARN of the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         *
         * <p>
         * Type of the backend cluster.
         * </p>
         * 
         * @param clusterType
         *        <p>
         *        Type of the backend cluster.
         *        </p>
         * @see ClusterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterType
         */
        Builder clusterType(String clusterType);

        /**
         *
         * <p>
         * Type of the backend cluster.
         * </p>
         * 
         * @param clusterType
         *        <p>
         *        Type of the backend cluster.
         *        </p>
         * @see ClusterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterType
         */
        Builder clusterType(ClusterType clusterType);

        /**
         *
         * <p>
         * The time at which operation was started.
         * </p>
         * 
         * @param startTime
         *        <p>
         *        The time at which operation was started.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         *
         * <p>
         * The time at which the operation finished.
         * </p>
         * 
         * @param endTime
         *        <p>
         *        The time at which the operation finished.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         *
         * <p>
         * If cluster operation failed from an error, it describes the error.
         * </p>
         * 
         * @param errorInfo
         *        <p>
         *        If cluster operation failed from an error, it describes the error.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(ErrorInfo errorInfo);

        /**
         *
         * <p>
         * If cluster operation failed from an error, it describes the error.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorInfo.Builder} avoiding the need to
         * create one manually via {@link ErrorInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #errorInfo(ErrorInfo)}.
         * 
         * @param errorInfo
         *        a consumer that will call methods on {@link ErrorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorInfo(ErrorInfo)
         */
        default Builder errorInfo(Consumer<ErrorInfo.Builder> errorInfo) {
            return errorInfo(ErrorInfo.builder().applyMutation(errorInfo).build());
        }

        /**
         *
         * <p>
         * ARN of the cluster operation.
         * </p>
         * 
         * @param operationArn
         *        <p>
         *        ARN of the cluster operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationArn(String operationArn);

        /**
         *
         * <p>
         * State of the cluster operation.
         * </p>
         * 
         * @param operationState
         *        <p>
         *        State of the cluster operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationState(String operationState);

        /**
         *
         * <p>
         * Type of the cluster operation.
         * </p>
         * 
         * @param operationType
         *        <p>
         *        Type of the cluster operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationType(String operationType);

        /**
         *
         * <p>
         * Properties of a provisioned cluster.
         * </p>
         * 
         * @param provisioned
         *        <p>
         *        Properties of a provisioned cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioned(ClusterOperationV2Provisioned provisioned);

        /**
         *
         * <p>
         * Properties of a provisioned cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterOperationV2Provisioned.Builder}
         * avoiding the need to create one manually via {@link ClusterOperationV2Provisioned#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterOperationV2Provisioned.Builder#build()} is called
         * immediately and its result is passed to {@link #provisioned(ClusterOperationV2Provisioned)}.
         * 
         * @param provisioned
         *        a consumer that will call methods on {@link ClusterOperationV2Provisioned.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioned(ClusterOperationV2Provisioned)
         */
        default Builder provisioned(Consumer<ClusterOperationV2Provisioned.Builder> provisioned) {
            return provisioned(ClusterOperationV2Provisioned.builder().applyMutation(provisioned).build());
        }

        /**
         *
         * <p>
         * Properties of a serverless cluster.
         * </p>
         * 
         * @param serverless
         *        <p>
         *        Properties of a serverless cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverless(ClusterOperationV2Serverless serverless);

        /**
         *
         * <p>
         * Properties of a serverless cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterOperationV2Serverless.Builder}
         * avoiding the need to create one manually via {@link ClusterOperationV2Serverless#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterOperationV2Serverless.Builder#build()} is called
         * immediately and its result is passed to {@link #serverless(ClusterOperationV2Serverless)}.
         * 
         * @param serverless
         *        a consumer that will call methods on {@link ClusterOperationV2Serverless.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverless(ClusterOperationV2Serverless)
         */
        default Builder serverless(Consumer<ClusterOperationV2Serverless.Builder> serverless) {
            return serverless(ClusterOperationV2Serverless.builder().applyMutation(serverless).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String clusterArn;

        private String clusterType;

        private Instant startTime;

        private Instant endTime;

        private ErrorInfo errorInfo;

        private String operationArn;

        private String operationState;

        private String operationType;

        private ClusterOperationV2Provisioned provisioned;

        private ClusterOperationV2Serverless serverless;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterOperationV2 model) {
            clusterArn(model.clusterArn);
            clusterType(model.clusterType);
            startTime(model.startTime);
            endTime(model.endTime);
            errorInfo(model.errorInfo);
            operationArn(model.operationArn);
            operationState(model.operationState);
            operationType(model.operationType);
            provisioned(model.provisioned);
            serverless(model.serverless);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterType() {
            return clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        @Override
        public final Builder clusterType(ClusterType clusterType) {
            this.clusterType(clusterType == null ? null : clusterType.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final ErrorInfo.Builder getErrorInfo() {
            return errorInfo != null ? errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(ErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final String getOperationArn() {
            return operationArn;
        }

        public final void setOperationArn(String operationArn) {
            this.operationArn = operationArn;
        }

        @Override
        public final Builder operationArn(String operationArn) {
            this.operationArn = operationArn;
            return this;
        }

        public final String getOperationState() {
            return operationState;
        }

        public final void setOperationState(String operationState) {
            this.operationState = operationState;
        }

        @Override
        public final Builder operationState(String operationState) {
            this.operationState = operationState;
            return this;
        }

        public final String getOperationType() {
            return operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        public final ClusterOperationV2Provisioned.Builder getProvisioned() {
            return provisioned != null ? provisioned.toBuilder() : null;
        }

        public final void setProvisioned(ClusterOperationV2Provisioned.BuilderImpl provisioned) {
            this.provisioned = provisioned != null ? provisioned.build() : null;
        }

        @Override
        public final Builder provisioned(ClusterOperationV2Provisioned provisioned) {
            this.provisioned = provisioned;
            return this;
        }

        public final ClusterOperationV2Serverless.Builder getServerless() {
            return serverless != null ? serverless.toBuilder() : null;
        }

        public final void setServerless(ClusterOperationV2Serverless.BuilderImpl serverless) {
            this.serverless = serverless != null ? serverless.build() : null;
        }

        @Override
        public final Builder serverless(ClusterOperationV2Serverless serverless) {
            this.serverless = serverless;
            return this;
        }

        @Override
        public ClusterOperationV2 build() {
            return new ClusterOperationV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
