/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Information about the broker access configuration.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectivityInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectivityInfo.Builder, ConnectivityInfo> {
    private static final SdkField<PublicAccess> PUBLIC_ACCESS_FIELD = SdkField.<PublicAccess> builder(MarshallingType.SDK_POJO)
            .memberName("PublicAccess").getter(getter(ConnectivityInfo::publicAccess)).setter(setter(Builder::publicAccess))
            .constructor(PublicAccess::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicAccess").build()).build();

    private static final SdkField<VpcConnectivity> VPC_CONNECTIVITY_FIELD = SdkField
            .<VpcConnectivity> builder(MarshallingType.SDK_POJO).memberName("VpcConnectivity")
            .getter(getter(ConnectivityInfo::vpcConnectivity)).setter(setter(Builder::vpcConnectivity))
            .constructor(VpcConnectivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConnectivity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_ACCESS_FIELD,
            VPC_CONNECTIVITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("publicAccess", PUBLIC_ACCESS_FIELD);
                    put("vpcConnectivity", VPC_CONNECTIVITY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final PublicAccess publicAccess;

    private final VpcConnectivity vpcConnectivity;

    private ConnectivityInfo(BuilderImpl builder) {
        this.publicAccess = builder.publicAccess;
        this.vpcConnectivity = builder.vpcConnectivity;
    }

    /**
     *
     * <p>
     * Public access control for brokers.
     * </p>
     * 
     * @return <p>
     *         Public access control for brokers.
     *         </p>
     */
    public final PublicAccess publicAccess() {
        return publicAccess;
    }

    /**
     *
     * <p>
     * VPC connectivity access control for brokers.
     * </p>
     * 
     * @return <p>
     *         VPC connectivity access control for brokers.
     *         </p>
     */
    public final VpcConnectivity vpcConnectivity() {
        return vpcConnectivity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(publicAccess());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConnectivity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectivityInfo)) {
            return false;
        }
        ConnectivityInfo other = (ConnectivityInfo) obj;
        return Objects.equals(publicAccess(), other.publicAccess()) && Objects.equals(vpcConnectivity(), other.vpcConnectivity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectivityInfo").add("PublicAccess", publicAccess()).add("VpcConnectivity", vpcConnectivity())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicAccess":
            return Optional.ofNullable(clazz.cast(publicAccess()));
        case "VpcConnectivity":
            return Optional.ofNullable(clazz.cast(vpcConnectivity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConnectivityInfo, T> g) {
        return obj -> g.apply((ConnectivityInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectivityInfo> {
        /**
         *
         * <p>
         * Public access control for brokers.
         * </p>
         * 
         * @param publicAccess
         *        <p>
         *        Public access control for brokers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicAccess(PublicAccess publicAccess);

        /**
         *
         * <p>
         * Public access control for brokers.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link PublicAccess.Builder} avoiding the need
         * to create one manually via {@link PublicAccess#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PublicAccess.Builder#build()} is called immediately and its
         * result is passed to {@link #publicAccess(PublicAccess)}.
         * 
         * @param publicAccess
         *        a consumer that will call methods on {@link PublicAccess.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicAccess(PublicAccess)
         */
        default Builder publicAccess(Consumer<PublicAccess.Builder> publicAccess) {
            return publicAccess(PublicAccess.builder().applyMutation(publicAccess).build());
        }

        /**
         *
         * <p>
         * VPC connectivity access control for brokers.
         * </p>
         * 
         * @param vpcConnectivity
         *        <p>
         *        VPC connectivity access control for brokers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnectivity(VpcConnectivity vpcConnectivity);

        /**
         *
         * <p>
         * VPC connectivity access control for brokers.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link VpcConnectivity.Builder} avoiding the
         * need to create one manually via {@link VpcConnectivity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConnectivity.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConnectivity(VpcConnectivity)}.
         * 
         * @param vpcConnectivity
         *        a consumer that will call methods on {@link VpcConnectivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConnectivity(VpcConnectivity)
         */
        default Builder vpcConnectivity(Consumer<VpcConnectivity.Builder> vpcConnectivity) {
            return vpcConnectivity(VpcConnectivity.builder().applyMutation(vpcConnectivity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PublicAccess publicAccess;

        private VpcConnectivity vpcConnectivity;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectivityInfo model) {
            publicAccess(model.publicAccess);
            vpcConnectivity(model.vpcConnectivity);
        }

        public final PublicAccess.Builder getPublicAccess() {
            return publicAccess != null ? publicAccess.toBuilder() : null;
        }

        public final void setPublicAccess(PublicAccess.BuilderImpl publicAccess) {
            this.publicAccess = publicAccess != null ? publicAccess.build() : null;
        }

        @Override
        public final Builder publicAccess(PublicAccess publicAccess) {
            this.publicAccess = publicAccess;
            return this;
        }

        public final VpcConnectivity.Builder getVpcConnectivity() {
            return vpcConnectivity != null ? vpcConnectivity.toBuilder() : null;
        }

        public final void setVpcConnectivity(VpcConnectivity.BuilderImpl vpcConnectivity) {
            this.vpcConnectivity = vpcConnectivity != null ? vpcConnectivity.build() : null;
        }

        @Override
        public final Builder vpcConnectivity(VpcConnectivity vpcConnectivity) {
            this.vpcConnectivity = vpcConnectivity;
            return this;
        }

        @Override
        public ConnectivityInfo build() {
            return new ConnectivityInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
