/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConfigurationResponse extends KafkaResponse implements
        ToCopyableBuilder<CreateConfigurationResponse.Builder, CreateConfigurationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateConfigurationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(CreateConfigurationResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<ConfigurationRevision> LATEST_REVISION_FIELD = SdkField
            .<ConfigurationRevision> builder(MarshallingType.SDK_POJO).memberName("LatestRevision")
            .getter(getter(CreateConfigurationResponse::latestRevision)).setter(setter(Builder::latestRevision))
            .constructor(ConfigurationRevision::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRevision").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(CreateConfigurationResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIME_FIELD, LATEST_REVISION_FIELD, NAME_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("arn", ARN_FIELD);
                    put("creationTime", CREATION_TIME_FIELD);
                    put("latestRevision", LATEST_REVISION_FIELD);
                    put("name", NAME_FIELD);
                    put("state", STATE_FIELD);
                }
            });

    private final String arn;

    private final Instant creationTime;

    private final ConfigurationRevision latestRevision;

    private final String name;

    private final String state;

    private CreateConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.latestRevision = builder.latestRevision;
        this.name = builder.name;
        this.state = builder.state;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) of the configuration.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the configuration.
     *         </p>
     */
    public final String arn() {
        return arn;
    }

    /**
     *
     * <p>
     * The time when the configuration was created.
     * </p>
     * 
     * @return <p>
     *         The time when the configuration was created.
     *         </p>
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     *
     * <p>
     * Latest revision of the configuration.
     * </p>
     * 
     * @return <p>
     *         Latest revision of the configuration.
     *         </p>
     */
    public final ConfigurationRevision latestRevision() {
        return latestRevision;
    }

    /**
     *
     * <p>
     * The name of the configuration.
     * </p>
     * 
     * @return <p>
     *         The name of the configuration.
     *         </p>
     */
    public final String name() {
        return name;
    }

    /**
     *
     * <p>
     * The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <p>
     *         The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
     *         </p>
     * @see ConfigurationState
     */
    public final ConfigurationState state() {
        return ConfigurationState.fromValue(state);
    }

    /**
     *
     * <p>
     * The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <p>
     *         The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
     *         </p>
     * @see ConfigurationState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestRevision());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationResponse)) {
            return false;
        }
        CreateConfigurationResponse other = (CreateConfigurationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(latestRevision(), other.latestRevision()) && Objects.equals(name(), other.name())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConfigurationResponse").add("Arn", arn()).add("CreationTime", creationTime())
                .add("LatestRevision", latestRevision()).add("Name", name()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LatestRevision":
            return Optional.ofNullable(clazz.cast(latestRevision()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationResponse, T> g) {
        return obj -> g.apply((CreateConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateConfigurationResponse> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) of the configuration.
         * </p>
         * 
         * @param arn
         *        <p>
         *        The Amazon Resource Name (ARN) of the configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         *
         * <p>
         * The time when the configuration was created.
         * </p>
         * 
         * @param creationTime
         *        <p>
         *        The time when the configuration was created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         *
         * <p>
         * Latest revision of the configuration.
         * </p>
         * 
         * @param latestRevision
         *        <p>
         *        Latest revision of the configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRevision(ConfigurationRevision latestRevision);

        /**
         *
         * <p>
         * Latest revision of the configuration.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link ConfigurationRevision.Builder} avoiding
         * the need to create one manually via {@link ConfigurationRevision#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigurationRevision.Builder#build()} is called immediately and
         * its result is passed to {@link #latestRevision(ConfigurationRevision)}.
         * 
         * @param latestRevision
         *        a consumer that will call methods on {@link ConfigurationRevision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestRevision(ConfigurationRevision)
         */
        default Builder latestRevision(Consumer<ConfigurationRevision.Builder> latestRevision) {
            return latestRevision(ConfigurationRevision.builder().applyMutation(latestRevision).build());
        }

        /**
         *
         * <p>
         * The name of the configuration.
         * </p>
         * 
         * @param name
         *        <p>
         *        The name of the configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         *
         * <p>
         * The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
         * </p>
         * 
         * @param state
         *        <p>
         *        The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
         *        </p>
         * @see ConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationState
         */
        Builder state(String state);

        /**
         *
         * <p>
         * The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
         * </p>
         * 
         * @param state
         *        <p>
         *        The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
         *        </p>
         * @see ConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationState
         */
        Builder state(ConfigurationState state);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant creationTime;

        private ConfigurationRevision latestRevision;

        private String name;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationResponse model) {
            super(model);
            arn(model.arn);
            creationTime(model.creationTime);
            latestRevision(model.latestRevision);
            name(model.name);
            state(model.state);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ConfigurationRevision.Builder getLatestRevision() {
            return latestRevision != null ? latestRevision.toBuilder() : null;
        }

        public final void setLatestRevision(ConfigurationRevision.BuilderImpl latestRevision) {
            this.latestRevision = latestRevision != null ? latestRevision.build() : null;
        }

        @Override
        public final Builder latestRevision(ConfigurationRevision latestRevision) {
            this.latestRevision = latestRevision;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ConfigurationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public CreateConfigurationResponse build() {
            return new CreateConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
