/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcConnectionRequest extends KafkaRequest implements
        ToCopyableBuilder<CreateVpcConnectionRequest.Builder, CreateVpcConnectionRequest> {
    private static final SdkField<String> TARGET_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetClusterArn").getter(getter(CreateVpcConnectionRequest::targetClusterArn))
            .setter(setter(Builder::targetClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetClusterArn").build()).build();

    private static final SdkField<String> AUTHENTICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Authentication").getter(getter(CreateVpcConnectionRequest::authentication))
            .setter(setter(Builder::authentication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authentication").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(CreateVpcConnectionRequest::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final SdkField<List<String>> CLIENT_SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ClientSubnets")
            .getter(getter(CreateVpcConnectionRequest::clientSubnets))
            .setter(setter(Builder::clientSubnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSubnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(CreateVpcConnectionRequest::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateVpcConnectionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_CLUSTER_ARN_FIELD,
            AUTHENTICATION_FIELD, VPC_ID_FIELD, CLIENT_SUBNETS_FIELD, SECURITY_GROUPS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("targetClusterArn", TARGET_CLUSTER_ARN_FIELD);
                    put("authentication", AUTHENTICATION_FIELD);
                    put("vpcId", VPC_ID_FIELD);
                    put("clientSubnets", CLIENT_SUBNETS_FIELD);
                    put("securityGroups", SECURITY_GROUPS_FIELD);
                    put("tags", TAGS_FIELD);
                }
            });

    private final String targetClusterArn;

    private final String authentication;

    private final String vpcId;

    private final List<String> clientSubnets;

    private final List<String> securityGroups;

    private final Map<String, String> tags;

    private CreateVpcConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.targetClusterArn = builder.targetClusterArn;
        this.authentication = builder.authentication;
        this.vpcId = builder.vpcId;
        this.clientSubnets = builder.clientSubnets;
        this.securityGroups = builder.securityGroups;
        this.tags = builder.tags;
    }

    /**
     *
     * <p>
     * The cluster Amazon Resource Name (ARN) for the VPC connection.
     * </p>
     * 
     * @return <p>
     *         The cluster Amazon Resource Name (ARN) for the VPC connection.
     *         </p>
     */
    public final String targetClusterArn() {
        return targetClusterArn;
    }

    /**
     *
     * <p>
     * The authentication type of VPC connection.
     * </p>
     * 
     * @return <p>
     *         The authentication type of VPC connection.
     *         </p>
     */
    public final String authentication() {
        return authentication;
    }

    /**
     *
     * <p>
     * The VPC ID of VPC connection.
     * </p>
     * 
     * @return <p>
     *         The VPC ID of VPC connection.
     *         </p>
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientSubnets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClientSubnets() {
        return clientSubnets != null && !(clientSubnets instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * The list of client subnets.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientSubnets} method.
     * </p>
     * 
     * @return <p>
     *         The list of client subnets.
     *         </p>
     */
    public final List<String> clientSubnets() {
        return clientSubnets;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     *
     * <p>
     * The list of security groups.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return <p>
     *         The list of security groups.
     *         </p>
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     *
     * <p>
     * A map of tags for the VPC connection.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return <p>
     *         A map of tags for the VPC connection.
     *         </p>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(authentication());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasClientSubnets() ? clientSubnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcConnectionRequest)) {
            return false;
        }
        CreateVpcConnectionRequest other = (CreateVpcConnectionRequest) obj;
        return Objects.equals(targetClusterArn(), other.targetClusterArn())
                && Objects.equals(authentication(), other.authentication()) && Objects.equals(vpcId(), other.vpcId())
                && hasClientSubnets() == other.hasClientSubnets() && Objects.equals(clientSubnets(), other.clientSubnets())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVpcConnectionRequest").add("TargetClusterArn", targetClusterArn())
                .add("Authentication", authentication()).add("VpcId", vpcId())
                .add("ClientSubnets", hasClientSubnets() ? clientSubnets() : null)
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetClusterArn":
            return Optional.ofNullable(clazz.cast(targetClusterArn()));
        case "Authentication":
            return Optional.ofNullable(clazz.cast(authentication()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "ClientSubnets":
            return Optional.ofNullable(clazz.cast(clientSubnets()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcConnectionRequest, T> g) {
        return obj -> g.apply((CreateVpcConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateVpcConnectionRequest> {
        /**
         *
         * <p>
         * The cluster Amazon Resource Name (ARN) for the VPC connection.
         * </p>
         * 
         * @param targetClusterArn
         *        <p>
         *        The cluster Amazon Resource Name (ARN) for the VPC connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetClusterArn(String targetClusterArn);

        /**
         *
         * <p>
         * The authentication type of VPC connection.
         * </p>
         * 
         * @param authentication
         *        <p>
         *        The authentication type of VPC connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authentication(String authentication);

        /**
         *
         * <p>
         * The VPC ID of VPC connection.
         * </p>
         * 
         * @param vpcId
         *        <p>
         *        The VPC ID of VPC connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         *
         * <p>
         * The list of client subnets.
         * </p>
         * 
         * @param clientSubnets
         *        <p>
         *        The list of client subnets.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSubnets(Collection<String> clientSubnets);

        /**
         *
         * <p>
         * The list of client subnets.
         * </p>
         * 
         * @param clientSubnets
         *        <p>
         *        The list of client subnets.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSubnets(String... clientSubnets);

        /**
         *
         * <p>
         * The list of security groups.
         * </p>
         * 
         * @param securityGroups
         *        <p>
         *        The list of security groups.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         *
         * <p>
         * The list of security groups.
         * </p>
         * 
         * @param securityGroups
         *        <p>
         *        The list of security groups.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         *
         * <p>
         * A map of tags for the VPC connection.
         * </p>
         * 
         * @param tags
         *        <p>
         *        A map of tags for the VPC connection.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private String targetClusterArn;

        private String authentication;

        private String vpcId;

        private List<String> clientSubnets = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcConnectionRequest model) {
            super(model);
            targetClusterArn(model.targetClusterArn);
            authentication(model.authentication);
            vpcId(model.vpcId);
            clientSubnets(model.clientSubnets);
            securityGroups(model.securityGroups);
            tags(model.tags);
        }

        public final String getTargetClusterArn() {
            return targetClusterArn;
        }

        public final void setTargetClusterArn(String targetClusterArn) {
            this.targetClusterArn = targetClusterArn;
        }

        @Override
        public final Builder targetClusterArn(String targetClusterArn) {
            this.targetClusterArn = targetClusterArn;
            return this;
        }

        public final String getAuthentication() {
            return authentication;
        }

        public final void setAuthentication(String authentication) {
            this.authentication = authentication;
        }

        @Override
        public final Builder authentication(String authentication) {
            this.authentication = authentication;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getClientSubnets() {
            if (clientSubnets instanceof SdkAutoConstructList) {
                return null;
            }
            return clientSubnets;
        }

        public final void setClientSubnets(Collection<String> clientSubnets) {
            this.clientSubnets = ___listOf__stringCopier.copy(clientSubnets);
        }

        @Override
        public final Builder clientSubnets(Collection<String> clientSubnets) {
            this.clientSubnets = ___listOf__stringCopier.copy(clientSubnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientSubnets(String... clientSubnets) {
            clientSubnets(Arrays.asList(clientSubnets));
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcConnectionRequest build() {
            return new CreateVpcConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
