/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterV2Response extends KafkaResponse implements
        ToCopyableBuilder<DescribeClusterV2Response.Builder, DescribeClusterV2Response> {
    private static final SdkField<Cluster> CLUSTER_INFO_FIELD = SdkField.<Cluster> builder(MarshallingType.SDK_POJO)
            .memberName("ClusterInfo").getter(getter(DescribeClusterV2Response::clusterInfo))
            .setter(setter(Builder::clusterInfo)).constructor(Cluster::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("clusterInfo", CLUSTER_INFO_FIELD);
                }
            });

    private final Cluster clusterInfo;

    private DescribeClusterV2Response(BuilderImpl builder) {
        super(builder);
        this.clusterInfo = builder.clusterInfo;
    }

    /**
     *
     * <p>
     * The cluster information.
     * </p>
     * 
     * @return <p>
     *         The cluster information.
     *         </p>
     */
    public final Cluster clusterInfo() {
        return clusterInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterV2Response)) {
            return false;
        }
        DescribeClusterV2Response other = (DescribeClusterV2Response) obj;
        return Objects.equals(clusterInfo(), other.clusterInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClusterV2Response").add("ClusterInfo", clusterInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterInfo":
            return Optional.ofNullable(clazz.cast(clusterInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterV2Response, T> g) {
        return obj -> g.apply((DescribeClusterV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClusterV2Response> {
        /**
         *
         * <p>
         * The cluster information.
         * </p>
         * 
         * @param clusterInfo
         *        <p>
         *        The cluster information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterInfo(Cluster clusterInfo);

        /**
         *
         * <p>
         * The cluster information.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link Cluster.Builder} avoiding the need to
         * create one manually via {@link Cluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Cluster.Builder#build()} is called immediately and its result is
         * passed to {@link #clusterInfo(Cluster)}.
         * 
         * @param clusterInfo
         *        a consumer that will call methods on {@link Cluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterInfo(Cluster)
         */
        default Builder clusterInfo(Consumer<Cluster.Builder> clusterInfo) {
            return clusterInfo(Cluster.builder().applyMutation(clusterInfo).build());
        }
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private Cluster clusterInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterV2Response model) {
            super(model);
            clusterInfo(model.clusterInfo);
        }

        public final Cluster.Builder getClusterInfo() {
            return clusterInfo != null ? clusterInfo.toBuilder() : null;
        }

        public final void setClusterInfo(Cluster.BuilderImpl clusterInfo) {
            this.clusterInfo = clusterInfo != null ? clusterInfo.build() : null;
        }

        @Override
        public final Builder clusterInfo(Cluster clusterInfo) {
            this.clusterInfo = clusterInfo;
            return this;
        }

        @Override
        public DescribeClusterV2Response build() {
            return new DescribeClusterV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
