/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReplicatorRequest extends KafkaRequest implements
        ToCopyableBuilder<DescribeReplicatorRequest.Builder, DescribeReplicatorRequest> {
    private static final SdkField<String> REPLICATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicatorArn").getter(getter(DescribeReplicatorRequest::replicatorArn))
            .setter(setter(Builder::replicatorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("replicatorArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATOR_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("replicatorArn", REPLICATOR_ARN_FIELD);
                }
            });

    private final String replicatorArn;

    private DescribeReplicatorRequest(BuilderImpl builder) {
        super(builder);
        this.replicatorArn = builder.replicatorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replicator to be described.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replicator to be described.
     */
    public final String replicatorArn() {
        return replicatorArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicatorArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicatorRequest)) {
            return false;
        }
        DescribeReplicatorRequest other = (DescribeReplicatorRequest) obj;
        return Objects.equals(replicatorArn(), other.replicatorArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReplicatorRequest").add("ReplicatorArn", replicatorArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicatorArn":
            return Optional.ofNullable(clazz.cast(replicatorArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicatorRequest, T> g) {
        return obj -> g.apply((DescribeReplicatorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeReplicatorRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replicator to be described.
         * </p>
         * 
         * @param replicatorArn
         *        The Amazon Resource Name (ARN) of the replicator to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatorArn(String replicatorArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private String replicatorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicatorRequest model) {
            super(model);
            replicatorArn(model.replicatorArn);
        }

        public final String getReplicatorArn() {
            return replicatorArn;
        }

        public final void setReplicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
        }

        @Override
        public final Builder replicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeReplicatorRequest build() {
            return new DescribeReplicatorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
