/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Includes encryption-related information, such as the AWS KMS key used for encrypting data at rest and whether you
 * want MSK to encrypt your data in transit.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionInfo implements SdkPojo, Serializable, ToCopyableBuilder<EncryptionInfo.Builder, EncryptionInfo> {
    private static final SdkField<EncryptionAtRest> ENCRYPTION_AT_REST_FIELD = SdkField
            .<EncryptionAtRest> builder(MarshallingType.SDK_POJO).memberName("EncryptionAtRest")
            .getter(getter(EncryptionInfo::encryptionAtRest)).setter(setter(Builder::encryptionAtRest))
            .constructor(EncryptionAtRest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionAtRest").build()).build();

    private static final SdkField<EncryptionInTransit> ENCRYPTION_IN_TRANSIT_FIELD = SdkField
            .<EncryptionInTransit> builder(MarshallingType.SDK_POJO).memberName("EncryptionInTransit")
            .getter(getter(EncryptionInfo::encryptionInTransit)).setter(setter(Builder::encryptionInTransit))
            .constructor(EncryptionInTransit::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionInTransit").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_AT_REST_FIELD,
            ENCRYPTION_IN_TRANSIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("encryptionAtRest", ENCRYPTION_AT_REST_FIELD);
                    put("encryptionInTransit", ENCRYPTION_IN_TRANSIT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final EncryptionAtRest encryptionAtRest;

    private final EncryptionInTransit encryptionInTransit;

    private EncryptionInfo(BuilderImpl builder) {
        this.encryptionAtRest = builder.encryptionAtRest;
        this.encryptionInTransit = builder.encryptionInTransit;
    }

    /**
     *
     * <p>
     * The data-volume encryption details.
     * </p>
     * 
     * @return <p>
     *         The data-volume encryption details.
     *         </p>
     */
    public final EncryptionAtRest encryptionAtRest() {
        return encryptionAtRest;
    }

    /**
     *
     * <p>
     * The details for encryption in transit.
     * </p>
     * 
     * @return <p>
     *         The details for encryption in transit.
     *         </p>
     */
    public final EncryptionInTransit encryptionInTransit() {
        return encryptionInTransit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionAtRest());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionInTransit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionInfo)) {
            return false;
        }
        EncryptionInfo other = (EncryptionInfo) obj;
        return Objects.equals(encryptionAtRest(), other.encryptionAtRest())
                && Objects.equals(encryptionInTransit(), other.encryptionInTransit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionInfo").add("EncryptionAtRest", encryptionAtRest())
                .add("EncryptionInTransit", encryptionInTransit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionAtRest":
            return Optional.ofNullable(clazz.cast(encryptionAtRest()));
        case "EncryptionInTransit":
            return Optional.ofNullable(clazz.cast(encryptionInTransit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionInfo, T> g) {
        return obj -> g.apply((EncryptionInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionInfo> {
        /**
         *
         * <p>
         * The data-volume encryption details.
         * </p>
         * 
         * @param encryptionAtRest
         *        <p>
         *        The data-volume encryption details.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionAtRest(EncryptionAtRest encryptionAtRest);

        /**
         *
         * <p>
         * The data-volume encryption details.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link EncryptionAtRest.Builder} avoiding the
         * need to create one manually via {@link EncryptionAtRest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionAtRest.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionAtRest(EncryptionAtRest)}.
         * 
         * @param encryptionAtRest
         *        a consumer that will call methods on {@link EncryptionAtRest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionAtRest(EncryptionAtRest)
         */
        default Builder encryptionAtRest(Consumer<EncryptionAtRest.Builder> encryptionAtRest) {
            return encryptionAtRest(EncryptionAtRest.builder().applyMutation(encryptionAtRest).build());
        }

        /**
         *
         * <p>
         * The details for encryption in transit.
         * </p>
         * 
         * @param encryptionInTransit
         *        <p>
         *        The details for encryption in transit.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionInTransit(EncryptionInTransit encryptionInTransit);

        /**
         *
         * <p>
         * The details for encryption in transit.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link EncryptionInTransit.Builder} avoiding the
         * need to create one manually via {@link EncryptionInTransit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionInTransit.Builder#build()} is called immediately and
         * its result is passed to {@link #encryptionInTransit(EncryptionInTransit)}.
         * 
         * @param encryptionInTransit
         *        a consumer that will call methods on {@link EncryptionInTransit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionInTransit(EncryptionInTransit)
         */
        default Builder encryptionInTransit(Consumer<EncryptionInTransit.Builder> encryptionInTransit) {
            return encryptionInTransit(EncryptionInTransit.builder().applyMutation(encryptionInTransit).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EncryptionAtRest encryptionAtRest;

        private EncryptionInTransit encryptionInTransit;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionInfo model) {
            encryptionAtRest(model.encryptionAtRest);
            encryptionInTransit(model.encryptionInTransit);
        }

        public final EncryptionAtRest.Builder getEncryptionAtRest() {
            return encryptionAtRest != null ? encryptionAtRest.toBuilder() : null;
        }

        public final void setEncryptionAtRest(EncryptionAtRest.BuilderImpl encryptionAtRest) {
            this.encryptionAtRest = encryptionAtRest != null ? encryptionAtRest.build() : null;
        }

        @Override
        public final Builder encryptionAtRest(EncryptionAtRest encryptionAtRest) {
            this.encryptionAtRest = encryptionAtRest;
            return this;
        }

        public final EncryptionInTransit.Builder getEncryptionInTransit() {
            return encryptionInTransit != null ? encryptionInTransit.toBuilder() : null;
        }

        public final void setEncryptionInTransit(EncryptionInTransit.BuilderImpl encryptionInTransit) {
            this.encryptionInTransit = encryptionInTransit != null ? encryptionInTransit.build() : null;
        }

        @Override
        public final Builder encryptionInTransit(EncryptionInTransit encryptionInTransit) {
            this.encryptionInTransit = encryptionInTransit;
            return this;
        }

        @Override
        public EncryptionInfo build() {
            return new EncryptionInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
